//
// HiRiseDemo: a Demo Application of the HiRise Constraint Solver
//
// Copyright (C) 1998 Hiroshi HOSOBE
//
////////////////////////////////////////////////////////////////

// HiRiseDemo.cpp : AvP[VpNX̋@\`s܂B
//

#include "stdafx.h"
#include "HiRiseDemo.h"

#include "MainFrm.h"
#include "BinTreeDoc.h"
#include "BinTreeView.h"
#include "TreeDoc.h"
#include "TreeView.h"
#include "KochDoc.h"
#include "KochView.h"
#include "GraphDoc.h"
#include "GraphView.h"

#include "HRBase.h"
#include "HRList.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CHiRiseDemoApp

BEGIN_MESSAGE_MAP(CHiRiseDemoApp, CWinApp)
	//{{AFX_MSG_MAP(CHiRiseDemoApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	//}}AFX_MSG_MAP
	// W̃t@C{hLg R}h
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
	// ẄZbgAbv R}h
	ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CHiRiseDemoApp NX̍\z

CHiRiseDemoApp::CHiRiseDemoApp()
{
	// TODO: ̈ʒuɍ\zpR[hǉĂB
	//  InitInstance ̏dvȏׂċLqĂB
}

/////////////////////////////////////////////////////////////////////////////
// B CHiRiseDemoApp IuWFNg

CHiRiseDemoApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CHiRiseDemoApp NX̏

BOOL CHiRiseDemoApp::InitInstance()
{
	AfxEnableControlContainer();

	// WIȏ
	// ̋@\gpAst@C̃TCY
	//  Έȉ̓̏[`̒sKvȂ
	//  폜ĂB

#ifdef _AFXDLL
	Enable3dControls();			// L DLL ̒ MFC gpꍇɂ͂ĂяoĂB
#else
	Enable3dControlsStatic();	// MFC ƐÓIɃNĂꍇɂ͂ĂяoĂB
#endif

	// ݒ肪ۑ鉺̃WXg L[ύX܂B
	// Ж܂͏ȂǁAK؂ȕ
	// ύXĂB
	SetRegistryKey(_T("Local AppWizard-Generated Applications"));

	LoadStdProfileSettings();  // W INI t@C̃IvV[ނ܂ (MRU ܂)

	// AvP[Vp̃hLg ev[go^܂BhLg ev[g
	//  ̓hLgAt[ EBhEƃr[邽߂ɋ@\܂B

	binTreeTemplate = new CMultiDocTemplate(
		IDR_BIN_TREE_TYPE,
		RUNTIME_CLASS(CBinTreeDoc),
		RUNTIME_CLASS(CMDIChildWnd),
		RUNTIME_CLASS(CBinTreeView));
	AddDocTemplate(binTreeTemplate);

	treeTemplate = new CMultiDocTemplate(
		IDR_TREE_TYPE,
		RUNTIME_CLASS(CTreeDoc),
		RUNTIME_CLASS(CMDIChildWnd),
		RUNTIME_CLASS(CTreeView));
	AddDocTemplate(treeTemplate);

	kochTemplate = new CMultiDocTemplate(
		IDR_KOCH_TYPE,
		RUNTIME_CLASS(CKochDoc),
		RUNTIME_CLASS(CMDIChildWnd),
		RUNTIME_CLASS(CKochView));
	AddDocTemplate(kochTemplate);

	graphTemplate = new CMultiDocTemplate(
		IDR_GRAPH_TYPE,
		RUNTIME_CLASS(CGraphDoc),
		RUNTIME_CLASS(CMDIChildWnd),
		RUNTIME_CLASS(CGraphView));
	AddDocTemplate(graphTemplate);

	// C MDI t[ EBhE쐬
	CMainFrame* pMainFrame = new CMainFrame;
	if (!pMainFrame->LoadFrame(IDR_MAINFRAME))
		return FALSE;
	m_pMainWnd = pMainFrame;

	// DDEAfile open ȂǕW̃VF R}h̃R}hC͂܂B
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);

#if 0
	// R}hCŃfBXpb` R}hw肵܂B
	if (!ProcessShellCommand(cmdInfo))
		return FALSE;
#endif

	// C EBhEꂽ̂ŁA\ƍXVs܂B
	pMainFrame->ShowWindow(m_nCmdShow);
	pMainFrame->UpdateWindow();

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// AvP[Ṽo[WŎg CAboutDlg _CAO

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// _CAO f[^
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard z֐̃I[o[Ch𐶐܂B
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // // DDX/DDV ̃T|[g
	//}}AFX_VIRTUAL

// Cve[V
protected:
	//{{AFX_MSG(CAboutDlg)
		// bZ[W nh͂܂B
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// bZ[W nh͂܂B
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// _CAOs邽߂̃AvP[V R}h
void CHiRiseDemoApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// CHiRiseDemoApp R}h
