//
// HiRiseDemo: a Demo Application of the HiRise Constraint Solver
//
// Copyright (C) 1998 Hiroshi HOSOBE
//
////////////////////////////////////////////////////////////////

// GraphView.h : CGraphView NX̐錾уC^[tFCX̒`܂B
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_GRAPHVIEW_H__36E617AF_46BC_11D1_A2EE_0000E8260BD8__INCLUDED_)
#define AFX_GRAPHVIEW_H__36E617AF_46BC_11D1_A2EE_0000E8260BD8__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "HRSolver.h"

class GraphNode;
class GraphEdge;

class CGraphView : public CView
{
protected: // VACY@\݂̂쐬܂B
	CGraphView();
	DECLARE_DYNCREATE(CGraphView)

// Agr[g
public:
	CGraphDoc* GetDocument();

// Iy[V
public:

// I[o[Ch
	// ClassWizard ͉z֐̃I[o[Ch𐶐܂B
	//{{AFX_VIRTUAL(CGraphView)
	public:
	virtual void OnDraw(CDC* pDC);  // ̃r[`悷ۂɃI[o[Ch܂B
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	protected:
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	//}}AFX_VIRTUAL

// Cve[V
public:
	typedef enum {
		IM_NORMAL,
		IM_DRAG_OBJECT,
		IM_SPECIFY_EDGE
	} InputMode;

	InputMode m_inputMode;

	GraphNode* m_pDraggedGraphNode;
	HREdit m_editX;
	HREdit m_editY;

	CPoint m_popupPoint;
	GraphNode* m_pSelectedNode;
	GraphEdge* m_pSelectedEdge;

	GraphNode* m_pGraphNodeToAddEdge;
	CPoint m_edgeEnd0;
	CPoint m_edgeEnd1;

	BOOL m_firstDraw;

	virtual ~CGraphView();

	void planAndExec();

	GraphNode* PickGraphNode(CPoint point);
	GraphEdge* PickGraphEdge(CPoint point);
	void DrawGraph(int nodeSize, CDC* pDC);

#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	//{{AFX_MSG(CGraphView)
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRefresh();
	afx_msg void OnGraphNode();
	afx_msg void OnGraphEdge();
	afx_msg void OnGraphStay();
	afx_msg void OnGraphDirect();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // GraphView.cpp t@CfobO̎gp܂B
inline CGraphDoc* CGraphView::GetDocument()
   { return (CGraphDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio ͑Os̒Oɒǉ̐錾}܂B

#endif // !defined(AFX_GRAPHVIEW_H__36E617AF_46BC_11D1_A2EE_0000E8260BD8__INCLUDED_)
