//
// HiRiseDemo: a Demo Application of the HiRise Constraint Solver
//
// Copyright (C) 1998 Hiroshi HOSOBE
//
////////////////////////////////////////////////////////////////

// GraphView.cpp : CGraphView NX̓̒`s܂B
//

#include <time.h>
#include "stdafx.h"
#include "HiRiseDemo.h"

#include "MainFrm.h"
#include "GraphDoc.h"
#include "GraphView.h"

#include "GraphNode.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGraphView

IMPLEMENT_DYNCREATE(CGraphView, CView)

BEGIN_MESSAGE_MAP(CGraphView, CView)
	//{{AFX_MSG_MAP(CGraphView)
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_RBUTTONDOWN()
	ON_COMMAND(ID_GRAPH_NODE, OnGraphNode)
	ON_COMMAND(ID_GRAPH_EDGE, OnGraphEdge)
	ON_COMMAND(ID_GRAPH_STAY, OnGraphStay)
	ON_COMMAND(ID_GRAPH_DIRECT, OnGraphDirect)
	//}}AFX_MSG_MAP
	// WR}h
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGraphView NX̍\z/

CGraphView::CGraphView()
: m_editX(1), m_editY(1)
{
	// TODO: ̏ꏊɍ\zp̃R[hǉĂB

	m_firstDraw = TRUE;
	m_inputMode = IM_NORMAL;
	m_pDraggedGraphNode = 0;
}

CGraphView::~CGraphView()
{
}

BOOL CGraphView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: ̈ʒu CREATESTRUCT cs C Window NX܂̓X^C
	//  CĂB

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CGraphView NX̕`

void CGraphView::DrawGraph(int nodeSize, CDC* pDC)
{
	CGraphDoc* pDoc = GetDocument();
	int nNodes = pDoc->m_graphNodes.GetSize();
	int nEdges = pDoc->m_graphEdges.GetSize();
	int i;

	CPen redPen1;
	redPen1.CreatePen(PS_SOLID, pDoc->m_lineWidth, RGB(0xFF, 0, 0));

	CPen pen1;
	pen1.CreatePen(PS_SOLID, pDoc->m_lineWidth, RGB(0, 0, 0));

	for (i = 0; i < nEdges; i++) {
		GraphEdge* edge = (GraphEdge*) pDoc->m_graphEdges.GetAt(i);
		GraphNode* node0 = edge->m_node0;
		GraphNode* node1 = edge->m_node1;

		if (edge->m_direction != 0)
			pDC->SelectObject(&redPen1);
		else
			pDC->SelectObject(&pen1);

		pDC->MoveTo((LONG) *node0->m_x, (LONG) *node0->m_y);
		pDC->LineTo((LONG) *node1->m_x, (LONG) *node1->m_y);
	}

	CPen pen2;
	pen2.CreatePen(PS_SOLID, 1, RGB(0, 0, 0));
	pDC->SelectObject(&pen2);

	CBrush greenBrush(RGB(0, 0xff, 0));
	CBrush redBrush(RGB(0xff, 0, 0));
	CBrush blueBrush(RGB(0, 0, 0xff));

	for (i = 0; i < nNodes; i++) {
		GraphNode* node = (GraphNode*) pDoc->m_graphNodes.GetAt(i);

		CRect rect;
		rect.left = (LONG) *node->m_x - nodeSize / 2;
		rect.right = (LONG) *node->m_x + nodeSize / 2;
		rect.top = (LONG) *node->m_y - nodeSize / 2;
		rect.bottom = (LONG) *node->m_y + nodeSize / 2;

		if (node == m_pDraggedGraphNode) {
			pDC->SelectObject(&greenBrush);
			pDC->Ellipse(rect.left, rect.top, rect.right, rect.bottom);
		}
		else if (node->m_stayed) {
			pDC->SelectObject(&redBrush);
			pDC->Ellipse(rect.left, rect.top, rect.right, rect.bottom);
		}
		else {
			pDC->SelectObject(&blueBrush);
			pDC->Ellipse(rect.left, rect.top, rect.right, rect.bottom);
		}
	}
}

void CGraphView::OnDraw(CDC* pDC)
{
	CGraphDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	// TODO: ̏ꏊɃlCeBu f[^p̕`R[hǉ܂B

	if (m_firstDraw) {
		char buf[BUFSIZ];
		sprintf(buf, "plan: %f ms, exec: %f ms (#vars: %d, #cons: %d)",
			    pDoc->planTimeForConstruction, pDoc->execTimeForConstruction,
				pDoc->m_solver.countVars(), pDoc->m_solver.countCons());
		extern CHiRiseDemoApp theApp;
		((CMainFrame*) theApp.m_pMainWnd)->SetStatusBar(buf);
		m_firstDraw = FALSE;
	}

	CPen *pOldPen = pDC->GetCurrentPen();
	CBrush* oldBrush = pDC->GetCurrentBrush();

	if (m_inputMode == IM_SPECIFY_EDGE) {
		CPen pen;
		pen.CreatePen(PS_SOLID, pDoc->m_lineWidth, RGB(0, 0xff, 0));
		pDC->SelectObject(&pen);

		pDC->MoveTo(m_edgeEnd0);
		pDC->LineTo(m_edgeEnd1);
	}

	DrawGraph(pDoc->m_nodeSize, pDC);

	pDC->SelectObject(pOldPen);
	pDC->SelectObject(oldBrush);
}

void CGraphView::planAndExec()
{
	CGraphDoc* pDoc = GetDocument();

	CWaitCursor wc;

	clock_t t0 = clock();
	pDoc->m_solver.plan();
	clock_t t1 = clock();
	pDoc->m_solver.execute();
	clock_t t2 = clock();

	double planTime = (t1 - t0) / (double) CLOCKS_PER_SEC * 1000;
	double execTime = (t2 - t1) / (double) CLOCKS_PER_SEC * 1000;

	char buf[BUFSIZ];
	sprintf(buf, "plan: %f ms, exec: %f ms (#vars: %d, #cons: %d)",
			planTime, execTime,
			pDoc->m_solver.countVars(), pDoc->m_solver.countCons());

	extern CHiRiseDemoApp theApp;
	((CMainFrame*) theApp.m_pMainWnd)->SetStatusBar(buf);
}

/////////////////////////////////////////////////////////////////////////////
// CGraphView NẌ

BOOL CGraphView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// ftHg̈
	return DoPreparePrinting(pInfo);
}

void CGraphView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: O̓ʂȏǉĂB
}

void CGraphView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: ̌㏈ǉĂB
}

/////////////////////////////////////////////////////////////////////////////
// CGraphView NX̐ff

#ifdef _DEBUG
void CGraphView::AssertValid() const
{
	CView::AssertValid();
}

void CGraphView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CGraphDoc* CGraphView::GetDocument() // fobO o[W̓CCłB
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CGraphDoc)));
	return (CGraphDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CGraphView NX̃bZ[W nh

GraphNode* CGraphView::PickGraphNode(CPoint point)
{
	CGraphDoc* pDoc = GetDocument();
	int nNodes = pDoc->m_graphNodes.GetSize();
	int nodeSize = pDoc->m_nodeSize;
	int i;

	for (i = nNodes - 1; i >= 0; i--) {
		GraphNode* node = (GraphNode*) pDoc->m_graphNodes.GetAt(i);

		if (point.x >= (LONG) *node->m_x - nodeSize / 2 &&
			point.x <= (LONG) *node->m_x + nodeSize / 2 &&
			point.y >= (LONG) *node->m_y - nodeSize / 2 &&
			point.y <= (LONG) *node->m_y + nodeSize / 2)
			return node;
	}

	return 0;
}

GraphEdge* CGraphView::PickGraphEdge(CPoint point)
{
	CGraphDoc* pDoc = GetDocument();
	int nEdges = pDoc->m_graphEdges.GetSize();
	int tolerance = 2 * pDoc->m_lineWidth;
	int i;

	for (i = 0; i < nEdges; i++) {
		GraphEdge* edge = (GraphEdge*) pDoc->m_graphEdges.GetAt(i);
		GraphNode* node0 = edge->m_node0;
		double x0 = (double) *node0->m_x;
		double y0 = (double) *node0->m_y;
		GraphNode* node1 = edge->m_node1;
		double ax = (double) *node1->m_x - x0;
		double ay = (double) *node1->m_y - y0;
		
		if (fabs(ax) >= fabs(ay)) {
			if (fabs(ax) < 0.1)
				continue;
			
			double t = ((double) point.x - x0) / ax;
			if (t < 0 || t > 1)
				continue;

			double py = y0 + t * ay;
			if (point.y > py - tolerance && point.y < py + tolerance)
				return edge;
		}
		else {
			if (fabs(ay) < 0.1)
				continue;

			double t = ((double) point.y - y0) / ay;
			if (t < 0 || t > 1)
				continue;

			double px = x0 + t * ax;
			if (point.x > px - tolerance && point.x < px + tolerance)
				return edge;
		}
	}

	return 0;
}

void CGraphView::OnMouseMove(UINT nFlags, CPoint point) 
{
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉ邩܂̓ftHg̏ĂяoĂ
	
	CGraphDoc* pDoc = GetDocument();

	switch (m_inputMode) {
	case IM_NORMAL:
		break;
	case IM_DRAG_OBJECT:
		m_editX.set((HRValue) point.x);
		m_editY.set((HRValue) point.y);
		pDoc->m_solver.execute();

		RedrawWindow();
		break;
	case IM_SPECIFY_EDGE:
		m_edgeEnd1 = point;

		RedrawWindow();
		break;
	}

	CView::OnMouseMove(nFlags, point);
}

void CGraphView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	CGraphDoc* pDoc = GetDocument();

	switch (m_inputMode) {
	case IM_NORMAL:
		m_pDraggedGraphNode = PickGraphNode(point);

		if (m_pDraggedGraphNode != 0) {
			m_inputMode = IM_DRAG_OBJECT;

			m_editX.clear();
			m_editX.add(m_pDraggedGraphNode->m_x, (HRValue) point.x);
			pDoc->m_solver.add(m_editX);
		
			m_editY.clear();
			m_editY.add(m_pDraggedGraphNode->m_y, (HRValue) point.y);
			pDoc->m_solver.add(m_editY);

			planAndExec();

			RedrawWindow();
		}
		break;
	case IM_DRAG_OBJECT:
		m_inputMode = IM_NORMAL;
		break;
	case IM_SPECIFY_EDGE:
		break;
	}

	CView::OnLButtonDown(nFlags, point);
}

void CGraphView::OnLButtonUp(UINT nFlags, CPoint point) 
{
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉ邩܂̓ftHg̏ĂяoĂ
	
	CGraphDoc* pDoc = GetDocument();

	switch (m_inputMode) {
	case IM_NORMAL:
		break;
	case IM_DRAG_OBJECT:
		m_inputMode = IM_NORMAL;

		pDoc->m_solver.remove(m_editX);		
		pDoc->m_solver.remove(m_editY);		

		m_pDraggedGraphNode = 0;

		planAndExec();

		RedrawWindow();
		break;
	case IM_SPECIFY_EDGE:
		m_inputMode = IM_NORMAL;

		GraphNode* pNode = PickGraphNode(point);
		if (pNode != 0 || pNode == m_pGraphNodeToAddEdge) {
			GraphEdge* edge = m_pGraphNodeToAddEdge->connect(pNode);
			if (edge != 0) {
				pDoc->m_graphEdges.Add(edge);
				planAndExec();
			}
		}
		m_pGraphNodeToAddEdge = 0;

		RedrawWindow();
		break;
	}

	CView::OnLButtonUp(nFlags, point);
}

void CGraphView::OnRButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉ邩܂̓ftHg̏ĂяoĂ
	
	m_popupPoint = point;

	m_pSelectedNode = PickGraphNode(m_popupPoint);
	m_pSelectedEdge = PickGraphEdge(m_popupPoint);
	if (m_pSelectedNode != 0) {
		CMenu menu;
		menu.LoadMenu(IDR_GRAPH);
		CMenu* pPopup = menu.GetSubMenu(0);	

		/* enable ID_GRAPH_NODE */

		/* enable ID_GRAPH_EDGE */

		if (m_pSelectedNode->m_outside) {
			pPopup->CheckMenuItem(ID_GRAPH_STAY,
								  MF_BYCOMMAND | MF_CHECKED);
			pPopup->EnableMenuItem(ID_GRAPH_STAY,
								   MF_BYCOMMAND | MF_GRAYED);
		}
		else {
			if (m_pSelectedNode->m_stayed)
				pPopup->CheckMenuItem(ID_GRAPH_STAY,
									  MF_BYCOMMAND | MF_CHECKED);
			else
				pPopup->CheckMenuItem(ID_GRAPH_STAY,
									  MF_BYCOMMAND | MF_UNCHECKED);
		}

		pPopup->EnableMenuItem(ID_GRAPH_DIRECT,
							   MF_BYCOMMAND | MF_GRAYED);

		CPoint sPoint = point;
		ClientToScreen(&sPoint);
		pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON, 
							   sPoint.x, sPoint.y, this);
		menu.DestroyMenu();
	}
	else if (m_pSelectedEdge != 0) {
		CMenu menu;
		menu.LoadMenu(IDR_GRAPH);
		CMenu* pPopup = menu.GetSubMenu(0);	

		/* enable ID_GRAPH_NODE */

		pPopup->EnableMenuItem(ID_GRAPH_EDGE,
							   MF_BYCOMMAND | MF_GRAYED);

		pPopup->EnableMenuItem(ID_GRAPH_STAY,
							   MF_BYCOMMAND | MF_GRAYED);

		if (m_pSelectedEdge->m_direction != 0)
			pPopup->CheckMenuItem(ID_GRAPH_DIRECT,
								  MF_BYCOMMAND | MF_CHECKED);
		else
			pPopup->CheckMenuItem(ID_GRAPH_DIRECT,
								  MF_BYCOMMAND | MF_UNCHECKED);

		CPoint sPoint = point;
		ClientToScreen(&sPoint);
		pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON, 
							   sPoint.x, sPoint.y, this);
		menu.DestroyMenu();
	}
	else {
		CMenu menu;
		menu.LoadMenu(IDR_GRAPH);
		CMenu* pPopup = menu.GetSubMenu(0);	

		/* enable ID_GRAPH_NODE */

		pPopup->EnableMenuItem(ID_GRAPH_EDGE,
							   MF_BYCOMMAND | MF_GRAYED);

		pPopup->EnableMenuItem(ID_GRAPH_STAY,
							   MF_BYCOMMAND | MF_GRAYED);

		pPopup->EnableMenuItem(ID_GRAPH_DIRECT,
							   MF_BYCOMMAND | MF_GRAYED);

		CPoint sPoint = point;
		ClientToScreen(&sPoint);
		pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON, 
							   sPoint.x, sPoint.y, this);
		menu.DestroyMenu();
	}

	CView::OnRButtonDown(nFlags, point);
}

void CGraphView::OnGraphNode() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	
	CGraphDoc* pDoc = GetDocument();
	HRSolver* solver = &pDoc->m_solver;	

	GraphNode* node = new GraphNode(pDoc, FALSE);
	pDoc->m_graphNodes.Add(node);

	HREdit editX(1);
	editX.add(node->m_x, (HRValue) m_popupPoint.x);
	solver->add(editX);
	HREdit editY(1);
	editY.add(node->m_y, (HRValue) m_popupPoint.y);
	solver->add(editY);
	
	planAndExec();

	RedrawWindow();
}

void CGraphView::OnGraphEdge() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	
	if (m_pSelectedNode == 0)
		return;

	m_inputMode = IM_SPECIFY_EDGE;
	
	m_pGraphNodeToAddEdge = m_pSelectedNode;
	m_edgeEnd0.x = (LONG) *m_pSelectedNode->m_x;
	m_edgeEnd0.y = (LONG) *m_pSelectedNode->m_y;
	m_edgeEnd1 = m_popupPoint;

	RedrawWindow();
}

void CGraphView::OnGraphStay() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	
	CGraphDoc* pDoc = GetDocument();

	if (m_pSelectedNode == 0)
		return;

	if (m_pSelectedNode->m_stayed) {
		if (m_pSelectedNode->m_outside)
			return;

		m_pSelectedNode->unstay();
	}
	else 
		m_pSelectedNode->stay();

	planAndExec();

	RedrawWindow();
}

void CGraphView::OnGraphDirect() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	
	CGraphDoc* doc = GetDocument();

	if (m_pSelectedEdge == 0)
		return;

	if (m_pSelectedEdge->m_direction != 0)
		m_pSelectedEdge->undirect();
	else 
		m_pSelectedEdge->direct();

	planAndExec();

	RedrawWindow();
}
