//
// HiRiseDemo: a Demo Application of the HiRise Constraint Solver
//
// Copyright (C) 1998 Hiroshi HOSOBE
//
////////////////////////////////////////////////////////////////

#include "HRSolver.h"

class CGraphDoc;
class GraphNode;

class GraphEdge {
public:
	GraphNode* m_node0;
	GraphNode* m_node1;

	HRLinear* m_direction;

	GraphEdge(GraphNode* node0, GraphNode* node1);
	
	void direct();
	void undirect();
};

class GraphNode {
public:
	CGraphDoc* m_document;

	CPtrArray m_edges;

	BOOL m_outside;
	BOOL m_stayed;

	HRVar m_x;
	HRVar m_y;

	HRLinear m_averageX;
	HRLinear m_averageY;

	HRStay m_stayX;
	HRStay m_stayY;

	GraphNode(CGraphDoc* document, BOOL outside = TRUE);
	~GraphNode();

	GraphEdge* connect(GraphNode* pair);

	void stay();
	void unstay();

private:
	void updateConstraints();
};
