//
// HiRiseDemo: a Demo Application of the HiRise Constraint Solver
//
// Copyright (C) 1998 Hiroshi HOSOBE
//
////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "GraphDoc.h"
#include "GraphNode.h"

GraphEdge::GraphEdge(GraphNode* node0, GraphNode* node1)
{
	m_node0 = node0;
	m_node1 = node1;

	m_direction = 0;
}

void GraphEdge::direct()
{
	HRSolver* solver = &m_node0->m_document->m_solver;
	HRParser* parser = &m_node0->m_document->m_parser;

	if (m_direction != 0)
		return;

	char buf[BUFSIZ];
	sprintf(buf, "%f * ($0 - $1) - %f * ($2 - $3) = 0",
			*m_node1->m_y - *m_node0->m_y,
			*m_node1->m_x - *m_node0->m_x);
	m_direction = (HRLinear*)
		parser->createCon(2, buf,
						  &m_node1->m_x, &m_node0->m_x,
						  &m_node1->m_y, &m_node0->m_y);
	solver->add(m_direction);
}

void GraphEdge::undirect()
{
	if (m_direction == 0)
		return;

	delete m_direction;

	m_direction = 0;
}

GraphNode::GraphNode(CGraphDoc* document, BOOL outside)
: m_averageX(4), m_averageY(4), m_stayX(3), m_stayY(3)
{
	m_document = document;
	m_outside = outside;
	m_stayed = FALSE;
}

GraphNode::~GraphNode()
{
	int i, j;

	int nEdges = m_edges.GetSize();

	for (i = 0; i < nEdges; i++) {
		GraphEdge* edge = (GraphEdge*) m_edges.GetAt(i);

		GraphNode* pair;
		if (edge->m_node0 == this)
			pair = edge->m_node1;
		else // edge->m_node1 == this
			pair = edge->m_node0;

		int nPairEdges = pair->m_edges.GetSize();
		for (j = 0; j < nPairEdges; j++) {
			GraphEdge* e = (GraphEdge*) pair->m_edges.GetAt(j);
			if (e == edge) {
				pair->m_edges.RemoveAt(j);
				break;
			}
		}

		delete edge;
	}
}

void GraphNode::updateConstraints()
{
	int nEdges = m_edges.GetSize();
	int i;

	m_averageX.clear();
	m_averageY.clear();

	m_averageX.add(m_x, (HRValue) nEdges);
	m_averageY.add(m_y, (HRValue) nEdges);

	for (i = 0; i < nEdges; i++) {
		GraphEdge* edge = (GraphEdge*) m_edges.GetAt(i);

		GraphNode* pair;
		if (edge->m_node0 == this)
			pair = edge->m_node1;
		else // edge->m_node1 == this
			pair = edge->m_node0;

		m_averageX.add(pair->m_x, (HRValue) -1);
		m_averageY.add(pair->m_y, (HRValue) -1);
	}

	m_document->m_solver.add(m_averageX);
	m_document->m_solver.add(m_averageY);
}

GraphEdge* GraphNode::connect(GraphNode* pair)
{
	int i;

	int nEdges = m_edges.GetSize();
	for (i = 0; i < nEdges; i++) {
		GraphEdge* edge = (GraphEdge*) m_edges.GetAt(i);

		GraphNode* p;
		if (edge->m_node0 == this)
			p = edge->m_node1;
		else // edge->m_node1 == this
			p = edge->m_node0;

		if (p == pair)
			return 0;
	}

	GraphEdge* edge = new GraphEdge(this, pair);
	m_edges.Add(edge);
	pair->m_edges.Add(edge);

	if (nEdges > 0 && !m_outside)
		updateConstraints();
	if (pair->m_edges.GetSize() > 1 && !pair->m_outside)
		pair->updateConstraints();

	return edge;
}

void GraphNode::stay()
{
	if (m_stayed)
		return;

	m_stayed = TRUE;

	m_stayX.add(m_x);
	m_document->m_solver.add(m_stayX);

	m_stayY.add(m_y);
	m_document->m_solver.add(m_stayY);
}

void GraphNode::unstay()
{
	if (!m_stayed)
		return;

	m_stayed = FALSE;

	m_stayX.clear();
	m_stayY.clear();
}
