//
// HiRiseDemo: a Demo Application of the HiRise Constraint Solver
//
// Copyright (C) 1998 Hiroshi HOSOBE
//
////////////////////////////////////////////////////////////////

// GraphDoc.cpp : CGraphDoc NX̓̒`s܂B
//

#include <time.h>
#include "stdafx.h"
#include <math.h>
#include "HiRiseDemo.h"

#include "GraphDoc.h"

#include "GraphNode.h"
#include "GraphDialog.h"

#ifndef M_PI
#define	M_PI 3.14159265358979323846
#endif // !M_PI

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGraphDoc

IMPLEMENT_DYNCREATE(CGraphDoc, CDocument)

BEGIN_MESSAGE_MAP(CGraphDoc, CDocument)
	//{{AFX_MSG_MAP(CGraphDoc)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
		//        ̈ʒuɐR[hҏWȂłB
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGraphDoc NX̍\z/

CGraphDoc::CGraphDoc()
{
	// TODO: ̈ʒuɂPxĂ΂\zp̃R[hǉĂB

	int i;

	CGraphDialog dialog;
	dialog.DoModal();

	CPtrArray editXs;
	CPtrArray editYs;
	
	GraphNode* node;
	for (i = 0; i < dialog.m_nOutsideNodes; i++) {
		node = new GraphNode(this);
		m_graphNodes.Add(node);
		
		if (i > 0) {
			GraphNode* lastNode = (GraphNode*) m_graphNodes.GetAt(i - 1);
			m_graphEdges.Add(node->connect(lastNode));
		}
			
		node->stay();

		HREdit* editX = new HREdit(0);
		editX->add(node->m_x,
				   (250 + 100 * cosf(2 * (float) M_PI
									 / dialog.m_nOutsideNodes * i)));
		m_solver.add(*editX);
		editXs.Add(editX);

		HREdit* editY = new HREdit(0);
		editY->add(node->m_y,
				   (120 - 100 * sinf(2 * (float) M_PI
									 / dialog.m_nOutsideNodes * i)));
		m_solver.add(*editY);
		editYs.Add(editY);
	}		
	GraphNode* firstNode = (GraphNode*) m_graphNodes.GetAt(0);
	m_graphEdges.Add(firstNode->connect(node));

	clock_t t0 = clock();
	m_solver.plan();
	clock_t t1 = clock();
	m_solver.execute();
	clock_t t2 = clock();

	for (i = 0; i < dialog.m_nOutsideNodes; i++) {
		HREdit* editX = (HREdit*) editXs.GetAt(i);
		delete editX;
		
		HREdit* editY = (HREdit*) editYs.GetAt(i);
		delete editY;
	}

	planTimeForConstruction = (t1 - t0) / (double) CLOCKS_PER_SEC * 1000;
	execTimeForConstruction = (t2 - t1) / (double) CLOCKS_PER_SEC * 1000;

	m_nodeSize = 20;
	m_lineWidth = 2;
}

CGraphDoc::~CGraphDoc()
{
	int nNodes = m_graphNodes.GetSize();
	int i;
	
	for (i = 0; i < nNodes; i++) {
		GraphNode* node = (GraphNode*) m_graphNodes.GetAt(i);
		delete node;
	}
}

BOOL CGraphDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// TODO: ̈ʒuɍďǉĂB
	// (SDI hLg͂̃hLgėp܂B)

	return TRUE;
}



/////////////////////////////////////////////////////////////////////////////
// CGraphDoc VAC[[V

void CGraphDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: ̈ʒuɕۑp̃R[hǉĂB
	}
	else
	{
		// TODO: ̈ʒuɓǂݍݗp̃R[hǉĂB
	}
}

/////////////////////////////////////////////////////////////////////////////
// CGraphDoc NX̐ff

#ifdef _DEBUG
void CGraphDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CGraphDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CGraphDoc R}h
