//
// HiRiseDemo: a Demo Application of the HiRise Constraint Solver
//
// Copyright (C) 1998 Hiroshi HOSOBE
//
////////////////////////////////////////////////////////////////

// BinTreeView.h : CBinTreeView NX̐錾уC^[tFCX̒`܂B
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_BINTREEVIEW_H__36E617AF_46BC_11D1_A2EE_0000E8260BD8__INCLUDED_)
#define AFX_BINTREEVIEW_H__36E617AF_46BC_11D1_A2EE_0000E8260BD8__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "HRSolver.h"

class BinTreeNode;

class CBinTreeView : public CView
{
protected: // VACY@\݂̂쐬܂B
	CBinTreeView();
	DECLARE_DYNCREATE(CBinTreeView)

// Agr[g
public:
	CBinTreeDoc* GetDocument();

// Iy[V
public:

// I[o[Ch
	// ClassWizard ͉z֐̃I[o[Ch𐶐܂B
	//{{AFX_VIRTUAL(CBinTreeView)
	public:
	virtual void OnDraw(CDC* pDC);  // ̃r[`悷ۂɃI[o[Ch܂B
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	protected:
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	//}}AFX_VIRTUAL

// Cve[V
public:
	typedef enum {
		IM_NORMAL,
		IM_DRAG_OBJECT,
		IM_SPECIFY_LINE
	} InputMode;

	InputMode m_inputMode;

	BinTreeNode* m_pDraggedBinTreeNode;
	HREdit m_editX;
	HREdit m_editY;

	CPoint m_popupPoint;
	BinTreeNode* m_pSelectedNode;

	struct StayBinTreeData {
		BinTreeNode* m_pNode;
		HRStay m_stayX;
		HRStay m_stayY;
		
#ifdef WEAKER
		StayBinTreeData() : m_stayX(2), m_stayY(2) { m_pNode = 0; }
#else // !WEAKER
		StayBinTreeData() : m_stayX(1), m_stayY(1) { m_pNode = 0; }
#endif // WEAKER
	};

	CPtrArray m_stayBinTreeData;

	BinTreeNode* m_pLinedBinTreeNode;
	CPoint m_lineEnd0;
	CPoint m_lineEnd1;

	struct LineBinTreeData {
		BinTreeNode* m_pNode;
		CPoint m_lineEnd0;
		CPoint m_lineEnd1;
		HRLinear m_line;
		
#ifdef WEAKER
		LineBinTreeData() : m_line(2) { m_pNode = 0; }
#else // !WEAKER
		LineBinTreeData() : m_line(1) { m_pNode = 0; }
#endif // WEAKER
	};

	CPtrArray m_lineBinTreeData;

	BOOL m_firstDraw;

	virtual ~CBinTreeView();

	void planAndExec();

	void CalcEndPoints(CRect rect, CPoint point0, CPoint point1, 
					   CPoint& end0, CPoint& end1);
	BinTreeNode* PickBinTreeNode(BinTreeNode* pBinTree, int nodeSize, CPoint point);
	void DrawBinTree(BinTreeNode* pBinTree, int nodeSize, CDC* pDC);
	void RemoveStaysAndLines(BinTreeNode* pNode);

#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	//{{AFX_MSG(CBinTreeView)
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnBinTreeAdd();
	afx_msg void OnBinTreeRemove();
	afx_msg void OnBinTreeStay();
	afx_msg void OnBinTreeLine();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // BinTreeView.cpp t@CfobO̎gp܂B
inline CBinTreeDoc* CBinTreeView::GetDocument()
   { return (CBinTreeDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio ͑Os̒Oɒǉ̐錾}܂B

#endif // !defined(AFX_BINTREEVIEW_H__36E617AF_46BC_11D1_A2EE_0000E8260BD8__INCLUDED_)
