//
// HiRiseDemo: a Demo Application of the HiRise Constraint Solver
//
// Copyright (C) 1998 Hiroshi HOSOBE
//
////////////////////////////////////////////////////////////////

// BinTreeView.cpp : CBinTreeView NX̓̒`s܂B
//

#include <time.h>
#include "stdafx.h"
#include "HiRiseDemo.h"

#include "MainFrm.h"
#include "BinTreeDoc.h"
#include "BinTreeView.h"

#include "BinTreeNode.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CBinTreeView

IMPLEMENT_DYNCREATE(CBinTreeView, CView)

BEGIN_MESSAGE_MAP(CBinTreeView, CView)
	//{{AFX_MSG_MAP(CBinTreeView)
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_RBUTTONDOWN()
	ON_COMMAND(ID_BIN_TREE_ADD, OnBinTreeAdd)
	ON_COMMAND(ID_BIN_TREE_REMOVE, OnBinTreeRemove)
	ON_COMMAND(ID_BIN_TREE_STAY, OnBinTreeStay)
	ON_COMMAND(ID_BIN_TREE_LINE, OnBinTreeLine)
	//}}AFX_MSG_MAP
	// WR}h
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBinTreeView NX̍\z/

CBinTreeView::CBinTreeView()
#ifdef WEAKER
: m_editX(3), m_editY(3)
#else // !WEAKER
: m_editX(2), m_editY(2)
#endif // WEAKER
{
	// TODO: ̏ꏊɍ\zp̃R[hǉĂB

	m_firstDraw = TRUE;
	m_inputMode = IM_NORMAL;
	m_pDraggedBinTreeNode = 0;
}

CBinTreeView::~CBinTreeView()
{
	while (m_stayBinTreeData.GetSize() > 0) {
		StayBinTreeData* pData = (StayBinTreeData*)
			m_stayBinTreeData.GetAt(0);
		m_stayBinTreeData.RemoveAt(0);
		delete pData;
	}
	while (m_lineBinTreeData.GetSize() > 0) {
		LineBinTreeData* pData = (LineBinTreeData*)
			m_lineBinTreeData.GetAt(0);
		m_lineBinTreeData.RemoveAt(0);
		delete pData;
	}
}

BOOL CBinTreeView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: ̈ʒu CREATESTRUCT cs C Window NX܂̓X^C
	//  CĂB

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CBinTreeView NX̕`

void CBinTreeView::CalcEndPoints(CRect rect, 
									CPoint point0, CPoint point1, 
									CPoint& end0, CPoint& end1)
{
	CPoint end[4];
	double a, b, c;
	double x, y;
	int i;

	a = point1.y - point0.y;
	b = -(point1.x - point0.x);
	c = point0.x * a + point0.y * b;

	int n = 0;

	if (b != 0) {
		// left
		y = (c - a * rect.left) / b;
		if (y >= rect.top && y <= rect.bottom) {
			end[n].x = rect.left;
			end[n].y = (LONG) y;
			n++;
		}
		
		// right
		y = (c - a * rect.right) / b;
		if (y >= rect.top && y <= rect.bottom) {
			end[n].x = rect.right;
			end[n].y = (LONG) y;
			n++;
		}
	}

	if (a != 0) {
		// top
		x = (c - b * rect.top) / a;
		if (x >= rect.left && x <= rect.right) {
			end[n].x = (LONG) x;
			end[n].y = rect.top;
			n++;
		}

		// bottom
		x = (c - b * rect.bottom) / a;
		if (x >= rect.left && x <= rect.right) {
			end[n].x = (LONG) x;
			end[n].y = rect.bottom;
			n++;
		}
	}

	if (n == 0)
		end0.x = end0.y = end1.x = end1.y = 0;
	else if (n == 1)
		end0 = end1 = end[0];
	else if (n == 2) {
		end0 = end[0];
		end1 = end[1];
	}
	else if (n > 2) {
		end0 = end[0];
		for (i = 1; i < n; i++) {
			if (end[i].x != end0.x || end[i].y != end0.y) {
				end1 = end[i];
				break;
			}
		}
		if (i == n)
			end1 = end0;
	}
}

void CBinTreeView::DrawBinTree(BinTreeNode* pBinTree, int nodeSize, CDC* pDC)
{
	int i;

	CPoint p;
	p.x = (LONG) *pBinTree->m_x;
	p.y = (LONG) *pBinTree->m_y;

	if (pBinTree->m_pLeftChild != 0) {
		pDC->MoveTo(p);
		pDC->LineTo((LONG) *pBinTree->m_pLeftChild->m_x,
					(LONG) *pBinTree->m_pLeftChild->m_y);
	}

	if (pBinTree->m_pRightChild != 0) {
		pDC->MoveTo(p);
		pDC->LineTo((LONG) *pBinTree->m_pRightChild->m_x,
					(LONG) *pBinTree->m_pRightChild->m_y);
	}

	CRect rect;
	rect.left = p.x - nodeSize / 2;
	rect.right = p.x + nodeSize / 2;
	rect.top = p.y - nodeSize / 2;
	rect.bottom = p.y + nodeSize / 2;

	if (pBinTree == m_pDraggedBinTreeNode)
		pDC->FillSolidRect(&rect, RGB(0, 0xff, 0));
	else {
		BOOL done = FALSE;

		for (i = 0; i < m_stayBinTreeData.GetSize(); i++) {
			StayBinTreeData* pData = (StayBinTreeData*)
				m_stayBinTreeData.GetAt(i);
			if (pData->m_pNode == pBinTree) {
				pDC->FillSolidRect(&rect, RGB(0xff, 0, 0));
				done = TRUE;
				break;
			}
		}

		if (!done) {
			for (i = 0; i < m_lineBinTreeData.GetSize(); i++) {
				LineBinTreeData* pData = (LineBinTreeData*)
					m_lineBinTreeData.GetAt(i);
				if (pData->m_pNode == pBinTree) {
					pDC->FillSolidRect(&rect, RGB(0xff, 0, 0));
					done = TRUE;
					break;
				}
			}
		}

		if (!done)
			pDC->FillSolidRect(&rect, RGB(0, 0, 0xff));
	}

	if (pBinTree->m_pLeftChild != 0)
		DrawBinTree(pBinTree->m_pLeftChild, nodeSize, pDC);

	if (pBinTree->m_pRightChild != 0)
		DrawBinTree(pBinTree->m_pRightChild, nodeSize, pDC);
}

void CBinTreeView::OnDraw(CDC* pDC)
{
	CBinTreeDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	// TODO: ̏ꏊɃlCeBu f[^p̕`R[hǉ܂B

	if (m_firstDraw) {
		char buf[BUFSIZ];
		sprintf(buf, "plan: %f ms, exec: %f ms (#vars: %d, #cons: %d)",
			    pDoc->planTimeForConstruction, pDoc->execTimeForConstruction,
				pDoc->m_solver.countVars(), pDoc->m_solver.countCons());
		extern CHiRiseDemoApp theApp;
		((CMainFrame*) theApp.m_pMainWnd)->SetStatusBar(buf);
		m_firstDraw = FALSE;
	}

	int i;

	CRect rect;
	GetClientRect(rect);

	CPen *pOldPen = pDC->GetCurrentPen();

	if (m_inputMode == IM_SPECIFY_LINE) {
		CPoint end0;
		CPoint end1;
		CalcEndPoints(rect, m_lineEnd0, m_lineEnd1, end0, end1);

		CPen pen;
		pen.CreatePen(PS_SOLID, pDoc->m_lineWidth, RGB(0, 0xff, 0));
		pDC->SelectObject(&pen);

		pDC->MoveTo(end0);
		pDC->LineTo(end1);
	}

	CPen pen;
	pen.CreatePen(PS_SOLID, pDoc->m_lineWidth, RGB(0xff, 0, 0));
	pDC->SelectObject(&pen);

	for (i = 0; i < m_lineBinTreeData.GetSize(); i++) {
		LineBinTreeData* pData = (LineBinTreeData*)
			m_lineBinTreeData.GetAt(i);

		CPoint end0;
		CPoint end1;
		CalcEndPoints(rect, pData->m_lineEnd0, pData->m_lineEnd1,
					  end0, end1);

		pDC->MoveTo(end0);
		pDC->LineTo(end1);
	}

	CPen pen1;
	pen1.CreatePen(PS_SOLID, pDoc->m_lineWidth, RGB(0, 0, 0));
	pDC->SelectObject(&pen1);

	DrawBinTree(pDoc->m_pBinTree, pDoc->m_nodeSize, pDC);

	pDC->SelectObject(pOldPen);
}

void CBinTreeView::planAndExec()
{
	CBinTreeDoc* pDoc = GetDocument();

	CWaitCursor wc;

	clock_t t0 = clock();
	pDoc->m_solver.plan();
	clock_t t1 = clock();
	pDoc->m_solver.execute();
	clock_t t2 = clock();

	double planTime = (t1 - t0) / (double) CLOCKS_PER_SEC * 1000;
	double execTime = (t2 - t1) / (double) CLOCKS_PER_SEC * 1000;

	char buf[BUFSIZ];
	sprintf(buf, "plan: %f ms, exec: %f ms (#vars: %d, #cons: %d)",
			planTime, execTime,
			pDoc->m_solver.countVars(), pDoc->m_solver.countCons());

	extern CHiRiseDemoApp theApp;
	((CMainFrame*) theApp.m_pMainWnd)->SetStatusBar(buf);
}

/////////////////////////////////////////////////////////////////////////////
// CBinTreeView NẌ

BOOL CBinTreeView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// ftHg̈
	return DoPreparePrinting(pInfo);
}

void CBinTreeView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: O̓ʂȏǉĂB
}

void CBinTreeView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: ̌㏈ǉĂB
}

/////////////////////////////////////////////////////////////////////////////
// CBinTreeView NX̐ff

#ifdef _DEBUG
void CBinTreeView::AssertValid() const
{
	CView::AssertValid();
}

void CBinTreeView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CBinTreeDoc* CBinTreeView::GetDocument() // fobO o[W̓CCłB
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CBinTreeDoc)));
	return (CBinTreeDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CBinTreeView NX̃bZ[W nh

BinTreeNode* CBinTreeView::PickBinTreeNode(BinTreeNode* pBinTree, int nodeSize, CPoint point)
{
	if (pBinTree->m_pRightChild != 0) {
		BinTreeNode* pickedNode = PickBinTreeNode(pBinTree->m_pRightChild,
												  nodeSize, point);
		if (pickedNode != 0)
			return pickedNode;
	}

	if (pBinTree->m_pLeftChild != 0) {
		BinTreeNode* pickedNode = PickBinTreeNode(pBinTree->m_pLeftChild,
												  nodeSize, point);
		if (pickedNode != 0)
			return pickedNode;
	}

	if (point.x >= (LONG) *pBinTree->m_x - nodeSize / 2 &&
		point.x <= (LONG) *pBinTree->m_x + nodeSize / 2 &&
	    point.y >= (LONG) *pBinTree->m_y - nodeSize / 2 &&
		point.y <= (LONG) *pBinTree->m_y + nodeSize / 2)
		return pBinTree;

	return 0;
}

void CBinTreeView::OnMouseMove(UINT nFlags, CPoint point) 
{
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉ邩܂̓ftHg̏ĂяoĂ
	
	CBinTreeDoc* pDoc = GetDocument();

	switch (m_inputMode) {
	case IM_NORMAL:
		break;
	case IM_DRAG_OBJECT:
		m_editX.set((HRValue) point.x);
		m_editY.set((HRValue) point.y);
		pDoc->m_solver.execute();

		RedrawWindow();
		break;
	case IM_SPECIFY_LINE:
		m_lineEnd1 = point;

		RedrawWindow();
		break;
	}

	CView::OnMouseMove(nFlags, point);
}

void CBinTreeView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	CBinTreeDoc* pDoc = GetDocument();

	switch (m_inputMode) {
	case IM_NORMAL:
		m_pDraggedBinTreeNode = PickBinTreeNode(pDoc->m_pBinTree, pDoc->m_nodeSize, point);

		if (m_pDraggedBinTreeNode != 0) {
			m_inputMode = IM_DRAG_OBJECT;

			m_editX.clear();
			m_editX.add(m_pDraggedBinTreeNode->m_x, (HRValue) point.x);
			pDoc->m_solver.add(m_editX);
		
			m_editY.clear();
			m_editY.add(m_pDraggedBinTreeNode->m_y, (HRValue) point.y);
			pDoc->m_solver.add(m_editY);

			RedrawWindow();

			planAndExec();
		}
		break;
	case IM_DRAG_OBJECT:
		m_inputMode = IM_NORMAL;
		break;
	case IM_SPECIFY_LINE:
		break;
	}

	CView::OnLButtonDown(nFlags, point);
}

void CBinTreeView::OnLButtonUp(UINT nFlags, CPoint point) 
{
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉ邩܂̓ftHg̏ĂяoĂ
	
	CBinTreeDoc* pDoc = GetDocument();

	switch (m_inputMode) {
	case IM_NORMAL:
		break;
	case IM_DRAG_OBJECT:
		m_inputMode = IM_NORMAL;

		pDoc->m_solver.remove(m_editX);		
		pDoc->m_solver.remove(m_editY);		

		m_pDraggedBinTreeNode = 0;

		RedrawWindow();

		planAndExec();
		break;
	case IM_SPECIFY_LINE:
		m_inputMode = IM_NORMAL;

		LineBinTreeData* pData = new LineBinTreeData;

		pData->m_pNode = m_pLinedBinTreeNode;
		pData->m_lineEnd0 = m_lineEnd0;
		pData->m_lineEnd1 = m_lineEnd1;

		pData->m_line.clear();
		pData->m_line.add(m_pLinedBinTreeNode->m_x,
						  (HRValue) m_lineEnd1.y - m_lineEnd0.y);
		pData->m_line.add(m_pLinedBinTreeNode->m_y,
						  (HRValue) -(m_lineEnd1.x - m_lineEnd0.x));
		pData->m_line.setConst((HRValue) m_lineEnd0.x * (m_lineEnd1.y - m_lineEnd0.y)
							   - m_lineEnd0.y * (m_lineEnd1.x - m_lineEnd0.x));
		pDoc->m_solver.add(pData->m_line);

		m_lineBinTreeData.Add(pData);

		RedrawWindow();

		planAndExec();
		break;
	}

	CView::OnLButtonUp(nFlags, point);
}

void CBinTreeView::RemoveStaysAndLines(BinTreeNode* pNode)
{
	int i;

	if (pNode->m_pLeftChild != 0)
		RemoveStaysAndLines(pNode->m_pLeftChild);
	if (pNode->m_pRightChild != 0)
		RemoveStaysAndLines(pNode->m_pRightChild);

	for (i = 0; i < m_stayBinTreeData.GetSize(); i++) {
		StayBinTreeData* pData = (StayBinTreeData*)
			m_stayBinTreeData.GetAt(i);
		if (pData->m_pNode == pNode) {
			m_stayBinTreeData.RemoveAt(i);
			delete pData;
			break;
		}
	}
	
	for (i = 0; i < m_lineBinTreeData.GetSize(); i++) {
		LineBinTreeData* pData = (LineBinTreeData*)
			m_lineBinTreeData.GetAt(i);
		if (pData->m_pNode == pNode) {
			m_lineBinTreeData.RemoveAt(i);
			delete pData;
			break;
		}
	}
}

void CBinTreeView::OnRButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉ邩܂̓ftHg̏ĂяoĂ
	
	CBinTreeDoc* pDoc = GetDocument();
	int i;

	m_popupPoint = point;

	m_pSelectedNode = PickBinTreeNode(pDoc->m_pBinTree, pDoc->m_nodeSize,
									  point);
	if (m_pSelectedNode != 0) {
		CMenu menu;
		menu.LoadMenu(IDR_BIN_TREE);
		CMenu* pPopup = menu.GetSubMenu(0);	

		if (m_pSelectedNode->m_pLeftChild == 0 ||
			m_pSelectedNode->m_pRightChild == 0)
			pPopup->EnableMenuItem(ID_BIN_TREE_ADD,
								   MF_BYCOMMAND | MF_ENABLED);
		else
			pPopup->EnableMenuItem(ID_BIN_TREE_ADD,
								   MF_BYCOMMAND | MF_GRAYED);
		
		if (m_pSelectedNode->m_pParent != 0)
			pPopup->EnableMenuItem(ID_BIN_TREE_REMOVE,
								   MF_BYCOMMAND | MF_ENABLED);
		else
			pPopup->EnableMenuItem(ID_BIN_TREE_REMOVE,
								   MF_BYCOMMAND | MF_GRAYED);
		
		for (i = 0; i < m_stayBinTreeData.GetSize(); i++) {
			StayBinTreeData* pData = (StayBinTreeData*)
				m_stayBinTreeData.GetAt(i);
			if (pData->m_pNode == m_pSelectedNode)
				break;
		}
		if (i < m_stayBinTreeData.GetSize())
			pPopup->CheckMenuItem(ID_BIN_TREE_STAY,
								  MF_BYCOMMAND | MF_CHECKED);
		else
			pPopup->CheckMenuItem(ID_BIN_TREE_STAY,
								  MF_BYCOMMAND | MF_UNCHECKED);

		for (i = 0; i < m_lineBinTreeData.GetSize(); i++) {
			LineBinTreeData* pData = (LineBinTreeData*)
				m_lineBinTreeData.GetAt(i);
			if (pData->m_pNode == m_pSelectedNode)
				break;
		}
		if (i < m_lineBinTreeData.GetSize())
			pPopup->CheckMenuItem(ID_BIN_TREE_LINE,
								  MF_BYCOMMAND | MF_CHECKED);
		else
			pPopup->CheckMenuItem(ID_BIN_TREE_LINE,
								  MF_BYCOMMAND | MF_UNCHECKED);

		CPoint sPoint = point;
		ClientToScreen(&sPoint);
		pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON, 
							   sPoint.x, sPoint.y, this);
		menu.DestroyMenu();
	}

	CView::OnRButtonDown(nFlags, point);
}

void CBinTreeView::OnBinTreeAdd() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	
	CBinTreeDoc* pDoc = GetDocument();

	if (m_pSelectedNode == 0)
		return;

	if (m_pSelectedNode->m_pLeftChild == 0) {
		if (m_pSelectedNode->m_pRightChild == 0) {
			m_pSelectedNode->m_xInterval.clear();

			m_pSelectedNode->m_pLeftChild =
				new BinTreeNode(&pDoc->m_solver, pDoc->m_xUnit, pDoc->m_yUnit,
								m_pSelectedNode, 1);
			
			m_pSelectedNode->m_midAlign.clear();
			m_pSelectedNode
				->m_midAlign.equal(m_pSelectedNode->m_x,
								   m_pSelectedNode->m_pLeftChild->m_x);
			pDoc->m_solver.add(m_pSelectedNode->m_midAlign);

			m_pSelectedNode->m_leftAlign.clear();
			m_pSelectedNode
				->m_leftAlign.equal(m_pSelectedNode->m_left,
									m_pSelectedNode->m_pLeftChild->m_left);
			pDoc->m_solver.add(m_pSelectedNode->m_leftAlign);

			m_pSelectedNode->m_rightAlign.clear();
			m_pSelectedNode
				->m_rightAlign.equal(m_pSelectedNode->m_right,
									 m_pSelectedNode->m_pLeftChild->m_right);
			pDoc->m_solver.add(m_pSelectedNode->m_rightAlign);

			m_pSelectedNode->m_leftYInterval.clear();
			m_pSelectedNode
				->m_leftYInterval.sum(m_pSelectedNode->m_y, pDoc->m_yUnit,
									  m_pSelectedNode->m_pLeftChild->m_y);
			pDoc->m_solver.add(m_pSelectedNode->m_leftYInterval);
		}
		else {
			m_pSelectedNode->m_pLeftChild =
				new BinTreeNode(&pDoc->m_solver, pDoc->m_xUnit, pDoc->m_yUnit,
								m_pSelectedNode, 1);
			
			m_pSelectedNode->m_midAlign.clear();
			m_pSelectedNode
				->m_midAlign.center(m_pSelectedNode->m_pRightChild->m_x,
									m_pSelectedNode->m_pLeftChild->m_x,
									m_pSelectedNode->m_x);
			pDoc->m_solver.add(m_pSelectedNode->m_midAlign);

			m_pSelectedNode->m_leftAlign.clear();
			m_pSelectedNode
				->m_leftAlign.equal(m_pSelectedNode->m_left,
									m_pSelectedNode->m_pLeftChild->m_left);
			pDoc->m_solver.add(m_pSelectedNode->m_leftAlign);

			m_pSelectedNode->m_childrenGlue.clear();
			m_pSelectedNode
				->m_childrenGlue.equal(m_pSelectedNode->m_pRightChild->m_left,
									   m_pSelectedNode->m_pLeftChild->m_right);
			pDoc->m_solver.add(m_pSelectedNode->m_childrenGlue);

			m_pSelectedNode->m_leftYInterval.clear();
			m_pSelectedNode
				->m_leftYInterval.sum(m_pSelectedNode->m_y, pDoc->m_yUnit,
									  m_pSelectedNode->m_pLeftChild->m_y);
			pDoc->m_solver.add(m_pSelectedNode->m_leftYInterval);
		}
	}
	else {
		if (m_pSelectedNode->m_pRightChild == 0) {
			m_pSelectedNode->m_pRightChild =
				new BinTreeNode(&pDoc->m_solver, pDoc->m_xUnit, pDoc->m_yUnit,
								m_pSelectedNode, 1);
			
			m_pSelectedNode->m_midAlign.clear();
			m_pSelectedNode
				->m_midAlign.center(m_pSelectedNode->m_pLeftChild->m_x,
									m_pSelectedNode->m_pRightChild->m_x,
									m_pSelectedNode->m_x);
			pDoc->m_solver.add(m_pSelectedNode->m_midAlign);

			m_pSelectedNode->m_rightAlign.clear();
			m_pSelectedNode
				->m_rightAlign.equal(m_pSelectedNode->m_right, 
									 m_pSelectedNode->m_pRightChild->m_right);
			pDoc->m_solver.add(m_pSelectedNode->m_rightAlign);

			m_pSelectedNode->m_childrenGlue.clear();
			m_pSelectedNode
				->m_childrenGlue.equal(m_pSelectedNode->m_pLeftChild->m_right, 
									   m_pSelectedNode->m_pRightChild->m_left);
			pDoc->m_solver.add(m_pSelectedNode->m_childrenGlue);

			m_pSelectedNode->m_rightYInterval.clear();
			m_pSelectedNode
				->m_rightYInterval.sum(m_pSelectedNode->m_y, pDoc->m_yUnit,
									   m_pSelectedNode->m_pRightChild->m_y);
			pDoc->m_solver.add(m_pSelectedNode->m_rightYInterval);
		}
		else 
			return;
	}

	planAndExec();

	RedrawWindow();
}

void CBinTreeView::OnBinTreeRemove() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	
	CBinTreeDoc* pDoc = GetDocument();

	if (m_pSelectedNode == 0 || 
		m_pSelectedNode->m_pParent == 0)
		return;

	BinTreeNode* pParent = m_pSelectedNode->m_pParent; 

	if (pParent->m_pLeftChild == m_pSelectedNode)
		pParent->m_pLeftChild = 0;
	else
		pParent->m_pRightChild = 0;

	RemoveStaysAndLines(m_pSelectedNode);
	delete m_pSelectedNode;

	if (pParent->m_pLeftChild != 0) {
		pParent->m_midAlign.clear();
		pParent->m_midAlign.equal(pParent->m_x, 
								  pParent->m_pLeftChild->m_x);
		pDoc->m_solver.add(pParent->m_midAlign);

		pParent->m_rightAlign.clear();
		pParent->m_rightAlign.equal(pParent->m_right, 
									pParent->m_pLeftChild->m_right);
		pDoc->m_solver.add(pParent->m_rightAlign);
	}
	else if (pParent->m_pRightChild != 0) {
		pParent->m_midAlign.clear();
		pParent->m_midAlign.equal(pParent->m_x, 
								  pParent->m_pRightChild->m_x);
		pDoc->m_solver.add(pParent->m_midAlign);

		pParent->m_leftAlign.clear();
		pParent->m_leftAlign.equal(pParent->m_left, 
								   pParent->m_pRightChild->m_left);
		pDoc->m_solver.add(pParent->m_leftAlign);
	}
	else {
		pParent->m_midAlign.clear();
		pParent->m_midAlign.center(pParent->m_left, pParent->m_right,
								   pParent->m_x);
		pDoc->m_solver.add(pParent->m_midAlign);

		pParent->m_xInterval.clear();
		pParent->m_xInterval.sum(pParent->m_left, pDoc->m_xUnit,
								 pParent->m_right);
		pDoc->m_solver.add(pParent->m_xInterval);
	}

	planAndExec();

	RedrawWindow();
}

void CBinTreeView::OnBinTreeStay() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	
	CBinTreeDoc* pDoc = GetDocument();
	int i;

	if (m_pSelectedNode == 0)
		return;

	StayBinTreeData* pData;
	for (i = 0; i < m_stayBinTreeData.GetSize(); i++) {
		pData = (StayBinTreeData*) m_stayBinTreeData.GetAt(i);
		if (pData->m_pNode == m_pSelectedNode)
			break;
	}
	if (i < m_stayBinTreeData.GetSize()) {
		m_stayBinTreeData.RemoveAt(i);
		delete pData;
	}
	else {
		pData = new StayBinTreeData;
	
		pData->m_pNode = m_pSelectedNode;
		pData->m_stayX.add(m_pSelectedNode->m_x);
		pDoc->m_solver.add(pData->m_stayX);
		pData->m_stayY.add(m_pSelectedNode->m_y);
		pDoc->m_solver.add(pData->m_stayY);

		m_stayBinTreeData.Add(pData);
	}

	planAndExec();

	RedrawWindow();
}

void CBinTreeView::OnBinTreeLine() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	
	CBinTreeDoc* pDoc = GetDocument();
	int i;

	if (m_pSelectedNode == 0)
		return;

	LineBinTreeData* pData;
	for (i = 0; i < m_lineBinTreeData.GetSize(); i++) {
		pData = (LineBinTreeData*) m_lineBinTreeData.GetAt(i);
		if (pData->m_pNode == m_pSelectedNode)
			break;
	}
	if (i < m_lineBinTreeData.GetSize()) {
		m_lineBinTreeData.RemoveAt(i);
		delete pData;

		planAndExec();
	}
	else {
		m_inputMode = IM_SPECIFY_LINE;
	
		m_pLinedBinTreeNode = m_pSelectedNode;
		m_lineEnd0.x = (LONG) *m_pSelectedNode->m_x;
		m_lineEnd0.y = (LONG) *m_pSelectedNode->m_y;
		m_lineEnd1 = m_popupPoint;
	}

	RedrawWindow();
}
