//
// HiRiseDemo: a Demo Application of the HiRise Constraint Solver
//
// Copyright (C) 1998 Hiroshi HOSOBE
//
////////////////////////////////////////////////////////////////

#include "HRSolver.h"

class BinTreeNode {
public:
	HRSolver* m_pSolver;

	BinTreeNode* m_pParent;
	BinTreeNode* m_pLeftChild;
	BinTreeNode* m_pRightChild;

	HRVar m_x;
	HRVar m_left;
	HRVar m_right;

	HRVar m_y;

	HRLinear m_midAlign;
	HRLinear m_xInterval;
	HRLinear m_leftAlign;
	HRLinear m_rightAlign;
	HRLinear m_childrenGlue;

	HRLinear m_leftYInterval;
	HRLinear m_rightYInterval;

	BinTreeNode(HRSolver* pSolver, HRVar& xUnit, HRVar& yUnit,
				BinTreeNode* pParent, int height);
	~BinTreeNode();
};
