//
// HiRiseDemo: a Demo Application of the HiRise Constraint Solver
//
// Copyright (C) 1998 Hiroshi HOSOBE
//
////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "BinTreeNode.h"

BinTreeNode::BinTreeNode(HRSolver* pSolver, HRVar& xUnit, HRVar& yUnit,
						 BinTreeNode* pParent, int height)
#ifdef WEAKER
//: m_midAlign(1), m_xInterval(1), m_leftAlign(1), m_rightAlign(1),
//  m_childrenGlue(1), m_leftYInterval(1), m_rightYInterval(1)
: m_midAlign(0), m_xInterval(1), m_leftAlign(0), m_rightAlign(0),
  m_childrenGlue(0), m_leftYInterval(1), m_rightYInterval(1)
#else // !WEAKER
: m_midAlign(0), m_xInterval(0), m_leftAlign(0), m_rightAlign(0),
  m_childrenGlue(0), m_leftYInterval(0), m_rightYInterval(0)
#endif // WEAKER
{
	m_pSolver = pSolver;

	m_pParent = pParent;

	if (height == 1) {
		m_pLeftChild = 0;
		m_pRightChild = 0;

		m_midAlign.center(m_left, m_right, m_x);
		m_pSolver->add(m_midAlign);

		m_xInterval.sum(m_left, xUnit, m_right);
		m_pSolver->add(m_xInterval);
	}
	else {
		m_pLeftChild = new BinTreeNode(m_pSolver, xUnit, yUnit,
									   this, height - 1);
		m_pRightChild = new BinTreeNode(m_pSolver, xUnit, yUnit,
									   this, height - 1);

		m_midAlign.add(m_x, 2).add(m_pLeftChild->m_x, -1)
			.add(m_pRightChild->m_x, -1);
		m_pSolver->add(m_midAlign);

		m_leftAlign.equal(m_left, m_pLeftChild->m_left);
		m_pSolver->add(m_leftAlign);

		m_rightAlign.equal(m_right, m_pRightChild->m_right);
		m_pSolver->add(m_rightAlign);

		m_childrenGlue.equal(m_pLeftChild->m_right, m_pRightChild->m_left);
		m_pSolver->add(m_childrenGlue);

		m_leftYInterval.add(m_y, 1).add(yUnit, 1)
			.add(m_pLeftChild->m_y, -1);
		m_pSolver->add(m_leftYInterval);

		m_rightYInterval.add(m_y, 1).add(yUnit, 1)
			.add(m_pRightChild->m_y, -1);
		m_pSolver->add(m_rightYInterval);
	}
}

BinTreeNode::~BinTreeNode()
{
	if (m_pLeftChild != 0)
		delete m_pLeftChild;

	if (m_pRightChild != 0)
		delete m_pRightChild;
}
