//
// HiRiseDemo: a Demo Application of the HiRise Constraint Solver
//
// Copyright (C) 1998 Hiroshi HOSOBE
//
////////////////////////////////////////////////////////////////

// BinTreeDoc.cpp : CBinTreeDoc NX̓̒`s܂B
//

#include <time.h>
#include "stdafx.h"
#include "HiRiseDemo.h"

#include "BinTreeDoc.h"

#include "BinTreeNode.h"
#include "BinTreeDialog.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CBinTreeDoc

IMPLEMENT_DYNCREATE(CBinTreeDoc, CDocument)

BEGIN_MESSAGE_MAP(CBinTreeDoc, CDocument)
	//{{AFX_MSG_MAP(CBinTreeDoc)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
		//        ̈ʒuɐR[hҏWȂłB
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBinTreeDoc NX̍\z/

CBinTreeDoc::CBinTreeDoc()
#ifdef WEAKER
: m_stayXUnit(4), m_stayYUnit(4), m_stayTopX(5), m_stayTopY(5)
#else // !WEAKER
: m_stayXUnit(3), m_stayYUnit(3), m_stayTopX(4), m_stayTopY(4)
#endif // WEAKER
{
	// TODO: ̈ʒuɂPxĂ΂\zp̃R[hǉĂB

	CBinTreeDialog dialog;
	dialog.DoModal();

	m_stayXUnit.add(m_xUnit);
	m_solver.add(m_stayXUnit);

	m_stayYUnit.add(m_yUnit);
	m_solver.add(m_stayYUnit);

	m_pBinTree = new BinTreeNode(&m_solver, m_xUnit, m_yUnit,
								 0, dialog.m_binTreeHeight);

	m_stayTopX.add(m_pBinTree->m_x);
	m_solver.add(m_stayTopX);
	m_stayTopY.add(m_pBinTree->m_y);
	m_solver.add(m_stayTopY);

#ifdef WEAKER
	HREdit editXUnit(2);
#else // !WEAKER
	HREdit editXUnit(1);
#endif // WEAKER
	editXUnit.add(m_xUnit, 30);
	m_solver.add(editXUnit);

#ifdef WEAKER
	HREdit editYUnit(2);
#else // !WEAKER
	HREdit editYUnit(1);
#endif // WEAKER
	editYUnit.add(m_yUnit, 60);
	m_solver.add(editYUnit);

#ifdef WEAKER
	HREdit editTopX(2);
#else // !WEAKER
	HREdit editTopX(1);
#endif // WEAKER
	editTopX.add(m_pBinTree->m_x, 250);
	m_solver.add(editTopX);

#ifdef WEAKER
	HREdit editTopY(2);
#else // !WEAKER
	HREdit editTopY(1);
#endif // WEAKER
	editTopY.add(m_pBinTree->m_y, 20);
	m_solver.add(editTopY);

	clock_t t0 = clock();
	m_solver.plan();
	clock_t t1 = clock();
	m_solver.execute();
	clock_t t2 = clock();

	planTimeForConstruction = (t1 - t0) / (double) CLOCKS_PER_SEC * 1000;
	execTimeForConstruction = (t2 - t1) / (double) CLOCKS_PER_SEC * 1000;

	m_nodeSize = dialog.m_nodeSize;
	m_lineWidth = dialog.m_lineWidth;
}

CBinTreeDoc::~CBinTreeDoc()
{
	delete m_pBinTree;
}

BOOL CBinTreeDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// TODO: ̈ʒuɍďǉĂB
	// (SDI hLg͂̃hLgėp܂B)

	return TRUE;
}



/////////////////////////////////////////////////////////////////////////////
// CBinTreeDoc VAC[[V

void CBinTreeDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: ̈ʒuɕۑp̃R[hǉĂB
	}
	else
	{
		// TODO: ̈ʒuɓǂݍݗp̃R[hǉĂB
	}
}

/////////////////////////////////////////////////////////////////////////////
// CBinTreeDoc NX̐ff

#ifdef _DEBUG
void CBinTreeDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CBinTreeDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CBinTreeDoc R}h
