//
// The HiRise Constraint Solver
//
// Copyright (C) 1998 Hiroshi HOSOBE
//
////////////////////////////////////////////////////////////////

#ifndef _HR_VAR_H
#define _HR_VAR_H

#include "HRBase.h"
#include "HRList.h"

class HRCon;

class HRVar: public HRBase {

private:
    HRValue m_val;
    HRList<HRCon*> m_cons;

public:
    virtual const HRString getClass() const { return "HRVar"; }

    HRVar();
    HRVar(HRValue val);
#ifdef DEBUG
    HRVar(const HRString name);
    HRVar(const HRString name, HRValue val);
#endif // DEBUG
    void init(HRValue val);

    virtual ~HRVar();
    
    void set(HRValue val) { m_val = val; }
    HRValue get() { return m_val; } 
	HRValue operator*() { return get(); }

    int countCons() { return m_cons.count(); }
#ifdef DEBUG
    HRCon* getCon(int i);
#else // !DEBUG
    HRCon* getCon(int i) { return m_cons.get(i); }
#endif // DEBUG
    int index(HRCon& con) { return m_cons.index(&con); }
    HRVar& add(HRCon& con);
    HRVar& remove(HRCon& con);

};

#endif // _HR_VAR_H
