//
// The HiRise Constraint Solver
//
// Copyright (C) 1998 Hiroshi HOSOBE
//
////////////////////////////////////////////////////////////////

#include <stdio.h>
#include "HRVar.h"
#include "HRCon.h"
#include "HRSolver.h"

HRVar::HRVar()
{
    init((HRValue) 0);
}

HRVar::HRVar(HRValue val)
{
    init(val);
}

#ifdef DEBUG
HRVar::HRVar(const HRString name)
    : HRBase(name)
{
    init((HRValue) 0);
}

HRVar::HRVar(const HRString name, HRValue val)
    : HRBase(name)
{
    init(val);
}
#endif // DEBUG

void HRVar::init(HRValue val)
{
    m_val = (HRValue) val;
}

HRVar::~HRVar()
{
    if (m_cons.count() > 0) {
#ifdef DEBUG
        warning("~HRVar", "constraints remaining\n");
#endif // DEBUG

		while (m_cons.count() > 0) {
			HRCon* con = m_cons.get(0);
#ifdef DEBUG
			char buf[BUFSIZ];
			sprintf(buf, "implicit removal of constraint: %s\n", con->getClassAndName());
			warning("~HRVar", buf);
#endif // DEBUG
			con->getSolver()->remove(*con);
		}
	}
}

#ifdef DEBUG
HRCon* HRVar::getCon(int i)
{
    if (i < 0 || i >= m_cons.count())
        error("getCon", "index out of range\n");

    return m_cons.get(i);
}
#endif // DEBUG

HRVar& HRVar::add(HRCon& con)
{
#ifdef DEBUG
    if (m_cons.index(&con) >= 0)
        error("add", "constraint already added\n");
#endif // DEBUG

    m_cons.add(&con);

	return *this;
}

HRVar& HRVar::remove(HRCon& con)
{
#ifdef DEBUG
    if (m_cons.index(&con) == -1)
        error("remove", "constraint not added\n");
#endif // DEBUG

    m_cons.remove(&con);

	return *this;
}
