//
// The HiRise Constraint Solver
//
// Copyright (C) 1998 Hiroshi HOSOBE
//
////////////////////////////////////////////////////////////////

#include "HRStay.h"
#include "HRSolver.h"

void HRStay::init()
{
}

void HRStay::destroy()
{
	if (m_solver != 0) {
#ifdef DEBUG
		warning("destroy", "implicit removal of constraint\n");
#endif // DEBUG
		m_solver->remove(*this);
	}
}

HRStay::HRStay(int str)
    : HRCon(str)
{
    init();
}

HRStay::HRStay(int str, HRVar& var)
    : HRCon(str)
{
    init();
	add(var);
}

#ifdef DEBUG
HRStay::HRStay(const HRString name, int str)
    : HRCon(name, str)
{
    init();
}

HRStay::HRStay(const HRString name, int str, HRVar& var)
    : HRCon(name, str)
{
    init();
	add(var);
}
#endif // DEBUG

HRStay::~HRStay()
{
	destroy();
}

void HRStay::clear()
{
	destroy();
	HRCon::clear();
	init();
}

HRCon& HRStay::add(HRVar& var)
{
#ifdef DEBUG
    if (countVars() > 0)
        error("add", "variable already added\n");
#endif // DEBUG

    HRCon::add(var);

	return *this;
}
