//
// The HiRise Constraint Solver
//
// Copyright (C) 1998 Hiroshi HOSOBE
//
////////////////////////////////////////////////////////////////

#ifndef _HR_SOLVER_H
#define _HR_SOLVER_H

#include "HRBase.h"
#include "HRList.h"
#include "HRVar.h"
#include "HRCon.h"
#include "HRStay.h"
#include "HREdit.h"
#include "HRLinear.h"

struct HRLowerVec {
	int str;
	int idx;
	HRList<HRIndexAndValue> elems;
	HRValue cst;
};

struct HRUpperVec {
	HRBool shift;
	int srcCol;
	int dstCol;
	HRList<HRIndexAndValue> elems;
};

struct HRStr {
	int str;
	int idx;
};

class HRSolver: public HRBase {

    typedef HRList<HRVar*> HRVars;
    typedef HRList<HRCon*> HRCons;

private:
    HRVars m_vars;
    HRCons m_level[HR_N_LEVELS];
    HRList<HREdit*> m_edits;
	int m_nRealVars;
    int m_nRealCons;

	HRList<HRLowerVec*> m_lowerVecs;
	HRList<HRUpperVec*> m_upperVecs;
	HRStr* m_waStr;
	HRValue* m_row;
	HRValue* m_row2;
    HRValue* m_fsValue;
    HRValue* m_bsValue;

	HRCons m_inactCons;
	HRCons m_addedCons;
	HRList<int> m_removedRows;
	HRStr m_strongestRemovedRowStr;
	HRList<int> m_removedVars;
	int m_firstPrefConIndex;

public:
    virtual const HRString getClass() const { return "HRSolver"; }

    HRSolver();
    virtual ~HRSolver();
    
    HRBool add(HRCon& con);
    HRBool add(HRCon* con) { return add(*con); }
    HRBool remove(HRCon& con);
    HRBool remove(HRCon* con) { return remove(*con); }

	int countVars() { return m_nRealVars; }
	int countCons() { return m_nRealCons; }
    
	HRBool refresh();
    HRBool plan();
    HRBool execute();

private:
	void getFirst(int& str, int& idx);
	void getNext(int& str, int& idx);

	void refactorize();
	void refactorizePrefCons();
    void factorize();
	void updateWalkaboutStrengths();

    void changeConstants();
    void forwardSubstitution();
    void backwardSubstitution();

    void setRow(HRValue* row, HRValue& cst, HRCon& con);
    void setRow(HRValue* row, HRValue& cst, int str, int idx);
    void setRowForStay(HRValue* row, HRValue& cst, HRStay& stay);
    void setRowForEdit(HRValue* row, HRValue& cst, HREdit& edit);
    void setRowForLinear(HRValue* row, HRValue& cst, HRLinear& lin);
    void setRowForWeakestStay(HRValue* row, HRValue& cst, int vIdx);

};

#endif // _HR_SOLVER_H
