//
// The HiRise Constraint Solver
//
// Copyright (C) 1998 Hiroshi HOSOBE
//
////////////////////////////////////////////////////////////////

#ifndef _HR_PARSER_H
#define _HR_PARSER_H

#include "HRBase.h"

const int HR_PASER_HASH_SIZE = 101;

class HRVar;
class HRCon;

class HRParserHashEntry;
class HRParserLinearTerm;

class HRParser: HRBase {
	
	HRParserHashEntry* m_hash[HR_PASER_HASH_SIZE];

public:
    virtual const HRString getClass() const { return "HRParser"; }

	HRParser();
	~HRParser();

	HRVar* createVar(const HRString name, HRValue val = 0);
	void deleteVar(const HRString name);
	HRVar* getVar(const HRString name);
	HRValue getValue(const HRString name) { return getVar(name)->get(); }
	HRValue gv(const HRString name) { return getValue(name); }

	HRCon* createCon(int str, const HRString expr, ...);
	
private:
	HRBool isSpace(char ch) { return ch == ' ' || ch == '\t' || ch == '\n'; }
	int calcHashVal(const HRString name);
	HRBool insertHashEntry(const HRString name, HRVar* var);
	HRBool deleteHashEntry(const HRString name);
	HRParserHashEntry* getHashEntry(const HRString name);

	HRBool checkNameValidity(const HRString name);

	int countLocalVars(const HRString expr);
	HRConType getConType(const HRString expr);
	HRCon* createStayOrEditCon(int str, const HRString expr,
							   HRList<HRVar*>& vars);
	HRCon* createLinearCon(int str, const HRString expr, HRList<HRVar*>& vars);

	void freeTerms(HRParserLinearTerm* term);
	void addTerms(HRParserLinearTerm* term0, HRParserLinearTerm* term1,
				  HRValue scale);
	void multTerms(HRParserLinearTerm* term, HRValue scale);
		
	HRBool isAlphabet(char ch) { 
		return (ch >= 'a' && ch <= 'z') || (ch >= 'A' && ch <= 'Z') ||
			ch == '_'; }
	HRBool isDigit(char ch) { return ch >= '0' && ch <= '9'; }
	void skipSpaces(const HRString expr, int& i);

	HRParserLinearTerm* parseVariable(const HRString expr, int& i,
									  HRList<HRVar*>& vars);
	HRParserLinearTerm* parseValue(const HRString expr, int& i,
								   HRList<HRVar*>& vars);
	HRParserLinearTerm* parseTerm(const HRString expr, int& i,
								  HRList<HRVar*>& vars);
	HRParserLinearTerm* parseExpression(const HRString expr, int& i,
										HRList<HRVar*>& vars);

};

#endif // _HR_PARSER_H
