//
// The HiRise Constraint Solver
//
// Copyright (C) 1998 Hiroshi HOSOBE
//
////////////////////////////////////////////////////////////////

#ifndef _HR_LIST_H
#define _HR_LIST_H

#include "HRBase.h"

template<class Elem>
class HRList: HRBase {

private:
#ifdef __GNUC__
    const int HR_BLOCK_LEN = 8;
#else // !__GNUC__
    static const int HR_BLOCK_LEN;
#endif // __GNUC__

private:
    int m_maxLen;
    int m_len;
    Elem* m_list;

	void init();
	void destroy();

public:
    virtual const HRString getClass() const { return "HRList"; }

    HRList();
    virtual ~HRList();
	void clear();

    inline int count() { return m_len; }
#ifdef DEBUG
	void set(int index, Elem elem);
    Elem get(int index);
#else // !DEBUG
	inline void set(int index, Elem elem) { m_list[index] = elem; }
    inline Elem get(int index) { return m_list[index]; }
#endif // DEBUG
    int index(Elem elem);
    void add(Elem elem);
    void addIfAbsent(Elem elem);
    void remove(Elem elem);
	Elem removeAt(int index);
    void insert(int index, Elem elem);
    void append(HRList<Elem>& list);

};

#ifdef WIN32
#ifndef _HR_LIST_C
extern template class HRList<int>;

extern template class HRList<HRIndexAndValue>;

class HRVar;
extern template class HRList<HRVar*>;

class HRCon;
extern template class HRList<HRCon*>;

class HREdit;
extern template class HRList<HREdit*>;

struct HRLowerVec;
extern template class HRList<HRLowerVec*>;

struct HRUpperVec;
extern template class HRList<HRUpperVec*>;
#endif // !_HR_LIST_C
#endif // WIN32

#endif _HR_LIST_H
