//
// The HiRise Constraint Solver
//
// Copyright (C) 1998 Hiroshi HOSOBE
//
////////////////////////////////////////////////////////////////

#include <stdlib.h>
#include <stdio.h>
#define _HR_LIST_C
#include "HRList.h"

#ifdef WIN32
template<class Elem>
const int HRList<Elem>::HR_BLOCK_LEN = 8;
#endif // !WIN32

template<class Elem>
void HRList<Elem>::init()
{
    m_maxLen = HR_BLOCK_LEN;
    m_len = 0;

    if ((m_list = (Elem*) malloc(sizeof(Elem) * m_maxLen)) == 0)
        error("init");
}

template<class Elem>
void HRList<Elem>::destroy()
{
    free(m_list);
}

template<class Elem>
HRList<Elem>::HRList() 
{ 
	init(); 
}

template<class Elem>
HRList<Elem>::~HRList() 
{ 
	destroy(); 
}

template<class Elem>
void HRList<Elem>::clear() 
{ 
	destroy(); 
	init(); 
}

#ifdef DEBUG
template<class Elem>
void HRList<Elem>::set(int index, Elem elem)
{
    if (index < 0 || index >= m_len)
        error("set", "index out of range\n");
    
    m_list[index] = elem;
}

template<class Elem>
Elem HRList<Elem>::get(int index)
{
    if (index < 0 || index >= m_len)
        error("get", "index out of range\n");
    
    return m_list[index];
}
#endif // DEBUG
    
template<class Elem>
int HRList<Elem>::index(Elem elem)
{
    for (int i = 0; i < m_len; i++)
        if (m_list[i] == elem)
            return i;

    return -1;
}

template<class Elem>
void HRList<Elem>::add(Elem elem)
{
    if (m_len + 1 == m_maxLen) {
        m_maxLen += HR_BLOCK_LEN;
        if ((m_list = (Elem*) realloc(m_list, sizeof(Elem) * m_maxLen))
            == 0)
            error("add");
    }

    m_list[m_len++] = elem;
}

template<class Elem>
void HRList<Elem>::addIfAbsent(Elem elem)
{
    if (index(elem) == -1)
        add(elem);
}

template<class Elem>
void HRList<Elem>::remove(Elem elem)
{
    int i = 0;

    for ( ; i < m_len; i++)
        if (m_list[i] == elem)
            break;
	if (i == m_len)
		return;

    m_len--;

    for ( ; i < m_len; i++)
        m_list[i] = m_list[i + 1];
}

template<class Elem>
Elem HRList<Elem>::removeAt(int index)
{
#ifdef DEBUG
    if (index < 0 || index > m_len)
        error("removeAt", "index out of range\n");
#endif // DEBUG

	Elem elem = m_list[index];

    m_len--;

    for (int i = index ; i < m_len; i++)
        m_list[i] = m_list[i + 1];

	return elem;
}

template<class Elem>
void HRList<Elem>::insert(int index, Elem elem)
{
#ifdef DEBUG
    if (index < 0 || index > m_len)
        error("insert", "index out of range\n");
#endif // DEBUG
    
    if (m_len + 1 == m_maxLen) {
        m_maxLen += HR_BLOCK_LEN;
        if ((m_list = (Elem*) realloc(m_list, sizeof(Elem) * m_maxLen))
            == 0)
            error("insert");
    }
    
    for (int i = m_len; i > index; i--)
        m_list[i] = m_list[i - 1];
    
    m_list[index] = elem;

    m_len++;
}

template<class Elem>
void HRList<Elem>::append(HRList<Elem>& list)
{
    int newLen = m_len + list.m_len;

    if (newLen >= m_maxLen) {
        m_maxLen = (newLen / HR_BLOCK_LEN + 1) * HR_BLOCK_LEN;
        if ((m_list = (Elem*) realloc(m_list, sizeof(Elem) * m_maxLen))
            == 0)
            error("append");
    }

    for (int i = 0; i < list.m_len; i++)
        m_list[m_len + i] = list.m_list[i];

    m_len = newLen;
}

#ifdef WIN32
template class HRList<int>;

template class HRList<HRIndexAndValue>;

class HRVar;
template class HRList<HRVar*>;

class HRCon;
template class HRList<HRCon*>;

class HREdit;
template class HRList<HREdit*>;

struct HRLowerVec;
template class HRList<HRLowerVec*>;

struct HRUpperVec;
template class HRList<HRUpperVec*>;
#endif // WIN32
