//
// The HiRise Constraint Solver
//
// Copyright (C) 1998 Hiroshi HOSOBE
//
////////////////////////////////////////////////////////////////

#ifndef _HR_LINEAR_H
#define _HR_LINEAR_H

#include "HRCon.h"

class HRLinear: public HRCon {

private:
    HRList<HRIndexAndValue> m_coefs;
    HRValue m_const;

    void init();
	void destroy();

public:
    virtual const HRString getClass() const { return "HRLinear"; }

    virtual const HRConType getType() const { return HR_LINEAR; }

    HRLinear(int str);
#ifdef DEBUG
    HRLinear(const HRString name, int str);
#endif // DEBUG
    virtual ~HRLinear();
	virtual void clear();
    
    virtual HRCon& add(HRVar& var);
    HRLinear& add(HRVar& var, HRValue coef);
#ifdef DEBUG
    HRValue getCoef(int index);
#else // !DEBUG
    HRValue getCoef(int index) { return m_coefs.get(index).value; }
#endif // DEBUG
	HRList<HRIndexAndValue>* getCoefs() { return &m_coefs; }
    HRLinear& setConst(HRValue ct);
    HRValue getConst() { return m_const; }

	// var0 = var1
	HRLinear& equal(HRVar& var0, HRVar& var1);

	// var0 + var1 = var2
	HRLinear& sum(HRVar& var0, HRVar& var1, HRVar& var2);

	// (var0 + var1) / 2 = var2
	HRLinear& center(HRVar& var0, HRVar& var1, HRVar& var2);
};

#endif // _HR_LINEAR_H
