//
// The HiRise Constraint Solver
//
// Copyright (C) 1998 Hiroshi HOSOBE
//
////////////////////////////////////////////////////////////////

#include "HRLinear.h"
#include "HRSolver.h"

void HRLinear::init()
{
    m_const = (HRValue) 0;
}

void HRLinear::destroy()
{
	if (m_solver != 0) {
#ifdef DEBUG
		warning("destroy", "implicit removal of constraint\n");
#endif // DEBUG
		m_solver->remove(*this);
	}
}

HRLinear::HRLinear(int str)
    : HRCon(str)
{
    init();
}

#ifdef DEBUG
HRLinear::HRLinear(const HRString name, int str)
    : HRCon(name, str)
{
    init();
}
#endif // DEBUG

HRLinear::~HRLinear()
{
	destroy();
}

void HRLinear::clear()
{
	destroy();
	m_coefs.clear();
	HRCon::clear();
	init();
}

HRCon& HRLinear::add(HRVar& var)
{
    error("add", "coefficient needed\n");

	return *this;
}

HRLinear& HRLinear::add(HRVar& var, HRValue coef)
{
    HRCon::add(var);

	HRIndexAndValue coef1;
	coef1.index = -1;
	coef1.value = coef;
    m_coefs.add(coef1);

	return *this;
}

#ifdef DEBUG
HRValue HRLinear::getCoef(int index)
{
    if (index < 0 || index >= m_coefs.count())
        error("getCoef", "index out of range\n");

    return m_coefs.get(index).value;
}
#endif // DEBUG

HRLinear& HRLinear::setConst(HRValue ct)
{
    m_const = ct;

	return *this;
}

HRLinear& HRLinear::equal(HRVar& var0, HRVar& var1)
{
#ifdef DEBUG
	if (countVars() > 0)
		error("equal", "variables already added\n");
#endif // DEBUG
		
	add(var0, (HRValue) 1);
	add(var1, (HRValue) -1);

	return *this;
}

HRLinear& HRLinear::sum(HRVar& var0, HRVar& var1, HRVar& var2)
{
#ifdef DEBUG
	if (countVars() > 0)
		error("sum", "variables already added\n");
#endif // DEBUG
		
	add(var0, (HRValue) 1);
	add(var1, (HRValue) 1);
	add(var2, (HRValue) -1);

	return *this;
}

HRLinear& HRLinear::center(HRVar& var0, HRVar& var1, HRVar& var2)
{
#ifdef DEBUG
	if (countVars() > 0)
		error("center", "variables already added\n");
#endif // DEBUG
		
	add(var0, (HRValue) 1);
	add(var1, (HRValue) 1);
	add(var2, (HRValue) -2);

	return *this;
}
