//
// The HiRise Constraint Solver
//
// Copyright (C) 1998 Hiroshi HOSOBE
//
////////////////////////////////////////////////////////////////

#ifndef _HR_EDIT_H
#define _HR_EDIT_H

#include "HRCon.h"

class HREdit: public HRCon {

private:
    HRValue m_val;

    void init();
	void destroy();

public:
    virtual const HRString getClass() const { return "HREdit"; }

    virtual const HRConType getType() const { return HR_EDIT; }

    HREdit(int str);
    HREdit(int str, HRVar& var);
#ifdef DEBUG
    HREdit(const HRString name, int str);
    HREdit(const HRString name, int str, HRVar& var);
#endif // DEBUG
    virtual ~HREdit();
	virtual void clear();
    
    virtual HRCon& add(HRVar& var);
    HREdit& add(HRVar& var, HRValue val);

    virtual HRCon& set(HRValue val) { m_val = val; return *this; }
    virtual HRValue get() { return m_val; }

};

#endif // _HR_EDIT_H
