//
// The HiRise Constraint Solver
//
// Copyright (C) 1998 Hiroshi HOSOBE
//
////////////////////////////////////////////////////////////////

#include "HREdit.h"
#include "HRSolver.h"

void HREdit::init()
{
    m_val = (HRValue) 0;
}

void HREdit::destroy()
{
	if (m_solver != 0) {
#ifdef DEBUG
		warning("destroy", "implicit removal of constraint\n");
#endif // DEBUG
		m_solver->remove(*this);
	}
}

HREdit::HREdit(int str)
    : HRCon(str)
{
    init();
}

HREdit::HREdit(int str, HRVar& var)
    : HRCon(str)
{
    init();
	add(var);
}

#ifdef DEBUG
HREdit::HREdit(const HRString name, int str)
    : HRCon(name, str)
{
    init();
}

HREdit::HREdit(const HRString name, int str, HRVar& var)
    : HRCon(name, str)
{
    init();
	add(var);
}
#endif // DEBUG

HREdit::~HREdit()
{
	destroy();
}

void HREdit::clear()
{
	destroy();
	HRCon::clear();
	init();
}

HRCon& HREdit::add(HRVar& var)
{
    add(var, (HRValue) 0);

	return *this;
}

HREdit& HREdit::add(HRVar& var, HRValue val)
{
#ifdef DEBUG
    if (countVars() > 0)
        error("add", "variable already added\n");
#endif // DEBUG

    HRCon::add(var);
    m_val = val;

	return *this;
}
