//
// The HiRise Constraint Solver
//
// Copyright (C) 1998 Hiroshi HOSOBE
//
////////////////////////////////////////////////////////////////

#ifndef _HR_CON_H
#define _HR_CON_H

#include "HRBase.h"
#include "HRList.h"
#include "HRVar.h"

class HRSolver;

class HRCon: public HRBase {

protected:
	HRSolver* m_solver;

private:
    int m_str;
    HRList<HRVar*> m_vars;
    int m_row;

    void init(int str);
	void destroy();

public:
    virtual const HRString getClass() const { return "HRCon"; }

    virtual const HRConType getType() const { return HR_CON; }

    HRCon(int str);
#ifdef DEBUG
    HRCon(const HRString name, int str);
#endif // DEBUG
    virtual ~HRCon();
	virtual void clear();
    
	void setSolver(HRSolver* solver) { m_solver = solver; }
	HRSolver* getSolver() { return m_solver; }

    int getStrength() { return m_str; }
    
    int countVars() { return m_vars.count(); }
#ifdef DEBUG
    HRVar* getVar(int i);
#else // !DEBUG
    HRVar* getVar(int i) { return m_vars.get(i); }
#endif // DEBUG
    int index(HRVar& var) { return m_vars.index(&var); }
    virtual HRCon& add(HRVar& var);
    virtual HRCon& remove(HRVar& var);

    void setRow(int row) { m_row = row; }
    int getRow() { return m_row; }

	// for HREdit
    virtual HRCon& set(HRValue val);
    virtual HRValue get();

};

#endif // _HR_CON_H
