//
// The HiRise Constraint Solver
//
// Copyright (C) 1998 Hiroshi HOSOBE
//
////////////////////////////////////////////////////////////////

#include "HRCon.h"
#include "HRSolver.h"

void HRCon::init(int str)
{
	m_solver = 0;
    m_str = str;
}

void HRCon::destroy()
{
}

HRCon::HRCon(int str)
{
    init(str);
}

#ifdef DEBUG
HRCon::HRCon(const HRString name, int str)
    : HRBase(name)
{
    init(str);
}
#endif // DEBUG

HRCon::~HRCon()
{
	destroy();
}

void HRCon::clear()
{
	destroy();
    m_vars.clear();
	init(m_str);
}

#ifdef DEBUG
HRVar* HRCon::getVar(int i)
{
    if (i < 0 || i >= m_vars.count())
        error("getVar", "index out of range\n");

    return m_vars.get(i);
}
#endif // DEBUG

HRCon& HRCon::add(HRVar& var)
{
#ifdef DEBUG
    if (m_vars.index(&var) >= 0)
        error("add", "variable already added\n");
#endif // DEBUG

    m_vars.add(&var);

	return *this;
}

HRCon& HRCon::remove(HRVar& var)
{
#ifdef DEBUG
    if (m_vars.index(&var) == -1)
        error("remove", "variable not added\n");
#endif // DEBUG

    m_vars.remove(&var);

	return *this;
}

HRCon& HRCon::set(HRValue val)
{
	error("set", "edit constraint required\n");

	return *this;
}

HRValue HRCon::get()
{
	error("get", "edit constraint required\n");

	return 0;
}
