//
// The HiRise Constraint Solver
//
// Copyright (C) 1998 Hiroshi HOSOBE
//
////////////////////////////////////////////////////////////////

#ifndef _HR_BASE_H
#define _HR_BASE_H

#ifdef WIN32
#ifdef _DEBUG
#define DEBUG
#endif // _DEBUG
#endif // WIN32

typedef int HRBool;

const HRBool HR_FALSE = 0;
const HRBool HR_TRUE = 1;

typedef char* HRString;

typedef double HRValue;

const HRValue HR_EPS = (HRValue) 1.0e-4;

inline int nearEq(HRValue val0, HRValue val1) {
	HRValue diff = val0 - val1;
	return diff > -HR_EPS && diff < HR_EPS; }

struct HRIndexAndValue {
	int index;
	HRValue value;
};

inline int operator==(HRIndexAndValue& inv0, HRIndexAndValue& inv1) {
	return HR_FALSE; }

typedef enum {
    HR_CON,
    HR_STAY,
    HR_EDIT,
    HR_LINEAR,
    HR_WEAKEST_STAY
} HRConType;

const int HR_N_LEVELS = 16;

class HRBase {

private:
#ifdef DEBUG
    HRString m_name;
#endif // DEBUG

public:
    virtual const HRString getClass() const = 0;

#ifdef DEBUG
    HRBase();
    HRBase(const HRString name);
    virtual ~HRBase();
#endif // DEBUG

#ifdef DEBUG
    const HRString getName() const;
#endif // DEBUG
    const HRString getClassAndName() const;

    void error(const HRString funName, const HRString message);
    void error(const HRString funName);
    void warning(const HRString funName, const HRString message);

};

#endif // _HR_BASE_H
