//
// The HiRise Constraint Solver
//
// Copyright (C) 1998 Hiroshi HOSOBE
//
////////////////////////////////////////////////////////////////

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "HRBase.h"

#ifdef DEBUG
HRBase::HRBase()
{
    m_name = 0;
}

HRBase::HRBase(const HRString name)
{
    if ((m_name = strdup(name)) == 0)
        error("HRBase");
}

HRBase::~HRBase()
{
	if (m_name != 0)
        free(m_name);
}

const HRString HRBase::getName() const
{
    if (m_name != 0)
        return m_name;

    static char buf[16];
    sprintf(buf, "%08x", (unsigned int) this);

    return buf;
}
#endif // DEBUG

const HRString HRBase::getClassAndName() const
{
#ifdef DEBUG
    static char buf[BUFSIZ];

    if (m_name == 0)
        sprintf(buf, "%s: %08x", getClass(), (unsigned int) this);
    else
        sprintf(buf, "%s: %s", getClass(), m_name);

    return buf;
#else // !DEBUG
    return getClass();
#endif // DEBUG
}

void HRBase::error(const HRString funName, const HRString message)
{
#ifdef DEBUG
    fprintf(stderr, "error: %s::%s: %s: %s",
            getClass(), funName, getName(), message);
#else // !DEBUG
    fprintf(stderr, "error: %s::%s: %s",
            getClass(), funName, message);
#endif // DEBUG

#ifdef DEBUG
    abort();
#else // !DEBUG
    exit(0);
#endif // DEBUG
}

void HRBase::error(const HRString funName)
{
    char buf[BUFSIZ];

#ifdef DEBUG
    sprintf(buf, "error: %s::%s: %s", getClass(), funName, getName());
    perror(buf);
#else // !DEBUG
    sprintf(buf, "error: %s::%s", getClass(), funName);
    perror(buf);
#endif // DEBUG

#ifdef DEBUG
    abort();
#else // !DEBUG
    exit(0);
#endif // DEBUG
}

void HRBase::warning(const HRString funName, const HRString message)
{
#ifdef DEBUG
    fprintf(stderr, "warning: %s::%s: %s: %s",
            getClass(), funName, getName(), message);
#endif // DEBUG
}
