
/*
   Domain description for the wolrd word.
   It has an example of axioms.
   Copyright: 1998,  Jorge Lobo.
*/


%==========HEADINGS=====================================

:- multifile causes/3.
:- multifile affects/3.
:- multifile sensing/1.
:- multifile initially/1.
:- multifile initially_unknown/1.
:- multifile axiom/2.

%=======================================================

action(move(X,Y)) :-
	myblock(X),
	diff(X,table),
	myblock(Y),
	diff(X,Y).
%=======================================================

fluent(clear(X)) :-
	myblock(X).

fluent(on(X,Y)) :-
	myblock(X),
	diff(X,table),
	myblock(Y).

%=======================================================


/*   There are two heuristic rules:

     1.  Move blocks to the table if they are not part of 
         a good tower.

     2.  Do not destroy good towers.

Good towers are towers that are subsets of the goal.
These heuristis were borrowed from the master thesis
"Planning in complex domains: Expressiveness and efficiency,"
by Yulia Gelfond Kahl of University of Texas at El Paso.

*/
heuristic( move( X, Y), State,_) :- 
  goal( Goal),
  member( on( X, Y), Goal),
  \+ true_in_state( on( X, Y), State),
  goodtower( Y, State, Goal).

heuristic( move( X, table), State,_) :- 
  \+ true_in_state( on( X, table), State),
  goal( Goal),
  \+ goodtower( X, State, Goal).

%=======================================================

goodtower( table, _, _).

goodtower( X, State, Goal) :- 
  true_in_state( on( X, table), State),
  \+ memberXinGoal( X, Goal).
goodtower( Y, State, Goal) :- 
  myblock( Z), diff(Z,table),
  member( on( Y, Z), Goal),
  true_in_state( on( Y, Z), State),
  goodtower( Z, State, Goal).

%=======================================================

memberXinGoal( X, Goal) :- 
  myblock( Z), diff(Z,table),
  member( on( X, Z), Goal).

%=======================================================

possible( move(X,Y), State) :-
	true_in_state(clear(X),State),
	true_in_state(clear(Y),State),
	true_in_state(neg(on(X,Y)),State).

%=======================================================

causes(move(X,Y),on(X,Y),[]).
causes(move(X,Y),neg(on(X,Z)),[on(X,Z)]).
causes(move(X,Y),clear(Z),[on(X,Z)]).

%=======================================================

axiom(on(X,Y),neg(clear(Y))) :-
	myblock(Y),
	diff(Y,table).

%=======================================================

/*  Below you can find several initial states and goals.
    Remove the comment signs around the one you would like
    to test.
    At this point the first initial state is uncommented.
*/

%=======================================================
/*

myblock( a).
myblock( b).
myblock( c).
myblock( table).
initially( on( c, a)).
initially( on( a, table)).
initially( on( b, table)).
initially( clear( c)).
initially( clear( b)).
initially( clear( table)).


goal( [on( b, c), on( a, b)]).

%  Plan: [move(c,table),move(b,c),move(a,b)]
*/

%=======================================================
/*
myblock( a).
myblock( b).
myblock( c).
myblock( d).
myblock( table).
initially( on( d, b)).
initially( on( c, a)).
initially( on( a, table)).
initially( on( b, table)).
initially( clear( c)).
initially( clear( d)).
initially( clear( table)).


goal( [on( b, c), on( a, b), on( d, a)]).
*/
%  Plan: move(c,table),move(d,table),move(b,c),move(a,b),move(d,a)

%=======================================================

/*
myblock( a).
myblock( b).
myblock( c).
myblock( d).
myblock( e).
myblock( f).
myblock( table).
initially( on( f, d)).
initially( on( d, b)).
initially( on( b, table)).

initially( on( e, c)).
initially( on( c, a)).
initially( on( a, table)).

initially( clear( e)).
initially( clear( f)).
initially( clear( table)).

goal( [on( b, e), on( a, b), on( f, a), on( c, d)]).
*/

%  Plan: [move(e,t),move(f,t),move(d,t),move(b,e),move(c,d),move(a,b),move(f,a)]



%=======================================================
/*
% New  1

myblock( a).
myblock( b).
myblock( c).
myblock( d).
myblock( e).
myblock( f).
myblock( table).
initially( on( f, table)).
initially( on( d, b)).
initially( on( b, e)).

initially( on( e, table)).
initially( on( c, table)).
initially( on( a, c)).

initially( clear( f)).
initially( clear( a)).
initially( clear( d)).
initially( clear( table)).


goal( [on(a,b),on(b,c),on(c,f),on(f,d),on(d,e)]).
*/

%=======================================================
/*
% New  2

myblock( a).
myblock( b).
myblock( c).
myblock( d).
myblock( e).
myblock( f).
myblock( table).
initially( on( f, e)).
initially( on( d, table)).
initially( on( b, f)).

initially( on( e, c)).
initially( on( c, a)).
initially( on( a, d)).

initially( clear( b)).
initially( clear( table)).


goal( [on(b,table),on(f,a),on(c,e),on(a,d),on(d,c)]).
*/
%================

/* The following example is to test the while with
   the entailment relation.

*/


myblock( a).
myblock( b).
myblock( c).
myblock( d).
myblock( table).

initially( on( d, table)).
initially( on( b, a)).
initially( on( c, b)).

initially( clear( c)).
initially( clear( d)).
initially( clear( table)).


example(        [while(neg(clear(a)),
                   [if(on(c,b),[move(c,table)]),
                    if(clear(b),[move(b,table)])
                   ]),
                 move(a,d),move(c,a)
                ]).

/* query: example(Plan), entails(Query,Plan). 
   
  Query is a property of the final states, such [clear(b),on(a,d)]
  or [claer(a)].  For the first query the answer is yes for the
  second query the answer is no.

*/

%============
