% Copyright (C) 1998  Katsumi Inoue 
%
%%% utility.pl %%%
%
% Made by J.S
% H9.10.23
% alp$@%7%9%F%`$GMQ$$$k%f!<%F%#%j%F%#$r$3$N%U%!%$%k$K=8$a$?!#(J
% $@4pK\$N%f!<%F%#%j%F%#$N$_$N%U%!%$%k$G$"$k!#(J

% $@=PNO4XO"%f!<%F%#%j%F%#(J
%
%
%
printf(Var) :-
	var(Var),!,
	print(Var).
printf(Term) :- !,
	printf_list(Term).

printf_list([]) :- !.
printf_list([One|Rem]) :- !,
	printf_list_one(One),
	printf(Rem).
printf_list(One) :-
	printf_list_one(One).

printf_list_one({Control}) :- !,
	port_control(Control).
printf_list_one('') :- !.
printf_list_one(Term) :-
	print(Term).

port_control(repeat(N,Obj)) :- !,
	port_loop(N,Obj).
port_control(nl) :- !,
	nl.
port_control(nl(N)) :- !,
	port_loop(N,{nl}).
port_control(quote(Term)) :- !,
	writeq(Term).
port_control(ttyflush) :- !,
	ttyflush.
port_control(tab) :- !,
	write('        ').
port_control(tab(N)) :- !,
	port_loop(N,{tab}).

port_loop(0,_) :- !.
port_loop(N,Obj) :- !,
	printf(Obj),
	NewN is N - 1,
	port_loop(NewN,Obj).

%
% output
%
print_length(L) :-
	write('Number of answer sets : '),write(L),nl,!.

print_length1(L) :-
	write('Number of Models: '),write(L),nl,!.

print_set([],_) :- printf(['Answer sets : []',{nl}]).
print_set(M,answer) :-
	write('Answer sets : ['),
	(M = [] -> write(']'),nl;nl,print_set1(M)),!.
print_set(M,satisfy) :-
	write('Models : ['),nl,
	print_set1(M),!.

print_set1([M]) :- !,write(M),write(']'),nl.
print_set1([M|L]) :-
	write(M),nl,
	print_set1(L).


%
% Runtime function
%
time(T) :-
        statistics(runtime,[_,T]),!.

%  print Run time
print_time(T) :-
	nl,write('* Time: '),
	T1 is T /1000,
	write(T1),
	write(' sec. *'),nl,!.


member(X,[X|_]) :- !.
member(X,[_|Y]) :- member(X,Y).

members(X,[X|_]).
members(X,[_|Y]) :- members(X,Y).


% append
%append([],L,L).
%append([X|L1],L2,[X|L3]) :- append(L1,L2,L3).
%
% append1
%   not contain same literal
%
append([],L,L).
append([X|L1],L2,[X|L3]) :- \+member(X,L2),append(L1,L2,L3).
append([_|L1],L2,L3) :- append(L1,L2,L3).

%
%   Library
%
%member(X,[X|_]) :- !.
%member(X,[_|Xs]) :- member(X,Xs).

length([],X) :- X = 0.

length([_|T],X) :- length(T,X1) , X = X1 + 1.

%append([],X,X) :- !.
%append([A|B],C,[A|D]) :- append(B,C,D). 

%--------< app_list >-----------------------------------%

app_list([],L,L) :- !.
app_list([One|Rem],L,[One|NewRem]) :-
	app_list(Rem,L,NewRem).

%-------< delete list >---------------------------------%

delete_list(_,_,[],[]) :- !.
delete_list(strong,DEL,[DEL|Rem],NewRem) :- !,
	delete_list(strong,DEL,Rem,NewRem).
delete_list(weak,DEL,[One|Rem],NewRem) :-
	DEL == One,!,
	delete_list(weak,DEL,Rem,NewRem).
delete_list(Mode,DEL,[One|Rem],[One|NewRem]) :- !,
	delete_list(Mode,DEL,Rem,NewRem).

