% Copyright (C) 1998  Katsumi Inoue 
%
%%% pr2mgtp.pl %%%
%
%
%  translator
%        translation of Abductive Extended Disjunctive programs
%
%
% disjunction transter
% program form check
%   head cycle check
% schema1, schema2
% no schema
%  pr2mgtp_out_program_form(_),pr2mgtp_out_schema  is change H8.10.17

% 黻
:- current_op(X,Y,(:-)),op(X,xfx,(<-)),op(X,fy,(<-)).
:- current_op(X,Y,(-)),op(X,fy,'not').


% <<<< translator >>>>
pr2mgtp :- !,
	pr2mgtp(_,_).

pr2mgtp(Mname) :- !,
	pr2mgtp(Mname,_).

pr2mgtp(Mname,Pname) :-
	var(Mname),!,
	repeat,
	printf('file name >> '),
	read(Mname),
	(Mname = exit;
	    pr2mgtp(Mname,Pname),fail).

pr2mgtp(Mname,Pname) :-
	var(Pname),!,
	filename_to_name_ext(Mname,Pname,_),
	pr2mgtp(Mname,Pname).

pr2mgtp(Mname,Pname) :-
        time(_),
	/* filename check */
	can_file_open_msg(read,Mname,[pr],MF),
	can_file_open_msg(write,Pname,[mgtp],PF),
	pr2mgtp_initialize,
	printf(['reading ',MF,' file',{nl}]),
	pr2mgtp_in(MF),
	printf(['transformation of Disjunction']),
	('clause'(yes) -> pr2mgtp_disjunction(1,_);true),
	/* make clause list */
	pr2mgtp_clause_list(1),
	printf([' ... ok !!',{nl}]),
	pr2mgtp_out(PF),
        time(T),
        print_time(T),
	!.

% <<<< initialize >>>>
pr2mgtp_initialize :-
	pr2mgtp_initialize_data(Pred,Arity),
	abolish(Pred,Arity),
	fail.

pr2mgtp_initialize :- !,
        assert(qindex(1)),
        assert(atomQ(nil)),
        counter(init,costg),
        counter(init,costv),
	counter(init,clause),
	assertz('clause'(no)),
        assertz('goal'(no)),
	assertz('form'(nodis)).

pr2mgtp_initialize_data('Goal',2).        /* ѥꥹ */
pr2mgtp_initialize_data('goal',1).
pr2mgtp_initialize_data('CostG',3).        /* ѥꥹ */
pr2mgtp_initialize_data('CostV',3).        /* ѥꥹ */
pr2mgtp_initialize_data('costg',1).
pr2mgtp_initialize_data('costv',1).
pr2mgtp_initialize_data('Predicate',1).   /* Prolog Ҹ */
pr2mgtp_initialize_data('head',1).        /* إåɥꥹ */
pr2mgtp_initialize_data('dis',1).         /* Disjunct ꥹ */
pr2mgtp_initialize_data('cl',1).          /* ǡ */
pr2mgtp_initialize_data('form',1).        /* Disjunction ̵ͭ */
pr2mgtp_initialize_data('Clause',3).      /* natural clause ǡ */
pr2mgtp_initialize_data('clause',1).      /* natural clause ̵ͭ */
pr2mgtp_initialize_data('Negative',1).    /* negative clause ǡ */
pr2mgtp_initialize_data('Assume',1).      /*  ꥹ */
pr2mgtp_initialize_data('Observation',1). /* ¬ ꥹ */


% <<<< format read date >>>>
pr2mgtp_in(File) :-
	see(File),
	repeat,
	read(In),
%	numbervars(In,0,_),
	pr2mgtp_in_loop(In),
	seen,!.


pr2mgtp_in_loop('end_of_file') :- !.
pr2mgtp_in_loop(P) :-
	pr2mgtp_in_case(P),
	fail.


/*  */
pr2mgtp_in_case(('<-' Ant)) :- !,
	pr2mgtp_in_clause(fail,Ant),!.

/*  */
pr2mgtp_in_case((Suc '<-' Ant)) :- !,
	pr2mgtp_in_clause(Suc,Ant),!.

/* ,,¬ */
pr2mgtp_in_case(Pre) :- !,
	pr2mgtp_in_predicate(Pre),!.


/* Pre ,,¬ΤɤξĤå */
pr2mgtp_in_predicate(Pre) :-
	(pr2mgtp_in_check_assume(Pre,AbdList)->assertz('Assume'(AbdList));
	  (pr2mgtp_in_check_observe(Pre,Ob)->assertz('Observation'(Ob));
	    (pr2mgtp_in_check_goal(Pre,G)->assertz('Goal'(Pre,G));
	       (pr2mgtp_in_check_predicate(Pre,NP)->assertz('Predicate'(NP));
		  pr2mgtp_in_clause(Pre,true))))).

%
% pr2mgtp_in_check_assume(Pre,AbdList)
%   Pre : 롼
%   AbdList : Υꥹ
%
/* ɽƤ뤫å */
pr2mgtp_in_check_assume(Pre,AbdList) :-
	(Pre =.. [Pred|Rem] -> 
	 Pred = 'assume',
	 (retract('Assume'(X)) -> true;X = []),
	 append(X,Rem,List),
	 pr2mgtp_in_check_element(List,AbdList);
	    fail).
% checkpoint
  
%
% pr2mgtp_in_check_observe(Pre,Ob)
%   Pre : 롼
%   Ob : ¬줿
%
/* ¬ɽƤ뤫å */
pr2mgtp_in_check_observe(Pre,Ob) :-
	(Pre =.. [Pred|Rem] ->
	 Pred = 'observation', Ob = Rem).


pr2mgtp_in_check_goal(Pre,G) :-
	(Pre =.. [_|Rem] ->
	 [X,G] = Rem,X='goal',retract('goal'(_)),assertz('goal'(yes))).
%checkpoint

%
% pr2mgtp_in_check_element(X,Y)
%   X : ꥹ
%   Y : ƱǤʤꥹ
%
/* ƱǤĤå*/
pr2mgtp_in_check_element([],[]).
pr2mgtp_in_check_element([X|L1],[X|L]) :-
	(member(X,L1) ->
	 delete_list(strong,X,L1,L2), pr2mgtp_in_check_element(L2,L);
	    pr2mgtp_in_check_element(L1,L)).
%
% pr2mgtp_in_check_predicate(Pre,NewPre)
%   Pre : ǡ
%   NewPre : PrologνҸꥹ
% Prolog νҸ ꥹȤκ
%
pr2mgtp_in_check_predicate(Pre,NewPre) :-
	Pre =.. [X|_],
	X = ':-',
	numbervars(Pre,0,_),
	(retract('Predicate'(P)) -> append(P,[Pre],NewPre);
	    NewPre = [Pre]).

%
% pr2mgtp_in_clause(Suc,Ant)
%   Suc : θ
%   Ant : 
%   
%   SucList2 : Ȥȥ
%
/* ǡκ */
pr2mgtp_in_clause(Suc,Ant) :-
        pr2mgtp_in_SucList(Suc,SucList),
        pr2mgtp_in_AntList(Ant,AntList),
        copy_term([SucList,AntList],[SucList1,AntList1]),
        numbervars([SucList1,AntList1],0,_),
        pr2mgtp_in_Cost(SucList1,SucList2),
        /* Disjunctive literal ΥꥹȤκ */
	(SucList2 = [_,_|_] ->
	 (retract('dis'(Dis)) ->
	  asserta('dis'([SucList2|Dis]));asserta('dis'([SucList2])));
	    true),
	/* ܥǥ Objective literal  Negative literal ʬ */
	pr2mgtp_in_inclause(AntList1,ONlist),
	/* ǡ¸ */
	pr2mgtp_in_clause_assert(SucList2,ONlist).

%
%
%  pr2mgtp_in_Cost(Suc)
%  Suc : Υꥹ
%
%
pr2mgtp_in_Cost([],[]).
pr2mgtp_in_Cost(Suc,Suc2) :- !,
        copy_term(Suc,X),
        pr2mgtp_in_sort_Cost(X),
        pr2mgtp_in_append_Cost([],_),
        retract(list(Suc2)),
        abolish(qindex,1),
        assert(qindex(1)),
        assert(atomQ(nil)).

%
%
%  pr2mgtp_in_put_Cost(Suc,Suc2)
%  Suc : Υꥹ
%
%
pr2mgtp_in_sort_Cost([]) :- !.

pr2mgtp_in_sort_Cost([X|Rem]) :- 
        pick_up(X,X1),
        divide_Atom_Cost(X1,Atom,Cost),
        if(not_arg_var(Atom),(counter(get,costg,C),
                              assertz('CostG'(C,Atom,Cost))),
                             (counter(get,costv,C),
                              assertz('CostV'(C,Atom,Cost)))),
        add_to_PQ(atom(Atom,Cost,_)),
        pr2mgtp_in_sort_Cost(Rem). 

pr2mgtp_in_append_Cost(Suc,_) :-  
        if(remove_from_PQ(atom(X,_,_)),(append(Suc,[[X]],Suc3),
                                      pr2mgtp_in_append_Cost(Suc3,Suc3)),
                                      assert(list(Suc))). 

not_arg_var(Atom) :- !,
        numbervars(Atom,1,_),
        Atom =.. [_|Arg],
        arg_check(Arg).

arg_check([]).
arg_check([X|Rem]) :-
   if(X =.. [Pred,_],true,true),
   if(Pred=='$VAR',fail,true),
   arg_check(Rem).

%
% pr2mgtp_in_SucList(Suc,SucList)
%   Suc : 
%   SucList : Υꥹ
% SucList ϥꥹȤΥꥹ
% a,b,c;d,e;f  -->  [[a,b,c],[d,e],[f]]
%
/* ΥꥹȤ */
pr2mgtp_in_SucList(Suc,SucList) :-
	(Suc = fail ->
	 SucList = [];to_OrList(Suc,SucList)),
	pr2mgtp_in_head_list(SucList).

%
% pr2mgtp_in_head_list(X)
%   X : ΥꥹȡʥץΡ
% 
/* ץΤθΥꥹȤκ */
pr2mgtp_in_head_list([]).
pr2mgtp_in_head_list([Head|L]) :-
	(retract(head(X)) ->
	 append(Head,X,H),assertz(head(H));
	    assertz(head(Head))),
	pr2mgtp_in_head_list(L).

%
% pr2mgtp_in_AntList(Ant,AntList)
%   Ant : 
%   AntList : Υꥹ
% AntList ι
%   <- a,b,not c;d,not e;not f  -->  [[[a,b],[c]],[[d],[e]],[[],[f]]]
%
/* ΥꥹȤ */
pr2mgtp_in_AntList(Ant,AntList) :-
	(Ant = true ->
	 AntList = [];to_OrList(Ant,AntList)).

%
% pr2mgtp_in_clause_assert(Head,Body)
%   Head : Υǡ
%   body : Υǡ
% ǡ¸
%
/*  NAF ޤޤʤ*/
pr2mgtp_in_clause_assert([],ONlist) :-
	/* NAF ޤफå */
        if(pr2mgtp_in_clause_assert1(ONlist),
                      true,
                      (if(retract(p(naf)),(asserta(p(naf)),false),
                                          (asserta(p(naf)),false)))),
	assertz('Negative'(ONlist)).
/* Υƥ뤬 Negative literal ˴ޤޤ */
pr2mgtp_in_clause_assert([H],[[Obj,Neg]]) :-
	copy_term([H,Obj,Neg],[H1,Obj1,Neg1]),
%	numbervars([H1,Obj1,Neg1],0,_),
	/* Ф */
	pr2mgtp_in_take_condition(Obj1,Con),
	/* ޤޤ뤫å */
	pr2mgtp_in_check_negation(H1,Neg1,Con),
	counter(get,clause,C),
	assertz('Clause'(C,[],[[Obj,Neg]])).
/* ʳ */
pr2mgtp_in_clause_assert(Suc,ONlist) :-
 	counter(get,clause,C),
	('clause'(no) -> retract('clause'(no)),assertz('clause'(yes));true),
	assertz('Clause'(C,Suc,ONlist)).

%
% pr2mgtp_in_clause_assert1(X)
%   X : Υǡ
% NAF ޤޤʤ,
%
/* NAF ޤफå */
pr2mgtp_in_clause_assert1([]).
pr2mgtp_in_clause_assert1([[_,[]]|L]) :-
	pr2mgtp_in_clause_assert1(L).

%
% pr2mgtp_in_take_condition(Obj,Con)
%   Obj : Objective literal list
%   Con : condition list
%
/* ܥǥФ */
pr2mgtp_in_take_condition([],[]).
pr2mgtp_in_take_condition([{X}|O],[{X}|C]) :- !,
	pr2mgtp_in_take_condition(O,C).
pr2mgtp_in_take_condition([_|O],C) :- !,
	pr2mgtp_in_take_condition(O,C).

%
% pr2mgtp_in_check_negation(Head,Neg,Con)
%   Head :  list
%   Neg : negative literal list
%   Con : condition list
% Υƥ뤬 Negative literal ˴ޤޤ뤫å
% ޤޤƤ,
%
pr2mgtp_in_check_negation([],_,_).
pr2mgtp_in_check_negation([Head|H],Neg,Con) :- !,
	/* ΥƥˤĤƥå */
	pr2mgtp_in_check_negation1(Head,Neg,Con),!,
	pr2mgtp_in_check_negation(H,Neg,Con).

%
% pr2mgtp_in_check_negation1(Head,Neg,Con)
%   Head :  literal
%   Neg : negative literal list
%   Con : condition list
% ΥƥˤĤƥå
% ޤޤƤ,
%
pr2mgtp_in_check_negation1(H,[H|_],_).
pr2mgtp_in_check_negation1(H,[N|_],Con) :-
	H =.. [F1|P1],N =.. [F2|P2],
	F1 == F2,
	(in_var_hold(H);in_var_hold(N)),!,
	/* Ҹ̾Υå */
	(pr2mgtp_in_check_condition(H,N,Con) -> true;
	    /* ʽҸ̾Ʊ˰Υå */
	    pr2mgtp_in_check_negation_para(P1,P2,Con)).
pr2mgtp_in_check_negation1(H,[_|L],Con) :-
	pr2mgtp_in_check_negation1(H,L,Con).

%
% pr2mgtp_in_check_negation_para(P1,P2,Con)
%   P1 : 
%   P2 : 
%   Con : condition list
% Υå
%   Ʊʤ,
%
pr2mgtp_in_check_negation_para([],[],_).
pr2mgtp_in_check_negation_para(X,X,_).
pr2mgtp_in_check_negation_para([P1|_],[P2|_],Con) :-
	/* ѿޤޤ뤫å */
	(in_var_hold(P1);in_var_hold(P2)),!,
	/* ΰˤĤƤĴ٤ */
	pr2mgtp_in_check_negation_para_variable(P1,P2,Con).
pr2mgtp_in_check_negation_para([P1|L1],[P2|L2],Con) :- !,
	/* ѿդޤ줺,ΰƱʤ,ΰ */
	P1 = P2,
	pr2mgtp_in_check_negation_para(L1,L2,Con).

/* ƱΥå */
%pr2mgtp_in_check_negation_para_variable(_,_,[]).
pr2mgtp_in_check_negation_para_variable(X,Y,Con) :-
	/* ѿɤʤ,å */
	(var_original(X);var_original(Y)),!,
	 pr2mgtp_in_check_condition(X,Y,Con).
/* Ǥʤʤ,˽Ҹ̾Υå */
pr2mgtp_in_check_negation_para_variable(X,Y,Con) :-
	X =.. [F1|P1],Y =.. [F2|P2],
	F1 == F2,!,
	pr2mgtp_in_check_negation_para(P1,P2,Con).

/* å */
pr2mgtp_in_check_condition(_,_,[]).
pr2mgtp_in_check_condition(X,Y,[Con|_]) :-
	(Con = {X == Y};Con = {Y == X};Con = {X = Y};Con = {Y = X}).
pr2mgtp_in_check_condition(X,Y,[Con|_]) :-
	(Con = {X \== Y};Con = {Y \== X}),!,fail.
pr2mgtp_in_check_condition(X,Y,[_|Con]) :-
	\+(Con = []),
	pr2mgtp_in_check_condition(X,Y,Con).

%
% pr2mgtp_in_inclause(Body,BodyList)
%   Body : Υǡ
%   BodyList : ʬ줿Υǡ
%  Negative literal  Objective literal ʬ
%
pr2mgtp_in_inclause([],[[[],[]]]).
pr2mgtp_in_inclause([X],[[O1,N1]]) :-
	pr2mgtp_in_inclause1(X,O1,N1).
pr2mgtp_in_inclause([X|Y],[[O1,N1]|L]) :-
	pr2mgtp_in_inclause1(X,O1,N1),
	pr2mgtp_in_inclause(Y,L).

pr2mgtp_in_inclause1([],[],[]).
pr2mgtp_in_inclause1([not P],[],[P]).
pr2mgtp_in_inclause1([P],[P],[]).
pr2mgtp_in_inclause1([not P|L],T,[P|L1]) :- pr2mgtp_in_inclause1(L,T,L1).
pr2mgtp_in_inclause1([P|L],[P|L1],N) :- pr2mgtp_in_inclause1(L,L1,N).



%
% <<<< check Disjunction >>>>
%   Disjunction Ѥɽǽ᤬Ѵ
%
pr2mgtp_disjunction(Int,C_num) :-
	'Clause'(Int,[_],[[P,_]]),
	Next is Int +1,
	/* Ʊ Objective literal õ */
	pr2mgtp_check_positive([Int],Next,P,C_num),
	/*  Negative literal  append  */
	pr2mgtp_head_append_negative(C_num,[],HN_list),
	/* Disjunction Ѵǽå */
	pr2mgtp_test_disjunction(HN_list),
	pr2mgtp_disjunction(Next,_).
/* ¾᤬¸ߤ뤫å */
pr2mgtp_disjunction(Int,C_num) :-
	'COUNT'(clause,N),
	Int < N,
	Nint is Int + 1,
	pr2mgtp_disjunction(Nint,C_num).
pr2mgtp_disjunction(_,[]).

%
% pr2mgtp_check_positive(C,Num,P,C_num)
%   C : work variable
%   Num : ǽõֹ
%   P : objective literal
%   C_num : P  objective literal ˻ֹ
% P  objective literal ˤõ
%
pr2mgtp_check_positive(C,Num,Pd,C_num) :-
	'Clause'(Num,[_],[[P,_]]),
	Next is Num +1,!,
	/* Ʊ objective literal Ĥå */
	(each_holds_equal_list(Pd,P) ->
	 pr2mgtp_check_positive([Num|C],Next,Pd,C_num);
	    pr2mgtp_check_positive(C,Next,Pd,C_num)).
pr2mgtp_check_positive(C,Num,Pd,C_num) :-
	'COUNT'(clause,N),
	Num < N,
	N1 is Num +1,!,
	pr2mgtp_check_positive(C,N1,Pd,C_num).
pr2mgtp_check_positive(C,_,_,C).

%
% pr2mgtp_head_append_negative(N,X,List)
%   N : ֹ
%   X : work variable
%   List : append ꥹȤֹĥꥹ
% negative literal  append ꥹȤκ
%
pr2mgtp_head_append_negative([],X,X).
pr2mgtp_head_append_negative([Num|C],D,HN_list) :-
	'Clause'(Num,[H],[[P,N]]),
	append(H,N,HN),
	pr2mgtp_check_variable(HN),!,
	pr2mgtp_head_append_negative(C,[[Num,P,HN]|D],HN_list).
pr2mgtp_head_append_negative([Num|C],D,HN_list) :-
	'Clause'(Num,[H],[[P,N]]),
	append(H,N,HN),
	pr2mgtp_check_literal(HN),!,
	pr2mgtp_head_append_negative(C,[[Num,P,HN]|D],HN_list).
pr2mgtp_head_append_negative([_|C],D,HN_list) :- !,
	pr2mgtp_head_append_negative(C,D,HN_list).

%
% pr2mgtp_test_disjunction(List)
%   List :  Negative literal  append Τֹĥꥹ
% Disjunction ɽǽå
%
pr2mgtp_test_disjunction([]).
pr2mgtp_test_disjunction([[Num,P,HN]|L]) :-
	/* append ꥹȤƱõ */
	pr2mgtp_eq_HN(HN,L,[Num],Nlist),
	pr2mgtp_check_disjunction(HN,Nlist,S,Hlist),
%	(pr2mgtp_check_variable(Hlist) -> true;pr2mgtp_check_literal(Hlist)),
	(S = yes -> pr2mgtp_make_disjunction(Nlist,P,HN,Hlist);true).

%
% pr2mgtp_eq_HN(L,List,N,Nlist)
%   L : Ȥʤꥹ
%   List : Υǡ
%   N : work variable
%   Nlist : Ʊ append ꥹȤֹΥꥹ
%  append ꥹȤƱꥹȤõ
%
pr2mgtp_eq_HN(_,[],N,N).
pr2mgtp_eq_HN(HNd,[[Num,_,HN]|L],N,Nlist) :-
	equal_list(HNd,HN),
	pr2mgtp_eq_HN(HNd,L,[Num|N],Nlist).
pr2mgtp_eq_HN(HNd,[_|L],N,Nlist) :-
	pr2mgtp_eq_HN(HNd,L,N,Nlist).

%
% pr2mgtp_check_disjunction(L,Nlist,S,Hlist)
%   L : append ꥹ
%   Nlist : ֹΥꥹ
%   S : ɽǽȽ̡yes,no
%   Hlist : ˤƥΥꥹ
% Disjunction ɽǽå
pr2mgtp_check_disjunction(_,[_],no,_).
pr2mgtp_check_disjunction(HN,Nlist,S,Hlist) :-
	/* οå */
	length(Nlist,N1),length(HN,N2),
	N1 =< N2,
	pr2mgtp_check_disjunction1(Nlist,HN,[],Hlist),
	pr2mgtp_check_head(Hlist),
	S = yes.
pr2mgtp_check_disjunction(_,_,no,_).

/* ˤƥΥꥹȤ */
pr2mgtp_check_disjunction1([],_,H,H) :- !.
pr2mgtp_check_disjunction1([Num|N],HN,H,Hlist) :-
	'Clause'(Num,[[Head]],_),
	pr2mgtp_check_disjunction1(N,HN,[Head|H],Hlist).

/* Disjunct ˽ʣʤå */
pr2mgtp_check_head(Hlist) :-
	'head'(H),
	pr2mgtp_out_check_head2(Hlist,H).

%
% pr2mgtp_check_variable(List)
%   List : append 줿ꥹ
% ꥹȤǤѿޤޤƤ뤫Υå
pr2mgtp_check_variable([]).
pr2mgtp_check_variable([X|_]) :-
	in_var(X),!,fail.
pr2mgtp_check_variable([_|L]) :- !,
	pr2mgtp_check_variable(L).

%
% pr2mgtp_check_literal(List)
%   List : append 줿ꥹ
% List ǤνҸ̾٤ƤȤʤ,ѿƱΤʤ,
%
pr2mgtp_check_literal([X|List]) :-
	copy_term([X|List],L),copy_term(X,X1),
	numbervars(L,0,N),numbervars(X1,0,N1),!,
	N1 >= N,
	pr2mgtp_check_literal1(List).

pr2mgtp_check_literal1([]).
pr2mgtp_check_literal1([X|L]) :-
	/* X Ȥ */
	X =.. [F|_],
	copy_term(X,X1),numbervars(X1,0,An),!,
	pr2mgtp_check_predicate1(F,An,L),
	pr2mgtp_check_literal1(L).

pr2mgtp_check_predicate1(_,_,[]).
pr2mgtp_check_predicate1(F,N,[X|L]) :-
	/* Ҹ̾ѿΥå */
	X =.. [F1|_],
	\+(F = F1),
	copy_term(X,X1),!,numbervars(X1,0,N),
	pr2mgtp_check_predicate1(F,N,L).

%
% pr2mgtp_make_disjunction
% Disjunction κ
%
pr2mgtp_make_disjunction([Num],P,HN,Hlist) :-
	retract('Clause'(Num,_,_)),
	subtraction(HN,Hlist,NewN),
	pr2mgtp_disjunction_head(Hlist,Head),
	counter(get,clause,C),
	assertz('Clause'(C,Head,[[P,NewN]])),
	(retract('dis'(X)) -> asserta('dis'([Head|X]));
	    asserta('dis'([Head]))).
pr2mgtp_make_disjunction([Num|L],P,HN,Hlist) :-
	retract('Clause'(Num,_,_)),
	pr2mgtp_make_disjunction(L,P,HN,Hlist).

pr2mgtp_disjunction_head([],[]).
pr2mgtp_disjunction_head([H|L],[[H]|L1]) :-
	pr2mgtp_disjunction_head(L,L1).

%
% pr2mgtp_clause_list
% ץΤꥹȤ
%
pr2mgtp_clause_list(Int) :-
	pr2mgtp_clause_list1(Int,CL),
        assertz('cl'(CL)).

pr2mgtp_clause_list1(N,[[Head,Body]|CL]) :-
	'Clause'(N,Head,Body),
	((Head = [_,_|_],form(nodis)) -> pr2mgtp_out_check_disjunct(Head,Body);
	    true),
	N1 is N +1,
	pr2mgtp_clause_list1(N1,CL).
pr2mgtp_clause_list1(N,CL) :-
	'COUNT'(clause,Num),
	N < Num,
	N1 is N +1,
	pr2mgtp_clause_list1(N1,CL).
pr2mgtp_clause_list1(_,_).

%
% pr2mgtp_out_check_disjunct(D,Body)
%   D : Disjunct
%   Body : 
% Disjunct ƱѿѤƤ뤫å
%
pr2mgtp_out_check_disjunct(D,Body) :-
	pr2mgtp_out_take_condition1(Body,[],Con),
	pr2mgtp_check_disjunct_variable(D,Con).
pr2mgtp_out_check_disjunct(_,_) :- assertz('form'(dis)).

% take up condition from clause's body
pr2mgtp_out_take_condition1([],X,X) :- !.
pr2mgtp_out_take_condition1([[Obj,_]|L],X,Con) :-
	pr2mgtp_in_take_condition(Obj,C1),
	append(X,C1,Y),
	pr2mgtp_out_take_condition1(L,Y,Con).

% check variable of disjunct
pr2mgtp_check_disjunct_variable(D,Con) :-
	copy_term(D,D1),numbervars(D1,0,X),
	\+(X = 0),
	pr2mgtp_take_variable(D1,V),!,
	pr2mgtp_check_condition(V,Con).
pr2mgtp_check_disjunct_variable(_,_).

% make a variable list from Disjunction
pr2mgtp_take_variable([],_).
pr2mgtp_take_variable([D|L],V) :-
	pr2mgtp_take_variable1(D,[],X),
	(X = [] -> true;pr2mgtp_var_list(X,V)),
	pr2mgtp_take_variable(L,V).

% make a variable from each Disjunct
pr2mgtp_take_variable1([],X,Y) :- remove_same_element(X,Y).
pr2mgtp_take_variable1([L|R],X,Y) :-
	in_var_take(L,V),
	append(X,V,Z),
	pr2mgtp_take_variable1(R,Z,Y).

% variable list
pr2mgtp_var_list(New,[M1|M2]) :-
	(var(M1) -> M1 = New;
	    holds_equal_list(M1,New) ->true;pr2mgtp_var_list(New,M2)).

pr2mgtp_check_condition(V,Con) :-
	\+length(V,1),
	pr2mgtp_list_append(V,[],V1),!,
	pr2mgtp_check_condition1(V1,Con).
pr2mgtp_check_condition(_,_).

% append of list's element
pr2mgtp_list_append([],X,Y) :- remove_same_element(X,Y),!.
pr2mgtp_list_append([X|L],Y,Z) :-
	append(X,Y,A),
	pr2mgtp_list_append(L,A,Z).

% condition check
pr2mgtp_check_condition1(V,Con) :-
	length(V,N),
	pr2mgtp_count_equal(Con,0,Ceq),!,
	pr2mgtp_count_notequal(Con,0,0),
	Ceq >= N-1.

% return number of equal condition
pr2mgtp_count_equal([],N,N) :- !.
pr2mgtp_count_equal([X|L],N,Num) :-
	((X = {_ = _};X = {_ == _}) -> N1 is N +1;N1 = N),
	pr2mgtp_count_equal(L,N1,Num).

% return number of not equal condition
pr2mgtp_count_notequal([],N,N) :- !.
pr2mgtp_count_notequal([X|L],N,Num) :-
	(X = {_ \== _} -> N1 is N +1;N1 = N),
	pr2mgtp_count_notequal(L,N1,Num).

%
% <<<< write to a file >>>>
%
pr2mgtp_out(File) :-
	% there is a Abducible ?
	printf(['check programs form ... ']),
	tell(File),
	/* check program form */
	(retract('Assume'(AbdList)) -> pr2mgtp_out_program_form(AbdList),
            assert(p(abductive));
	    pr2mgtp_out_program_form([]),AbdList=[],assert(p(extended))),
	print(user,'ok !!'),nl(user),
	print(user,'generating negative clause by Negation as Failure ... '),
	pr2mgtp_out_generate_nclause(AbdList,S1,S2),
	/* negative clause ν */
	pr2mgtp_out_each_nclause(S1,S2),
	print(user,'ok !!'),nl(user),
	print(user,'saving program in '),print(user,File),
	print(user,' ... '),
	/* ν */
	pr2mgtp_out_clause(AbdList),
	/* ν */
	pr2mgtp_out_negative(AbdList),
	/* ¬ν */
	pr2mgtp_out_observation,
	/* Prolog ν*/
	pr2mgtp_out_predicate,
        /* ȥȤΥȤν */
        pr2mgtp_out_cost,
	told,
	printf(['done !!',{nl}]),
	!.

%
% pr2mgtp_out_program_form(Abd)
%   Abd : abducible list
% check program form
%
pr2mgtp_out_program_form([]) :-
	pr2mgtp_out_check_disjunction(Loop),
	(('form'(dis);Loop = yes) -> printf(['program(edp).',{nl}]);
	    printf(['program(nredp).',{nl}])).
pr2mgtp_out_program_form([]) :-
	printf(['program(elp).',{nl}]).
pr2mgtp_out_program_form(_) :-
	pr2mgtp_out_check_disjunction(Loop),
	(('form'(dis);Loop = yes) -> printf(['program(aedp).',{nl}]);
	    printf(['program(nralp).',{nl}])).
pr2mgtp_out_program_form(_) :-
	printf(['program(aelp).',{nl}]).

%
% pr2mgtp_out_check_disjunction(Loop)
%   Loop :
% head cycle ¸ߤ뤫å
%
pr2mgtp_out_check_disjunction(Loop) :-
	retract('head'(H)),
	retract('dis'(Dis)),
	/* disjunctive Ʊƥ뤬¸ߤ뤫å */
	(pr2mgtp_out_check_head(Dis,H) -> true;Loop = yes).

%
% pr2mgtp_out_check_head(Dis,Head)
%   Dis : Disjunct Υꥹ
%   Head : Head ˤƥΥꥹ
% Disjunct Ƴ롼뤬ʣ¸ߤ뤫
%   ¸ߤʤ,
%
pr2mgtp_out_check_head([],_).
pr2mgtp_out_check_head([Dis|L],H) :- !,
	pr2mgtp_out_check_head1(Dis,H),
	pr2mgtp_out_check_head(L,H).

pr2mgtp_out_check_head1([],_).
pr2mgtp_out_check_head1([Dis|L],H) :- !,
	pr2mgtp_out_check_head2(Dis,H),
	pr2mgtp_out_check_head1(L,H).

pr2mgtp_out_check_head2([],_).
pr2mgtp_out_check_head2([Dis|L],H) :- !,
	pr2mgtp_out_mem2(Dis,H,0),
	pr2mgtp_out_check_head2(L,H).

pr2mgtp_out_mem2(_,[],_).
pr2mgtp_out_mem2(X,[X|_],1) :- !,fail.
pr2mgtp_out_mem2(X,[X|L],0) :- !,
	pr2mgtp_out_mem2(X,L,1).
pr2mgtp_out_mem2(X,[_|L],S) :- !,
	pr2mgtp_out_mem2(X,L,S).


%
% pr2mgtp_out_check_loop(Dis,CL)
%   Dis : Disjunctive list
%   CL : ץΤǡ
% head cycle ¸ߤ뤫å
%   ¸ߤʤʤ,
%
pr2mgtp_out_check_loop([],_).
pr2mgtp_out_check_loop([Dish|L],CL) :-
	pr2mgtp_out_check_loop1(Dish,Dish,CL),!,
	pr2mgtp_out_check_loop(L,CL).

% take up disjunction
pr2mgtp_out_check_loop1([],_,_).
pr2mgtp_out_check_loop1([Dis|L],Dish,CL) :-
	pr2mgtp_out_check_loop2(Dis,Dish,CL),!,
	pr2mgtp_out_check_loop1(L,Dish,CL).

% take up conjunction
pr2mgtp_out_check_loop2([],_,_).
pr2mgtp_out_check_loop2([Con|L],Dish,CL) :-
	pr2mgtp_out_loop(Con,Dish,CL,[Con]),!,
	pr2mgtp_out_check_loop2(L,Dish,CL).

pr2mgtp_out_loop(Con,Dish,CL,His) :-
	pr2mgtp_out_match_body(Con,CL,Head),!,
	pr2mgtp_out_loop1(Dish,CL,Head,His).
pr2mgtp_out_loop(_,_,_,_).

pr2mgtp_out_loop1(Dish,CL,[Head|L],His) :-
	\+(Head = []),!,
	pr2mgtp_out_loop2(Dish,CL,Head,His),
	pr2mgtp_out_loop1(Dish,CL,L,His).
pr2mgtp_out_loop1(_,_,_,_).

pr2mgtp_out_loop2(_,_,[],_).
pr2mgtp_out_loop2(Dish,CL,[H|L],His) :-
	\+(member(H,His)),!,
	pr2mgtp_out_disjunction_literal(H,Dish,His),
	pr2mgtp_out_loop(H,Dish,CL,[H|His]),
	pr2mgtp_out_loop(Dish,CL,L,His).

%
% pr2mgtp_out_match_body(Con,CL,Head)
%   Con : literal
%   CL : ǡ
%   Head : ޥå󥰤θ
% Con ȥܥǥΥޥå
%   ޥå󥰤θ֤
%
pr2mgtp_out_match_body(_,[],_).
pr2mgtp_out_match_body(Con,[[Head,[[Obj,_]|_]]|_],Head) :-
	subsume_list(Con,Obj);subsume1_list(Con,Obj).
pr2mgtp_out_match_body(Con,[[Head,[_|L]]|CL],H) :-
	\+(L = []),
	pr2mgtp_out_match_body(Con,[[Head,L]|CL],H).
pr2mgtp_out_match_body(Con,[_|L],H) :-
	pr2mgtp_out_match_body(Con,L,H).

%
% pr2mgtp_out_disjunction_literal(Con,Dis,His)
%   Con : literal
%   Dis : disjunctive list
%   His : history
% Con  disjunctive ʳ disjunctive å
%
pr2mgtp_out_disjunction_literal(Con1,Dish,His) :-
	last_list(His,D),
	pr2mgtp_out_other_disjunction(Dish,D,Disl),!,
	pr2mgtp_out_not_member_literal(Con1,Disl).

%
% pr2mgtp_out_other_disjunction(Dis,D,Disj)
%   Dis : disjunctive list
%   D : disjunctive
%   Disj : D disjunctive list
% D  disjunctive list κ
%
pr2mgtp_out_other_disjunction([Dis|L],D,L) :- member(D,Dis).
pr2mgtp_out_other_disjunction([Dis|L],D,[Dis|L1]) :-
	pr2mgtp_out_other_disjunction(L,D,L1).

pr2mgtp_out_not_member_literal(_,[]).
pr2mgtp_out_not_member_literal(Con,[Dis|_]) :-
	subsume_list(Con,Dis),
	!,fail.
pr2mgtp_out_not_member_literal(Con,[_|L]) :-
	pr2mgtp_out_not_member_literal(Con,L).


%
% generate negative clause from program
%
pr2mgtp_out_generate_nclause(Abd,S1,S2) :-
	pr2mgtp_out_generate_nclause1(Abd,1,X),
	pr2mgtp_out_check_nclause1(X,S1),
	pr2mgtp_out_generate_nclause2(Abd,1,S1,Y),
	pr2mgtp_out_check_nclause2(S1,Y,S2).

%
% pr2mgtp_out_generate_nclause1(Abd,Int,S)
%   Abd : ν
%   Int : ֹ
%   S : negative clause1 
% NAF  negative clause1 θȤƥꥹȤ
%
pr2mgtp_out_generate_nclause1(Abd,Int,S) :-
	'Clause'(Int,_,Body),
	pr2mgtp_out_nclause1_list(Abd,Body,S),
	Next is Int +1,
	pr2mgtp_out_generate_nclause1(Abd,Next,S).
pr2mgtp_out_generate_nclause1(Abd,Int,S) :-
	'COUNT'(clause,N),
	Int < N,
	Next is Int +1,
	pr2mgtp_out_generate_nclause1(Abd,Next,S).
pr2mgtp_out_generate_nclause1(_,_,_).

/* ܥǥ NAF Ф */
pr2mgtp_out_nclause1_list(_,[],_).
pr2mgtp_out_nclause1_list(Abd,[[_,Neg]|L],S) :-
	pr2mgtp_out_nclause1_list1(Abd,Neg,S),
	pr2mgtp_out_nclause1_list(Abd,L,S).

/* NAF ꥹȤκ */
pr2mgtp_out_nclause1_list1(_,[],_).
pr2mgtp_out_nclause1_list1(Abd,[Neg|L],S) :-
	/* Neg ᤵʤʤ,Ȥ */
	(subsume_list(Neg,Abd) -> pr2mgtp_out_nclause1_list1(Abd,L,S);
	    nclause1_list(Neg,S),
	    pr2mgtp_out_nclause1_list1(Abd,L,S)).

%
% check generated schema1
%
pr2mgtp_out_check_nclause1(S,S1) :-
	pr2mgtp_out_check_naf(S,X),
	pr2mgtp_out_check_same_nclause1(X,S1).

%
% pr2mgtp_out_check_naf(X,Y)
%   X : negative clause 
%   Y : negative clause
% resolution check of each Negative literal
%
pr2mgtp_out_check_naf([],[]).
pr2mgtp_out_check_naf([S|L],S1) :-
	pr2mgtp_out_check_trans(S,[],[], nbk),
	pr2mgtp_out_check_naf(L,S1).
pr2mgtp_out_check_naf([S|L],[S|L1]) :-
	pr2mgtp_out_check_naf(L,L1).

%
% pr2mgtp_out_check_trans(S, His,N, Mode)
%   S : ƳФߤ literal
%   His : history
%   N : negative literal
%   Mode : backtrack,ʤbk,nbk
% resolution check
%
/* ξ */
pr2mgtp_out_check_trans({X}, _,_, _) :- !,X.
/* 롼פˤʤ */
pr2mgtp_out_check_trans(S, His,_, _) :- hold_member(S,His),!.
%pr2mgtp_out_check_trans(S, His,_, _) :- subsume_list(S,His),!.
pr2mgtp_out_check_trans(S, His,N, Mode) :-
	pr2mgtp_out_head_matching(1,S,His,N,Mode).

%
% pr2mgtp_out_head_matching(N,S,B)
%   N : ֹ
%   S : literal
%   B : literal ޥåΥܥǥ
% Head matching
%
pr2mgtp_out_head_matching(N,S,His,Neg,Mode) :-
	'Clause'(N,H,B),
	pr2mgtp_out_head_matching1(H,B,S,Body),
	pr2mgtp_out_check_body(Body,[S|His],Neg, Mode).
pr2mgtp_out_head_matching(N,S,His,Neg,Mode) :-
	'COUNT'(clause,Num),
	Num > N,
	N1 is N +1,!,
	pr2mgtp_out_head_matching(N1,S,His,Neg,Mode).

/* ˤƥޥåAԤʤ */
pr2mgtp_out_head_matching1([[S|_]|_],Body,S,Body).
%pr2mgtp_out_head_matching1([[H|_]|_],Body,S,Body) :-
%	subsume(S,H).
pr2mgtp_out_head_matching1([[_|L]|L1],B,S,Body) :- !,
	pr2mgtp_out_head_matching1([L|L1],B,S,Body).
pr2mgtp_out_head_matching1([[]|L],B,S,Body) :- !,
	pr2mgtp_out_head_matching1(L,B,S,Body).

%
% pr2mgtp_out_check_body(S,Body, His,N, Mode)
%   S : reasoning literal
%   Body : ǡ
%   His : history
%   N : negative literal
%   Mode : backtrack mode
% check body
%
/* ƳФ */
pr2mgtp_out_check_body([[[],[]]|_],_,_, _) :- !.
/* ƳФ򤳤ߤliteralNAF¸ߤ */
pr2mgtp_out_check_body([[_,Neg]|L],His,N, Mode) :-
	hold_intersection(N,Neg,In),
	\+(In = []),!,
	\+(L = []),
	 pr2mgtp_out_check_body(L,His,N, Mode).
pr2mgtp_out_check_body([[Obj,Neg]|_],His,N, nbk) :-
	pr2mgtp_out_check_obj(Obj,His,N, nbk),
	pr2mgtp_out_check_neg(Neg,N).
pr2mgtp_out_check_body([[Obj,Neg]|_],His,N, bk) :-
	pr2mgtp_out_check_obj(Obj,His,N, bk),
	pr2mgtp_out_check_neg(Neg,N).
pr2mgtp_out_check_body([_|L],His,N, Mode) :- !,
	\+(L = []),
	pr2mgtp_out_check_body(L,His,N, Mode).

% resolusion of objective literal
pr2mgtp_out_check_obj([],_,_, _).
pr2mgtp_out_check_obj([_|L],His,N, Mode) :-
	(last_list(His,X),component_check(X);
	    His = [X|_],component_check(X)),!,
	pr2mgtp_out_check_obj(L,His,N, Mode).
pr2mgtp_out_check_obj([Obj|L],His,N, Mode) :-
	pr2mgtp_out_check_trans(Obj,His,N, Mode),
	hold_intersection(N,L,In),
	In = [],
	pr2mgtp_out_check_obj(L,His,[Obj|N], Mode).

% head matching of negative literal
pr2mgtp_out_check_neg([],_).
pr2mgtp_out_check_neg(Neg,N) :-
	hold_intersection(Neg,N,In),
	\+(In = []),!,fail.
pr2mgtp_out_check_neg([Neg|L],N) :-
	\+pr2mgtp_out_check_fact(1,Neg),
	pr2mgtp_out_check_neg(L,N).

%
% pr2mgtp_out_check_fact(N,X)
%   N : ֹ
%   X : ƥ
% X¤Ĵ٤
% 
pr2mgtp_out_check_fact(N,X) :-
	'Clause'(N,H,B),
	pr2mgtp_out_head_matching1(H,B,X,Body),
	member([[],[]],Body).
pr2mgtp_out_check_fact(N,X) :-
	'COUNT'(clause,Num),
	Num > N,
	N1 is N +1,!,
	pr2mgtp_out_check_fact(N1,X).


% delete same negative clause1
pr2mgtp_out_check_same_nclause1([],[]).
pr2mgtp_out_check_same_nclause1([X|L],L1) :-
	member(X,L),
	pr2mgtp_out_check_same_nclause1(L,L1).
pr2mgtp_out_check_same_nclause1([X|L],[X|L1]) :-
	pr2mgtp_out_check_same_nclause1(L,L1).


%
% generate Negative clause2
%    These are Negative clause2 by Head and Negation as Failure
%
pr2mgtp_out_generate_nclause2(Abd,Int,S1,S) :-
	'Clause'(Int,Head,Body),
	pr2mgtp_out_nclause2_list(Abd,Head,Body,S1,S),
	Next is Int +1,
	pr2mgtp_out_generate_nclause2(Abd,Next,S1,S).
pr2mgtp_out_generate_nclause2(Abd,Int,S1,S) :-
	'COUNT'(clause,N),
	Int < N,
	Next is Int +1,
	pr2mgtp_out_generate_nclause2(Abd,Next,S1,S).
pr2mgtp_out_generate_nclause2(_,_,_,_).

%
% pr2mgtp_out_nclause2_list(Abd,Head,Body,S1,S)
%   Abd : ⽸
%   Head : θ
%   Body : 
%   S1 : negative clause1 list
%   S : negative clause2 
% ˤƸNAFΥڥꥹȤ
%
pr2mgtp_out_nclause2_list(_,[],_,_,_).
pr2mgtp_out_nclause2_list(Abd,[Head|H],Body,S1,S) :-
	pr2mgtp_out_nclause2_list1(Abd,Head,Body,S1,S),
	pr2mgtp_out_nclause2_list(Abd,H,Body,S1,S).

% make negative clause2 by Head and Negation as Failure
pr2mgtp_out_nclause2_list1(_,_,[],_,_).
pr2mgtp_out_nclause2_list1(Abd,Head,[[_,[]]|B],S1,S) :-
	pr2mgtp_out_nclause2_list1(Abd,Head,B,S1,S).
pr2mgtp_out_nclause2_list1(Abd,Head,[[_,Neg]|B],S1,S) :-
	pr2mgtp_out_nclause2_list2(Abd,Head,Neg,S1,S),
	pr2mgtp_out_nclause2_list1(Abd,Head,B,S1,S).

pr2mgtp_out_nclause2_list2(_,[],_,_,_).
pr2mgtp_out_nclause2_list2(Abd,[X|L],Neg,S1,S) :-
	pr2mgtp_out_nclause2_list3(Abd,X,Neg,S1,S),
	pr2mgtp_out_nclause2_list2(Abd,L,Neg,S1,S).

/* ڥΥꥹȤˤ,negative clause1 ꥹȤǤޤޤʤ */
pr2mgtp_out_nclause2_list3(_,_,[],_,_).
pr2mgtp_out_nclause2_list3(Abd,X,[Y|L],S1,S) :-
	X == Y,
	pr2mgtp_out_nclause2_list3(Abd,X,L,S1,S).
pr2mgtp_out_nclause2_list3(Abd,Head,[Neg|L],S1,S) :-
	\+member(Neg,S1),
	\+subsume_list(Neg,Abd),
	nclause2_list([Neg,Head],S),
	pr2mgtp_out_nclause2_list3(Abd,Head,L,S1,S).
pr2mgtp_out_nclause2_list3(Abd,Head,[_|L],S1,S) :-
	pr2mgtp_out_nclause2_list3(Abd,Head,L,S1,S).

%
% check generated Negative clause2
%
pr2mgtp_out_check_nclause2(S1,S,S2) :-
	pr2mgtp_out_check_td(S,N,S1),
	pr2mgtp_out_check_same_nclause2(N,S2).

%
% pr2mgtp_out_check_td(S,S2,S1)
%   S : negative clause2 
%   S2 : negative clause2
%   S1 : negative clause1
% transfer check of each schema2
%
pr2mgtp_out_check_td([],[],_).
pr2mgtp_out_check_td([[_,H]|L],X,S1) :-
	subsume_list(H,S1),
	pr2mgtp_out_check_td(L,X,S1).
pr2mgtp_out_check_td([[N,H]|L],X,S1) :-
	copy_term([N,H],[N1,H1]),
	N1 =.. [Nf|_],H1 =.. [Hf|_],
	((Nf == Hf,(in_var(N1);in_var(H1))) ->
	  pr2mgtp_out_check_trans(H1,[],[], bk),
	  pr2mgtp_out_check_trans(N1,[],[H1], bk),
	  \+(H1 = N1);
	    pr2mgtp_out_check_trans(H1,[],[N1], nbk),
	    pr2mgtp_out_check_trans(N,[],[H1], nbk)),
	pr2mgtp_out_check_td(L,X,S1).
pr2mgtp_out_check_td([[N,H]|L],[[N,H]|X],S1) :-
	pr2mgtp_out_check_td(L,X,S1).

%
% pr2mgtp_out_check_same_nclause2(X,Y)
%   X : negative clause2
%   Y : Ʊڥޤޤʤ negative clause2
% check same schema2
%
pr2mgtp_out_check_same_nclause2([],[]).
pr2mgtp_out_check_same_nclause2([X|L],[X|N]) :-
	pr2mgtp_out_check_same_nclause22(X,L),!,
	pr2mgtp_out_check_same_nclause2(L,N).
pr2mgtp_out_check_same_nclause2([_|L],N) :- !,
	pr2mgtp_out_check_same_nclause2(L,N).

pr2mgtp_out_check_same_nclause22(_,[]).
pr2mgtp_out_check_same_nclause22(X,[Y|L]) :-
	\+equal_list(X,Y),
	pr2mgtp_out_check_same_nclause22(X,L).


%
% Positive clauses and Negative clauses containing Negation As Failure
%
% <<<< take up clause date>>>>
%
pr2mgtp_out_clause(AbdList) :-
	retract('Clause'(_,Suc,ONlist)),
	pr2mgtp_out_clause1(AbdList,Suc,ONlist),
	pr2mgtp_out_clause(AbdList).
pr2mgtp_out_clause(_).

%
% clause contained abducition is skiped or skiped and original work
%
pr2mgtp_out_clause1(AL,Suc,[[O,N]]) :-
	/* skipΤߤΥå */
	check_not_only_skip(AL,O,N,Skip),
	set_product(Skip,S2),
	pr2mgtp_out_clause2(AL,Suc,[[O,N]],S2).
pr2mgtp_out_clause1(AL,Suc,ONlist) :-
	pr2mgtp_out_clause2(AL,Suc,ONlist,[]).

pr2mgtp_out_clause2(AL,Suc,ONlist,[]) :-
	copy_term(AL,AL1),
	/* ΥƥȤǤʤΤʬ */
	pr2mgtp_out_divide_abducible(AL1,ONlist,Plist),
	/* ν */
	pr2mgtp_out_mgtp_rule(AL1,Suc,Plist).
pr2mgtp_out_clause2(AL,Suc,ONlist,[Skip|Rem]) :-
	copy_term(AL,AL1),
	copy_term(AL,AL2),
	/* ѤѴ */
	pr2mgtp_out_change_literal(Skip,Suc,ONlist,S1,Clist),
	/* ΥƥȤǤʤΤʬ */
	pr2mgtp_out_divide_abducible(AL1,Clist,Plist),
	/* ν */
	pr2mgtp_out_mgtp_rule(AL2,S1,Plist),
	pr2mgtp_out_clause2(AL,Suc,ONlist,Rem).


%
% pr2mgtp_out_change_literal(L,S,B,S1,B1)
%   L : ν
%   S : θ
%   B : 
%   S1 : Ѵθ
%   B1 : Ѵ
% original work
%
pr2mgtp_out_change_literal(L,S,[[O,N]],S1,[[O1,N1]]) :-
	append(S,O,X),append(X,N,Y),
	copy_term(Y,Y1),
	pr2mgtp_out_hold_literal(L,Y1),
	divide(Y1,S,S1,Y2),
	divide(Y2,O,O1,Y3),
	divide(Y3,N,N1,_).

pr2mgtp_out_hold_literal([],_).
pr2mgtp_out_hold_literal([L|R],Y1) :-
	member2(L,Y1),
	pr2mgtp_out_hold_literal(R,Y1).

%
% pr2mgtp_out_divide_abducible(AL,O,N,Obj,Abd,Nge,NgeAbd)
% divide abducible for each Objective Literal and Negative Literal
%
pr2mgtp_out_divide_abducible(_,[],[]).
pr2mgtp_out_divide_abducible(AL,[[O,N]|L],[[Obj,Abd,Neg,NA]|L1]) :-
	pr2mgtp_out_divide_abducible1(AL,O,N,Obj,Abd,Neg,NA),
	pr2mgtp_out_divide_abducible(AL,L,L1).

pr2mgtp_out_divide_abducible1(AL,O,N,Obj,Abd,Neg,NegAbd) :-
% intersection of AbdList and O is Objective Abducible
	intersection(O,AL,Abd),
% subtraction Abducible from O is Objective Literal
	subtraction(O,Abd,Obj),
% intersection of AbdList and N is Negative Abducible
	intersection(N,AL,NegAbd),
% subtraction Negative Abducible from N is Negative Literal
	subtraction(N,NegAbd,Neg).


% <<<< make a MGTP rule >>>>
pr2mgtp_out_mgtp_rule(AL,Suc,Plist) :-
	hold_numbervars(Suc,Plist,S,Holdlist),
	pr2mgtp_out_mgtp_antecedent(Holdlist),
	printf(' --> '),
	pr2mgtp_out_mgtp_consequent(AL,S,Holdlist),
	printf(['.',{nl}]).

%
% hold numbervars to all parameter
%
hold_numbervars(_,[],_,[]).
hold_numbervars(Suc,[[Obj,Abd,Neg,NegAbd]|L],S,[[O,A,N,NA]|R]) :-
	append(Suc,Obj,X1),append(X1,Abd,X2),
	append(X2,Neg,X3),append(X3,NegAbd,X),
	numbervars(X,0,_),
	divide(X,Suc,S,Y1),divide(Y1,Obj,O,Y2),divide(Y2,Abd,A,Y3),
	divide(Y3,Neg,N,Y4),divide(Y4,NegAbd,NA,_),
	hold_numbervars(Suc,L,S,R).


%
% pr2mgtp_out_mgtp_antecedent(X)
%   X : Υꥹ
% print antecedent of clause on output file
%
pr2mgtp_out_mgtp_antecedent([]) :- printf('true').
pr2mgtp_out_mgtp_antecedent([[[],_,_,_]|R]) :-
	pr2mgtp_out_mgtp_antecedent(R).

% a part of Disjunction
pr2mgtp_out_mgtp_antecedent([[Con,_,_,_]]) :-
	pr2mgtp_out_antecedent(Con).
pr2mgtp_out_mgtp_antecedent([[Con,_,_,_]|L]) :-
	pr2mgtp_out_antecedent(Con),
	printf(' ; '),
	pr2mgtp_out_mgtp_antecedent(L).

% a part of Conjunction
pr2mgtp_out_antecedent([{Obj}]) :- printf(['{',Obj,'}']).
pr2mgtp_out_antecedent([Obj]) :- printf(Obj).

pr2mgtp_out_antecedent([{Obj}|Rem]) :-
	printf(['{',Obj,'}, ']),
	pr2mgtp_out_antecedent(Rem).
pr2mgtp_out_antecedent([Obj|Rem]) :-
	printf([Obj,', ']),
	pr2mgtp_out_antecedent(Rem).

%
% pr2mgtp_out_mgtp_consequent(Abd,S,Body)
%   Abd : ν
%   S,Body : Υǡꥹ
% print consequent of clause on output file
%
pr2mgtp_out_mgtp_consequent(_,[],[]).
pr2mgtp_out_mgtp_consequent(_,[],[_,[],[],[]]) :-
	printf([' --> false.',{nl}]).
pr2mgtp_out_mgtp_consequent(AL,[],[[_,[],[],[]]|R]) :-
	pr2mgtp_out_mgtp_consequent(AL,[],R).
pr2mgtp_out_mgtp_consequent(_,_,[]).
pr2mgtp_out_mgtp_consequent(AL,Suc,[[_,[],[],[]]]) :-
	pr2mgtp_out_consequent_disjunction(AL,Suc,[],[],[]).
pr2mgtp_out_mgtp_consequent(AL,Suc,[[_,[],[],[]]|R]) :-
	pr2mgtp_out_mgtp_consequent(AL,Suc,R).
pr2mgtp_out_mgtp_consequent(AL,Suc,[[_,Abd,Neg,NegAbd]|R]) :- 
	pr2mgtp_out_consequent_disjunction(AL,Suc,Abd,Neg,NegAbd),
	pr2mgtp_out_not_abducible(Abd),
	pr2mgtp_out_connect_or(Abd,[Neg,NegAbd]),
	pr2mgtp_out_k_literal(Neg),
	pr2mgtp_out_connect_or(Neg,[NegAbd]),
	pr2mgtp_out_abducible(NegAbd),
	pr2mgtp_out_mgtp_consequent(AL,Suc,R).

%
% pr2mgtp_out_consequent_disjunction(Abd,B1,B2,B3,B4)
%   Abd : ν
%   B1,B2,B3,B4 : Υǡꥹ
% print conjuction of consequent
pr2mgtp_out_consequent_disjunction(_,[],_,_,_).
pr2mgtp_out_consequent_disjunction(AL,[Suc|Rem],Abd,Neg,NegAbd) :-
	pr2mgtp_out_objective_literal(AL,Suc),
	  pr2mgtp_out_connect_and(Suc,[Abd,Neg,NegAbd]),
	pr2mgtp_out_abducible_disjunction(Abd),
	  pr2mgtp_out_connect_and(Abd,[Neg,NegAbd]),
	pr2mgtp_out_not_k_literal_disjunction(Neg),
	  pr2mgtp_out_connect_and(Neg,[NegAbd]),
	pr2mgtp_out_not_abducible_disjunction(NegAbd),
	  pr2mgtp_out_connect_or([Rem,Abd,Neg,NegAbd]),
	pr2mgtp_out_consequent_disjunction(AL,Rem,Abd,Neg,NegAbd).


% print K-Literal as Classical Negation at disjunction
pr2mgtp_out_not_k_literal_disjunction([]).
pr2mgtp_out_not_k_literal_disjunction([X]) :-
	printf(['-k(',X,')']).
pr2mgtp_out_not_k_literal_disjunction([X|L]) :-
	printf(['-k(',X,'), ']),
	pr2mgtp_out_not_k_literal_disjunction(L).


% print Abducible Literal at disjunction
pr2mgtp_out_abducible_disjunction([]).
pr2mgtp_out_abducible_disjunction([X]) :-
	printf(['h(',X,')']).
pr2mgtp_out_abducible_disjunction([X|L]) :-
	printf(['h(',X,'), ']),
	pr2mgtp_out_abducible_disjunction(L).


% print Abducible Literal as Classical Negation at disjunction
pr2mgtp_out_not_abducible_disjunction([]).
pr2mgtp_out_not_abducible_disjunction([X]) :-
	printf(['-h(',X,')']).
pr2mgtp_out_not_abducible_disjunction([X|L]) :-
	printf(['-h(',X,'), ']),
	pr2mgtp_out_not_abducible_disjunction(L).


% print Objective Literal
pr2mgtp_out_objective_literal(_,[]).
pr2mgtp_out_objective_literal(AL,[X]) :-
	copy_term(AL,AL1),
	(member(X,AL1) -> printf(['h(',X,')']);
	    printf(X)).
pr2mgtp_out_objective_literal(AL,[X|L]) :-
	copy_term(AL,AL1),
	(member(X,AL1) -> printf(['h(',X,'), ']);
	    printf([X,', '])),
	pr2mgtp_out_objective_literal(AL,L).


% print K-Literal
pr2mgtp_out_k_literal([]).
pr2mgtp_out_k_literal([X]) :-
	printf(['k(',X,')']).
pr2mgtp_out_k_literal([X|L]) :-
	printf(['k(',X,') ; ']),
	pr2mgtp_out_k_literal(L).


% print K-Literal as Classical Negation
pr2mgtp_out_not_k_literal([]).
pr2mgtp_out_not_k_literal([X]) :-
	printf(['-k(',X,')']).
pr2mgtp_out_not_k_literal([X|L]) :-
	printf(['-k(',X,') ; ']),
	pr2mgtp_out_not_k_literal(L).


% print Abducible Literal
pr2mgtp_out_abducible([]).
pr2mgtp_out_abducible([X]) :-
	printf(['h(',X,')']).
pr2mgtp_out_abducible([X|L]) :-
	printf(['h(',X,') ; ']),
	pr2mgtp_out_abducible(L).


% print Abducible Literal as Classical Negation
pr2mgtp_out_not_abducible([]).
pr2mgtp_out_not_abducible([X]) :-
	printf(['-h(',X,')']).
pr2mgtp_out_not_abducible([X|L]) :-
	printf(['-h(',X,') ; ']),
	pr2mgtp_out_not_abducible(L).


%
% pr2mgtp_out_negative(AL)
%   AL : ν
% Negative clause without containing Negation As Failure
%
pr2mgtp_out_negative(AL) :-
	retract('Negative'([[Obj,_]])),
	numbervars(Obj,0,_),
	pr2mgtp_out_negative_clause_objective(AL,Obj),
	printf(' --> false'),
	printf(['.',{nl}]),
	pr2mgtp_out_negative(AL).
pr2mgtp_out_negative(_).

% print Objective Literal of Negative clause
pr2mgtp_out_negative_clause_objective(_,[]).
pr2mgtp_out_negative_clause_objective(_,[{X}]) :- printf(['{',X,'}']).
pr2mgtp_out_negative_clause_objective(AL,[X]) :-
	copy_term(AL,AL1),
	(member(X,AL1) -> printf(['h(',X,')']);
	    printf(X)).
pr2mgtp_out_negative_clause_objective(AL,[X|L]) :-
	copy_term(AL,AL1),
	(member(X,AL1) -> printf(['h(',X,'), ']);
	    printf([X,', '])),
	pr2mgtp_out_negative_clause_objective(AL,L).
/*
pr2mgtp_out_negative_clause_objective([A|AL],[A]) :-
	printf(['h(',A,')']), 
	pr2mgtp_out_negative_clause_objective(AL,[A]).
pr2mgtp_out_negative_clause_objective([A|AL],[X]) :-
	printf([X,', ']),
	pr2mgtp_out_negative_clause_objective(AL,[X]).
pr2mgtp_out_negative_clause_objective([A|AL],[A|L]) :-
	printf(['h(',A,')']), 
	pr2mgtp_out_negative_clause_objective(AL,L).
pr2mgtp_out_negative_clause_objective([A|AL],[X|L]) :-
	printf([X,', ']),
	pr2mgtp_out_negative_clause_objective(AL,L).
*/
pr2mgtp_out_negative_clause_objective(AL,[{X}|L]) :-
	printf(['{',X,'}, ']),
	pr2mgtp_out_negative_clause_objective(AL,L).


%
% pr2mgtp_out_each_nclause(S1,S2)
%   S1 : Negative clause1 list
%   S2 : Negative clause2 list
% print each Negative clause
%
pr2mgtp_out_each_nclause(S1,S2) :-
	pr2mgtp_out_nclause1(S1),
	pr2mgtp_out_nclause2(S2),
	pr2mgtp_out_schema.

% print Negative clause1
pr2mgtp_out_nclause1([]).
pr2mgtp_out_nclause1([S|L]) :-
	pr2mgtp_out_take_head(1,S,S1),
	numbervars(S,0,N),
	(\+(N = 0) -> pr2mgtp_out_check_subsume(S1,S2);true),
	printf(['k(',S,')']),
	pr2mgtp_out_condition(S,S2,N),
	printf([' --> false.',{nl}]),
	pr2mgtp_out_nclause1(L).

pr2mgtp_out_take_head(N,X,Y) :-
	'Clause'(N,Head,_),
	pr2mgtp_out_take_head1(Head,X,Y),
	N1 is N+1,
	pr2mgtp_out_take_head(N1,X,Y).
pr2mgtp_out_take_head(N,X,Y) :-
	'COUNT'(clause,Num),
	N < Num,
	N1 is N +1,
	pr2mgtp_out_take_head(N1,X,Y).
pr2mgtp_out_take_head(_,_,_).

pr2mgtp_out_take_head1([],_,_).
pr2mgtp_out_take_head1([[H|L]|L1],S,R) :-
	copy_term(S,S1),
	H = S1,
	pr2mgtp_out_head(S1,R),
	pr2mgtp_out_take_head1([L|L1],S,R).
pr2mgtp_out_take_head1([[_|L]|L1],S,R) :- !,
	pr2mgtp_out_take_head1([L|L1],S,R).
pr2mgtp_out_take_head1([[]|L],S,R) :- !,
	pr2mgtp_out_take_head1(L,S,R).

pr2mgtp_out_head(S1,[X|Y]) :-
	(var(X) -> X = S1;
	    (subsume(S1,X) -> true;pr2mgtp_out_head(S1,Y))).

% subsume check of list
pr2mgtp_out_check_subsume([],[]).
pr2mgtp_out_check_subsume([X|L],[X|L1]) :-
	pr2mgtp_out_check_subsume1(X,L),
	pr2mgtp_out_check_subsume(L,L1).
pr2mgtp_out_check_subsume([_|L],L1) :-
	pr2mgtp_out_check_subsume(L,L1).

pr2mgtp_out_check_subsume1(_,[]).
pr2mgtp_out_check_subsume1(X,[Y|L]) :- !,
	\+subsume(X,Y),
	pr2mgtp_out_check_subsume1(X,L).

pr2mgtp_out_condition(_,_,0).
pr2mgtp_out_condition(_,[],_).
pr2mgtp_out_condition(S,[S1|L],N) :-
	numbervars(S1,0,N1),
	\+var(S1),
	(N =< N1 -> true;
	    printf([', {',S,' \== ',S1,'}'])),
	pr2mgtp_out_condition(S,L,N).
pr2mgtp_out_condition(S,[_|L],N) :-
	pr2mgtp_out_condition(S,L,N).

% print Negative clause2
pr2mgtp_out_nclause2([]).
pr2mgtp_out_nclause2([[X,Y]|L]) :-
	copy_term([X,Y],[A,B]),
	numbervars([A,B],0,_),
	printf(['k(',A,'), k(',B,')']),
	pr2mgtp_out_print_nclause2([X,Y]),
	numbervars(A,0,Nx),
	pr2mgtp_out_check_condition(X,Nx),
	numbervars(B,0,Ny),
	pr2mgtp_out_check_condition(X,Ny),
	printf([' --> false.',{nl}]),
	pr2mgtp_out_nclause2(L).

pr2mgtp_out_print_nclause2([X,Y]) :-
	X =.. [X1|P1],
	Y =.. [Y1|P2],
	X1 == Y1,
	length(P1,N),length(P2,N),
	((in_var_hold(X);in_var_hold(Y)) ->
	  printf([', {',X,' \== ',Y,'}']);true).
pr2mgtp_out_print_nclause2([_,_]).

pr2mgtp_out_check_condition(_,0).
pr2mgtp_out_check_condition(X,_) :-
	copy_term(X,Y),
	pr2mgtp_out_take_head(1,X,X1),
	numbervars(X,0,Nx),
	(\+(Nx = 0) ->
	 pr2mgtp_out_check_subsume(X1,X2),
	 pr2mgtp_out_condition(Y,X2,Nx);
	    true).


pr2mgtp_out_schema :-
	printf(['-(A), (A) --> false.',{nl}]),
        (p(naf)-> 
	     printf(['-k(A), (A) --> false.',{nl}]),
             printf(['k(-(A)), (A) --> false.',{nl}]),
             printf(['k(A), -(A) --> false.',{nl}]),
	     printf(['k(A), k(-(A)) --> false.',{nl}])
             ;true),
        (p(abductive)->
             printf(['-h(A), (A) --> false.',{nl}]),
             printf(['-h(A), h(A) --> false.',{nl}]),
	     printf(['h(A), -(A) --> false.',{nl}]),
	     printf(['h(A), h(-(A)) --> false.',{nl}])
	     ;true),
        printf(['transformed_program.',{nl}]),
	retractall(p(_)).

% print Observation
pr2mgtp_out_observation :-
	(retract('Observation'([Observation])) ->
	 numbervars(Observation,0,_),
	 printf(['true --> k(',Observation,').',{nl}]),
	 pr2mgtp_out_observation;
	    true).

% print Prolog predicate	
pr2mgtp_out_predicate :-
	retract('Predicate'(Predicate)),!,
	printf({nl}),
	pr2mgtp_out_predicate_loop(Predicate).
pr2mgtp_out_predicate :- !.

pr2mgtp_out_predicate_loop([]) :- !.
pr2mgtp_out_predicate_loop([One|Rem]) :-
	pr2mgtp_out_predicate_one(One),!,
	pr2mgtp_out_predicate_loop(Rem).

pr2mgtp_out_predicate_one((Head :- Body)) :- !,
	printf([{quote(Head)},' :- ']),
	pr2mgtp_out_predicate_body(Body,''),
	printf(['.',{nl}]).
pr2mgtp_out_predicate_one(Head) :-
	printf([{quote(Head)},'.',{nl}]).

pr2mgtp_out_predicate_body('!',C) :- !,
	printf([C,'!']).
pr2mgtp_out_predicate_body((One,Rem),C) :- !,
	pr2mgtp_out_predicate_body(One,C),
	pr2mgtp_out_predicate_body(Rem,',').
pr2mgtp_out_predicate_body((O1;O2),C) :- !,
	printf([C,{nl},{tab},'(',{quote(O1)},';',{quote(O2)},')']).
pr2mgtp_out_predicate_body(One,C) :- !,
	printf([C,{nl},{tab},{quote(One)}]).

% <<<< connect symbol or ,and >>>>
pr2mgtp_out_connect_and([],_).
pr2mgtp_out_connect_and(_,[]).
pr2mgtp_out_connect_and(X,[L|R]) :-
	L = [_|_] -> printf(', ');pr2mgtp_out_connect_and(X,R).

pr2mgtp_out_connect_or([]).
pr2mgtp_out_connect_or([X|L]) :-
	X = [_|_] -> printf(' ; ');pr2mgtp_out_connect_or(L).

pr2mgtp_out_connect_or([],_).
pr2mgtp_out_connect_or(_,[]).
pr2mgtp_out_connect_or(X,[L|R]) :-
	L = [_|_] -> printf(' ; ');pr2mgtp_out_connect_or(X,R).

% ȤϤ롣
pr2mgtp_out_cost :- 
        if(retract('COUNT'(costg,Num)),pr2mgtp_out_costg(Num),true),
        if(retract('COUNT'(costv,Num)),pr2mgtp_out_costv(Num),true).
pr2mgtp_out_cost :- true.

pr2mgtp_out_costg(0) :- 
       if(retract('goal'(X)),true,true),
       if(X='yes',(retract('Goal'(_,Atom)),
                   printf(['goal:(',Atom,').',{nl}])),
                  true).

pr2mgtp_out_costg(N) :-
	'CostG'(N,Atom,Cost),
        if(Cost=0,true,printf(['cost(',Atom,',',Cost,').',{nl}])),
	N1 is N-1,
	pr2mgtp_out_costg(N1).

pr2mgtp_out_costv(0) :- 
       if(retract('goal'(X)),true,true),
       if(X='yes',(retract('Goal'(_,Atom)),
                   printf(['goal:(',Atom,').',{nl}])),
                  true).

pr2mgtp_out_costv(N) :-
	'CostV'(N,Atom,Cost),
        if(Cost=0,true,printf(['cost(',Atom,',',Cost,').',{nl}])),
	N1 is N-1,
	pr2mgtp_out_costv(N1).

%
%
% ȥȥȤʬѥ桼ƥƥ
%
%
pick_up([X],X).
divide_Atom_Cost(Atom ':' Cost,Atom,Cost).
divide_Atom_Cost(Atom,Atom,0).


%
%
% Υȥ򥳥Ȥν¤٤뤿Υ桼ƥƥ  
%
%
remove_from_PQ(atom(G,C,B)) :-
    retract(atomQ(Q)),
    \+ emptyPQ(Q),    
    removePQ(atom(G,C,N),Q,Q1),
    retract(atom_ind(N,B)),
    assert(atomQ(Q1)).

add_to_PQ(atom(G,C,B)) :-
    get_index(N),
    assert(atom_ind(N,B)),
    retract(atomQ(Q)),
    insertPQ(atom(G,C,N),Q,Q1),
    assert(atomQ(Q1)).

get_index(N1) :-
   retract(qindex(N)),
   N1 is N+1,
   assert(qindex(N1)).

:- dynamic qindex/1.

insertPQ(NV, nil, pq(NV,nil,nil)).
insertPQ(NV, pq(V,LPQ,RPQ), pq(V,RPQ,NLPQ)) :-
   better(V,NV), !,
   insertPQ(NV,LPQ,NLPQ).
insertPQ(NV, pq(V,LPQ,RPQ), pq(NV,RPQ,NLPQ)) :-
   insertPQ(V,LPQ,NLPQ).

removePQ(Val, pq(Val,nil,PQ),PQ) :- !.
removePQ(Val, pq(Val,LPQ,RPQ),NPQ) 
  :- remanyPQ(RMV,RPQ,NRPQ),
     pushPQ(pq(RMV,NRPQ,LPQ),NPQ).

pushPQ(pq(Val,pq(LV,PQLL,PQLR),pq(RV,PQRL,PQRR)), 
       pq(LV,LPQ,pq(RV,PQRL,PQRR)) ) :-
  better(LV,RV),
  better(LV,Val), !,
  pushPQ(pq(Val,PQLL,PQLR),LPQ).

pushPQ(pq(Val,LPQ, pq(RV,PQRL,PQRR)), pq(RV,LPQ,RPQ))
  :- better(RV,Val), !,
     pushPQ(pq(Val,PQRL,PQRR),RPQ).

pushPQ(PQ,PQ).

remanyPQ(Val, pq(Val,nil,PQ),PQ) :- !.
remanyPQ(V, pq(Val,LPQ,RPQ), pq(Val,NLPQ,LPQ)) :-
   remanyPQ(V,RPQ,NLPQ).

better(atom(_,X,_),atom(_,Y,_)) :- !,
   X =< Y.
better(X,Y) :- X > Y.

emptyPQ(nil).

makeground(T) :-
    numbervars(T,0,_).

