% Copyright (C) 1998  Katsumi Inoue
%
%%% mgtp2nhmuty.pl %%%
%

listtopred([A1|A2],Pred) :-
	(A2 == [],!,
	 Pred = A1;
	    listtopred(A2,Pred2),
	    Pred = (A1;Pred2)
	).

or_var(A,B,AB):-
	or1_var([],A,New),
	or1_var(New,B,AB).
or1_var(A,[],A).
or1_var(A,[B1|B2],AB):-
	(atom(B1),!,or1_var(A,B2,AB);
	    B1=..[Pred|Arg],
	    (Pred=='$VAR',!,
	     (member(B1,A),or1_var(A,B2,AB);
		 append2(A,[B1],AB1),or1_var(AB1,B2,AB)
	     );	    
		or1_var(A,Arg,AB1),
		or1_var(AB1,B2,AB)
	    )
	).

ent_dom([]).
ent_dom([A1|A2]):-
	((atom(A1);number(A1)),!,
	 dom_atom(A),
	 (member(A1,A),!;
	     append2(A,[A1],New),
	     retract((dom_atom(_))),
	     assert((dom_atom(New)))
	 );
	    A1=..[Pred|Arg],
	    (Pred=='$VAR',!;
		ent_dom(Arg),
		dom_func(A,B),
		(member(Pred,A),!;
		    append2(A,[Pred],New_A),
		    append2(B,[A1],New_B),
		    retract((dom_func(_,_))),
		    assert((dom_func(New_A,New_B)))
		)
	    )
	),
	ent_dom(A2).

member_var(X,[H|_]) :- H==X,!.
member_var(X,[_|T]) :- member_var(X,T).
member_var(_,[]) :- !,fail.

append2([],X,X):-!.
append2([X|Y],Z,[X|U]) :- !,append2(Y,Z,U).
append2(X,Z,[X|Z]):-!.

append_atom(X,[],X).
append_atom(Atom1,Atom2,NewAtom) :-
				name(Atom1,List1),
				name(Atom2,List2),
				append2(List1,List2,NewList),
				name(NewAtom,NewList).
delete(X,X,[]).
delete([],_,_) :- fail,!.
delete([X|Y],X,Y).
delete([Z|Y],X,[Z|U]) :- delete(Y,X,U).

append_list(X,[],X).
append_list(A,[BF1|BFn],New_Atom) :-
				append_atom(A,BF1,Atom),
			        append_list(Atom,BFn,New_Atom).
append_atom(X,[],X).
append_atom(Atom1,Atom2,NewAtom) :-
				name(Atom1,List1),
				name(Atom2,List2),
				append2(List1,List2,NewList),
				name(NewAtom,NewList).

nh_write((A;B)):-
	write((A)),
	write(';'),
	nh_write(B),!.
nh_write((A,B)):-
	write((A)),
	write(','),
	nh_write(B),!.
nh_write(A):-
	write((A)).

nh_write_b((A;B)):-
	atom(A),!,
	write((A)),
	write(';'),
	nh_write_b(B);
	A=..[Pred|Arg],
	dist_ad(Pred,Predn,[]),
	An=..[Predn|Arg],
	write((An)),
	write(';'),
	nh_write_b(B),!.
nh_write_b((A,B)):-
	atom(A),!,
	write((A)),
	write(','),
	nh_write_b(B);
	A=..[Pred|Arg],
	dist_ad(Pred,Predn,[]),
	An=..[Predn|Arg],
	write((An)),
	write(','),
	nh_write_b(B),!.
nh_write_b(A):-
	atom(A),!,
	write((A));
	A=..[Pred|Arg],
	dist_ad(Pred,Predn,[]),
	An=..[Predn|Arg],
	write((An)).

unknown_check((H1;H2),A1,A2) :-
	unknown_check2((H1;H2),A1,A2).
unknown_check(H,[H],[]).
unknown_check2([],[],[]).
unknown_check2((H1;H2),A1,A2) :-
	unknown_check2(H1,A1_1,A2_1),
	unknown_check2(H2,A1_2,A2_2),
	append2(A1_1,A1_2,A1),
	append2(A2_1,A2_2,A2).
unknown_check2(H,A1,A2) :-
	H=..[Pred|_],
	dist_ad2(Pred,Check),
	(Check==[],!,
	 A1=[H],
	 A2=[];
	    A1=[],
	    A2=[H]
	).
 		
nh_magic_w((A;B)):-
	A=='false',!,
	write('true'),
	nh_magic_w(B);
	A=='true',!,
	write('false'),
	nh_magic_w(B);
	atom(A),!,
	append_atom('magic_',A,M_A),
	write((M_A)),
	write(','),
	nh_magic_w(B),!;
        mk_magic_adrn(A),
	write(','),
	nh_magic_w(B),!.
nh_magic_w((A,B)):-
	A=='false',!,
	write('true'),
	nh_magic_w(B);
	A=='true',!,
	write('false'),
	nh_magic_w(B);
	atom(A),!,
	append_atom('magic_',A,M_A),
	write((M_A)),
	write(','),
	nh_magic_w(B),!;
	mk_magic_adrn(A),write(','),
	nh_magic_w(B),!.
nh_magic_w(A):-
	A=='false',!,
	write('true');
	A=='true',!,
	write('false');
	(atom(A),!,
	 append_atom('magic_',A,M_A),
	 write((M_A)),!;
	    mk_magic_adrn(A),!
	).


mk_magic_adrn(A) :- 
	A=..[H_Q|Arg_Q],
	rec_magic_arg(H_Q,Arg_Q,New_Arg),
	A_ad=..[H_Q|New_Arg],
	write('magic_'),
	write((A_ad)).

mk_BFlist([],[]).
mk_BFlist([A1|An],[B1|Bn]) :- 
	(atom(A1),!,
	 B1 = b,mk_BFlist(An,Bn);
	    !,B1 = f,mk_BFlist(An,Bn)
	).

false_ad_w((A,B),Arg) :-
	(atom(A),!,
	 write((A)),
	 write(','),
	 false_ad_w(B,Arg);
	    mk_false_adrn_w(A,Arg),write(','),
	    A=..[_|Arg_A],
	    or_var(Arg,Arg_A,NA),
	    false_ad_w(B,NA)).
false_ad_w(A,Arg) :-
	(atom(A),!,
	 write((A));
	    mk_false_adrn_w(A,Arg)).

mk_false_adrn_w(A,Arg_list) :- 
	A=..[H_Q|Arg_Q],
	mk_new_bf(Arg_list,Arg_Q,BF_list),
	append_atom(H_Q,'_',US_A),
	append_list(US_A,BF_list,New_A),
	magic_list(PQ1,PQ2),
	(member(H_Q,PQ1),!,
	 (member(New_A,PQ2);
	     add_abnormal(H_Q,New_A)
	 ); 
	    abnormal(Ab1,Ab2),
	    append2(Ab1,[H_Q],New1ab),
	    (Ab2==[],!,
	     New2ab=[[New_A]];
		append2(Ab2,[[New_A]],New2ab)),
	    append2(PQ1,[H_Q],New1),
	    append2(PQ2,[New_A],New2),
	    retract((magic_list(_,_))),
	    assert((magic_list(New1,New2))),
	    retract((abnormal(_,_))),
	    assert((abnormal(New1ab,New2ab)))
	),
	A_ad=..[New_A|Arg_Q],
	write((A_ad)).

false_ad((A,B),Arg) :-
	(atom(A),!,
	 false_ad(B,Arg);
	    mk_false_adrn(A,Arg),
	    A=..[_|Arg_A],
	    or_var(Arg,Arg_A,NA),
	    false_ad(B,NA)).
false_ad(A,Arg) :-
	(atom(A),!;
	    mk_false_adrn(A,Arg)).

mk_false_adrn(A,Arg_list) :- 
	A=..[H_Q|Arg_Q],
	mk_new_bf(Arg_list,Arg_Q,BF_list),
	append_atom(H_Q,'_',US_A),
	append_list(US_A,BF_list,New_A),
	magic_list(PQ1,PQ2),
	(member(H_Q,PQ1),!,
	 (member(New_A,PQ2);
	     add_abnormal(H_Q,New_A)
	 ); 
	    abnormal(Ab1,Ab2),
	    append2(Ab1,[H_Q],New1ab),
	    (Ab2==[],!,
	     New2ab=[[New_A]];
		append2(Ab2,[[New_A]],New2ab)),
	    append2(PQ1,[H_Q],New1),
	    append2(PQ2,[New_A],New2),
	    retract((magic_list(_,_))),
	    assert((magic_list(New1,New2))),
	    retract((abnormal(_,_))),
	    assert((abnormal(New1ab,New2ab)))
	).

mk_new_bf(_,[],[]).
mk_new_bf(Arg_list,[Arg1|Arg2],[BF1|BFn]) :-
	(atom(Arg1),!,
	 BF1 = b,
	 mk_new_bf(Arg_list,Arg2,BFn);
	    Arg1=..[Pred|Arg_A],
	    (Pred=='$VAR',!,
	     (member(Arg1,Arg_list),!,
	      BF1 = b,
	      mk_new_bf(Arg_list,Arg2,BFn);
		 BF1 = f,!,
		 mk_new_bf(Arg_list,Arg2,BFn)
	     );
		mk_new_bf(Arg_list,Arg_A,BFlist),
		(all_b_check(BFlist),!,
		 BF1 = b,
		 mk_new_bf(Arg_list,Arg2,BFn);
		    BF1 = f,
		    mk_new_bf(Arg_list,Arg2,BFn)
		)
	    )
	).
mk_new_bf(Arg_list,Arg1,BF1) :-
	(atom(Arg1),!,
	 BF1 = b;
	    Arg1=..[Pred|Arg_A],
	    (Pred=='$VAR',!,
	     (member(Arg1,Arg_list),!,
	      BF1 = b;
		 BF1 = f
	     );
		mk_new_bf(Arg_list,Arg_A,BFlist),
		(all_b_check(BFlist),!,
		 BF1 = b,
		 BF1 = f
		)
	    )
	).

all_b_check([]).
all_b_check([BF1|BF2]) :-
	BF1 == 'b',!,
	all_b_check(BF2);
	!,fail.
all_b_check(BF) :-
	BF == 'b',!,
	true;
	!,fail.

add_abnormal([],[]).
add_abnormal(A,Ad) :-
	abnormal(AB1n,AB2n),
	last(AB1n,L_AB1,R_AB1),
	(L_AB1=='end',!,
	 last(AB2n,_,R_AB2),
	 AB1=R_AB1,
	 AB2=R_AB2;
	    AB1=AB1n,
	    AB2=AB2n
	),
	add_pred_ab(A,Ad,AB1,AB2,[],New,Flag),
	(Flag=='Ok',!,
	 retract((ab_check(_))),
	 assert((ab_check('ab_occur'))),
	 retract((abnormal(_,_))),
	 assert((abnormal(AB1,New)));
	    true).

trs_pred(Pred,Bind,[],[]) :- Bind = Pred.
trs_pred(Pred,Bind,[Ad1|Rest1],[Ad2|Rest2]) :-
	(Pred == Ad1,
	 Bind = Ad2;
	    trs_pred(Pred,Bind,Rest1,Rest2)).
trs_pred(Pred,Bind,[Ad1],[Ad2]) :-
	(Pred == Ad1,
	 Bind = Ad2;
	    Bind = Pred).

add_pred_ab(_,_,[],[],_,_,F):-F=[].
add_pred_ab(Pred,Bind,[Ad1|Rest1],[Ad2|Rest2],Fab,GFab,Flag) :-
	(Pred == Ad1,!,
	 (member(Bind,Ad2),!,
	  Flag=[];
	     append2(Ad2,[Bind],New_Ab),
	     (Fab==[],!,
	      GFa=[New_Ab];
		 append2(Fab,[New_Ab],GFa)),
		 (Rest2==[],!,GFab=GFa;
		     append2(GFa,Rest2,GFab)),
		     Flag='Ok');
	    (Fab==[],!,
	     Fw=[Ad2];
		(chk_atom(Fab),!,append2([Fab],[Ad2],Fw);
		    append2(Fab,[Ad2],Fw))),
		add_pred_ab(Pred,Bind,Rest1,Rest2,Fw,GFab,Flag)).
add_pred_ab(Pred,Bind,[Ad1],[Ad2],Fab,GFab,Flag) :-
	(Pred == Ad1,!,
	 (member(Bind,Ad2),!,
	  Flag=[];
	     append2([Ad2],[Bind],New_Ab),
	     (Fab==[],!,GFab=New_Ab;
		 append2(Fab,[New_Ab],GFab)),
		 Flag='Ok')
	;true).

chk_atom([]):-fail.
chk_atom([A]):- atom(A),!,true;fail.

rec_magic_arg(_,[],[]).
rec_magic_arg(Pred,Arg,M_arg):-
	last_atom(Pred,L_P,R_P),
	last(Arg,L_A,R_A),
	(L_P==b,
	 rec_magic_arg(R_P,R_A,F_arg),
	 append2(F_arg,[L_A],M_arg),!;
	    L_P==f,
	    rec_magic_arg(R_P,R_A,M_arg),!;
	    L_P=')',!,
	    M_arg=Arg;
	    L_P=='_',!,
	    M_arg=[]
	).

last_atom(Pred,Last,Rest) :-  
	name(Pred,List),
	last(List,Last1,Rest1),
	name(Last,[Last1]),
	name(Rest,Rest1).

last([],[],[]).
last([Atom|[]],Atom,[]).
last([Atom1|Atom2],Last,[Atom1|Tail]) :- !,last(Atom2,Last,Tail).

get_suparg((A;B),C,Arg):-
	atom(A),!,get_suparg(B,C,Arg);
	(A=..[Pred|Arg_A],
	 rec_magic_arg(Pred,Arg_A,M_arg),
	 or_var(M_arg,C,D),
	 get_suparg(B,D,Arg)).
get_suparg((A,B),C,Arg):-
	atom(A),!,get_suparg(B,C,Arg);
	(A=..[Pred|Arg_A],
	 rec_magic_arg(Pred,Arg_A,M_arg),
	 or_var(M_arg,C,D),
	 get_suparg(B,D,Arg)).
get_suparg(A,C,Arg):-
	atom(A),!,Arg=C;
	(A=..[Pred|Arg_A],
	 rec_magic_arg(Pred,Arg_A,M_arg),
	 or_var(M_arg,C,Arg)).

get_arg((A;B),C,Arg):-
	atom(A),!,get_arg(B,C,Arg);
	(A=..[_|Arg_A],
	 or_var(Arg_A,C,D),
	 get_arg(B,D,Arg)).
get_arg((A,B),C,Arg):-
	atom(A),!,get_arg(B,C,Arg);
	(A=..[_|Arg_A],
	 or_var(Arg_A,C,D),
	 get_arg(B,D,Arg)).
get_arg(A,C,Arg):-
	atom(A),!,Arg=C;
	(A=..[_|Arg_A],
	 or_var(Arg_A,C,Arg)).

cp_file :-
	read(Z),numbervars(Z,0,_),
	(Z==end_of_file,!;
	    write((Z)),
	    write('.'),
	    nl,
	    cp_file,!).

cp_file_f :-
	read(Z),numbervars(Z,0,_),
	(Z==end_of_file,!;
	    write((Z)),
	    write('.'),
	    nl,
	    cp_file_f,!).

cp_file_ck1 :-
        read(Z),numbervars(Z,0,_),
        (Z==end_of_file -> ! ;
            (Z=(cost(_,_)) -> 
               (write((Z)),write('.'),nl,cp_file_ck1,!);
               (Z = program((_)) -> (write((Z)),write('.'),nl,
                                     cp_file_schema,cp_file_ck1,!);
                                    (cp_file_ck1,!)))
	).

cp_file_ck2 :-
        read(Z),numbervars(Z,0,_),
        (Z==end_of_file -> ! ;
            (Z=(B-->A) -> 
               (B=='true' -> 
                   (A=(k(_)) -> (write((Z)),write('.'),nl,cp_file_ck2,!);
                                (cp_file_ck2,!));
                   (A=='false' -> (write((Z)),write('.'),nl,cp_file_ck2,!);
                                  (cp_file_ck2,!)));
               (Z=(cost(A,B)) -> 
                  (write((Z)),write('.'),nl,cp_file_ck2,!);
                  (Z = program((_)) -> (write((Z)),write('.'),nl,
                                        cp_file_schema,cp_file_ck2,!);
                                       (cp_file_ck2,!))))
	).

cp_file_schema :-
        read(Z),numbervars(Z,0,_),
        (Z=(transformed_program) -> ! ;
            (write((Z)),write('.'),nl,cp_file_schema,!)).

cp_file_no_schema :-
        read(Z),numbervars(Z,0,_),
        (Z=(transformed_program) -> ! ;
            (cp_file_no_schema,!)).


cp_file_no_ck1 :-
        read(Z),numbervars(Z,0,_),
        (Z==end_of_file -> ! ;
            (Z=(_-->A) -> (write((Z)),write('.'),nl,cp_file_no_ck1,!);
               (Z=(goal:(A)) -> (write('goal:('),write((A)),write(').'),nl,cp_file_no_ck1,!);
                  (Z=(program(_)) -> (cp_file_no_schema,cp_file_no_ck1,!);
                                     (cp_file_no_ck1,!)))) 
	).

cp_file_no_ck2 :-
        read(Z),numbervars(Z,0,_),
        (Z==end_of_file -> ! ;
            (Z=(B-->A) -> 
               (B=='true' -> (write((Z)),write('.'),nl,cp_file_no_ck2,!);
                   (A='false' -> (cp_file_no_ck2,!);
                                 (write((Z)),write('.'),nl,cp_file_no_ck2,!)));
               (Z=(goal:(A)) -> 
                  (write('goal:('),write((A)),write(').'),nl,cp_file_no_ck2,!);
                  (Z=(program(_)) -> (cp_file_no_schema,cp_file_no_ck2,!);
                                     (cp_file_no_ck2,!))))
	).

dom_check_nhm([],_,A) :- nh_magic_w(A).
dom_check_nhm([H1|H2],Body,A) :- 
	member(H1,Body),!,
	dom_check_nhm(H2,Body,A);
	dom_c(F),
	(F=='dom_not_occur',!,
	 	 retract((dom_c(_))),
	 assert((dom_c('dom_occur')));
	    true
	),
 	write('dom('),
	write((H1)),
	write(')'),
	dom_check_nhm2(H2,Body,A).

dom_check_nhm2([],_,A) :- A=='false',!;write(','),nh_magic_w(A).
dom_check_nhm2([H1|H2],Body,A) :- 
	member(H1,Body),!,
	dom_check_nhm2(H2,Body,A);
	dom_c(F),
	(F=='dom_not_occur',!,
	 	 retract((dom_c(_))),
	 assert((dom_c('dom_occur')));
	    true
	),
 	write(',dom('),
	write((H1)),
	write(')'),
	dom_check_nhm2(H2,Body,A).

dom_check([],_).
dom_check([H1|H2],Body) :-
	member(H1,Body),!,
	dom_check(H2,Body);
	dom_c(F),
	(F=='dom_not_occur',!,
	 retract((dom_c(_))),
	 assert((dom_c('dom_occur')));
	    true
	),
 	write(',dom('),
	write((H1)),
	write(')'),
	dom_check(H2,Body).

dom_check_t([]) :- !,write('true').
dom_check_t([H1|H2]) :-
	dom_c(F),
	(F=='dom_not_occur',!,
	 retract((dom_c(_))),
	 assert((dom_c('dom_occur')));
	    true
	),
 	write('dom('),
	write((H1)),
	write(')'),
	(H2==[],!;
	    dom_check(H2,[])
	).


dom_write:-
	dom_atom(A),
	(A==[],!,
	 write('true-->dom(a).'),nl;
	    dom_atom_w(A)
	),
	dom_func(_,F),
	(F==[],!;
	    dom_func_w(F)
	).
dom_atom_w([]).
dom_atom_w([A1|A2]):-
	write('true-->dom('),
	write((A1)),
	write(').'),nl,
	dom_atom_w(A2).
dom_func_w([]).
dom_func_w([F1|F2]):-
	F1=..[_|Arg],
	dom_farg_w(Arg),
	write('-->dom('),
	write((F1)),
	write(').'),nl,
	dom_func_w(F2).
dom_farg_w([]).
dom_farg_w([A1|A2]):-
	write('dom('),
	write((A1)),
	write(')'),
	dom_farg_w2(A2).
dom_farg_w2([]).
dom_farg_w2([A1|A2]):-
	write(',dom('),
	write((A1)),
	write(')'),
	dom_farg_w2(A2).

dom_write1:-
	dom_func(_,F),
	dom_atom(A),
	(F==[],!,
	 (A==[],!,
	  write('true-->dom(a).'),nl;
	     dom_atom_w2_b(A)
	 );
	    (A==[],!,
	     write('true-->dom(a),dom_lev(a,0).'),nl;
		dom_atom_w2(A)
	    )
	).
dom_atom_w2([]).
dom_atom_w2([A1|A2]):-
	write('true-->dom('),
	write((A1)),
	write('),dom_lev('),
	write((A1)),
	write(',0).'),nl,
	dom_atom_w2(A2).
dom_atom_w2_b([]).
dom_atom_w2_b([A1|A2]):-
	write('true-->dom('),
	write((A1)),
	write(').'),nl,
	dom_atom_w2_b(A2).

dom_write2:-
	dom_max_l(Max),
	dom_func(_,F),
	(F==[],!;
	    dom_func2_w(F),
	    next_num_dom2(0,Max),
	    prog_w
	).
dom_func2_w([]).
dom_func2_w([F1|F2]):-
	F1=..[_|Arg],
	dom_farg2_w(Arg,0),
	write('-->dom('),
	write((F1)),
	write('),dom_lev('),
	write((F1)),
	write(',Last).'),nl,
	dom_func2_w(F2).
dom_farg2_w([],_).
dom_farg2_w([A1|A2],Po):-
	append_atom('F',Po,Fc),
	write('dom_lev('),
	write((A1)),
	write(','),
	write((Fc)),
	write(')'),
	Po1 is Po + 1,
	dom_farg2_w2(A2,Po1,Pn),
	write(',{max('),
	(Pn =\= 0,!,
	 write('('),
	 num_list_F(0,Pn),
	 write(')');
	    num_list_F(0,Pn)
	),
	write(',Max)},'),
	write('next(Max,Last)').
dom_farg2_w2([],Po,Pn) :- Pn is Po - 1.
dom_farg2_w2([A1|A2],Po,Pn):-
	append_atom('F',Po,Fc),
	write(',dom_lev('),
	write((A1)),
	write(','),
	write((Fc)),
	write(')'),
	Po1 is Po + 1,
	dom_farg2_w2(A2,Po1,Pn).
next_num_dom2(I,Max) :-
	I < Max,!,
	J is I + 1,
	next_num_w2(I,J),
	next_num_dom2(J,Max);
	true.
next_num_w2(I,J) :-
	write('dom_lev(X,'),
	write((I)),
	write(')-->next('),
	write((I)),
	write(','),
	write((J)),
	write(').'),nl.


dom_write1_lev :-
	dom_atom(A),
	(A==[],!,
	 write('true-->dom_lev(a,0).'),nl;
	    dom_atom_w_lev(A)
	).
dom_atom_w_lev([]).
dom_atom_w_lev([A1|A2]):-
	write('true-->dom_lev('),
	write((A1)),
	write(',0).'),nl,
	dom_atom_w_lev(A2).

dom_write2_lev:-
	dom_func(_,F),
	(F==[],!;
	    dom_func_w_lev(F)   
	).
dom_func_w_lev([]).
dom_func_w_lev([F1|F2]):-
	F1=..[_|Arg],
	dom_farg_w_lev(Arg,0),
	write('-->dom_lev('),
	write((F1)),
	write(',Last).'),nl,
	dom_func_w_lev(F2).
dom_farg_w_lev([],_).
dom_farg_w_lev([A1|A2],Po):-
	append_atom('Fc',Po,Fc),
	append_atom('F',Po,Fc2),
	write('dom_lev('),
	write((A1)),
	write(','),
	write((Fc)),
	write('),next_dom('),
	write((Fc)),
	write(','),
	write((Fc2)),
	write(')'),
	Po1 is Po + 1,
	dom_farg_w_lev2(A2,Po1,Pn),
	write(',{max('),
	(Pn =\= 0,!,
	 write('('),
	 num_list_F(0,Pn),
	 write(')');
	    write('F0')
	),
	write(',Last)}').
dom_farg_w_lev2([],Po,Pn) :- Pn is Po - 1.
dom_farg_w_lev2([A1|A2],Po,Pn):-
	append_atom('Fc',Po,Fc),
	append_atom('F',Po,Fc2),
	write(',dom_lev('),
	write((A1)),
	write(','),
	write((Fc)),
	write('),next_dom('),
	write((Fc)),
	write(','),
	write((Fc2)),
	write(')'),
	Po1 is Po + 1,
	dom_farg_w_lev2(A2,Po1,Pn).
next_num_dom_lev(I,Max) :-
	I < Max,!,
	J is I + 1,
	next_num_dom_lev2(I,J),
	next_num_dom_lev(J,Max);
	true.
next_num_dom_lev2(I,J) :-
	write('dom_lev(X,'),
	write((I)),
	write(')-->next_dom('),
	write((I)),
	write(','),
	write((J)),
	write(').'),nl.


num_list_F(Po,Pn) :-
	Pn =\= Po,!,
	append_atom('F',Po,Fc),
	write((Fc)),
	write(','),
	Po1 is Po + 1,
	num_list_F(Po1,Pn);
	append_atom('F',Pn,Fc),
	write((Fc)).


prog_w :-
	write('max((A,B),C) :- max(B,C1),(A < C1,!,C=C1;C=A).'),nl,
	write('max(A,C) :- C = A.'),nl.


tree((A;B),AB) :-
	atom(A),
	tree(B,ABn),
	append2([[A]],ABn,AB);
	abnormal(Ab1,Ab2),
	A=..[Pred|_],
	trs_pred(Pred,Bind,Ab1,Ab2),
	tree(B,ABn),
	append2([Bind],ABn,AB).
tree(A,AB) :-
	atom(A),
	AB=[[A]];
	abnormal(Ab1,Ab2),
	A=..[Pred|_],
	trs_pred(Pred,Bind,Ab1,Ab2),
	AB=[Bind].

tree_disp([],_) :- !,fail.
tree_disp([AB1|[]],AB) :-
	onback(front(AB1,ABf,_)),
	onback(append2(AB,[ABf],AB_n)),
	onback(disp(AB_n)),
	fail.
tree_disp([AB1|AB2],AB) :-
	(onback(front(AB1,ABf,ABb)),
	 onback(append2(AB,[ABf],AB_n)),
	 onback(tree_disp(AB2,AB_n));
	    onback(front(AB1,ABf,ABb)),
	    (ABb==[],!,fail;
		onback(append2([ABb],AB2,AB_n)),
		onback(tree_disp(AB_n,AB))
	    );
	    !,fail
	).
tree_disp(_,_):-!,fail.

disp([]):-!,fail.
disp(AB) :- 
	ad_ptn(Ad_list),
	retract((ad_ptn(_))),
	(Ad_list\==[],
	 append2(Ad_list,[AB],New),
	 assert((ad_ptn(New)));
	    assert((ad_ptn([AB])))
	),
	!,fail.

onback(X):- !,X.
onback(_):- fail.

onfowardtracking(_).
onfowardtracking(X):- X,fail.

front_atom(Pred,Front,Rest) :-  
	name(Pred,List),
	front(List,Front1,Rest1),
	name(Front,[Front1]),
	name(Rest,Rest1).

front([],[],[]):-!.
front([Atom|[]],Atom,[]):-!.
front([X|Y],X,Y):-!.

front2([],_,_):- !,fail.
front2([_|[]],_,_):- !,fail.
front2([X|Y],X,Y).

next([],_) :- !,fail.
next([_|T2],Next) :- Next=[[T2]].
next([_],_) :- !,fail.

out_atom_que([]):-!.
out_atom_que([Arg1|Arg2]) :-
	!,
	onback(write((Arg1))),
	out_atom_que(Arg2).

rest_check :- 
	read(Z),
	Z==end_of_file,!,true;
	seen,!,fail.

add_ab_t(T) :-
	abnormal(A,B),
	append2(A,[T],New1),
	append2(B,[[T]],New2),
	retract((abnormal(_,_))),
	assert((abnormal(New1,New2))).

dist_ad([],[],_).
dist_ad(Pred,Predn,Chk) :-
	last_atom(Pred,L_P,R_P),
	(L_P=='_',!,
	 (Chk==[],!,
	  append_atom(R_P,'_',Predn);
	     Predn=R_P
	 );
	    dist_ad(R_P,Predn,a)
	).
dist_ad2(Pred,Check) :-
	last_atom(Pred,L_P,_),
	(L_P=='_',!,
	 Check=[];
	    Check=Pred
	).
count_list([_|B],Cnt,Cnt_n) :-
	(B==[],!,
	 Cnt_n is Cnt + 1;
	    Cnt1 is Cnt + 1,
	    count_list(B,Cnt1,Cnt_n)
	).
count_list([],Cnt,Cnt).

