% Copyright (C) 1998  Katsumi Inoue
%
%%% mgtp2nhm.pl %%%
%

:- op(1200,xfx,'-->').
:- dynamic magic_list/2,abnormal/2,ab_check/1,ad_ptn/1,dom_c/1,dom_atom/1,
	   dom_func/2,head_list/2,head_list_m/2,body_list/1.


initial :-
	assert((ab_check('ab_not_occur'))),
	assert((ad_ptn([]))),
	assert((magic_list([],[]))),
        assert((abnormal([],[]))),
	assert((dom_c('dom_not_occur'))),
	assert((dom_atom([]))),
	assert((dom_func([],[]))),
	assert((head_list([],[]))),
	assert((head_list_m([],[]))),
	assert((head_list_m2([],[]))),
	assert((body_list([]))).

refresh :-
	abolish(ab_check),
	abolish(ad_ptn),
	abolish(magic_list),
        abolish(abnormal),
	abolish(dom_c),
	abolish(dom_atom),
	abolish(dom_func),
	abolish(head_list),
	abolish(head_list_m),
	abolish(head_list_m2),
	abolish(body_list).

mgtp2nhm(X,InFile) :-
    nhmcheck(X,InFile,InFile).

mgtp2nhm(X,InFile,OutFile) :-
    nhmcheck(X,InFile,OutFile).

nhmcheck(X,InFile,OutFile) :-
        can_file_open_msg(read,InFile,[mgtp],S1),
        see(S1),goal_check(Goal),seen,
        (var(Goal) -> mgtp2nnhm(X,InFile,OutFile);mgtp2enhm(X,InFile,OutFile)).



goal_check(Goal) :-   
        read(Z),numbervars(Z,0,_),
        (Z==end_of_file -> ! ;
           (Z=(goal:(A)) -> (Goal=yes,
                             assert(goaldf([A])),
                             assert(goalbf([A])),!);
                            (goal_check(Goal),!)) 
	).

mgtp2nnhm(Kind,InFile,OutFile) :- 
	initial,
        can_file_open_msg(read,InFile,[mgtp],S1),
        can_file_open_msg(write,'temp/cost_kliteral',[tmp],CK),
        see(S1),tell(CK),cp_file_ck1,seen,told,
        can_file_open_msg(write,'temp/source',[tmp],S),
	see(S1),tell(S),cp_file_no_ck1,seen,told,
        can_file_open_msg(read,'temp/source',[tmp],S),
	see(S),ent_domlist,seen,
        can_file_open_msg(write,'temp/false_f',[tmp],False_f),
	see(S),tell(False_f),file_dist_f,seen,told,
        can_file_open_msg(write,'temp/true_f',[tmp],True_f),
	see(S),tell(True_f),file_dist_t,seen,told,
        can_file_open_msg(write,'temp/ft_rest',[tmp],Ft_rest),
	see(S),tell(Ft_rest),file_dist_rest,seen,told,
        can_file_open_msg(read,'temp/ft_rest',[tmp],Ft_rest),
        can_file_open_msg(write,'temp/rest_hd',[tmp],Rest_hd),
	see(Ft_rest),tell(Rest_hd),hd_adrn_ftr(0,Chk),seen,told,
	(Chk=\=0, !,hd_adrn_ftr_c(Chk) ; true),
	retract((ab_check(_))),
	assert((ab_check('ab_not_occur'))),
        can_file_open_msg(write,'temp/ft_rest_fin_hd',[tmp],Ft_rest_fin_hd),
	see(Ft_rest),tell(Ft_rest_fin_hd),adrn_ftr(Chk2),seen,told,
	(Chk2=='end',! ; adrn_ftr_c),
	retract((ad_ptn(_))),
	assert((ad_ptn([]))),
        can_file_open_msg(read,'temp/false_f',[tmp],False_f),
        can_file_open_msg(read,'temp/true_f',[tmp],True_f),
        can_file_open_msg(write,'temp/true_f_fin_hd',[tmp],True_f_fin_hd),
	see(True_f),tell(True_f_fin_hd),adrn_tf,seen,told,
        can_file_open_msg(write,InFile,[ad],T_S),
        can_file_open_msg(read,'temp/true_f_fin_hd',[tmp],True_f_fin_hd),
        can_file_open_msg(read,'temp/ft_rest_fin_hd',[tmp],Ft_rest_fin_hd),
	see(False_f),tell(T_S),cp_file,seen,
        see(True_f_fin_hd),           cp_file,seen,
	see(Ft_rest_fin_hd),          cp_file,seen,told,
  	magic_list(A,_),
	(A==[],!,
	 if(Kind='df',
           (can_file_open_msg(write,OutFile,[mgtp],M_S),
            can_file_open_msg(read,InFile,[ad],T_S),
            can_file_open_msg(read,'temp/cost_kliteral',[tmp],CK),
	    see(T_S),tell(M_S),nh_magic2(1),seen,see(CK),cp_file,seen,told),
           (can_file_open_msg(write,OutFile,[mgtp],M_S),
            can_file_open_msg(read,InFile,[ad],T_S),
            can_file_open_msg(read,'temp/cost_kliteral',[tmp],CK),
	    see(T_S),tell(M_S),nh_magic2,seen,see(CK),cp_file,seen,told,
	    write('magic adorned'),nl)
         );
            if(Kind='df',
            (can_file_open_msg(write,OutFile,[mgtp],Sup_S),
             can_file_open_msg(read,'temp/cost_kliteral',[tmp],CK),
             can_file_open_msg(write,'temp/temp',[tmp],Temp),
             can_file_open_msg(read,InFile,[ad],T_S),
	     see(T_S),tell(Temp),nh_supmagic(1),seen,told,
             can_file_open_msg(read,'temp/temp',[tmp],Temp),
	     see(Temp),ent_head_magic,seen,
	     dom_c(F1),
	     (F1=='dom_occur',!,
	      see(CK),tell(Sup_S),cp_file,seen,dom_write,
              see(Temp),cp_file,seen,told,
	      write('supmagic adorned'),nl,
	      write('magic program dom occured'),nl,
	      retract((dom_c(_))),
	      assert((dom_c('dom_not_occur')));
		 see(CK),tell(Sup_S),cp_file,seen,see(Temp),cp_file,seen,told,
		 write('supmagic adorned'),nl,
		 write('magic program dom NOT occured'),nl
	     )
            ),
            (can_file_open_msg(write,OutFile,[mgtp],Sup_S2),
             can_file_open_msg(read,InFile,[ad],T_S),
             can_file_open_msg(read,'temp/cost_kliteral',[tmp],CK),
             can_file_open_msg(write,'temp/temp2',[tmp],Temp2),
	     see(T_S),tell(Temp2),nh_magic,seen,told,
             can_file_open_msg(read,'temp/temp2',[tmp],Temp2),
	     see(Temp2),ent_head_magic2,seen,
	     dom_c(F1b),
	     (F1b=='dom_occur',!,
	      see(CK),tell(Sup_S2),cp_file,seen,dom_write,
              see(Temp2),cp_file,seen,told,
	      write('supmagic2 adorned'),nl,
	      write('magic2 program dom occured'),nl,
	      retract((dom_c(_))),
	      assert((dom_c('dom_not_occur')));
		see(CK),tell(Sup_S2),cp_file,seen,see(Temp2),cp_file,seen,told,
		write('supmagic2 adorned'),nl,
		write('magic2 program dom NOT occured'),nl
	     )
            )),
            can_file_open_msg(read,InFile,[ad],T_S),
            can_file_open_msg(write,'temp/temp',[tmp],Temp),
	    see(T_S),tell(Temp),dom_tg_ent,seen,told,
	    dom_c(F2),
	    (F2=='dom_occur',!,
             can_file_open_msg(write,InFile,[ad],T_S),
             can_file_open_msg(read,'temp/temp',[tmp],Temp),
	     see(Temp),tell(T_S),dom_write1,cp_file,dom_write2,seen,told,
	     write('adorned program dom occured'),nl,
	     retract((dom_c(_))),
	     assert((dom_c('dom_not_occur')));
                can_file_open_msg(write,InFile,[ad],T_S),
                can_file_open_msg(read,'temp/temp',[tmp],Temp),
		see(Temp),tell(T_S),cp_file,seen,told,
		write('adorned program dom NOT occured'),nl
	    )
	),refresh.

dom_tg_ent :-
	read(Z),numbervars(Z,0,_),
	(Z==end_of_file,!;
	    Z=(B-->A),!,
	    (B=='true',!,
	     get_arg(A,[],Arg_head),
	     dom_check_t(Arg_head),
	     write('-->'),
	     write((A)),
	     write('.'),nl,
	     dom_tg_ent;
		get_arg(B,[],Arg_body),
		get_arg(A,[],Arg_head),
		write((B)),
		dom_check(Arg_head,Arg_body),
		write('-->'),
		write((A)),
		write('.'),nl,
		dom_tg_ent
	    );
	    Z=(_:(A)),!,
	    write('goal:('),
	    write((A)),
	    write(').'),nl,
	    dom_tg_ent;
	    Z=(A),
	    get_arg(A,[],Arg_head),
	    dom_check_t(Arg_head),
	    write('-->'),
	    write((A)),
	    write('.'),nl,
	    dom_tg_ent
	).
  
ent_domlist :-
	read(Z),numbervars(Z,0,_),
	(Z==end_of_file,!;
	    Z=(B-->A),
	    (A=='false',!;
		ent_dlist(A)
	    ),
	    (B=='true',!;
		ent_dlist(B)
	    ),
	    ent_domlist;
	    Z=(_:(A)),!,
	    ent_dlist(A),
	    ent_domlist;
	    Z=(A),
	    ent_dlist(A),
	    ent_domlist
	).
ent_dlist((A;B)):-
	atom(A),
	ent_dlist(B);
	A=..[_|Arg],
	ent_dom(Arg),
	ent_dlist(B).
ent_dlist((A,B)) :-
	atom(A),
	ent_dlist(B);
	A=..[_|Arg],
	ent_dom(Arg),
	ent_dlist(B).
ent_dlist(A) :-
	atom(A);
	A=..[_|Arg],
	ent_dom(Arg).

file_dist_f :- 
	read(Z),numbervars(Z,0,_),
	(Z==end_of_file,!;
	    Z=(B-->A),
	    A=='false',!,
	    false_ad_w(B,[]),
	    ent_body(B),
	    write('-->false.'),nl,
	    file_dist_f;
	    Z=(_:(A)),!,
	    write('goal:('),
	    false_ad_w(A,[]),
	    write(').'),nl,
	    file_dist_f;
	    file_dist_f,!).

file_dist_t :- 
	read(Z),numbervars(Z,0,_),
	(Z==end_of_file,!;
	    Z=(_:_),!,
	    file_dist_t;
	    Z=(B-->_),
	    (B=='true',!,
	     write((Z)),write('.'),nl,
	     file_dist_t;
		file_dist_t,!
	    );
	    write('true-->'),
	    write((Z)),	    
	    write('.'),nl,
	    file_dist_t,!
	).
			   
file_dist_rest :- 
	read(Z),numbervars(Z,0,_),
	(Z==end_of_file,!;
	    Z=(B-->A),!,
	    (B=='true',!,ent_head(A);
		(A=='false',!;
		    ent_head(A),
		    ent_body(B),
		    write((Z)),write('.'),nl
		)
	    ),
	    file_dist_rest;
	    Z=(A),
	    ent_head(A),
	    file_dist_rest
	).

hd_adrn_ftr(Prv,Chk) :- 
	read(Z),numbervars(Z,0,_),
	(Z==end_of_file,!,Chk is Prv;
	    Z=(B-->A),
	    (rec_b_arg(A,Arg),!,  
	     false_ad(B,Arg), 
	     hd_adrn_ftr(Prv,Chk);
		Next is Prv + 1,
		write((Z)),write('.'),nl,
		!,hd_adrn_ftr(Next,Chk))).

hd_adrn_ftr_c(Cnt) :- 
        can_file_open_msg(read,'temp/rest_hd',[tmp],Rest_hd),
        can_file_open_msg(write,'temp/rest_hd_temp',[tmp],Rest_hd_temp),
	see(Rest_hd),tell(Rest_hd_temp),cp_file,seen,told,
        can_file_open_msg(write,'temp/rest_hd',[tmp],Rest_hd),
        can_file_open_msg(read,'temp/rest_hd_temp',[tmp],Rest_hd_temp),
	see(Rest_hd_temp),tell(Rest_hd),hd_adrn_ftr(0,Chk),seen,told,
	(Chk=\=0,!,
	 (Chk=\=Cnt,!,
	  hd_adrn_ftr_c(Chk);
	     see(Rest_hd),hd_rm,seen,
	     write('non entory Pred occur'),nl
	 );
	    true
	).

hd_rm :-
	read(Z),numbervars(Z,0,_),
	(Z==end_of_file,!;
	    Z=(_-->A),!,
	    (mg_chk_hd(A),!;
		write('Warning possibly 1 clause removed'),nl
	    ),
	    hd_rm_l1(A),
	    hd_rm; 
		hd_rm
	).
hd_rm_l1((A;B)) :-
	A=..[Pred|_],
	abnormal(AB1,AB2),
	(member(Pred,AB1),!,
	 write((A)),nl,
	 true;
	    body_list(Body),
	    member(Pred,Body),!,
	    true;
	    write((A)),nl,
	    append_atom(Pred,'_',New),
	    (AB1==[],!,
	     retract((abnormal(_,_))),
	     assert((abnormal([Pred],[[New]])));
		append2(AB1,[Pred],New1),
		append2(AB2,[[New]],New2),
		retract((abnormal(_,_))),
		assert((abnormal(New1,New2)))
	    )
	),
	hd_rm_l1(B).
hd_rm_l1((A,B)) :-
	A=..[Pred|_],
	abnormal(AB1,AB2),
	(member(Pred,AB1),!,
	 write((A)),nl,
	 true;
	    body_list(Body),
	    member(Pred,Body),!,
	    true;
	    write((A)),nl,
	    append_atom(Pred,'_',New),
	    (AB1==[],!,
	     retract((abnormal(_,_))),
	     assert((abnormal([Pred],[[New]])));
		append2(AB1,[Pred],New1),
		append2(AB2,[[New]],New2),
		retract((abnormal(_,_))),
		assert((abnormal(New1,New2)))
	    )
	),
	hd_rm_l1(B).
hd_rm_l1(A) :-
	A=..[Pred|_],
	abnormal(AB1,AB2),
	(member(Pred,AB1),!,
	 write((A)),nl,nl,
	 true;
	    body_list(Body),
	    member(Pred,Body),!,
	    true;
	    write((A)),nl,nl,
	    append_atom(Pred,'_',New),
	    (AB1==[],!,
	     retract((abnormal(_,_))),
	     assert((abnormal([Pred],[[New]])));
		append2(AB1,[Pred],New1),
		append2(AB2,[[New]],New2),
		retract((abnormal(_,_))),
		assert((abnormal(New1,New2)))
	    )
	).

adrn_ftr(Chk) :- 
	read(Z),numbervars(Z,0,_),
	(Z==end_of_file,!,Chk='end';
	    Z=(B-->A),
	    tree(A,Adorn),
	    adrn_ftr_l1(Chk,A,B,Adorn),
	    (Chk=='ok',!;
		adrn_ftr(Chk))).
adrn_ftr_l1(Chk,A,B,Adorn) :-
	tree_disp(Adorn,[]);
	ad_ptn(Ad_list),
	adrn_ftr_l2(A,B,Ad_list),
	retract((ad_ptn(_))),
	assert((ad_ptn([]))),
	ab_check(F),
	(F=='ab_occur',!,
	 retract((ab_check(_))),
	 assert((ab_check('ab_not_occur'))),
	 Chk='ok';
	    true
	).

adrn_ftr_c :-
        can_file_open_msg(read,'temp/ft_rest',[tmp],Ft_rest),
        can_file_open_msg(write,'temp/ft_rest_fin_hd',[tmp],Ft_rest_fin_hd),
	see(Ft_rest),tell(Ft_rest_fin_hd),adrn_ftr(Chk),seen,told,
	(Chk=='end',!;
	    Chk=='ok',adrn_ftr_c).

adrn_ftr_l2(_,_,[]).
adrn_ftr_l2(A,B,[AD1|AD2]) :-
	rec_ftr_b_arg(A,Arg,AD1),
	false_ad_w(B,Arg),
	write('-->'),
	ent_mg_hd(A,AD1),
	write('.'),nl,
	adrn_ftr_l2(A,B,AD2).

rec_ftr_b_arg((A1;A2),Arg_list,[AB1|AB2]) :- 
	atom(A1),
	rec_ftr_b_arg(A2,Arg_list,AB2);
	A1=..[_|Arg],
	rec_magic_arg(AB1,Arg,M_arg),
	rec_ftr_b_arg(A2,Arg2,AB2),
	or_var(Arg2,M_arg,Arg_list).
rec_ftr_b_arg(A,Arg_list,[AB]) :- 
	atom(A),
	Arg_list=[];
	A=..[_|Arg],
	rec_magic_arg(AB,Arg,M_arg),
	or1_var([],M_arg,Arg_list).

ent_mg_hd((A;B),[AB1|AB2]) :- 
	atom(A),!,
	write((A)),write(';'),
	ent_mg_hd(B,AB2);
	A=..[_|Arg],
	A_ad=..[AB1|Arg],
	write((A_ad)),write(';'),
	ent_mg_hd(B,AB2).
ent_mg_hd(A,[AB]) :- 
	atom(A),!,
	write((A));
	A=..[_|Arg],
	A_ad=..[AB|Arg],
	write((A_ad)).

adrn_tf :- 
	read(Z),numbervars(Z,0,_),
	(Z==end_of_file,!;
	    Z=(_-->A),
	    tree(A,Adorn),
	    adrn_tf_l1(A,Adorn),
	    adrn_tf
	).
adrn_tf_l1(A,Adorn) :-
	tree_disp(Adorn,[]);
	ad_ptn(Ad_list),
	adrn_tf_l2(A,Ad_list),
	retract((ad_ptn(_))),
	assert((ad_ptn([]))).

adrn_tf_l2(_,[]).
adrn_tf_l2(A,[AD1|AD2]) :-
	write('true'),
	write('-->'),
	ent_mg_hd(A,AD1),
	write('.'),nl,
	adrn_tf_l2(A,AD2).

rec_b_arg((A1;A2),Arg_list) :- 
	atom(A1),
	rec_b_arg(A2,Arg_list);
	magic_list(PQ1,PQ2),
	A1=..[Pred|Arg],
	member(Pred,PQ1),!,
	rec_b_arg(A2,Arg2),
	trs_pred(Pred,Bind,PQ1,PQ2),
	rec_magic_arg(Bind,Arg,M_arg),
	or_var(Arg2,M_arg,Arg_list);
	!,fail.
rec_b_arg((A1,A2),Arg_list) :- 
	atom(A1),
	rec_b_arg(A2,Arg_list);
	magic_list(PQ1,PQ2),
	A1=..[Pred|Arg],
	member(Pred,PQ1),!,
	rec_b_arg(A2,Arg2),
	trs_pred(Pred,Bind,PQ1,PQ2),
	rec_magic_arg(Bind,Arg,M_arg),
	or_var(Arg2,M_arg,Arg_list);
	!,fail.
rec_b_arg(A,Arg_list) :- 
	atom(A),
	Arg_list=[];
	magic_list(PQ1,PQ2),
	A=..[Pred|Arg],
	member(Pred,PQ1),!,
	trs_pred(Pred,Bind,PQ1,PQ2),
	rec_magic_arg(Bind,Arg,M_arg),
	or1_var([],M_arg,Arg_list);
	!,fail.

nh_magic2 :-
	read(Z),numbervars(Z,0,_),
	(Z==end_of_file,!;
	    Z=(_:(A)),!,
	    write('true-->'),
	    nh_magic_w(A),
	    write('.'),nl,
	    nh_magic2;
	    Z=(B-->A),!,           
	    (B=='true',!,
	     nh_magic_w(A),
	     write('-->'),
	     nh_write(A),
	     write('.'),nl;
		nh_magic_w(A),
		write('-->'),
		nh_magic_w(B),
		write('.'),nl,
		(A=='false',!;
		    nh_magic_w(A),
		    write(',')),
		    nh_write(B),
		    write('-->'),
		    nh_write(A),
		    write('.'),nl,!
	    ),
	    nh_magic2,!;
	    Z=(A),
	    nh_magic_w(A),
	    write('-->'),
	    nh_write(A),
	    write('.'),nl,
	    nh_magic2,!;
	    nh_magic2
	).

nh_magic2(R_num) :-
	read(Z),numbervars(Z,0,_),
	(Z==end_of_file,!;
	    Z=(_:(A)),!,
	    write('true-->'),
	    nh_magic_w(A),
	    write('.'),nl,
	    Next is R_num + 1,
	    nh_magic2(Next);
	    Z=(B-->A),!,           
	    (B=='true',!,
	     nh_magic_w(A),
	     write('-->'),
	     nh_write(A),
	     write('.'),nl,
	     Next is R_num + 1,
	     nh_magic2(Next);
		nh_magic2_1(R_num,1,A,B),
		write('.'),nl,
		Next is R_num + 1,
		nh_magic2(Next)
	    )
	).

nh_magic2_1(R_num,B_num,A,(B1,B2)):-
	nh_magic_w(A),
	write('-->'),
	nh_magic_w(B1),
	write(','),
	append_atom('supmagic_',R_num,S_P1),
	append_atom(S_P1,'_',S_P2),
	append_atom(S_P2,B_num,S_P),
	write((S_P)),
	write('.'),nl,
	nh_magic2_2(A,R_num,B_num,B1,B2,S_P).

nh_magic2_1(R_num,B_num,A,B):-
	nh_magic_w(A),
	write('-->'),
	nh_magic_w(B),
	write(','),
	append_atom('supmagic_',R_num,S_P1),
	append_atom(S_P1,'_',S_P2),
	append_atom(S_P2,B_num,S_P),
	write((S_P)),
	write('.'),nl,
	write((S_P)),
	write(','),
	nh_write(B),
	write('-->'),
	nh_write(A).

nh_magic2_2(A,R_num,B_num,B1,(B2,B3),Sup_P):-
	write((Sup_P)),
	write(','),
	nh_write(B1),
	write('-->'),
	nh_magic_w(B2),
	write(','),
	N_B is B_num + 1,
	append_atom('supmagic_',R_num,S_P1),
	append_atom(S_P1,'_',S_P2),
	append_atom(S_P2,N_B,S_P),
	write((S_P)),
	write('.'),nl,
 	nh_magic2_2(A,R_num,N_B,B2,B3,S_P).

nh_magic2_2(A,R_num,B_num,B1,B2,Sup_P):-
	write((Sup_P)),
	write(','),
	nh_write(B1),
	write('-->'),
	nh_magic_w(B2),
	write(','),
	N_B is B_num + 1,
	append_atom('supmagic_',R_num,S_P1),
	append_atom(S_P1,'_',S_P2),
	append_atom(S_P2,N_B,S_P),
	write((S_P)),
	write('.'),nl,
	write((S_P)),
	write(','),
	nh_write(B2),
	write('-->'),
	nh_write(A).

nh_magic :-
	read(Z),numbervars(Z,0,_),
	(Z==end_of_file,!;
	    Z=(_:(A)),!,
	    get_suparg(A,[],Arg_head),
	    dom_check_t(Arg_head),
	    write('-->'),
	    nh_magic_w(A),
	    write('.'),nl,
	    nh_magic;
	    Z=(B-->A),!,           
	    (B=='true',!,
	     get_arg(A,[],Arg_head),
	     get_suparg(A,[],Arg_body),
	     nh_magic_w(A),
	     dom_check(Arg_head,Arg_body),
	     write('-->'),
	     nh_write_b(A),
	     write('.'),nl,nh_magic;
		unknown_check(A,A1_chk,A2_chk),
		(A2_chk == [],!,
		 get_suparg(B,[],Arg_head1),
		 get_suparg(A,[],Arg_body1),
		 dom_check_nhm(Arg_head1,Arg_body1,A),
		 write('-->'),
		 nh_magic_w(B),
		 write('.'),nl,
		 (A=='false',!,
		  get_arg(B,[],Arg_body2);
		     get_arg(B,[],Arg_body),
		     or_var(Arg_body1,Arg_body,Arg_body2),
		     nh_magic_w(A),
		     write(',')
		 ),
		 nh_write_b(B),
		 get_arg(A,[],Arg_head2),
		 dom_check(Arg_head2,Arg_body2),
		 write('-->'),
		 nh_write_b(A),
		 write('.'),nl;
		    get_suparg(B,[],Arg_head1),
		    get_arg(B,[],Arg_body),
		    get_arg(A,[],Arg_head2),
		    (A1_chk==[],!,true;
			listtopred(A1_chk,A1),
			get_suparg(A1,[],Arg_body1_1),
			dom_check_nhm(Arg_head1,Arg_body1_1,A1),
			write('-->'),
			nh_magic_w(B),
			write('.'),nl,
			or_var(Arg_body1_1,Arg_body,Arg_body2_1),
			nh_magic_w(A1),
			write(','),
			nh_write_b(B),
			dom_check(Arg_head2,Arg_body2_1),
			write('-->'),
			nh_write_b(A),
			write('.'),nl
		    ),
		    (A2_chk==[],!,true;
			listtopred(A2_chk,A2),
			get_suparg(A2,[],Arg_body1_2),
			dom_check_nhm(Arg_head1,Arg_body1_2,A2),
			write('-->'),
			nh_magic_w(B),
			write('.'),nl,		
			or_var(Arg_body1_2,Arg_body,Arg_body2_2),
			nh_magic_w(A2),
			write(','),
			nh_write_b(B),
			dom_check(Arg_head2,Arg_body2_2),
			write('-->'),
			nh_write_b(A),
			write('.'),nl
		    )
		),
		nh_magic
	    );
	    Z=(A),
	    get_arg(A,[],Arg_head),
	    get_suparg(A,[],Arg_body),
	    nh_magic_w(A),
	    dom_check(Arg_head,Arg_body),
	    write('-->'),
	    nh_write_b(A),
	    write('.'),nl,
	    nh_magic
	).


nh_supmagic(R_num) :-
	read(Z),numbervars(Z,0,_),
	(Z==end_of_file,!;
	    Z=(_:(A)),!,
	    get_suparg(A,[],Arg_head),
	    dom_check_t(Arg_head),
	    write('-->'),
	    nh_magic_w(A),
	    write('.'),nl,
	    Next is R_num + 1,
	    nh_supmagic(Next);
	    Z=(B-->A),!,           
	    (B=='true',!,
	     get_suparg(A,[],Arg_body),
	     get_arg(A,[],Arg_head),
	     nh_magic_w(A),
	     dom_check(Arg_head,Arg_body),
	     write('-->'),
	     nh_write_b(A),
	     write('.'),nl,
	     Next is R_num + 1,
	     nh_supmagic(Next);
		unknown_check(A,A1_chk,A2_chk),
		(A2_chk==[],!,
		get_suparg(A,[],Arg_body),
		nh_supmagic1(R_num,1,A,B,Arg_body),
		write('.'),nl,
		Next is R_num + 1,
		nh_supmagic(Next);
		    (A1_chk==[],!;
			listtopred(A1_chk,A1),
			get_suparg(A1,[],Arg_body1),
			nh_supmagic1_2(R_num,1,A1,B,Arg_body1,A),
			write('.'),nl
		    ),
		    (A2_chk==[],!;
			listtopred(A2_chk,A2),
			get_suparg(A2,[],Arg_body2),
			nh_supmagic1_2(R_num,1,A2,B,Arg_body2,A),
			write('.'),nl
		    ),
		    Next is R_num + 1,
		    nh_supmagic(Next)
		)
	    );
	    Z=(A),
	    get_suparg(A,[],Arg_body),
	    get_arg(A,[],Arg_head),
	    nh_magic_w(A),
	    dom_check(Arg_head,Arg_body),
	    write('-->'),
	    nh_write_b(A),
	    write('.'),nl,
	    Next is R_num + 1,
	    nh_supmagic(Next)
	).

nh_supmagic1(R_num,B_num,A,(B1,B2),Arg_body):-
	nh_magic_w(A),
	B1=..[Pred_B1|Arg_B1],
	rec_magic_arg(Pred_B1,Arg_B1,Arg_head),
	or1_var([],Arg_head,Arg_headvar),
	dom_check(Arg_headvar,Arg_body),
	write('-->'),
	nh_magic_w(B1),
	write(','),
	append_atom('supmagic_',R_num,S_P1),
	append_atom(S_P1,'_',S_P2),
	append_atom(S_P2,B_num,S_P),
	Sup_P=..[S_P|Arg_body],
	write((Sup_P)),
	write('.'),nl,
	nh_supmagic2(A,R_num,B_num,B1,B2,Sup_P).

nh_supmagic1(R_num,B_num,A,B,Arg_body):-
	nh_magic_w(A),
	B=..[Pred_B|Arg_B],
	rec_magic_arg(Pred_B,Arg_B,Arg_head),
	or1_var([],Arg_head,Arg_headvar),
	dom_check(Arg_headvar,Arg_body),
	write('-->'),
	nh_magic_w(B),
	write(','),
	append_atom('supmagic_',R_num,S_P1),
	append_atom(S_P1,'_',S_P2),
	append_atom(S_P2,B_num,S_P),
	Sup_P=..[S_P|Arg_body],
	write((Sup_P)),
	write('.'),nl,
	write((Sup_P)),
	write(','),
	nh_write_b(B),
	or_var(Arg_body,Arg_B,Arg_body2),
	get_arg(A,[],Arg_head2),
	dom_check(Arg_head2,Arg_body2),
	write('-->'),
	nh_write_b(A).

nh_supmagic1_2(R_num,B_num,A,(B1,B2),Arg_body,NH_A):-
	nh_magic_w(A),
	B1=..[Pred_B1|Arg_B1],
	rec_magic_arg(Pred_B1,Arg_B1,Arg_head),
	or1_var([],Arg_head,Arg_headvar),
	dom_check(Arg_headvar,Arg_body),
	write('-->'),
	nh_magic_w(B1),
	write(','),
	append_atom('supmagic_',R_num,S_P1),
	append_atom(S_P1,'_',S_P2),
	append_atom(S_P2,B_num,S_P),
	Sup_P=..[S_P|Arg_body],
	write((Sup_P)),
	write('.'),nl,
	nh_supmagic2(NH_A,R_num,B_num,B1,B2,Sup_P).

nh_supmagic1_2(R_num,B_num,A,B,Arg_body,NH_A):-
	nh_magic_w(A),
	B=..[Pred_B|Arg_B],
	rec_magic_arg(Pred_B,Arg_B,Arg_head),
	or1_var([],Arg_head,Arg_headvar),
	dom_check(Arg_headvar,Arg_body),
	write('-->'),
	nh_magic_w(B),
	write(','),
	append_atom('supmagic_',R_num,S_P1),
	append_atom(S_P1,'_',S_P2),
	append_atom(S_P2,B_num,S_P),
	Sup_P=..[S_P|Arg_body],
	write((Sup_P)),
	write('.'),nl,
	write((Sup_P)),
	write(','),
	nh_write_b(B),
	or_var(Arg_body,Arg_B,Arg_body2),
	get_arg(A,[],Arg_head2),
	dom_check(Arg_head2,Arg_body2),
	write('-->'),
	nh_write_b(NH_A).

nh_supmagic2(A,R_num,B_num,B1,(B2,B3),Sup_P):-
	write((Sup_P)),
	write(','),
	nh_write_b(B1),
	Sup_P=..[_|Arg_S],
	B1=..[_|Arg_B1],
	B2=..[Pred_B2|Arg_B2],
	or_var(Arg_S,Arg_B1,Arg_body),
	rec_magic_arg(Pred_B2,Arg_B2,Arg_head),
	or1_var([],Arg_head,Arg_headvar),
	dom_check(Arg_headvar,Arg_body),
	write('-->'),
	nh_magic_w(B2),
	write(','),
	N_B is B_num + 1,
	append_atom('supmagic_',R_num,S_P1),
	append_atom(S_P1,'_',S_P2),
	append_atom(S_P2,N_B,S_P),
	Sup_P2=..[S_P|Arg_body],
	write((Sup_P2)),
	write('.'),nl,
 	nh_supmagic2(A,R_num,N_B,B2,B3,Sup_P2).

nh_supmagic2(A,R_num,B_num,B1,B2,Sup_P):-
	write((Sup_P)),
	write(','),
	nh_write_b(B1),
	Sup_P=..[_|Arg_S],
	B1=..[_|Arg_B1],
	B2=..[Pred_B2|Arg_B2],
	rec_magic_arg(Pred_B2,Arg_B2,Arg_head),
	or1_var([],Arg_head,Arg_headvar),
	or_var(Arg_S,Arg_B1,Arg_body),
	dom_check(Arg_headvar,Arg_body),
	write('-->'),
	nh_magic_w(B2),
	write(','),
	N_B is B_num + 1,
	append_atom('supmagic_',R_num,S_P1),
	append_atom(S_P1,'_',S_P2),
	append_atom(S_P2,N_B,S_P),
	Sup_P2=..[S_P|Arg_body],
	write((Sup_P2)),
	write('.'),nl,
	write((Sup_P2)),
	write(','),
	or_var(Arg_body,Arg_B2,Arg_body2),
	get_arg(A,[],Arg_head2),
	nh_write_b(B2),
	dom_check(Arg_head2,Arg_body2),
	write('-->'),
	nh_write_b(A).

mg_chk_hd((A1;A2)) :- 
	atom(A1),
	true;
	A1=..[Pred|_],
	(magic_list(PQ1,_),
	 member(Pred,PQ1),!,
	 true;
	    !,mg_chk_hd(A2)
	).
mg_chk_hd((A1,A2)) :- 
	atom(A1),
	true;
	A1=..[Pred|_],
	(magic_list(PQ1,_),
	 member(Pred,PQ1),!,
	 true;
	    !,mg_chk_hd(A2)
	).
mg_chk_hd(A) :- 
	atom(A),
	true;
	A=..[Pred|_],
	(magic_list(PQ1,_),
	 member(Pred,PQ1),!,
	 true;
	    !,fail
	).

ent_head((A;B)) :-
	A=..[Pred|Arg],	
	head_list(Head,Arity),
	(member(Pred,Head),!;
	    count_list(Arg,0,Cnt),
	    append2(Head,[Pred],New1),
	    append2(Arity,[Cnt],New2),
	    retract((head_list(_,_))),
	    assert((head_list(New1,New2)))
	),
	ent_head(B).
ent_head((A,B)) :-
	A=..[Pred|Arg],	
	head_list(Head,Arity),
	(member(Pred,Head),!;
	    count_list(Arg,0,Cnt),
	    append2(Head,[Pred],New1),
	    append2(Arity,[Cnt],New2),
	    retract((head_list(_,_))),
	    assert((head_list(New1,New2)))
	),
	ent_head(B).
ent_head(A) :-
	A=..[Pred|Arg],
	head_list(Head,Arity),
	(member(Pred,Head),!;
	    count_list(Arg,0,Cnt),
	    append2(Head,[Pred],New1),
	    append2(Arity,[Cnt],New2),
	    retract((head_list(_,_))),
	    assert((head_list(New1,New2)))
	).
ent_body((A,B)) :-
	A=..[Pred|_],	
	body_list(Body),
	(member(Pred,Body),!;
	    append2(Body,[Pred],New),
	    retract((body_list(_))),
	    assert((body_list(New)))
	),
	ent_body(B).
ent_body(A) :-
	A=..[Pred|_],	
	body_list(Body),
	(member(Pred,Body),!;
	    append2(Body,[Pred],New),
	    retract((body_list(_))),
	    assert((body_list(New)))
	).
ent_head_magic :-
	read(Z),numbervars(Z,0,_),
	(Z==end_of_file,!;
	    Z=(B-->A),!,
	    (B=='true',!,ent_head_m(A);
		(A=='false',!;ent_head_m(A))
	    ),
	    ent_head_magic;
	    Z=(A),ent_head_m(A),ent_head_magic
	).
		
ent_head_m((A;B)) :-
	A=..[Pred|Arg],	
	head_list_m(Head,Arity),
	(member(Pred,Head),!;
	    count_list(Arg,0,Cnt),
	    append2(Head,[Pred],New1),
	    append2(Arity,[Cnt],New2),
	    retract((head_list_m(_,_))),
	    assert((head_list_m(New1,New2)))
	),
	ent_head_m(B).
ent_head_m((A,B)) :-
	A=..[Pred|Arg],	
	head_list_m(Head,Arity),
	(member(Pred,Head),!;
	    count_list(Arg,0,Cnt),
	    append2(Head,[Pred],New1),
	    append2(Arity,[Cnt],New2),
	    retract((head_list_m(_,_))),
	    assert((head_list_m(New1,New2)))
	),
	ent_head_m(B).
ent_head_m(A) :-
	A=..[Pred|Arg],
	head_list_m(Head,Arity),
	(member(Pred,Head),!;
	    count_list(Arg,0,Cnt),
	    append2(Head,[Pred],New1),
	    append2(Arity,[Cnt],New2),
	    retract((head_list_m(_,_))),
	    assert((head_list_m(New1,New2)))
	).

ent_head_magic2 :-
	read(Z),numbervars(Z,0,_),
	(Z==end_of_file,!;
	    Z=(B-->A),!,
	    (B=='true',!,ent_head_m2(A);
		(A=='false',!;ent_head_m2(A))
	    ),
	    ent_head_magic2;
	    Z=(A),ent_head_m2(A),ent_head_magic2
	).
		
ent_head_m2((A;B)) :-
	A=..[Pred|Arg],	
	head_list_m2(Head,Arity),
	(member(Pred,Head),!;
	    count_list(Arg,0,Cnt),
	    append2(Head,[Pred],New1),
	    append2(Arity,[Cnt],New2),
	    retract((head_list_m2(_,_))),
	    assert((head_list_m2(New1,New2)))
	),
	ent_head_m2(B).
ent_head_m2((A,B)) :-
	A=..[Pred|Arg],	
	head_list_m2(Head,Arity),
	(member(Pred,Head),!;
	    count_list(Arg,0,Cnt),
	    append2(Head,[Pred],New1),
	    append2(Arity,[Cnt],New2),
	    retract((head_list_m2(_,_))),
	    assert((head_list_m2(New1,New2)))
	),
	ent_head_m2(B).
ent_head_m2(A) :-
	A=..[Pred|Arg],
	head_list_m2(Head,Arity),
	(member(Pred,Head),!;
	    count_list(Arg,0,Cnt),
	    append2(Head,[Pred],New1),
	    append2(Arity,[Cnt],New2),
	    retract((head_list_m2(_,_))),
	    assert((head_list_m2(New1,New2)))
	).

mgtp2enhm(Kind,InFile,OutFile) :- 
	initial,
        can_file_open_msg(read,InFile,[mgtp],S1),
        can_file_open_msg(write,'temp/cost_kliteral',[tmp],CK),
        see(S1),tell(CK),cp_file_ck2,seen,told,
        can_file_open_msg(write,'temp/source',[tmp],S),
	see(S1),tell(S),cp_file_no_ck2,seen,told,
        can_file_open_msg(read,'temp/source',[tmp],S),
	see(S),ent_domlist,seen,
        can_file_open_msg(write,'temp/false_f',[tmp],False_f),
	see(S),tell(False_f),file_dist_f,seen,told,
        can_file_open_msg(write,'temp/true_f',[tmp],True_f),
	see(S),tell(True_f),file_dist_t,seen,told,
        can_file_open_msg(write,'temp/ft_rest',[tmp],Ft_rest),
	see(S),tell(Ft_rest),file_dist_rest,seen,told,
        can_file_open_msg(read,'temp/ft_rest',[tmp],Ft_rest),
        can_file_open_msg(write,'temp/rest_hd',[tmp],Rest_hd),
	see(Ft_rest),tell(Rest_hd),hd_adrn_ftr(0,Chk),seen,told,
	(Chk=\=0, !,hd_adrn_ftr_c(Chk) ; true),
	retract((ab_check(_))),
	assert((ab_check('ab_not_occur'))),
        can_file_open_msg(write,'temp/ft_rest_fin_hd',[tmp],Ft_rest_fin_hd),
	see(Ft_rest),tell(Ft_rest_fin_hd),adrn_ftr(Chk2),seen,told,
	(Chk2=='end',! ; adrn_ftr_c),
	retract((ad_ptn(_))),
	assert((ad_ptn([]))),
        can_file_open_msg(read,'temp/false_f',[tmp],False_f),
        can_file_open_msg(read,'temp/true_f',[tmp],True_f),
        can_file_open_msg(write,'temp/true_f_fin_hd',[tmp],True_f_fin_hd),
	see(True_f),tell(True_f_fin_hd),adrn_tf,seen,told,
        can_file_open_msg(write,InFile,[ad],T_S),
        can_file_open_msg(read,'temp/true_f_fin_hd',[tmp],True_f_fin_hd),
        can_file_open_msg(read,'temp/ft_rest_fin_hd',[tmp],Ft_rest_fin_hd),
	see(False_f),tell(T_S),cp_file,seen,
        see(True_f_fin_hd),           cp_file,seen,
	see(Ft_rest_fin_hd),          cp_file,seen,told,
  	magic_list(A,_),
	(A==[],!,
         if(Kind='df', 
   	   (can_file_open_msg(write,OutFile,[mgtp],M_S),
            can_file_open_msg(read,InFile,[ad],T_S),
            can_file_open_msg(read,'temp/cost_kliteral',[tmp],CK),
	    see(T_S),tell(M_S),enh_supmagic(1),seen,see(CK),cp_file,seen,told,
	    write('magic adorned'),nl
           ),
           (can_file_open_msg(write,OutFile,[mgtp],M_S2),
            can_file_open_msg(read,InFile,[ad],T_S),
            can_file_open_msg(read,'temp/cost_kliteral',[tmp],CK),
  	    see(T_S),tell(M_S2),enh_magic,seen,see(CK),cp_file,seen,told,
	    write('magic adorned'),nl
           )
         );
         if(Kind='df',
           (can_file_open_msg(write,OutFile,[mgtp],Sup_S),
            can_file_open_msg(read,'temp/cost_kliteral',[tmp],CK),
            can_file_open_msg(read,InFile,[ad],T_S),
            can_file_open_msg(write,'temp/temp',[tmp],Temp),
	    see(T_S),tell(Temp),enh_supmagic(1),seen,told,
            can_file_open_msg(read,'temp/temp',[tmp],Temp),
	    see(Temp),ent_head_magic,seen,
	    dom_c(F1),
	    (F1=='dom_occur',!,
	     see(CK),tell(Sup_S),cp_file,seen,dom_write,
             see(Temp),cp_file,seen,told,
	     write('supmagic adorned'),nl,
	     write('magic program dom occured'),nl,
	     retract((dom_c(_))),
	     assert((dom_c('dom_not_occur')));
		see(CK),tell(Sup_S),cp_file,seen,see(Temp),cp_file,seen,told,
		write('supmagic adorned'),nl,
		write('magic program dom NOT occured'),nl
	    )
           ),
           (can_file_open_msg(write,OutFile,[mgtp],Sup_S2),
            can_file_open_msg(read,'temp/cost_kliteral',[tmp],CK),
            can_file_open_msg(read,InFile,[ad],T_S),
            can_file_open_msg(write,'temp/temp2',[tmp],Temp2),
	    see(T_S),tell(Temp2),enh_magic,seen,told,
            can_file_open_msg(read,'temp/temp2',[tmp],Temp2),
	    see(Temp2),ent_head_magic2,seen,
	    dom_c(F1b),
	    (F1b=='dom_occur',!,
	     see(CK),tell(Sup_S2),cp_file,seen,dom_write,
             see(Temp2),cp_file,seen,told,
	     write('supmagic2 adorned'),nl,
	     write('magic2 program dom occured'),nl,
	     retract((dom_c(_))),
	     assert((dom_c('dom_not_occur')));
		see(CK),tell(Sup_S2),cp_file,seen,see(Temp2),cp_file,seen,told,
		write('supmagic2 adorned'),nl,
		write('magic2 program dom NOT occured'),nl
	    ))
           ),
            can_file_open_msg(read,InFile,[ad],T_S),
            can_file_open_msg(write,'temp/temp',[tmp],Temp),
	    see(T_S),tell(Temp),dom_tg_ent,seen,told,
	    dom_c(F2),
	    (F2=='dom_occur',!,
             can_file_open_msg(write,InFile,[ad],T_S),
             can_file_open_msg(read,'temp/temp',[tmp],Temp),
	     see(Temp),tell(T_S),dom_write1,cp_file,dom_write2,seen,told,
	     write('adorned program dom occured'),nl,
	     retract((dom_c(_))),
	     assert((dom_c('dom_not_occur')));
                can_file_open_msg(write,InFile,[ad],T_S),
                can_file_open_msg(read,'temp/temp',[tmp],Temp),
		see(Temp),tell(T_S),cp_file,seen,told,
		write('adorned program dom NOT occured'),nl
	    )
	),refresh.

ent_domlist :-
	read(Z),numbervars(Z,0,_),
	(Z==end_of_file,!;
	    Z=(B-->A),
	    (A=='false',!;
		ent_dlist(A)
	    ),
	    (B=='true',!;
		ent_dlist(B)
	    ),
	    ent_domlist;
	    Z=(_:(A)),!,
%
% $@%4!<%k$N5-21(J
%
            assert(goaldf([A])),
            assert(goalbf([A])),
	    ent_dlist(A),
	    ent_domlist;
	    Z=(A),
	    ent_dlist(A),
	    ent_domlist
	).

%
% $@3HD%I}M%@h%^%8%C%/%;%C%HJQ49(J
%
enh_magic :-
	read(Z),numbervars(Z,0,_),
	(Z==end_of_file,!;
	    Z=(_:(A)),!,
	    get_suparg(A,[],Arg_head),
	    dom_check_t(Arg_head),
	    write('-->'),
	    nh_magic_w(A),
	    write('.'),nl,
	    enh_magic;
	    Z=(B-->A),!,           
%
% true --> A.
%
	    (B=='true',!,
	     get_arg(A,[],Arg_head),
	     get_suparg(A,[],Arg_body),
	     nh_magic_w(A),
             if(retract(goalbf(Goal)),
               (write(',{goalset('),
                write((Goal)),
                write(',1)}')),
               true),
	     dom_check(Arg_head,Arg_body),
	     write('-->'),
	     nh_write_b(A),
	     write('.'),nl,enh_magic;
%
% B --> A.
%
                 count_dis(A,[],A1),
                 enh_magic1_1(A1,B),
                 enh_magic1_2(A1,A1,B),
 		 enh_magic);
%
%  A. 
%
	    Z=(A),
	    get_arg(A,[],Arg_head),
	    get_suparg(A,[],Arg_body),
	    nh_magic_w(A),
	    dom_check(Arg_head,Arg_body),
	    write('-->'),
	    nh_write_b(A),
	    write('.'),nl,
	    enh_magic
	).


enh_magic1_1([],_).

enh_magic1_1([X|Rem],B) :- !,
	nh_magic_w(X),
        write('-->'),
        nh_magic_w(B),
        write('.'),nl,
        enh_magic1_1(Rem,B).
       
enh_magic1_2([],_,_).

enh_magic1_2([X|Rem],A1,B) :- !,
	nh_magic_w(X),
        write(','),
        nh_write_b(B),
        write('-->'),
        nh_write_b(X),
        dis_sort_w(X,A1),
        write('.'),nl,
        enh_magic1_2(Rem,A1,B).

dis_sort_w(_,[]).

dis_sort_w(X,[X1|Rem]) :- !,
   if(X=X1,true,
           (write(';'),
            nh_write_b(X1))),
   dis_sort_w(X,Rem).

count_dis((B;Brem),BB,BB1) :- !,
        append2(BB,[B],BB2),
        count_dis(Brem,BB2,BB1). 

count_dis((B),BB,BB1) :-!,
	append2(BB,[B],BB1).

%
% $@3HD%?<$5M%@h%N%s%[!<%s!&%^%8%C%/%;%C%HJQ49(J
%
enh_supmagic(R_num) :-
	read(Z),numbervars(Z,0,_),
	(Z==end_of_file,!;
	    Z=(_:(A)),!,
	    get_suparg(A,[],Arg_head),
	    dom_check_t(Arg_head),
	    write('-->'),
	    nh_magic_w(A),
	    write('.'),nl,
	    Next is R_num + 1,
	    enh_supmagic(Next);
	    Z=(B-->A),!,           
	    (B=='true',!,
	     get_suparg(A,[],Arg_body),
	     get_arg(A,[],Arg_head),
	     nh_magic_w(A),
	     dom_check(Arg_head,Arg_body),
             if(retract(goaldf(Goal)),
               (write(',{goalset('),
                write((Goal)),
                write(',1)}')),
               true),
	     write('-->'),
	     nh_write_b(A),
	     write('.'),nl,
	     Next is R_num + 1,
	     enh_supmagic(Next);
		enh_supmagic_pre(R_num,1,A,B,A),
		write('.'),nl,
		Next is R_num + 1,
		enh_supmagic(Next));
	    Z=(A),
	    get_suparg(A,[],Arg_body),
	    get_arg(A,[],Arg_head),
	    nh_magic_w(A),
	    dom_check(Arg_head,Arg_body),
	    write('-->'),
	    nh_write_b(A),
	    write('.'),nl,
	    Next is R_num + 1,
	    enh_supmagic(Next)
	).

enh_supmagic_pre(R_num,B_num,(A1;A2),(B1,B2),A) :-
	get_suparg(A1,[],Arg_body),
	B1=..[Pred_B1|Arg_B1],
	rec_magic_arg(Pred_B1,Arg_B1,Arg_head),
	or1_var([],Arg_head,Arg_headvar),
	dom_check(Arg_headvar,Arg_body),
        nh_magic_w(A1),
        write('-->'),
        nh_magic_w(B1),
	write(','),
	append_atom('supmagic_',R_num,S_P1),
	append_atom(S_P1,'_',S_P2),
	append_atom(S_P2,B_num,S_P),
	Sup_P=..[S_P|Arg_body],
	write((Sup_P)),
	write('.'),nl,
        enh_supmagic_pre(R_num,B_num,A2,(B1,B2),A).        

enh_supmagic_pre(R_num,B_num,(A1;A2),B1,A) :-
	get_suparg(A1,[],Arg_body),
	B1=..[Pred_B1|Arg_B1],
	rec_magic_arg(Pred_B1,Arg_B1,Arg_head),
	or1_var([],Arg_head,Arg_headvar),
	dom_check(Arg_headvar,Arg_body),
        nh_magic_w(A1),
        write('-->'),
        nh_magic_w(B1),
	write(','),
	append_atom('supmagic_',R_num,S_P1),
	append_atom(S_P1,'_',S_P2),
	append_atom(S_P2,B_num,S_P),
	Sup_P=..[S_P|Arg_body],
	write((Sup_P)),
	write('.'),nl,        
        enh_supmagic_pre(R_num,B_num,A2,B1,A).        

enh_supmagic_pre(R_num,B_num,A1,(B1,B2),A) :-
	get_suparg(A1,[],Arg_body),
	B1=..[Pred_B1|Arg_B1],
	rec_magic_arg(Pred_B1,Arg_B1,Arg_head),
	or1_var([],Arg_head,Arg_headvar),
	dom_check(Arg_headvar,Arg_body),
        nh_magic_w(A1),
        write('-->'),
        nh_magic_w(B1),
	write(','),
	append_atom('supmagic_',R_num,S_P1),
	append_atom(S_P1,'_',S_P2),
	append_atom(S_P2,B_num,S_P),
	Sup_P=..[S_P|Arg_body],
	write((Sup_P)),
	write('.'),nl,
	enh_supmagic2(A,R_num,B_num,B1,B2,Sup_P).

enh_supmagic_pre(R_num,B_num,A1,B1,A) :-
	get_suparg(A1,[],Arg_body),
	B1=..[Pred_B1|Arg_B1],
	rec_magic_arg(Pred_B1,Arg_B1,Arg_head),
	or1_var([],Arg_head,Arg_headvar),
	dom_check(Arg_headvar,Arg_body),
        nh_magic_w(A1),
        write('-->'),
        nh_magic_w(B1),
	write(','),
	append_atom('supmagic_',R_num,S_P1),
	append_atom(S_P1,'_',S_P2),
	append_atom(S_P2,B_num,S_P),
	Sup_P=..[S_P|Arg_body],
	write((Sup_P)),
	write('.'),nl,
	write((Sup_P)),
	write(','),
	nh_write_b(B1),
	or_var(Arg_body,Arg_B1,Arg_body2),
	get_arg(A,[],Arg_head2),
	dom_check(Arg_head2,Arg_body2),
	write('-->'),
	nh_write_b(A).

enh_supmagic2(A,R_num,B_num,B1,(B2,B3),Sup_P):-
	write((Sup_P)),
	write(','),
	nh_write_b(B1),
	Sup_P=..[_|Arg_S],
	B1=..[_|Arg_B1],
	B2=..[Pred_B2|Arg_B2],
	or_var(Arg_S,Arg_B1,Arg_body),
	rec_magic_arg(Pred_B2,Arg_B2,Arg_head),
	or1_var([],Arg_head,Arg_headvar),
	dom_check(Arg_headvar,Arg_body),
	write('-->'),
	nh_magic_w(B2),
	write(','),
	N_B is B_num + 1,
	append_atom('supmagic_',R_num,S_P1),
	append_atom(S_P1,'_',S_P2),
	append_atom(S_P2,N_B,S_P),
	Sup_P2=..[S_P|Arg_body],
	write((Sup_P2)),
	write('.'),nl,
 	enh_supmagic2(A,R_num,N_B,B2,B3,Sup_P2).

enh_supmagic2(A,R_num,B_num,B1,B2,Sup_P):-
	write((Sup_P)),
	write(','),
	nh_write_b(B1),
	Sup_P=..[_|Arg_S],
	B1=..[_|Arg_B1],
	B2=..[Pred_B2|Arg_B2],
	rec_magic_arg(Pred_B2,Arg_B2,Arg_head),
	or1_var([],Arg_head,Arg_headvar),
	or_var(Arg_S,Arg_B1,Arg_body),
	dom_check(Arg_headvar,Arg_body),
	write('-->'),
	nh_magic_w(B2),
	write(','),
	N_B is B_num + 1,
	append_atom('supmagic_',R_num,S_P1),
	append_atom(S_P1,'_',S_P2),
	append_atom(S_P2,N_B,S_P),
	Sup_P2=..[S_P|Arg_body],
	write((Sup_P2)),
	write('.'),nl,
	write((Sup_P2)),
	write(','),
	or_var(Arg_body,Arg_B2,Arg_body2),
	get_arg(A,[],Arg_head2),
	nh_write_b(B2),
	dom_check(Arg_head2,Arg_body2),
	write('-->'),
	nh_write_b(A).

