% Copyright (C) 1998  Katsumi Inoue
%
%%% idmodel.pl %%%
%
% Best-First Iterative-Deepening MGTP  ('97.12.29) Complete Version 2.31
%  
% 
%
%% (C)1992 Institute for New Generation Computer Technology

do(Md) :- do(Md,default).
do1(Md) :- do(Md,one).
do1(Md,Depth) :- do(Md,one,Depth).

do(Md,default) :- model(M), flis(FLIS), lis(LIS), disjU(DisjU), disjO(DisjO),
	header(M, FLIS,LIS, DisjU,DisjO, _,Md,1,1,default) -> Md='unsat';Md='sat'.
do(Md,one) :- model(M), flis(FLIS), lis(LIS), disjU(DisjU), disjO(DisjO),
	header(M, FLIS,LIS, DisjU,DisjO, _,MD,1,0,one),
	do_result(MD),
	result(MD,Md).

do(Md,one,Depth) :- model(M), flis(FLIS), lis(LIS), disjU(DisjU), disjO(DisjO),
	header(M, FLIS,LIS, DisjU,DisjO, _,MD,Depth,0,one),
	do_result(MD),
	result(MD,Md).


header(M,FLIS,LIS,DisjU,DisjO, _,Md,TH,CD,Mode) :- 
      header2(M,FLIS,LIS,DisjU,DisjO, _,Md,TH,CD,Mode,Status),
      (var(Status) -> true ;
	    (NextTH is TH + 1,
	     header(M,FLIS,LIS,DisjU,DisjO, _,Md,NextTH,0,Mode))).

header2(_,_,_,[],[],NewMd,Md,TH,CD,Mode,Status) :-
        (CD > TH -> (var(Status) -> Status = undecide;true);
                    do(_,_,_,[],[],NewMd,Md,TH,CD,Mode,_)).

header2(M,FLIS,LIS,DisjU,DisjO, _,Md,TH,CD,Mode,Status) :-
        (CD > TH -> (var(Status) -> Status = undecide;true);
	    do(M,FLIS,LIS,DisjU,DisjO, _,Md,TH,CD,Mode,Status)). 

result(MD,Md) :- MD = [_,Md].
result([],'No more models').

% delete variable of list (fainally mgtp result)
do_result([]).
do_result([_|L]) :- do_result(L).

% List of models
add_model_list(_,_,default) :- !,false.
add_model_list(New,[one,New],one).

model_list(New,[M1|M2]) :-
	(var(M1) -> M1 = New;
	            equal_list(M1,New) ->true;model_list(New,M2)).

model_check(NewMd) :- !,
      if(retract(setgoal(A,X)),
                (if(model_check1(NewMd,A,X),
                                 assert(setgoal(A,X)),
                                 (assert(setgoal(A,X)),fail))),
                true), 
      if(retract(setver(A1,X1)),
                (if(model_check1(NewMd,A1,X1),
                                 assert(setver(A1,X1)),
                                 (assert(setver(A1,X1)),fail))),
                true), 
      if(retract(mlist(Mlist)),true,Mlist=[]),
      if(member(NewMd,Mlist),(asserta(mlist(Mlist)),fail),
                              (append([NewMd],Mlist,Mlist2),
                               asserta(mlist(Mlist2)))). 

model_check1(NewMd,A,X) :- !,
  model_check2(NewMd,A,X).


model_check2(_,[],_).

model_check2(NewMd,[A|Rem],X) :- !,
     count_atom(A,NewMd,0,Count),
     X=Count,
     model_check2(NewMd,Rem,X).

count_atom(_,[],C,C). 
count_atom(A,[X|Rem],C,C1) :- !,
     copy_term(A,A1),
     if(A1=X,C2 is C+1,C2=C),
     count_atom(A,Rem,C2,C1).

set(A,X) :- 
  if(retract(setver(_,_)),assert(setver(A,X)),
                          assert(setver(A,X))).
goalset(A,X) :-
  if(retract(setgoal(_,_)),assert(setgoal(A,X)),
                          assert(setgoal(A,X))).
  
%
%   do(+CurrentModel,
%        +LiteralInstanceStacksForFalseClauses,+LiteralInstanceStacksForOthers,
%        +DisjunctivesUnique,+DisjunctivesOther)
%%
do(_,_,_,[],[], NewMd,Md,TH,CD,one,_) :-
	(CD > TH -> true ;
                    (model_check(NewMd) -> add_model_list(NewMd,Md,one) ; true)).
do(_,_,_,[],[], _,_,_,_,one,_).
do(_,_,_,[],[], NewMd,Md,_,_,N,_) :- !,
	add_model_list(NewMd,Md,N).
do(M, FLIS,LIS, DisjU,DisjO, _,Md,TH,CD,N,Status) :-
	do(M, FLIS,LIS, DisjU,DisjO, Md,TH,CD,N,Status).

do(M, FLIS,LIS, [P|DisjU],DisjO, Md,TH,CD,N,Status) :- !,
    (member(P,M) -> do(M, FLIS,LIS, DisjU,DisjO, M,Md,TH,CD,N,Status);
	do1(M,P, FLIS,LIS, DisjU,DisjO, Md,TH,CD,N,Status)).
do(M, FLIS,LIS, [],[Dis|DisjO],  Md,TH,CD,N,Status) :-  !,
    (checkConsq(Dis,NDis, M) -> 
        expand(NDis, M, FLIS,LIS, DisjO, Md,TH,CD,N,Status);
	do(M, FLIS,LIS, [],DisjO, M,Md,TH,CD,N,Status)).

do1(M,P, FLIS,LIS, DisjU,DisjO, Md,TH,CD,N,Status) :-
	do0([P|M],[P], FLIS,LIS, DisjU,DisjO, Md,TH,CD,N,Status).

do0(M,DM, FLIS,LIS, DisjU,DisjO, Md,TH,CD,N,Status) :-
    satisfyClauses(M,DM, FLIS,NFLIS, [],False, _,_),
    do0Decide(False, M,DM, NFLIS,LIS, DisjU,DisjO, Md,TH,CD,N,Status).

do0Decide([], M,DM, FLIS,LIS, DisjU,DisjO, Md,TH,CD,N,Status) :- !,
    satisfyClauses(M,DM, LIS,NLIS, DisjU,NDisjU, DisjO,NDisjO),
    NextCD is CD +1,
    header2(M, FLIS,NLIS, NDisjU,NDisjO, M,Md,TH,NextCD,N,Status).

do0Decide(_, _,_, _,_, _,_, _,_, _,_, _). % False \= []

do2(M,P, FLIS,LIS, DisjU,DisjO, Md,TH,CD,N,Status) :- 
	append(P,M, PM),
	do0(PM,P, FLIS,LIS, DisjU,DisjO, Md,TH,CD,N,Status).

expand(_, _, _,_, _, Md, _,_,one, _) :- \+var(Md),Md = [one|_],!.
expand([], _, _,_, _, _, _,_, _,_) :- !.
expand([P|Ps], M, FLIS,LIS, DisjO, Md,TH,CD,N,Status) :-  
    do2(M,P, FLIS,LIS, [],DisjO, Md,TH,CD,N,Status),
    expand(Ps, M, FLIS,LIS, DisjO ,Md,TH,CD,N,Status).

satisfyClauses(M,DM, [lis(I,LiS)|LIS],[lis(I,NLiS)|NLIS1], Si,So, Di,Do) :- !,
    satisfyClause(I,LiS,NLiS, M,DM, Si,Sm, Di,Dm),
    satisfyClauses(M,DM, LIS,NLIS1, Sm,So, Dm,Do).
satisfyClauses(_,_, [],[], Si,Si, Di,Di).

satisfyClause(ID,LiS,NLiS, M,[PAT|DM], Si,So, Di,Do) :- !,
	satisfyClause1(ID,LiS,LiS1, M,PAT, Si,Sm, Di,Dm),
	satisfyClause(ID,LiS1,NLiS, M,DM, Sm,So, Dm,Do).
satisfyClause(_,LiS,LiS, _,[], Si,Si, Di,Di).

satisfyClause1(ID,LiS,NLiS, M,PAT, Si,So, Di,Do) :- pc(ID,PAT), !,
	satisfyAnte(ID,LiS,NLiS, M,[PAT], [[]],[], Si,So, Di,Do).
satisfyClause1(_,LiS,LiS, _,_, Si,Si, Di,Di).

satisfyAnte(ID,[],[], M,DM, Stack,DStack, Si,So, Di,Do) :- !,
    satisfyLiteral(ID, M,DM, Stack,DStack, Si,So, Di,Do).
satisfyAnte(ID,[S|LiS],[NS|NLiS1], M,DM, Stack,DStack, Si,So, Di,Do) :- 
    satisfyLiteral(ID, M,DM, Stack,DStack, S,NS, [],DS),
    satisfyAnte(ID,LiS,NLiS1, M,DM, S,DS, Si,So, Di,Do).

%
%   satisfyLiteral(+ClauseID, +WholeModel,+DifferentialOfModel,
%           +PreviousStack,+DifferentialOfPreviousStack,
%           +CurrentStack,-CurrentStack,
%           +DifferentialOfCurrentStack,-DifferentialOfCurrentStack)
%
satisfyLiteral(ID, M,DM, Stack,[S|DStack], Si,So, Di,Do) :- !,
    satisfyLiteral(ID, M,S, Si,Sm, Di,Dm),
    satisfyLiteral(ID, M,DM, Stack,DStack, Sm,So, Dm,Do).
satisfyLiteral(ID, M,DM, [S|Stack],DStack, Si,So, Di,Do) :- !,
    satisfyLiteral(ID, DM,S, Si,Sm, Di,Dm),
    satisfyLiteral(ID, M,DM, Stack,DStack, Sm,So, Dm,Do).
satisfyLiteral(_, _,_, [],[], Si,Si, Di,Di).

satisfyLiteral(ID, [P|Ps],S, Si,So, Di,Do) :- !,
    c(ID, [P|S], Si,Sm, Di,Dm),
    satisfyLiteral(ID, Ps,S, Sm,So, Dm,Do).
satisfyLiteral(_, [],_, Si,Si, Di,Di).

checkConsq([],[], _).
checkConsq([X|Xs],Ys, M) :- checkConsq1(X,M, 0,Y,Y, Xs,Ys).

checkConsq1([],M, 1,H,[], Xs,[H|Ys]) :- checkConsq(Xs,Ys, M).
checkConsq1([A|X],M, S,H,T, Xs,Ys) :- 
	(member(A,M) -> checkConsq1(X,M, S,H,T, Xs,Ys);
	    T = [A|T1],	checkConsq1(X,M, 1,H,T1, Xs,Ys)).


