% Copyright (C) 1998  Katsumi Inoue
%
%%% bfmodel.pl %%%
%
% Best-First Iterative-Deepening MGTP  ('97.12.29) Complete Version 2.31
%  
% 
%
%% (C)1992 Institute for New Generation Computer Technology

do(Md) :- do(Md,default).
do1(Md) :- do(Md,one).

do(Md,default) :- model(M), flis(FLIS), lis(LIS), disjU(DisjU), disjO(DisjO),
	header(M, FLIS,LIS, DisjU,DisjO, _,Md,1,1,default) -> Md='unsat';Md='sat'.
do(Md,one) :- model(M), flis(FLIS), lis(LIS), disjU(DisjU), disjO(DisjO),
	header(M, FLIS,LIS, DisjU,DisjO, _,MD,0,0,one),
	do_result(MD),
	result(MD,Md).

header(M,FLIS,LIS,DisjU,DisjO, _,Md,TH,TC,Mode) :- 
      header2(M,FLIS,LIS,DisjU,DisjO, _,Md,TH,TC,Mode,Status),
      (var(Status) -> true ;
	    (retract(min_child(NextTH)),
	     header(M,FLIS,LIS,DisjU,DisjO, _,Md,NextTH,0,Mode))).

header2(_,_,_,[],[],NewMd,Md,TH,TC,Mode,Status) :-
        (TC > TH -> (var(Status) -> (Status = undecide,
                                     new_min_child(TC));
                                     renew_min_child(TC));
                    do(_,_,_,[],[],NewMd,Md,TH,TC,Mode,_)).

header2(M,FLIS,LIS,DisjU,DisjO, _,Md,TH,TC,Mode,Status) :-
        (TC > TH -> (var(Status) -> (Status = undecide,
                                     new_min_child(TC));
                                     renew_min_child(TC));
	    do(M,FLIS,LIS,DisjU,DisjO, _,Md,TH,TC,Mode,Status)). 

new_min_child(TC):- !,
       assert(min_child(TC)). 

renew_min_child(TC):- !,
         if(retract(min_child(CurTH)),(TC < CurTH -> NewTH2 = TC ;
                                                     NewTH2 = CurTH ),
                                       NewTH2 = TC), 
         assert(min_child(NewTH2)).

result(MD,Md) :- MD = [_,Md].
result([],'No more models').

% delete variable of list (fainally mgtp result)
do_result([]).
do_result([_|L]) :- do_result(L).

% List of models
add_model_list(_,_,default) :- !,false.
add_model_list(New,[one,New],one).

model_list(New,[M1|M2]) :-
	(var(M1) -> M1 = New;
	            equal_list(M1,New) ->true;model_list(New,M2)).

model_check(NewMd,NewMd2,TC) :- !,
      if(retract(setgoal(A,X)),
                (if(model_check1(NewMd,A,X),
                                 assert(setgoal(A,X)),
                                 (assert(setgoal(A,X)),fail))),
                true), 
      if(retract(setver(A1,X1)),
                (if(model_check1(NewMd,A1,X1),
                                 assert(setver(A1,X1)),
                                 (assert(setver(A1,X1)),fail))),
                true), 
      if(retract(mlist(Mlist)),true,Mlist=[]),
      NewMd2 = [TC|NewMd],
      if(member(NewMd2,Mlist),(asserta(mlist(Mlist)),fail),
                              (append([NewMd2],Mlist,Mlist2),
                               asserta(mlist(Mlist2)))). 

model_check1(NewMd,A,X) :- !,
  model_check2(NewMd,A,X).


model_check2(_,[],_).

model_check2(NewMd,[A|Rem],X) :- !,
     count_atom(A,NewMd,0,Count),
     X=Count,
     model_check2(NewMd,Rem,X).

count_atom(_,[],C,C). 
count_atom(A,[X|Rem],C,C1) :- !,
     copy_term(A,A1),
     if(A1=X,C2 is C+1,C2=C),
     count_atom(A,Rem,C2,C1).

set(A,X) :- 
  if(retract(setver(_,_)),assert(setver(A,X)),
                          assert(setver(A,X))).

check(X) :- 
  if(retract(ver(Ver)),if(Ver = X,true,fail),fail).

goalset(A,X) :-
  if(retract(setgoal(_,_)),assert(setgoal(A,X)),
                          assert(setgoal(A,X))).
  


%
%   do(+CurrentModel,
%        +LiteralInstanceStacksForFalseClauses,+LiteralInstanceStacksForOthers,
%        +DisjunctivesUnique,+DisjunctivesOther)
%%
do(_,_,_,[],[], NewMd,Md,TH,TC,one,_) :-
	(TC > TH -> true ;
                    (model_check(NewMd,NewMd2,TC) -> add_model_list(NewMd2,Md,one) ; true)).
do(_,_,_,[],[], _,_,_,_,one,_).
do(_,_,_,[],[], NewMd,Md,_,_,N,_) :- !,
	add_model_list(NewMd,Md,N).
do(M, FLIS,LIS, DisjU,DisjO, _,Md,TH,TC,N,Status) :-
	do(M, FLIS,LIS, DisjU,DisjO, Md,TH,TC,N,Status).

do(M, FLIS,LIS, [P|DisjU],DisjO, Md,TH,TC,N,Status) :- !,
    (member(P,M) -> do(M, FLIS,LIS, DisjU,DisjO, M,Md,TH,TC,N,Status);
	do1(M,P, FLIS,LIS, DisjU,DisjO, Md,TH,TC,N,Status)).
do(M, FLIS,LIS, [],[Dis|DisjO],  Md,TH,TC,N,Status) :-  !,
    (checkConsq(Dis,NDis, M) -> 
        expand(NDis, M, FLIS,LIS, DisjO, Md,TH,TC,N,Status);
	do(M, FLIS,LIS, [],DisjO, M,Md,TH,TC,N,Status)).

do1(M,P, FLIS,LIS, DisjU,DisjO, Md,TH,TC,N,Status) :-
	do0([P|M],[P], FLIS,LIS, DisjU,DisjO, Md,TH,TC,N,Status).

do0(M,DM, FLIS,LIS, DisjU,DisjO, Md,TH,TC,N,Status) :-
    satisfyClauses(M,DM, FLIS,NFLIS, [],False, _,_),
    do0Decide(False, M,DM, NFLIS,LIS, DisjU,DisjO, Md,TH,TC,N,Status).

do0Decide([], M,DM, FLIS,LIS, DisjU,DisjO, Md,TH,TC,N,Status) :- !,
    satisfyClauses(M,DM, LIS,NLIS, DisjU,NDisjU, DisjO,NDisjO),
    if(renew_total_cost(M,TC,NextTC),true,true),
    header2(M, FLIS,NLIS, NDisjU,NDisjO, M,Md,TH,NextTC,N,Status).

do0Decide(_, _,_, _,_, _,_, _,_, _,_, _). % False \= []

do2(M,P, FLIS,LIS, DisjU,DisjO, Md,TH,TC,N,Status) :- 
	append(P,M, PM),
	do0(PM,P, FLIS,LIS, DisjU,DisjO, Md,TH,TC,N,Status).

expand(_, _, _,_, _, Md, _,_,one, _) :- \+var(Md),Md = [one|_],!.
expand([], _, _,_, _, _, _,_, _,_) :- !.
expand([P|Ps], M, FLIS,LIS, DisjO, Md,TH,TC,N,Status) :-  
    do2(M,P, FLIS,LIS, [],DisjO, Md,TH,TC,N,Status),
    expand(Ps, M, FLIS,LIS, DisjO ,Md,TH,TC,N,Status).

renew_total_cost(M,TC,NextTC) :- !,
    [Atom|_] = M,
    if(cost(Atom,NewCost),true,NewCost=0),
    NextTC is TC + NewCost.

%  calc_cost
%  $@%3%9%H$N7W;;$r9T$&!#(J
%  $@$?$@$7!"%3%9%H$,?tCM$GM?$($i$l$F$$$k>l9g$O7W;;$;$:$K=*N;$9$k!#(J
%  $@%3%9%H$,?t<0$GM?$($i$l$F$$$k>l9g!"7W;;$7$?8e%=!<%H$7!"$=$N7k2L$rJV$9!#(J
%
calc_cost([],TC,TC).
calc_cost([X|Rem],TC,TC2) :- !,
    if(cost(X,C),TC1 is TC + C,TC1 = TC),
    calc_cost(Rem,TC1,TC2).

%      (integer(C) -> copy_term([X|Rem],NDis2) ;
%                    ( calc_cost1(C,TC,Cost),
%                      asserta(cost(X,Cost)),
%                      calc_cost(Rem,TC,NDis2))         
%      ) 
%    ),copy_term([X|Rem],NDis2)).
%
%calc_cost1(X '+' Y,TC,Cost) :- 
%    if(X=g,Cost is TC + Y,true).
%calc_cost1(X '-' Y,TC,Cost) :- 
%    if(X=g,Cost is TC - Y,true).
%calc_cost1(X '*' Y,TC,Cost) :- 
%    if(X=g,Cost is TC * Y,true).
%calc_cost1(X '/' Y,TC,Cost) :- 
%    if(X=g,Cost is TC / Y,true).
%calc_cost1(_,_,0).



satisfyClauses(M,DM, [lis(I,LiS)|LIS],[lis(I,NLiS)|NLIS1], Si,So, Di,Do) :- !,
    satisfyClause(I,LiS,NLiS, M,DM, Si,Sm, Di,Dm),
    satisfyClauses(M,DM, LIS,NLIS1, Sm,So, Dm,Do).
satisfyClauses(_,_, [],[], Si,Si, Di,Di).

satisfyClause(ID,LiS,NLiS, M,[PAT|DM], Si,So, Di,Do) :- !,
	satisfyClause1(ID,LiS,LiS1, M,PAT, Si,Sm, Di,Dm),
	satisfyClause(ID,LiS1,NLiS, M,DM, Sm,So, Dm,Do).
satisfyClause(_,LiS,LiS, _,[], Si,Si, Di,Di).

satisfyClause1(ID,LiS,NLiS, M,PAT, Si,So, Di,Do) :- pc(ID,PAT), !,
	satisfyAnte(ID,LiS,NLiS, M,[PAT], [[]],[], Si,So, Di,Do).
satisfyClause1(_,LiS,LiS, _,_, Si,Si, Di,Di).

satisfyAnte(ID,[],[], M,DM, Stack,DStack, Si,So, Di,Do) :- !,
    satisfyLiteral(ID, M,DM, Stack,DStack, Si,So, Di,Do).
satisfyAnte(ID,[S|LiS],[NS|NLiS1], M,DM, Stack,DStack, Si,So, Di,Do) :- 
    satisfyLiteral(ID, M,DM, Stack,DStack, S,NS, [],DS),
    satisfyAnte(ID,LiS,NLiS1, M,DM, S,DS, Si,So, Di,Do).

%
%   satisfyLiteral(+ClauseID, +WholeModel,+DifferentialOfModel,
%           +PreviousStack,+DifferentialOfPreviousStack,
%           +CurrentStack,-CurrentStack,
%           +DifferentialOfCurrentStack,-DifferentialOfCurrentStack)
%
satisfyLiteral(ID, M,DM, Stack,[S|DStack], Si,So, Di,Do) :- !,
    satisfyLiteral(ID, M,S, Si,Sm, Di,Dm),
    satisfyLiteral(ID, M,DM, Stack,DStack, Sm,So, Dm,Do).
satisfyLiteral(ID, M,DM, [S|Stack],DStack, Si,So, Di,Do) :- !,
    satisfyLiteral(ID, DM,S, Si,Sm, Di,Dm),
    satisfyLiteral(ID, M,DM, Stack,DStack, Sm,So, Dm,Do).
satisfyLiteral(_, _,_, [],[], Si,Si, Di,Di).

satisfyLiteral(ID, [P|Ps],S, Si,So, Di,Do) :- !,
    c(ID, [P|S], Si,Sm, Di,Dm),
    satisfyLiteral(ID, Ps,S, Sm,So, Dm,Do).
satisfyLiteral(_, [],_, Si,Si, Di,Di).

checkConsq([],[], _).
checkConsq([X|Xs],Ys, M) :- checkConsq1(X,M, 0,Y,Y, Xs,Ys).

checkConsq1([],M, 1,H,[], Xs,[H|Ys]) :- checkConsq(Xs,Ys, M).
checkConsq1([A|X],M, S,H,T, Xs,Ys) :- 
	(member(A,M) -> checkConsq1(X,M, S,H,T, Xs,Ys);
	    T = [A|T1],	checkConsq1(X,M, 1,H,T1, Xs,Ys)).

