% Copyright (C) 1998  Katsumi Inoue 
%
%%% au.pl %%%
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%						%
%	Utility of Abductive Logic Program      %
%						%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% some goal:G given.
% if Program have model:M satisfying it then return Yes,
% else return No.
%
goalh(G) :-
	retractall(exist(_)),
	assert(exist([])),
	time(_),
	stone(M),
	(\+(M = 'No more answer sets') ->
	 member(G,M),
	(\+ exist(G) -> assert(exist(G));fail),
	 time(T),
	 print_time(T);
	 !,fail).

goalh(G,Depth) :-
	retractall(exist(_)),
	assert(exist([])),
	time(_),
	stone(M,Depth),
	(\+(M = 'No more answer sets') ->
	 member(G,M),
	(\+ exist(G) -> assert(exist(G));fail),
	 time(T),
	 print_time(T);
	 !,fail).


%
% some goal:G given.
% if stable model:M have model:Sm satisfying it then return its model,
% else return no.
%
goal(G,M) :- 
	(var(G) -> fail;true),
	time(_),
	stone(M),
	(\+(M = 'No more answer sets') ->
	 member(G,M),
	 time(T),
	 print_time(T);
	    !,fail).

goal(G,M,Depth) :- 
	(var(G) -> fail;true),
	time(_),
	stone(M,Depth),
	(\+(M = 'No more answer sets') ->
	 member(G,M),
	 time(T),
	 print_time(T);
	    !,fail).

%
% some goal:G given.
% if Program have model:M satisfying it then return Yes,
% else return No.
%
exp(O,Ex) :- 
	retractall(exist2(_,_)),
	assert(exist2([],[])),
	time(_),
	stone(M),
	(\+(M = 'No more answer sets') ->
	 members(O,M),
	 explanation([M],[Ex]),
	(\+ exist2(O,Ex) -> assert(exist2(O,Ex));fail),
	 time(T),
	 print_time(T);
	    !,fail).

%
% some goal:G given.
% if stable model:M have model:Sm satisfying it then return its all models,
% else return empty set.
%
goalall(G) :-
	program(Form),
	stone(M,Form),!,
	\+var(G),
	(in_var(G) -> grand_instance(M,Gi);Gi = [G]),!,
	take(G,Gi),
	in_goal(G,M,Sm,all),
	(Sm = [] -> fail;true),
%	print_set(Sm,satisfy),nl,
	print_set(Sm,answer),nl,
	length(Sm,L),
	print_length(L).

%
% some goal:G given.
% if stable model:M have model:Sm satisfying it then return its all models,
% else return empty set.
%
expall(O,Ex) :-
	retractall(exist(_)),
	assert(exist([])),
	program(Form),
	stone(M,Form),!,
	\+var(O),
	(in_var(O) -> grand_instance(M,Oi);Oi = [O]),!,
	take(O,Oi),
	in_goal(O,M,Sm,all),
	(Sm = [] -> fail;true),
	explanation(Sm,Ex),
	(\+ exist(O) -> assert(exist(O));fail).

min_exp(O,Ex) :-
	retractall(exist1(_)),
	assert(exist1([])),
	expall(O,E),
	min(E,Ex),
	(\+ exist1(O) -> assert(exist1(O));fail).

%
% Minimal Explanation
%  if there is observation in ALP program then
min_exp(Ex) :-
	program(Form),
	stone(Md,Form),
	explanation(Md,G1),
	min(G1,G2),
	none_or_empty(G2,Ex),!.


%
% if goal:G includes variables then return succese
% else return fail.
%
in_var(G) :-
	(var(G);G =.. [_|Para]),
	in_variable(Para).

in_variable([X|_]) :- var(X).
in_variable([X|_]) :- in_var(X).
in_variable([_|L]) :- in_variable(L).


%
% choose goal while goal includes variables
%
take(G,[G|_]).
take(G,[_|L]) :- take(G,L).


%
% make list of grand instance
%
grand_instance([],X) :-
	do_result(X).
grand_instance([M|L],X) :-
	grand_instance1(M,X),
	grand_instance(L,X).

grand_instance1([],_).
grand_instance1([M|L],X) :-
	grand_instance2(M,X),
	grand_instance1(L,X).

grand_instance2(E,[E|_]).
grand_instance2(E,[_|L]) :- grand_instance2(E,L).

%
% some goal:G given.
% if each model of stable model:M satisfied it then return Yes.
% else return No.
%
goaltrue(G) :-
	program(Form),
	stone(M,Form),
	(in_var(G) -> grand_instance(M,Gi);Gi = [G]),!,
	take(G,Gi),
	in_goal(G,M,Sm,all),
	Sm = M.

%
% whether there are models satisfying goal
%
in_goal(G,[M|_],M,one) :-
	in_goal1(G,M).
in_goal(G,[_|L],Sm,one) :-
	in_goal(G,L,Sm,one).

in_goal1(G,[G|_]).
in_goal1(G,[_|L]) :- in_goal1(G,L).

in_goal(_,[],[],all).
in_goal(G,[M|L1],[M|L2],all) :-
	copy_term(G,X),
        in_goal1(X,M),!,
	in_goal(G,L1,L2,all).

in_goal(G,[_|L1],Sm,all) :-
	in_goal(G,L1,Sm,all).

















