% Copyright (C) 1998  Katsumi Inoue 
%
%%% alputy.pl %%%
%
%
% obj_c(Ip) = {obj(Ip) | Ip<-I and Ip is canonical}
% canonical is that model satisfy T-condition
%
obj_c(M,Md) :- !,
	t_condition(M,M1),
	remove_k_literal_all(M1,Md).

%
% T-condition
% Test of whether satisfy T_condition
%
t_condition([],[]).
t_condition([M|L1],[M|L2]) :-
	t_condition_test(M),!,
	t_condition(L1,L2).
t_condition([_|L1],Md) :- t_condition(L1,Md).

% test whether satisfy T-condition
%t_condition_test(M) :- 
%	((member(k(X),M)) ->
%	    member(X,M),
%	    delete_list(weak,k(X),M,M1),
%	    t_condition_test(M1);
%	    true).

t_condition_test(M) :- 
	((member(k(X),M)) ->
            copy_term(X,Y),
	    member(Y,M),
	    delete_list(weak,k(X),M,M1),
	    t_condition_test(M1);
	    true).


%
% Remove K-Literal from each model set
%
remove_k_literal_all([],[]).
remove_k_literal_all([M|L1],[M1|L2]) :- !,
	remove_k_literal(M,M1),
	remove_k_literal_all(L1,L2).
remove_k_literal_all([_|L],Md) :- remove_k_literal_all(L,Md).

% Remove K_Literal from model
remove_k_literal([],[]).
remove_k_literal([X|L],Md) :- 
	(X = -(k(_)); X = k(_); X = -(h(_))),!,
	remove_k_literal(L,Md).
remove_k_literal([X|L],[X|L1]) :- remove_k_literal(L,L1).



%
% min(Ip) = {Ip of I | there is no Iq of I such that Iq subset Ip}
%
min(M,Md) :- minimal(M,M,Md).
%min(M,Md) :- minimal1(M,M1),minimal(M1,M1,Md).

minimal1([],[]).
minimal1([X|L1],[X|L2]):-
	\+ member(X,L1),minimal1(L1,L2).
minimal1([_|L1],M1):- minimal1(L1,M1).

minimal([],_,[]).
minimal([X|L1],M,[X|L2]) :-
	test_subset(X,M),minimal(L1,M,L2).
minimal([_|L1],M,Md) :- minimal(L1,M,Md).



test_subset(_,[]).
test_subset(X,[X|L]) :- test_subset(X,L).
test_subset(X,[M|L]) :- 
	(subset(M,X) -> fail;test_subset(X,L)).

%
% <<<< subset(X,Y) >>>>
%      X is subset of Y
%
subset([X|L],Y) :- member(X,Y),subset(L,Y).
subset([],_).


%
% min_r(Ip) = {Ip of I | there is no Iq of I such that q subset p}
%
min_r(M,Md) :-
%	takeup_abd_model(M,Abd,NonAbd),
	divide_element(M,M1),
	min_r_main(M1,M1,M2),
	append_literal(M2,M3),
	remove_same_element(M3,Md).

%
% AbdM are models include abducible
% NAbdM are models  have abducible
%
takeup_abd_model([],[],[]).
takeup_abd_model([M|L1],[Abd|L2],NonAbd) :-
	member(h(_),M),
	Abd = M,
	takeup_abd_model(L1,L2,NonAbd).
takeup_abd_model([M|L1],Abd,[NonAbd|L2]) :-
	NonAbd = M,
	takeup_abd_model(L1,Abd,L2).


%
% divide each model candicate  to Object literal and abducible
%   [model set] --> [[object literal],[abducible]]
%
divide_element([],[]).
divide_element([M|L],[M1|L1]) :-
	divide_element1(M,Obj,Abd),
	M1 = [Obj,Abd],
	divide_element(L,L1).

%
% divide model candicate to Object literal and abducible
%
divide_element1([],[],[]).
divide_element1([h(X)|L],Obj,[h(X)|L1]) :-
	divide_element1(L,Obj,L1).
divide_element1([X|L],[X|L1],Abd) :-
	divide_element1(L,L1,Abd).


%
% min_r main
%
min_r_main([],_,[]).
min_r_main([M|L],M1,[M|L1]) :-
	check_object_literal(M,M1),
	min_r_main(L,M1,L1).
min_r_main([_|L],M1,Md) :-
	min_r_main(L,M1,Md).

%
% check whether there is a models that have same object literal
%
check_object_literal(_,[]).
check_object_literal([X,Abd],[[_,Abd1]|L]) :- !,
	test_min_r(Abd,Abd1),
	check_object_literal([X,Abd],L).
check_object_literal(X,[_|L]) :- !,
	check_object_literal(X,L).

test_min_r(X,Y) :-
	(subset(X,Y) -> fail;
	    (subset(Y,X) -> fail;true));
	subset(X,Y).


%
% reform model candicate by append object literal and abducible
%
append_literal([],[]).
append_literal([[Obj,Abd]|L],[M|L1]) :-
	append(Abd,Obj,M),
	append_literal(L,L1).


%
% remove same element
%
remove_same_element([],[]).
remove_same_element([M|L1],[M|L]) :-
	(member(M,L1) ->
	delete_list(strong,M,L1,L2),
	remove_same_element(L2,L);
	    remove_same_element(L1,L)).
	

%
% Explanation
%
explanation([],[]) :- !.
explanation([M|L1],[E|L2]) :-
	take_abducible(M,E),
	E = [_|_],
	explanation(L1,L2).
explanation([_|L1],E) :-
	explanation(L1,E).


%
% take up abducible from model:M
%
take_abducible([],[]).
take_abducible([M|L1],[X|L2]) :-
	M = h(X),take_abducible(L1,L2).
take_abducible([_|L1],Abd) :-
	take_abducible(L1,Abd).


%
% remove work abducible
%
remove_work_abducible([],[]).
remove_work_abducible([M|L],[M1|L1]) :-
	takeup_abducible(M,M,M1),
	remove_work_abducible(L,L1).
remove_work_abducible([M|L],[M|L1]) :- !,
	remove_work_abducible(L,L1).

%
% if there is a abducible then delete from model list
%
takeup_abducible([],M,M).
takeup_abducible([h(Abd)|L],M,Md) :-
	delete_list(weak,Abd,M,M1),
	takeup_abducible(L,M1,Md).
takeup_abducible([_|L],M,Md) :- !,
	takeup_abducible(L,M,Md).

% none or empty
none_or_empty(M,Md) :-
	(M = [] -> Md = none;Md = M).


