% Copyright (C) 1998  Katsumi Inoue 
%
%%% alp.pl %%%
%
%
% reads programs from file-Mname.pr,
%       translates them into MGTP code in the file-Mname.pl
%                                       (the file-Pname.pl)
%
alptrans(Mname) :-
	pr2mgtp(Mname),
	mgtp2pl(Mname).

alptrans(Mname,Pname) :-
	pr2mgtp(Mname),
	mgtp2pl(Mname,Pname).

nhmtrans(df,Mname) :- 
        pr2mgtp(Mname),
        mgtp2nhm(df,Mname),
        mgtp2pl(Mname).

nhmtrans(df,Mname,Pname) :- 
        pr2mgtp(Mname),
        mgtp2nhm(df,Mname,Pname),
        mgtp2pl(Pname).

nhmtrans(bf,Mname) :- 
        pr2mgtp(Mname),
        mgtp2nhm(bf,Mname),
        mgtp2pl(Mname).

nhmtrans(bf,Mname,Pname) :- 
        pr2mgtp(Mname),
        mgtp2nhm(bf,Mname,Pname),
        mgtp2pl(Pname).

%
% reads programs from file-Mname.pr,
%       translates them into MGTP code in the file-Mname.pl(Pname.pl)
%       and then compiles this file
%
alpcompile(Mname) :-
	abolish(program,1),
	pr2mgtp(Mname),
	mgtp2pl(Mname,Pname),
	compile(Pname).


alpcompile(Mname,Pname) :-
	abolish(program,1),
	pr2mgtp(Mname),
	mgtp2pl(Mname,Pname),
	compile(Pname).

nhmcompile(df,Mname) :-
	abolish(program,1),
	pr2mgtp(Mname),
	mgtp2nhm(df,Mname),
	mgtp2pl(Mname),
	compile(Mname).

nhmcompile(df,Mname,Pname) :-
	abolish(program,1),
	pr2mgtp(Mname),
	mgtp2nhm(df,Mname,Pname),
	mgtp2pl(Pname),
	compile(Pname).

nhmcompile(bf,Mname) :-
	abolish(program,1),
	pr2mgtp(Mname),
	mgtp2nhm(bf,Mname),
	mgtp2pl(Mname),
	compile(Mname).

nhmcompile(bf,Mname,Pname) :-
	abolish(program,1),
	pr2mgtp(Mname),
	mgtp2nhm(bf,Mname,Pname),
	mgtp2pl(Pname),
	compile(Pname).
