//Copyright (C) 1998 Takeo Igarashi
//
//@	ZOgԂ̊֌WԂB
//
int SegmentRelation (Segment_Data*, Segment_Data*, float speed); // RemoveStrike ̎ 0 ˑ
int NodeInSegment_Check (int, Segment_Data*, float);
int NodeInSegment_Line (Node_Data *, Segment_Data*, float speed);
int NodeInSegment (int, Segment_Data*, float);
float node_line_distance (Node_Data * , Segment_Data*);

const _Non           = 0;
const _identical     = 1;
const _part1in2      = 2;
const _part1in2not2s = 3;
const _part1in2not2e = 4;
const _part2in1      = 5;
const _part2in1not1s = 6;
const _part2in1not1e = 7;
const _merge1s2s     = 8;	// Q{P{ɑ˂B ȂĂȂ
const _merge1s2e     = 9;
const _merge1e2s     = 10;
const _merge1e2e     = 11;
const _connect1s2s   = 12;	// [_Ȃ	  ȂĂ
const _connect1s2e   = 13;
const _connect1e2s   = 14;
const _connect1e2e   = 15;
const _touch1s       = 16;
const _touch1e       = 17;
const _touch2s       = 18;
const _touch2e       = 19;

const _sameline      = 20;
const _parallel      = 21;

						
float node_line_distance (Node_Data *node, Segment_Data* segment){
  
  Node_Data *StartNode, *EndNode;
  
  float a, b, bunbo, bunshi;

  StartNode = NodeArray.get(segment->start);
  EndNode = NodeArray.get(segment->end);

  Vector_Data vec0, vec1;
  vec0.set(StartNode, EndNode);
  vec1.set(StartNode, node);
  if (get_cos(vec0, vec1) < 0){
    return get_distance(node, StartNode);
  };
  vec1.set(EndNode, node);
  if (get_cos(vec0, vec1) > 0){
    return get_distance(node, EndNode);
  };

  
  a = EndNode->X - StartNode->X;
  b = EndNode->Y - StartNode->Y;

  bunbo = sqrt(a * a + b * b);
  bunshi = a * (node->Y - StartNode->Y) - b * (node->X - StartNode->X);

  if ( bunbo == 0 ) {
       return  get_distance(node, StartNode);
  }
  else {
       return Abs(bunshi / bunbo);
  }
}

int NodeInSegment (int node_num, Segment_Data* segment, float speed){ //int const_threshold){
//  if ( segment.type == Curve ) {
//     return NodeInSegment_Curve(*(NodeArray.get(node_num)), segment, const_threshold);
//  }
//  else {

//     Node_Data node =  NodeArray.get(node_num);
//			   oOBHHHH

     return NodeInSegment_Line(NodeArray.get(node_num), segment, speed); //const_threshold);
//  }

}

int NodeInSegment_Line (Node_Data *node, Segment_Data* segment, float speed){ //int const_threshold){
  float d1, d2, threshold ;

  d1 = get_distance(node, NodeArray.get(segment->start));
  d2 = get_distance(node, NodeArray.get(segment->end));

  // speed 80 -120 - 200 - 400
  threshold = (speed +100); 

  int result = false;

  #include "relatio~.cpp"  // RpC̃oO悯́@܂Ȃ

  return result;
}



int NodeInSegment_Check (int node_num, Segment_Data *segment,   float speed){ // int const_threshold ) {
  
  // const_threshold = 0 ... ZOgɑ΂銄ŌvZB
  //                 > 0 ... ̂܂  threshold ƂĎgB

  Node_Data *node;
  Segment_Data *tmp_segment;
  int i; 

   
  // ܂@łɌqĂȂׂ
  if (( segment->start == node_num ) || ( segment->end == node_num )){
    return false;
  }
  
  // Ɂ@A֌WɂȂ`FbNB
  node = NodeArray.get(segment->start);
  for ( i = 0; i<= node->owner.size - 1; i++){
    tmp_segment = SegmentArray.get(node->owner.get(i));
    if (( tmp_segment->start == node_num ) || ( tmp_segment->end == node_num )){
         return false;
     }
  }
  node = NodeArray.get(segment->end);
  for ( i = 0; i<= node->owner.size - 1;	i++){
    tmp_segment = SegmentArray.get(node->owner.get(i));
    if (( tmp_segment->start == node_num ) || ( tmp_segment->end == node_num )){
         return false;
     }
  }
  return NodeInSegment(node_num, segment, speed); //const_threshold);
}








int SegmentRelation (Segment_Data *segment1, Segment_Data *segment2,  
                     float speed, float *parallel_width){ //int const_threshold) {
  //
  //  OverStrike , Touch Segment ̏
  //         dȂAA   `FbN
  //				 parallel_width  segment2  segment1 ́@ǂꂭ炢Eɂ邩B

//  Const bent_angle = -.8 //菬mergeB
                         // -1 ɋ߂قǌBpcB
  int result;
  int l1s, l1e, l2s, l2e;

  float cosine;
  double tmp;

  float angle_allowance = speed / 20; // 80 - 400 -> 2 - 10
  float cosine_allowance = -cos(angle_allowance / 180 * pi);

  Vector_Data vector;

  l1s = NodeInSegment_Check(segment1->start, segment2, speed); //const_threshold);
  l1e = NodeInSegment_Check(segment1->end, segment2, speed);
  l2s = NodeInSegment_Check(segment2->start, segment1, speed);
  l2e = NodeInSegment_Check(segment2->end, segment1, speed);


  cosine = get_cos(segment1->vector(), segment2->vector());
  
  result = _Non;

  if  ( l1s && l1e ) {
    if  ( Abs(cosine) > 0.98){ //0.8 ) {       // ܂̏ꍇ px`FbN邢
      if  ( l2s && l2e ) {
       result = _identical;}
      else if  ( l2s ) {
       result = _part1in2not2e;}
      else if  ( l2e ) {
       result = _part1in2not2s;}
      else {
        result = _part1in2;}
      } 
    } 
  else if  ( l2s && l2e ) {
    if  ( Abs(cosine) > 0.98){ //0.8 ) {       // ܂̏ꍇ px`FbN邢
      if  ( l1s ) {
       result = _part2in1not1e;}
      else if ( l1e ) {
       result = _part2in1not1s;}
      else {
        result = _part2in1 ;}
      } 
    } 
//  else if ( ( (Abs(cosine) > .95) ) { // ) || (  segment2.Type = curve ) {    // ÂƂ͊px`FbN B
             // ړ_̊px }[W ܂ ڑ
  else if  ( l1s && l2s ) {
	   vector.set(*(NodeArray.get(segment1->start)),
	              *(NodeArray.get(segment2->start)));
       if  ((   get_cos(segment1->start_vec(), segment2->start_vec()) 
              < cosine_allowance  ) &&
             (get_cos(segment1->start_vec(), vector) > 0)) {
         result = _merge1s2s;}        // Q{P{ɑ˂B
       else	{
         result = _connect1s2s;}      //  [_Ȃ
       } 
    else if  ( l1s && l2e ) {
	   vector.set(*(NodeArray.get(segment1->start)),
	              *(NodeArray.get(segment2->end)));
       if (( get_cos(segment1->start_vec(), segment2->end_vec()) < cosine_allowance  ) &&
           (get_cos(segment1->start_vec(), vector) > 0)) {
         result = _merge1s2e;}
       else	{
         result = _connect1s2e;}
       } 
    else if  ( l1e && l2s ) {
	   vector.set(*(NodeArray.get(segment1->end)),
	              *(NodeArray.get(segment2->start)));
       if  ( (get_cos(segment1->end_vec(), segment2->start_vec()) < cosine_allowance  ) &&
             (get_cos(segment1->end_vec(), vector) > 0)) {
         result = _merge1e2s;}
       else	{
         result = _connect1e2s;}
       } 
    else if  ( l1e && l2e ) {
	   vector.set(*(NodeArray.get(segment1->end)),
	              *(NodeArray.get(segment2->end)));
       if  ((get_cos(segment1->end_vec(), segment2->end_vec()) < cosine_allowance  ) &&
            (get_cos(segment1->end_vec(), vector) > 0)) {
         result = _merge1e2e;}
       else {
         result = _connect1e2e;}
       } 

    
    else if  ( l1s ) {
       result = _touch1s;}
    else if  ( l1e ) {
       result = _touch1e;}
    else if  ( l2s ) {
       result = _touch2s;}
    else if  ( l2e ) {
       result = _touch2e;}

    //   ȂĂȂ@!! sameline, parallel ̃`FbN
    else if (Abs(tmp = get_cos(segment1->start_vec(), 
	                           segment2->start_vec())) > 0.996) { 
	  // (y1 - y0) x + (x0 - x1) y + (x1 y0 - x0 y1) = 0
	  if (tmp >0) tmp = 1; else tmp = -1;
 	  double a =  ( +NodeArray.get(segment1->end)->Y
 	               -NodeArray.get(segment1->start)->Y
				   + tmp * (+NodeArray.get(segment2->end)->Y
 	                        -NodeArray.get(segment2->start)->Y));
 	  double b =  ( -NodeArray.get(segment1->end)->X
 	               +NodeArray.get(segment1->start)->X
				   + tmp * ( -NodeArray.get(segment2->end)->X
 	                         +NodeArray.get(segment2->start)->X));
	  tmp = sqrt(a * a + b * b);
	  a = a / tmp;
	  b = b / tmp;
	  //  segment1 -> y1 start1 end1  
	  float y1     = a * NodeArray.get(segment1->start)->X
			       + b * NodeArray.get(segment1->start)->Y;
	  float start1 = b * NodeArray.get(segment1->start)->X
			       - a * NodeArray.get(segment1->start)->Y;
	  float end1   = b * NodeArray.get(segment1->end)->X
			       - a * NodeArray.get(segment1->end)->Y;
	  float y2     = a * NodeArray.get(segment2->start)->X
			       + b * NodeArray.get(segment2->start)->Y;
	  float start2 = b * NodeArray.get(segment2->start)->X
			       - a * NodeArray.get(segment2->start)->Y;
	  float end2   = b * NodeArray.get(segment2->end)->X
			       - a * NodeArray.get(segment2->end)->Y;
	  
	  if (Abs(y1 - y2) < 500) {
	    result = _sameline;}
	  else if ((((start1 - start2)*(end1 - start2))<0)||
			   (((start1 - end2)*(end1 - end2))<0)    ||
			   (((start2 - start1)*(end2 - start1))<0)) {
	    result = _parallel;
	    *parallel_width = y2 - y1;}
      
//      console.add(result);

	}


  return result;
}


// PairWebArray p syAT  `FbNI
float parallel(int segment1_num, int segment2_num){
  
   Segment_Data *segment1 = SegmentArray.get(segment1_num);
   Segment_Data *segment2 = SegmentArray.get(segment2_num);
   float tmp, result;

   if (Abs( tmp = get_cos(segment1->start_vec(), 
	                           segment2->start_vec())) > 0.999) { 
	  // (y1 - y0) x + (x0 - x1) y + (x1 y0 - x0 y1) = 0
	  if (tmp >0) tmp = 1; else tmp = -1;
 	  double a =  ( +NodeArray.get(segment1->end)->Y
 	               -NodeArray.get(segment1->start)->Y
				   + tmp * (+NodeArray.get(segment2->end)->Y
 	                        -NodeArray.get(segment2->start)->Y));
 	  double b =  ( -NodeArray.get(segment1->end)->X
 	               +NodeArray.get(segment1->start)->X
				   + tmp * ( -NodeArray.get(segment2->end)->X
 	                         +NodeArray.get(segment2->start)->X));
	  tmp = sqrt(a * a + b * b);
	  a = a / tmp;
	  b = b / tmp;
	  //  segment1 -> y1 start1 end1  
	  float y1     = a * NodeArray.get(segment1->start)->X
			       + b * NodeArray.get(segment1->start)->Y;
	  float start1 = b * NodeArray.get(segment1->start)->X
			       - a * NodeArray.get(segment1->start)->Y;
	  float end1   = b * NodeArray.get(segment1->end)->X
			       - a * NodeArray.get(segment1->end)->Y;
	  float y2     = a * NodeArray.get(segment2->start)->X
			       + b * NodeArray.get(segment2->start)->Y;
	  float start2 = b * NodeArray.get(segment2->start)->X
			       - a * NodeArray.get(segment2->start)->Y;
	  float end2   = b * NodeArray.get(segment2->end)->X
			       - a * NodeArray.get(segment2->end)->Y;
	  if (Abs(y1 - y2) < 500) {
	    result = false;}
	  else if ((((start1 - start2)*(end1 - start2))<=0)||
			   (((start1 - end2)*(end1 - end2))<=0)    ||
			   (((start2 - start1)*(end2 - start1))<=0)) {
	    result = Abs(y2 - y1);
	  }
	  else	{
	    result = false;
	  }
   }
   else
     result = false;

  return result;
}