//Copyright (C) 1998 Takeo Igarashi
//#include "list.cpp"



// Node-------------

class Node_Data : public Point_Data{
  public:
    int_List owner;
	friend int operator ==(Node_Data, Node_Data);
	friend int same_node(Node_Data *);
	void clear(){
	  owner.clear();}
};
int operator ==(Node_Data node1, Node_Data node2){
  return ((Abs(node1.X - node2.X) < 10) &&		//덷l
		  (Abs(node1.Y - node2.Y) < 10));
}
int same_node(Node_Data *node1, Node_Data *node2){
  return ((Abs(node1->X - node2->X) < 10) &&		//덷l
		  (Abs(node1->Y - node2->Y) < 10));
}


void   Vector_Data::set_norm(Node_Data p1, Node_Data p2){
  X = p2.X - p1.X;
  Y = p2.Y - p1.Y;
  float length = sqrt(X * X + Y * Y);
  X = X / length;
  Y = Y / length;
};
void   Vector_Data::set(Node_Data *p1, Node_Data *p2){
  X = p2->X - p1->X;
  Y = p2->Y - p1->Y;
};
float get_distance (Node_Data *p1, Node_Data *p2){
  float x, y;
  x = p1->X - p2->X;
  y = p1->Y - p2->Y;
  return(sqrt(x * x + y * y));
}



const max_node = 1000;
class Node_Array {
    Node_Data content[max_node];
	int used[max_node];
  public:
	int usedd(int n){return used[n];};
    int  size(); 
    int add(Node_Data node);
	int add(float,float);
    int add(int n);  // copy
	void remove(int n);
	Node_Data* get(int n);
	Node_Data* get_next(int *n);
	void clear();
	int identical(int a, int b){
		return same_node(content+a, content+b);}

	void add_owner(int n, int segment_num);
	void remove_owner(int n, int segment_num);
} NodeArray;
int Node_Array::size(){
  int n = 0;
  for (int i = 0; i < max_node; i++){
    if (used[i]) n++;
  }
  return n;
}


int Node_Array::add(Node_Data node){
  int i = 0;
  while (used[i]){
	i++;
    if (i == max_node) return -1;
	}
  content[i] = node;
  used[i] = true;
  return i;
}
int Node_Array::add(float x, float y){
  int i = 0;
  while (used[i]){
	i++;
    if (i == max_node) return -1;
	}
  content[i].X = x;
  content[i].Y = y;
  used[i] = true;
  return i;
}

int Node_Array::add(int n){
  int i = 0;
  while (used[i]){
	i++;
    if (i == max_node) return -1;
	}
  content[i].clear();          // owner 
  content[i].X = content[n].X;
  content[i].Y = content[n].Y;
  used[i] = true;
  return i;
}

void Node_Array::remove(int n){
  content[n].clear();
  used[n] = false;
}  
Node_Data* Node_Array::get(int n){
  return content + n;
}
Node_Data* Node_Array::get_next(int *n){
  //  n ͂߂ ŏɎgĂ̂ƂB
  //  ł̂܂ܕԂBł͂Ȃ
  //  s[PԂB
  int i = *n;
  while (used[i] == false) {
    i++;
	if (i >= max_node){
	  *n = -1;
	  return content;}
	}
  *n = i;
  return  content + i;
}  
void Node_Array::clear(){
  for (int i = 0 ; i < max_node; i++)
    remove(i);
} 
void Node_Array::add_owner(int n, int segment_num){
  content[n].owner.add(segment_num);
  used[n] = true;
}    
void Node_Array::remove_owner(int n, int segment_num){
  content[n].owner.remove_by_content(segment_num);
  if ( content[n].owner.size == 0 )
    remove(n);
}    
  




//Segment ----

class Segment_Data {
     Vector_Data
		start_vector,
		end_vector;
  public:
     int start,
	     end,
	     
	     type;

	  Vector_Data
		 start_vec();
	  Vector_Data
		 end_vec();

	  float length();
	  Vector_Data vector();
	  float angle(Segment_Data* base);
};
  const Straight = 0;
  const Curve = 1;
float Segment_Data::length(){
  return get_distance(NodeArray.get(start), NodeArray.get(end));
}
float Segment_Data::angle(Segment_Data* base){

  Node_Data* line1s = NodeArray.get(start); 
  Node_Data* line1e = NodeArray.get(end); 
  Node_Data* line2s = NodeArray.get(base->start); 
  Node_Data* line2e = NodeArray.get(base->end);

  // 1s == 2s Ɖ
  float X = line1e->X - line1s->X;
  float	Y = line1e->Y - line1s->Y; 
  float X0 = line1e->X - line1s->X;
  float	Y0 = line1e->Y - line1s->Y;

  if (same_node(line1e, line2e)){
  	X = -X;   	Y = -Y; 
  	X0 = - X0; 	Y0 = -Y0;}
  else if (same_node(line1s, line2e)){
  	X0 = - X0; 	Y0 = -Y0;}
  else if (same_node(line1s, line2s)){
  	X = -X;   	Y = -Y; }
  	  	 
  return get_relative_angle(X,Y,X0,Y0);
}
Vector_Data Segment_Data::vector(){
  Vector_Data result;
  result.set(NodeArray.get(start), NodeArray.get(end));
  return result;
}
Vector_Data Segment_Data::start_vec(){
  if (type == Curve){
    return start_vector;
  }
  else {
    Vector_Data vector;
    vector.set(*(NodeArray.get(start)), *(NodeArray.get(end)));
    return vector;
  }
}

Vector_Data Segment_Data::end_vec(){
  if (type == Curve){
    return end_vector;
  }
  else {
    Vector_Data vector;
    vector.set(*(NodeArray.get(end)), *(NodeArray.get(start)));
    return vector;
  }
}


const max_segment = 1000;
class Segment_Array {
    Segment_Data content[max_segment];
	int used[max_segment];
  public:
	int size();
    int add(Segment_Data node);
	void remove(int n);
	Segment_Data* get(int n) {return content + n;};
	Segment_Data* get_next(int *n);
	int create();
	int create(int start, int end);
	void clear();
	int same_segment(int a, int b);
} SegmentArray;

int Segment_Array::size(){
  int n = 0;
  for (int i = 0; i < max_segment; i++){
    if (used[i]) n++;
  }
  return n;
}
int Segment_Array::create(){
  int i = 0;
  while (used[i]){
	i++;
    if (i == max_segment) return -1;
	}

  used[i] = true;
  return i;
}
int Segment_Array::create(int start, int end){
  int           segment_num = create();
  Segment_Data  *segment = get(segment_num);

  segment->start = start;
  segment->end =   end;
  segment->type =  Straight;

  NodeArray.add_owner(start, segment_num);
  NodeArray.add_owner(end,   segment_num);

  return segment_num;
}

int Segment_Array::add(Segment_Data segment){
  int i = 0;
  while (used[i]){
	i++;
    if (i == max_segment) return -1;
	}
  content[i] = segment;
  used[i] = true;

  NodeArray.add_owner(segment.start, i);
  NodeArray.add_owner(segment.end, i);


  return i;
}
void Segment_Array::remove(int n){
  used[n] = false;

  NodeArray.remove_owner(content[n].start, n);
  NodeArray.remove_owner(content[n].end, n);

}  
Segment_Data* Segment_Array::get_next(int *n){
  //  n ͂߂ ŏɎgĂ̂ƂB
  //  ł̂܂ܕԂBł͂Ȃ
  //  s[PԂB
  int i = *n;
  while (used[i] == false) {
    i++;
	if (i == max_segment){
	  *n = -1;
	  return content;}
	}
  *n = i;
  return content + i;
}  

void Segment_Array::clear(){
  for (int i = 0 ; i < max_segment; i++)
    used[i] = false;
} 
   
// dȂĂ邩ׂB
int Segment_Array::same_segment(int a, int b){
	Segment_Data* segment0 =  content + a;
	Segment_Data* segment1 =  content + b;

  Node_Data* line1s = NodeArray.get(segment0->start); 
  Node_Data* line1e = NodeArray.get(segment0->end); 
  Node_Data* line2s = NodeArray.get(segment1->start); 
  Node_Data* line2e = NodeArray.get(segment1->end);

  return ((same_node(line1s,line2s) && same_node(line1e,line2e))
  	   || (same_node(line1e,line2s) && same_node(line1s,line2e)));
  	    		    	 
}


  
   
int segment_equal(int num1, int num2){
  return (
    (NodeArray.get(SegmentArray.get(num1)->start)->X ==
     NodeArray.get(SegmentArray.get(num2)->start)->X) &&
    (NodeArray.get(SegmentArray.get(num1)->start)->Y ==
     NodeArray.get(SegmentArray.get(num2)->start)->Y) &&
    (NodeArray.get(SegmentArray.get(num1)->end)->X ==
     NodeArray.get(SegmentArray.get(num2)->end)->X) &&
    (NodeArray.get(SegmentArray.get(num1)->end)->Y ==
     NodeArray.get(SegmentArray.get(num2)->end)->Y)
		 );
}





class Object_Data{
  protected:
    int_List segment;
  public:
    int size();  
//    void add(int n);
    int get(int n);  
//    void remove_by_index(List_Index n); 
//    void remove_by_content(int n); 
//    void clear();          
	// ̂łɂ邩`FbN
	int exist(int segment_num){
		for (int i=0; i<segment.size; i++){
			if (SegmentArray.same_segment(segment.get(i), segment_num))
				return true;
			}
		return false;
	}

				     
};
int Object_Data::size(){
  return segment.size;
}
int Object_Data::get(int n){
  return segment.get(n);
}


// Web Ȃ
class Hidden_Object_Data : public Object_Data {
  public:
    void add(int n);
    void remove_by_index(List_Index n); 
    void remove_by_content(int n); 
    void clear();               
};

void Hidden_Object_Data::add(int segment_num){
  // `FbN
  if (SegmentArray.get(segment_num)->length() < 50){
    SegmentArray.remove(segment_num);
	return;
  }    
  segment.add(segment_num);	 
//  WebArray_add(segment_num);
}
void Hidden_Object_Data::remove_by_index(List_Index n){
  int segment_num = segment.get(n);
//  WebArray_remove(segment_num);
  SegmentArray.remove(segment_num); 
  segment.remove_by_index(n);
}
void Hidden_Object_Data::remove_by_content(int n){
  int i = 0;
  while (i < segment.size){
    if (segment.get(i) == n){
	  break;}
	i++;
  }
  if (i == segment.size) { return ;}  // failed...
  
  remove_by_index(i);
}

void Hidden_Object_Data::clear(){
  while (segment.size > 0)
    remove_by_index(0);
//  for (int i = 0; i < segment.size ; i++){
//    WebArray_remove(segment.get(i));
//    SegmentArray.remove(segment.get(i)); 
//  }
//  segment.clear();
}





// web ̎舵
class Front_Object_Data : public Object_Data {
  public:
    void add(int n);
    void remove_by_index(List_Index n); 
    void remove_by_content(int n); 
    void clear();               
};
void WebArray_add(int);
void PairWebArray_add(Object_Data *,int);
void Front_Object_Data::add(int segment_num){
  // `FbN
  if (SegmentArray.get(segment_num)->length() < 100){
    SegmentArray.remove(segment_num);
	return;
  }    
  PairWebArray_add(this, segment_num);
  segment.add(segment_num);	 
  WebArray_add(segment_num);
}
void WebArray_remove(int);
void PairWebArray_remove(int);
void Front_Object_Data::remove_by_index(List_Index n){
  int segment_num = segment.get(n);
  WebArray_remove(segment_num);
  segment.remove_by_index(n);
  PairWebArray_remove(segment_num);
  SegmentArray.remove(segment_num); 
}
void Front_Object_Data::remove_by_content(int n){
  int i = 0;
  while (i < segment.size){
    if (segment.get(i) == n){
	  break;}
	i++;
  }
  if (i == segment.size) { return ;}  // failed...
  remove_by_index(i);
}
void WebArray_clear();
void Front_Object_Data::clear(){
  while (segment.size > 0)
    remove_by_index(0);
  WebArray_clear();      // {ȂsvBoOBB
}






void copy_object(Hidden_Object_Data *object1, Hidden_Object_Data *object2){
  int            segment_num ;
  Segment_Data   *segment     ,
                 *original_segment;
  Node_Data      node0;
  int i;
  int nodes[max_node];

  for (i = 0 ; i < max_node ; i++) nodes[i] = -1;
    object2->clear();   

  for (i = 0 ; i < object1->size() ; i++){
    original_segment = SegmentArray.get(object1->get(i));

    segment_num = SegmentArray.create();
    segment = SegmentArray.get(segment_num);
    segment->type =  Straight;

	if (nodes[original_segment->start] != -1)
	   segment->start = nodes[original_segment->start];
	else
	   nodes[original_segment->start] 
       = segment->start 
       = NodeArray.add(original_segment->start);

	if (nodes[original_segment->end] != -1)
	   segment->end = nodes[original_segment->end];
	else
	   nodes[original_segment->end] 
       = segment->end
       = NodeArray.add(original_segment->end);
       	   
    NodeArray.add_owner(segment->start, segment_num);
    NodeArray.add_owner(segment->end,   segment_num);
  
	object2->add(segment_num);
	
	} 
}

void copy_object(Front_Object_Data *object1, Hidden_Object_Data *object2){
  int            segment_num ;
  Segment_Data   *segment     ,
                 *original_segment;
  Node_Data      node0;
  int i;
  int nodes[max_node];

  for (i = 0 ; i < max_node ; i++) nodes[i] = -1;
    object2->clear();   

  for (i = 0 ; i < object1->size() ; i++){
    original_segment = SegmentArray.get(object1->get(i));

    segment_num = SegmentArray.create();
    segment = SegmentArray.get(segment_num);
    segment->type =  Straight;

	if (nodes[original_segment->start] != -1)
	   segment->start = nodes[original_segment->start];
	else
	   nodes[original_segment->start] 
       = segment->start 
       = NodeArray.add(original_segment->start);

	if (nodes[original_segment->end] != -1)
	   segment->end = nodes[original_segment->end];
	else
	   nodes[original_segment->end] 
       = segment->end
       = NodeArray.add(original_segment->end);

    NodeArray.add_owner(segment->start, segment_num);
    NodeArray.add_owner(segment->end,   segment_num);
  
	object2->add(segment_num);
	
	} 
}

void copy_object(Hidden_Object_Data *object1, Front_Object_Data *object2){
  int            segment_num ;
  Segment_Data   *segment     ,
                 *original_segment;
  Node_Data      node0;
  int i;
  int nodes[max_node];

  for (i = 0 ; i < max_node ; i++) nodes[i] = -1;
  object2->clear();   

  for (i = 0 ; i < object1->size() ; i++){
    original_segment = SegmentArray.get(object1->get(i));

    segment_num = SegmentArray.create();
    segment = SegmentArray.get(segment_num);
    segment->type =  Straight;

	if (nodes[original_segment->start] != -1)
	   segment->start = nodes[original_segment->start];
	else
	   nodes[original_segment->start] 
       = segment->start 
       = NodeArray.add(original_segment->start);

	if (nodes[original_segment->end] != -1)
	   segment->end = nodes[original_segment->end];
	else
	   nodes[original_segment->end] 
       = segment->end
       = NodeArray.add(original_segment->end);

    NodeArray.add_owner(segment->start, segment_num);
    NodeArray.add_owner(segment->end,   segment_num);
  
	object2->add(segment_num);
	
	} 
}