//Copyright (C) 1998 Takeo Igarashi
//
//    Object Definition
//
//    Class list   // IWi  \炵B
//

typedef int List_Index; 
  
class int_List {
  protected:
    int *content;
	int alive;
 public:
    int_List(void) { size = 0; alive = false;};
	~int_List(void){ if ((size > 0) && alive) delete content;};
	int_List& operator=(const int_List&);
	int_List(const int_List&);
 
    int size;
 	void add(int n);
	int  get(List_Index n){if (size > 0)  return content[n];
	                       else   return 0; }
	int  member(int n);
	int remove_by_content(int n);
	void remove_by_index(List_Index n);
	void clear()   { if ((size > 0) && alive) delete content;
	                 alive = false;
					 size = 0;};
};
int_List& int_List::operator=(const int_List& a){
  if (this != &a) {
    clear();
	content = new int[size = a.size];
	for (int i = 0 ; i < a.size ; i ++)
	  content[i] = a.content[i];
   }
	return *this;
   
};
int_List::int_List(const int_List& a){
	content = new int[size = a.size];
	for (int i = 0 ; i < a.size ; i ++)
	  content[i] = a.content[i];
};


void int_List::add(int n){
  int* tmp;
  tmp = new int[size + 1];
  for (int i = 0; i < size ; i++){
    *(tmp + i) = *(content + i);}
  if ( size > 0 )  delete content;
  content = tmp;
  content[size++] = n;
  alive = true;
}
   
int int_List::remove_by_content(int n){
  int i = 0;
  while (i < size){
    if (*(content + i) == n){
	  break;}
	i++;
  }
  if (i == size) { return false;}  // failed...
  while (i< size - 1){
    *(content + i) = *(content + i + 1);
	i++;
  }
  size--;
  if ((size == 0) && alive){
    delete content;
    alive = false;}
  return true;
}

void int_List::remove_by_index(List_Index n){
  int i = n;
  while (i< size - 1){
    content[i] = content[i + 1];
	i++;
  }
  size--;
  if ((size == 0) && alive){
    delete content;
    alive = false;}
}

int int_List::member(int n){
  int i = 0;
  while (i < size){
    if (*(content + i) == n){
	  break;}
	i++;
  }
  if (i == size) { return 0;}
  else {return 1;}
}
void copy(int_List l2, int_List l1) {
  l1.clear();
  for (int i = 0; i < l2.size; i ++)
    l1.add(l2.get(i));
} 





class float_List {
    float *content;
	int alive;
	float_List& operator=(const float_List&);
	float_List(const float_List&);
  public:
    float_List(void) { size = 0; alive = false;};
	~float_List(void){ if ((size > 0) && alive) delete content;};
    int size;
 	void add(float n);
	float  get(List_Index n){if (n < size) return content[n];
	                         else return -1;}
	int  member(float n);
	void remove_by_content(float n);
	void remove_by_index(List_Index n);
	void clear()   { if ((size > 0) && alive) delete content;
	                 alive = false;
					 size = 0;};

};
float_List& float_List::operator=(const float_List& a){
  if (this != &a) {
    clear();
	content = new float[size = a.size];
	for (int i = 0 ; i < a.size ; i ++)
	  content[i] = a.content[i];
   }
	return *this;
   
};
float_List::float_List(const float_List& a){
	content = new float[size = a.size];
	for (int i = 0 ; i < a.size ; i ++)
	  content[i] = a.content[i];
};

void float_List::add(float n){
  float* tmp;
  tmp = new float[size + 1];
  for (int i = 0; i < size ; i++){
    *(tmp + i) = *(content + i);}
  if ( size > 0 ) delete content;
  content = tmp;
  content[size++] = n;
  alive = true;
}
   
void float_List::remove_by_content(float n){
  int i = 0;
  while (i < size){
    if (*(content + i) == n){
	  break;}
	i++;
  }
  if (i == size) { return ;}  // failed...
  while (i< size - 1){
    *(content + i) = *(content + i + 1);
	i++;
  }
  size--;
  if ((size == 0) && alive){
    delete content;
    alive = false;}
}

void float_List::remove_by_index(List_Index n){
  int i = n;
  while (i< size - 1){
    content[i] = content[i + 1];
	i++;
  }
  size--;
  if ((size == 0) && alive){
    delete content;
    alive = false;}
}

int float_List::member(float n){
  int i = 0;
  while (i < size){
    if (*(content + i) == n){
	  break;}
	i++;
  }
  if (i == size) { return 0;}
  else {return 1;}
}






 // VB ł eXgpC^tF[X
  						 
int_List test_list;

extern "C" void _export WINAPI list_add (int n){
  test_list.add(n);
}

extern "C" void _export WINAPI list_remove (int n){
  test_list.remove_by_index(n);
}
extern "C" int _export WINAPI list_member (int n){
  return test_list.member(n);
}
extern "C" int _export WINAPI list_size (){
  return test_list.size;
  }

 