//Copyright (C) 1998 Takeo Igarashi

void GetMaltipleCandidates ();

void SolveConstraint ();
void AddOneConstraintToGraph (int constraint_num);
void ConstraintFireCheck(constraint_Data *constraint);

void ConstraintFire (constraint_Data* constraint);
void ConstraintFire2 (constraint_Data* constraint,
					  constraint_Data* waiting_constraint);
void ConstraintPropagate (Variable_Data* Variable);

#include "SolveDis.cpp"



int waiting2 ,
    waiting4 ;
constraint_Data    *waiting_constraint2,
                   *waiting_constraint4;



void SolveConstraint (){


//  Constraint Solver
//
//  Check Constraint -> make Constraint Graph
//  -> Set Newest Variable -> Constraint Propagation
//

  int Current_Constraint;
  waiting2 = false;
  waiting4 = false;

  constraintArray.sort();
  constraintArray.init_index();

//  ϐ[ ŏI
//  VariableArray.NSatisfied = 0;
//  while (VariableArray.NSatisfied < VariableArray.size()){
//     AddOneConstraintToGraph(constraintArray.get_next());
//  }

// Ō܂ SB  ̂
  for (int i = 0; i < constraintArray.size(); i++){
     AddOneConstraintToGraph(constraintArray.get_next());
  }
   

}







void AddOneConstraintToGraph (int constraint_num){

  //
  //  Main
  //
  //   Constraint ̕ϐ 𒲂ׂ ׂĊm肳Ă 
  //    ȊȌꍇ  OtցB

   constraint_Data *constraint;
   int i;

  constraint = constraintArray.get(constraint_num);


  for (i = 0; i <= constraint->Variable.size - 1; i++){
    if (VariableArray.get(constraint->Variable.get(i))->Specified ) {
       constraint->NSatisfied++;
	}
    else {
      VariableArray.get(constraint->Variable.get(i))
           ->constraint.add( constraint_num);
    }
  }

  ConstraintFireCheck(constraint);
}


void ConstraintFireCheck(constraint_Data *constraint){
  //  ϐ̐𒲂ׂB	ĂΔ

  if (constraint->Variable.size == constraint->NSatisfied + 1) {
    // ϐ\m肵ĂƔ΂B  P NVariable = 1
     ConstraintFire(constraint);
  }
  else if (constraint->Variable.size == constraint->NSatisfied ){
    // łɂׂĊmς
    if ((constraint->satisfied == 0) &&
        constraint->check_satisfied()) {
       constraint->satisfied = 2;}   // ͖{ŖB
  }
  else  {  //܂ Ȃ  -> A
    if ((constraint->Type == liner) && 
        (constraint->Variable.size == 2) &&
		(constraint->NSatisfied == 0)  &&
		((constraint->Variable.get(0)  -
		  constraint->Variable.get(1))  == -1)
	   ){  // on_line 
	   if (waiting4 &&                        // łɏoĂ
		   (waiting_constraint4->NSatisfied == 2)){
 	      waiting4 = false;
          ConstraintFire2(constraint, waiting_constraint4);
	   }
	   else {                               // 悾
	   	 waiting2 = true;
		 waiting_constraint2 = constraint;
	   }
	}
	else if ((constraint->Type == liner) && 
             (constraint->Variable.size == 4)){   // parallel 
           if ((constraint->NSatisfied == 2) &&
			   waiting2 &&
		       (waiting_constraint2->NSatisfied == 0)){
 	          waiting2 = false;
              ConstraintFire2(waiting_constraint2, constraint);
	        }
	        else {                               // 悾
              if (constraint->NSatisfied <= 2) {
	   	        waiting4 = true;
		        waiting_constraint4 = constraint;
			  }
	        }
	}
  }		
		
}







void ConstraintFire (constraint_Data* constraint){


   Variable_Data* Variable;
   float Value,
         tmp;
   int   i,
         num, //mϐ̈ʒu  
         variable_num;

  for (num = 0; num < constraint->Variable.size ; num++)
    if (!(VariableArray.get(constraint->Variable.get(num))->Specified) ) {
	  break;}
  
  variable_num = constraint->Variable.get(num);
  Variable = VariableArray.get(variable_num);
  
  // łallm肸  Constraint ݂
  if (num == constraint->Variable.size) {
    return;
  }

   Value = constraint->calcurate(num);

  //  prevent catastrophic	transform
  if (Abs(Variable->Value - Value) > 500){
    constraint->satisfied = 3;   // failed by limit
    return;
  }
  
  constraint->satisfied = 1;   // satisfy by myself

  Variable->Value = Value;
  Variable->Specified = true;
  VariableArray.NSatisfied++;

  ConstraintPropagate(Variable);

}


// sƐ  ̘A
void ConstraintFire2 (constraint_Data* constraint2,
					  constraint_Data* constraint4){


   Variable_Data* Variable0 , *Variable1;
   float Value0, Value1 ,
         tmp;

  Variable0 = VariableArray.get(constraint2->Variable.get(0));
  Variable1 = VariableArray.get(constraint2->Variable.get(1));


  //  a0 * x0 + b0 * y0 = c0
  //  a1 * x0 + b1 * y0 = c1
  int free = constraint2->Variable.get(0);  // 0 ,  2 
  float a0 = constraint4->Coefficient.get(free);
  float b0 = constraint4->Coefficient.get(1 + free );
  float c0 = constraint4->Constant
     - constraint4->Coefficient.get(2 - free)
	   * VariableArray.get(2 - free)->Value
     - constraint4->Coefficient.get(3 - free)
	   * VariableArray.get(3 - free)->Value;
  float a1 = constraint2->Coefficient.get(0);
  float b1 = constraint2->Coefficient.get(1);
  float c1 = constraint2->Constant;

  if ((a0 * b1 - a1 * b0) == 0 ) return;
  Value0 = (c0 * b1 - c1 * b0) / (a0 * b1 - a1 * b0);
  Value1 = (c0 * a1 - c1 * a0) / (b0 * a1 - b1 * a0);


  //  prevent catastrophic	transform
  if ((Abs(Variable0->Value - Value0) > 500) ||
      (Abs(Variable1->Value - Value1) > 500)){
    constraint2->satisfied = 4;   // failed by limit
    constraint4->satisfied = 4;   // failed by limit
    return;
  }

  constraint4->satisfied = 4;	  //  AŉI
  constraint2->satisfied = 4;          // 

  Variable0->Value = Value0;
  Variable0->Specified = true;
  VariableArray.NSatisfied++;

  Variable1->Value = Value1;
  Variable1->Specified = true;
  VariableArray.NSatisfied++;

  ConstraintPropagate(Variable0);
  ConstraintPropagate(Variable1);

}





void ConstraintPropagate (Variable_Data* Variable){
  


   constraint_Data* constraint;

   int i;


  // Otw`d
  for (i = 0; i<= Variable->constraint.size - 1; i++){
    constraint = constraintArray.get(Variable->constraint.get(i));
    constraint->NSatisfied++;

    ConstraintFireCheck(constraint);
  }
/*
    if (constraint->NSatisfied + 1== constraint->Variable.size ) {
       ConstraintFire(constraint);
    }
    else if ((constraint->Variable.size == constraint->NSatisfied )  &&
             (constraint->satisfied == 0) ){
    // łɂׂĊmς
        if (constraint->check_satisfied()) {
              constraint->satisfied = 2;}   // ͖{ŖB
    }
  }
*/
}
