//Copyright (C) 1998 Takeo Igarashi
void InitConstraint(Segment_Data* segment);
void  AddConstraint_stay(int Variable_num, float Value, float Strength);
void  AddConstraint_specify(int Variable_num, float Value, float Strength,
                            int reference_type, int_List *reference_segment);
void  AddConstraint_liner1(int Variable0, int Variable1, 
                           float Coefficient0,float Coefficient1,
                           float Constant, float Strength,
                           int reference_type, int_List *reference_segment);
void  AddConstraint_liner3(int Variable0,  int Variable1,     int Variable2,     int Variable3,
                           float Coefficient0,  float Coefficient1,float Coefficient2, float Coefficient3,
                           float Constant, float Strength,
						   int reference_type, int_List *reference_segment);

void  AddConstraint_online(int x0, int y0,     int x1,     int y1,
                           float x, float y,   
                           float Strength);

void ConvertToSegment(Segment_Data* segment);
extern "C" void _export WINAPI SolverTest();



void InitConstraint(Segment_Data* segment, float speed){
// ϐ(4)̏  stay ̃Zbg

//  80 - 400
//  meta_constraintArray.clear();

  constraintArray.clear();
  VariableArray.clear();

  int x0 = VariableArray.create(); // 0
  int y0 = VariableArray.create(); // 1
  int x1 = VariableArray.create(); // 2
  int y1 = VariableArray.create(); // 3

  (VariableArray.get(x0))->Value = OriginalLocation[x0] = NodeArray.get(segment->start)->X;
  (VariableArray.get(y0))->Value = OriginalLocation[y0] = NodeArray.get(segment->start)->Y;
  (VariableArray.get(x1))->Value = OriginalLocation[x1] = NodeArray.get(segment->end  )->X;
  (VariableArray.get(y1))->Value = OriginalLocation[y1] = NodeArray.get(segment->end  )->Y;
  
/*
  // Stay 	  Strength 100
 float adjust;	  // ZDî߁j
  if ( Abs(NodeArray.get(segment->start)->X - NodeArray.get(segment->end)->X)
     > Abs(NodeArray.get(segment->start)->Y - NodeArray.get(segment->end)->Y))
       {adjust = - 2;}
  else {adjust = + 2;}

  float strength = 300 - speed / 2 ; // 80..400 ->  300..100
  AddConstraint_stay(x0, OriginalLocation[x0], strength + adjust); // 80 + adjust);
  AddConstraint_stay(y0, OriginalLocation[y0], strength- adjust); // 80 - adjust);
  AddConstraint_stay(x1, OriginalLocation[x1], strength+ adjust); // 80 + adjust);
  AddConstraint_stay(y1, OriginalLocation[y1], strength- adjust); // 80 - adjust);
*/
};

// XeC   strength  vZȂ
void  AddConstraint_stay(int Variable_num, float Value, float Strength){
  constraint_Data* constraint = constraintArray.create();

  constraint->Type =     specify;
  constraint->Strength = Strength;
  constraint->Variable.add(Variable_num);
  constraint->Constant = Value;
  constraint->satisfied = 0;	// failed

  constraint->Explain.Type      = 0;
  constraint->Explain.Reference = &explain_list;

}  
// 萔
void  AddConstraint_specify(int Variable_num, float Value, float Strength,
                         int reference_type, int_List *reference_segment){
  constraint_Data* constraint = constraintArray.create();

  constraint->Type =     specify;
  constraint->Strength = Strength;
  constraint->Variable.add(Variable_num);
  constraint->Constant = Value;
  constraint->satisfied = 0;	// failed
	 
  constraint->Explain.Type      = reference_type;
  constraint->Explain.Reference = reference_segment;

  if (constraint->set_strength(Strength) < -1000) 
      constraintArray.remove();
  else if (constraintArray.dual())
      constraintArray.remove();

}  

// Diff p	new_node on old_line
void  AddConstraint_liner1(int Variable0, int Variable1, 
                           float Coefficient0,float Coefficient1 ,
                           float Constant, float Strength,
                         int reference_type, int_List *reference_segment){
  constraint_Data* constraint = constraintArray.create();

  constraint->Type     =    liner;
//  constraint->Strength =    Strength;
  constraint->Variable.add(Variable0);
  constraint->Variable.add(Variable1);
  constraint->Coefficient.add(Coefficient0);
  constraint->Coefficient.add(Coefficient1);
  constraint->Constant = Constant;
  constraint->satisfied = 0;	// failed

  constraint->Explain.Type      = reference_type;
  constraint->Explain.Reference = reference_segment;

  if (constraint->set_strength(Strength) < -1000) 
      constraintArray.remove();
  else if (constraintArray.dual())
      constraintArray.remove();


}  
// slope p	   parallel
void  AddConstraint_liner3(int Variable0,  int Variable1,     int Variable2,     int Variable3,
                           float Coefficient0,  float Coefficient1,float Coefficient2, float Coefficient3,
                           float Constant, float Strength,
                         int reference_type, int_List *reference_segment){

  constraint_Data* constraint = constraintArray.create();

  constraint->Type     =    liner;
  constraint->Strength =    Strength;
  constraint->Variable.add(Variable0);
  constraint->Variable.add(Variable1);
  constraint->Variable.add(Variable2);
  constraint->Variable.add(Variable3);
  constraint->Coefficient.add(Coefficient0);
  constraint->Coefficient.add(Coefficient1);
  constraint->Coefficient.add(Coefficient2);
  constraint->Coefficient.add(Coefficient3);
  constraint->Constant = Constant;
  constraint->satisfied = 0;	// failed

  constraint->Explain.Type      = reference_type;
  constraint->Explain.Reference = reference_segment;

  if (constraint->set_strength(Strength) < -1000) 
      constraintArray.remove();
  else if (constraintArray.dual())
      constraintArray.remove();

}  


void  AddConstraint_online(int x0, int y0,     int x1,     int y1,
                           float x, float y,   
                           float Strength){
  constraint_Data* constraint = constraintArray.create();

  constraint->Type  = on_line;
  constraint->Strength = Strength;
  constraint->Variable.add(x0);
  constraint->Variable.add(y0);
  constraint->Variable.add(x1);
  constraint->Variable.add(y1);
  constraint->Coefficient.add(x);
  constraint->Coefficient.add(y);

  constraint->satisfied = 0;	// failed

  constraint->Explain.Type      = 0;
  constraint->Explain.Reference = &explain_list;

  if (constraint->set_strength(Strength) < -1000) 
      constraintArray.remove();
  else if (constraintArray.dual())
      constraintArray.remove();
}


void ConvertToSegment(Segment_Data* segment){

  //  ňʂɂ m[ḧʒuύXB

  int x0 = 0,
      y0 = 1,
	  x1 = 2,
	  y1 = 3;
  if ((VariableArray.get(x0)->Value	!= VariableArray.get(x1)->Value) ||
      (VariableArray.get(y0)->Value	!= VariableArray.get(y1)->Value)){
    NodeArray.get(segment->start)->X = (VariableArray.get(x0)->Value);
    NodeArray.get(segment->start)->Y = (VariableArray.get(y0)->Value);
    NodeArray.get(segment->end)->X   = (VariableArray.get(x1)->Value);
    NodeArray.get(segment->end)->Y   = (VariableArray.get(y1)->Value);	
  }

}


extern "C" void _export WINAPI SolverTest(){

  constraintArray.clear();
  VariableArray.clear();

  int x0 = VariableArray.create();
  int y0 = VariableArray.create();
  int x1 = VariableArray.create();
  int y1 = VariableArray.create();


  constraint_Data* constraint0 = constraintArray.create();
  constraint_Data* constraint1 = constraintArray.create();
  constraint_Data* constraint2 = constraintArray.create();
  constraint_Data* constraint3 = constraintArray.create();
  constraint_Data* constraint4 = constraintArray.create();
/*
  constraint0->Type = liner;
  constraint0->Value = a;
  constraint0->Variable.add(b);
  constraint0->Coefficient.add(3);
  constraint0->Variable.add(c);
  constraint0->Coefficient.add(2);
  constraint0->Constant = 1;

  constraint1->Type = liner;
  constraint1->Value = b;
  constraint1->Variable.add(c);
  constraint1->Coefficient.add(1);
  constraint1->Constant = 2;
*/


  constraint0->Type  = on_line;
  constraint0->Strength = 10;
  constraint0->Variable.add(x0);
  constraint0->Variable.add(y0);
  constraint0->Variable.add(y1);
  constraint0->Coefficient.add(100);
  constraint0->Coefficient.add(5);




//  constraint0->Type = specify;
//  constraint0->Value = x0;
//  constraint0->Constant = 22;

  constraint1->Type = specify;
  constraint1->Strength = 8;
  constraint1->Constant = 0;

  constraint2->Type = specify;
  constraint2->Strength = 6;
  constraint2->Constant = 2;

  constraint3->Type = specify;
  constraint3->Strength = 4;
  constraint3->Constant = 8;

  constraint4->Type = specify;
  constraint4->Strength = 12;
  constraint4->Constant = 2;


 SolveConstraint();


}


