//Copyright (C) 1998 Takeo Igarashi
//  
void addConstraint_align(int, float,int,int,int_List*);
void addConstraint_start_node(float x, float y,int,int,int_List*);
void addConstraint_end_node(float x, float y,int,int,int_List*);
void addConstraint_congruent(float x, float y,int,int,int_List*);
void addConstraint_start_onLine(float a, float b, float c,int,int,int_List*);
void addConstraint_end_onLine(float a, float b, float c,int,int,int_List*);
void addConstraint_diff_x(float x,int,int,int_List*);
void addConstraint_diff_y(float y,int,int,int_List*);




float max_deformation = 800; //400;

float negrigible_region = 200; // ͒l𖳎͈
const negrigible_angle  = 10;
const ambiguous_region = 800; // Web ɂĉ\Ƃčl͈
const ambiguous_angle = 15;  //7;

class negrigible { // svȓ͒l 
  public:
  int v[4];
  void init(){
    for(int i = 0; i < 4; i++) v[i] = false;
  }
}  negrigible;



const constraint_start_node = 0,// [_v x0 =a, y0 = b
      constraint_end_node   = 1,  // [_v x1 =a, y1 = b
      constraint_congruent  = 2, //  x1-x0 = a, y1-y0 = b
      constraint_align_x0 = 3, 
      constraint_align_x1 = 4,
      constraint_align_y0 = 5,
      constraint_align_y1 = 6,
      constraint_start_onLine = 7, //  a *x0 + b * y0 = c
      constraint_end_onLine = 8,   //  a *x1 + b * y1 = c
      constraint_parallel = 9,	  // t a *x0 + b * y0 = c, a *x1 + b * y1 = c
      constraint_slope = 10,		  // X   a * (x1 - y0) + b* (y1 - y0) = 0
	  constraint_diff_x =11,
	  constraint_diff_y = 12,
	  constraint_pallalel = 13,
	  constraint_align_x = 14,
	  constraint_align_y = 15;

class pool_element{   
  public:
    float     variables[4]; //x0, y0, x1, y1;  ϐZbg m .. -1
	int       flag;
	int_List  history; // vZ̉ߒŎgp
	int_List  suspended; // ҋ@̐

	int_List  child; // 炤܂ꂽ element ̔ԍ

	void set_variables(int a,int b, int c, int d){
	  variables[0] = a; variables[1] = b;
	  variables[2] = c; variables[3] = d;}
	void clear(){
	  for(int i=0; i < 4; i++) variables[i]=-1;
	  history.clear();
	  suspended.clear();
	  child.clear();
	  }
	  
	int equal(pool_element* e){	// 0 not yet 1 different 2 same
	  // e V element 
//	  if ( suspended.size != 0) return 0;
	  for (int i = 0; i < 4; i++){
		if (Abs(e->variables[i] - variables[i]) > 50)
	   	  if (variables[i] == -1) return 0;
	  	  else  return 1;
	  }
	  if (e->suspended.size != suspended.size) return 1;
	  for (i =0 ; i < suspended.size; i++)
	    if (!(suspended.get(i) == e->suspended.get(i))) return 1;
	  return 2;  // ׂēB
	
	}
	int calcurate(int constraint_num);
    int calculate_align(float* x,float c);
    int calculate_on_line(float* x,float* y,float* x1,float* y1, int constraint_num, int constraint_type,   constraint_Data *constraint,float a, float b, float c);
    int calculate_sub(float* x1, float* x0, float coefficient);
	int simultaneous_equation(
                    float a, float b, float c,
                    float aa, float bb, 
                    float* x0, float* y0, float* x1, float* y1);
    int calcurate_cross(
                    float a, float b, float c,
                    float aa, float bb, float cc,
                    float* x, float* y);
	int suspend_check();
	float confidence(){
	  float diff = 0;

	  if ((Abs(variables[0] - variables[2]) < 100) &&
	      (Abs(variables[1] - variables[3]) < 100))
		return 0;
	  for (int i = 0; i < 4; i ++)
	    diff += Abs(variables[i] - OriginalLocation[i]);
	  float score = 0;
	  for (i = 0; i < history.size; i ++){
	    switch (constraintArray.get(history.get(i))
	            ->Type){
	  case constraint_start_node: score += 500; break; 
	  case constraint_end_node: score += 500; break;   
      case constraint_congruent: score += 800; break;  
      case constraint_align_x0: score += 300; break; 
      case constraint_align_x1: score += 300; break;
      case constraint_align_y0: score += 300; break;
      case constraint_align_y1: score += 300; break;
      case constraint_start_onLine: score += 500; break;
      case constraint_end_onLine:   score += 500; break;
      case constraint_parallel:     score += 0; break;
      case constraint_slope:        score += 300; break;
      case constraint_diff_x:       score += 300; break;
      case constraint_diff_y:       score += 300; break;
		   	  }
	  }  
	  return score + 10000 - diff;
	}
	int too_much_deformation(){
	  // ϐ݂ĕωʂ傫 true!
	  for (int i = 0; i < 4; i ++)
	    if ((variables[i] != -1) &&
	        (Abs(variables[i] - OriginalLocation[i])
	         > max_deformation)) return true;
	  return false;
	}
	void negrigible_check(){
	  // for (int i = 0; i < 4; i ++)
	  //  if (variables[i] == -1) return;
	  // m肵lɂ
	  // ͒lɋ߂̂ true
	  for (int i = 0; i < 4; i ++)
	    if ((variables[i] != -1) && 
	        (Abs(variables[i] - OriginalLocation[i]))
	         < negrigible_region) 
		   negrigible.v[i] = true;
	  return;
	} 
	 
};

int pool_element::calcurate(int constraint_num){
	  // vZ݂B-> 0A1suspend, 2dA3
	  // ʂ B
	
	  /*  explain ̂ƂlƂ܂̂ł߂ƂB
      //  ܂ׂ ^Cv 炩ɂ܂̂ł炩߃`FbN
	  for (int i = 0; i < history.size; i++)
	    if (constraintArray.get(i)->Type == type) return 3;
	  */
    
  int result,i,x,y;  // conmgruent p
      
float*  x0 = variables;
float*  y0 = variables+1;
float*  x1 = variables+2;
float*  y1 = variables+3;

  constraint_Data *constraint, *constraint2;
  constraint = constraintArray.get(constraint_num);

  switch (constraint->Type) {
    case constraint_start_node:// [_v x0 =a, y0 = b
	  if (   (*x0 == constraint->Coefficient.get(0))
	      && (*y0 == constraint->Coefficient.get(1))) 
	    return 2;
	  if ( (( *x0 == -1 ) || (*x0 == constraint->Coefficient.get(0)))
	    && (( *y0 == -1 ) || (*y0 == constraint->Coefficient.get(1)))){
	    *x0 = constraint->Coefficient.get(0);
	    *y0 = constraint->Coefficient.get(1);
		return 0;}
	  return 3;
    case constraint_end_node:  // [_v x1 =a, y1 = b
	  if (   (*x1 == constraint->Coefficient.get(0))
	      && (*y1 == constraint->Coefficient.get(1))) 
	    return 2;
	  if ( (( *x1 == -1 ) || (*x1 == constraint->Coefficient.get(0)))
	    && (( *y1 == -1 ) || (*y1 == constraint->Coefficient.get(1)))){
	    *x1 = constraint->Coefficient.get(0);
	    *y1 = constraint->Coefficient.get(1);
		return 0;}
	  return 3;
	case constraint_align_x0:  
	  return calculate_align(x0, constraint->Constant);
	case constraint_align_x1:
	  return calculate_align(x1, constraint->Constant);
	case constraint_align_y0:
  	  return calculate_align(y0, constraint->Constant);
	case constraint_align_y1:
	  return calculate_align(y1, constraint->Constant);
    case constraint_align_x:
	  x = calculate_align(x0, constraint->Constant);
	  y = calculate_align(x1, constraint->Constant);
	  // 0A1suspend, 2dA3
	  if ((x == 3) || (y == 3)) return 3;
	  if ((x == 2) && (y == 2)) return 2;
	  if ((x == 1) || (y == 1)) return 1;
	  return 0;
    case constraint_align_y:
	  x = calculate_align(y0, constraint->Constant);
	  y = calculate_align(y1, constraint->Constant);
	  // 0A1suspend, 2dA3
	  if ((x == 3) || (y == 3)) return 3;
	  if ((x == 2) && (y == 2)) return 2;
	  if ((x == 1) || (y == 1)) return 1;
	  return 0;



	case constraint_diff_x:
	  return calculate_sub(x1,x0,constraint->Constant);
	case constraint_diff_y:
	  return calculate_sub(y1,y0,constraint->Constant);
	case constraint_congruent: //  x1-x0 = a, y1-y0 = b
	  x = calculate_sub(x1,x0,constraint->Coefficient.get(0));
	  y = calculate_sub(y1,y0,constraint->Coefficient.get(1));
	  // 0A1suspend, 2dA3
	  if ((x == 3) || (y == 3)) return 3;
	  if ((x == 2) && (y == 2)) return 2;
	  if ((x == 1) || (y == 1)) return 1;
	  return 0;

	case constraint_start_onLine: //  a *x0 + b * y0 = c
      return calculate_on_line( x0,y0,x1,y1, 
                                constraint_num,constraint_start_onLine,constraint,
		 	                    constraint->Coefficient.get(0),constraint->Coefficient.get(1),constraint->Constant);
	case constraint_end_onLine:   //  a *x1 + b * y1 = c
      return calculate_on_line( x1,y1,x0,y0, 
                                constraint_num,constraint_end_onLine,constraint,
			                    constraint->Coefficient.get(0),constraint->Coefficient.get(1),constraint->Constant);
	case constraint_pallalel:
	  x = calculate_on_line( x0,y0,x1,y1, constraint_num,constraint_start_onLine,constraint,
			                 constraint->Coefficient.get(0),constraint->Coefficient.get(1),constraint->Constant);
	  y = calculate_on_line( x1,y1,x0,y0, constraint_num,constraint_end_onLine,constraint,
			                 constraint->Coefficient.get(0),constraint->Coefficient.get(1),constraint->Constant);
	  // 0A1suspend, 2dA3
	  if ((x == 3) || (y == 3)) return 3;
	  if ((x == 2) && (y == 2)) return 2;
	  if ((x == 1) || (y == 1)) return 1;
	  return 0;


	case constraint_slope:		  // X   a * (x1 - x0) + b* (y1 - y0) = 0
	  // 0A1suspend, 2dA3
	  if ((*x0 == -1) && ( *x1 != -1 )  && ( *y0 != -1 )  && ( *y1 != -1 )){
	    *x0 =  (*x1 + constraint->Coefficient.get(1) * (*y1 - *y0) 
		         /  constraint->Coefficient.get(0));
		return 0;}
	  if ((*x0 != -1) && ( *x1 == -1 )  && ( *y0 != -1 )  && ( *y1 != -1 )){
	    *x1 =  (*x0 - constraint->Coefficient.get(1) * (*y1 - *y0) 
		         /  constraint->Coefficient.get(0));
		return 0;}
	  if ((*x0 != -1) && ( *x1 != -1 )  && ( *y0 == -1 )  && ( *y1 != -1 )){
	    *y0 =  (*y1 + constraint->Coefficient.get(0) * (*x1 - *x0) 
		         /  constraint->Coefficient.get(1));
		return 0;}
	  if ((*x0 != -1) && ( *x1 != -1 )  && ( *y0 != -1 )  && ( *y1 == -1 )){
	    *y1 =  (*y0 - constraint->Coefficient.get(0) * (*x1 - *x0) 
		         /  constraint->Coefficient.get(1));
		return 0;}
	  if ((*x0 != -1) && ( *x1 != -1 )  && ( *y0 != -1 )  && ( *y1 != -1 )){
	    if ((constraint->Coefficient.get(1) * (*y1 - *y0) 
	       + constraint->Coefficient.get(0) * (*x1 - *x0)) < 100)
	      return 2;
	    else
	      return 3;}
	  //  A     
	  if ((*x0 == -1) && ( *y0 == -1 )  && ( *x1 != -1 )  && ( *y1 != -1 )) {
		  for (i = 0; i < suspended.size; i++)			
		    if ((constraint2 = constraintArray.get(suspended.get(i)))->Type  
	    		== constraint_start_onLine){
			   result = simultaneous_equation(
			             constraint2->Coefficient.get(0),
						 constraint2->Coefficient.get(1),
						 constraint2->Constant,
						 constraint->Coefficient.get(0),
						 constraint->Coefficient.get(1),
						 x0, y0, x1, y1);
			   if (result == 0){ 
			     history.add(i);
			     suspended.remove_by_index(i);}
			   return result;  // 0 or 3
	         }
		  return 1; // suspend
		  }
	  if ((*x0 != -1) && ( *y0 != -1 )  && ( *x1 == -1 )  && ( *y1 == -1 )) {
		  for (i = 0; i < suspended.size; i++)			
		    if ((constraint2 = constraintArray.get(suspended.get(i)))->Type  
	    		== constraint_end_onLine){
			   result = simultaneous_equation(
			             constraint2->Coefficient.get(0),
						 constraint2->Coefficient.get(1),
						 constraint2->Constant,
						 constraint->Coefficient.get(0),
						 constraint->Coefficient.get(1),
						 x1, y1, x0, y0);
			   if (result == 0){ 
			     history.add(i);
			     suspended.remove_by_index(i);}
			   return result;  // 0 or 3
	         }
		  return 1; // suspend
		  }
     return 1;    // dammy

  }
  return 3;
	  
}	
int pool_element::calculate_align(float* x,float c){
	  if (*x == c) return 2;
	  if (*x == -1 ){
	      *x = c; return 0;}
	  return 3;
}
  
int pool_element::calculate_on_line(float* x,float* y,float* x1,float* y1, 
                                    int constraint_num, int constraint_type,   
                                    constraint_Data *constraint,
                                    float a, float b, float c){
	  // ŝ߂ sub
	  // 0A1suspend, 2dA3
	  int i,result;
      constraint_Data  *constraint2;
	  if ((*x == -1 ) && (*y == -1)){
		  // AցB
		  for (i = 0; i < suspended.size; i++)	
/*		    if (((constraint2 = constraintArray.get(suspended.get(i)))->Type  
	    		 == constraint_slope) &&
	    		(*x1 != -1 ) && (*y1 != -1)) {
			   result = simultaneous_equation(
			             a,b,c,
						 constraint2->Coefficient.get(0),
						 constraint2->Coefficient.get(1),
						 x, y, x1, y1);
			   if (result == 0){ 
			     history.add(i);
			     suspended.remove_by_index(i);}
			   return result;  // 0 or 3
	         }
			 else
*/			  if (( (constraint2 = constraintArray.get(suspended.get(i)))->Type   == constraint_type) &&
			          (suspended.get(i) != constraint_num)){
			   result = calcurate_cross(
   			             a,b,c,
						 constraint2->Coefficient.get(0),
						 constraint2->Coefficient.get(1),
						 constraint2->Constant,
						 x, y);
			   if (result == 0){ 
			     history.add(i);
			     suspended.remove_by_index(i);}
			   return result;  // 0 or 3
	         }
			              
		return 1; // A Ȃ̂ suspend
	 }
	 if (*x == -1 ) {
	   *x = ((c - *y * b)
	        / a);
	   return 0;}
	 if (*y == -1 ) {
	   *y = ((c - *x * a)
	        / b);
	   return 0;}
	 if (Abs(*x * a + *y * b - c) < 2500)
	    return 2;
	 return 3;    
}



int pool_element::calculate_sub(float* x1,float* x0, float constant){
	  // ̂߂ sub
	  // 0A1suspend, 2dA3
	  if ((*x0 == -1 ) && (*x1 == -1)) return 1;
	  if (Abs(*x1 - *x0 - constant) < 10) return 2;
	  if (*x0 == -1 ){
		  *x0 = *x1 - constant;
		  return 0;
	  }
	  else{
	    if (*x1 == -1){
		  *x1 = *x0 + constant;	     
	      return 0;
		}
		else return 3; 
	  }
	  return 3;  // dammy
}
	  

int pool_element::simultaneous_equation(
                    float a, float b, float c,
                    float aa, float bb, 
                    float* x0, float* y0, float* x1, float* y1){
  // A
			   // a * x0 + b * y0 = c				  
			   // aa * (x1 - x0) + bb * (y1 - y0)	= 0	
			   // aa * x0 + bb * y0 = aa * x1 + bb * y1 
  float diameter = a * bb - b * aa;
  if (Abs(diameter) < 1) return 3;  // !
  float	   tmp = *x1 * aa + *y1 * bb;
	
  *x0 = (( -b * tmp + bb * c ) / diameter);			   
  *y0 = ((  a * tmp - aa * c ) / diameter);

  return 0;
}
int pool_element::calcurate_cross(
                    float a, float b, float c,
                    float aa, float bb, float cc,
                    float* x, float* y){
  // A
  // a * x + b * y = c
  // aa* x + bb* y = cc

  float diameter = a * bb - aa * b;
  if (diameter == 0) return 3; // s ƂȂ

  *x = (( c * bb - cc * b ) / diameter);
  *y = (( cc * a - c * aa ) / diameter);
  return 0;
}


int pool_element::suspend_check(){
  // KpAsuspend ̒g`FbN
  // KvȂ`d 0B  abort 3(KvȌ͊mۂĂ̂ňS)
  int result;
  for (int i = 0; i < suspended.size ; i++){
  // vZĂ݂B-> 0A1suspend, 2dA3
    result = calcurate(suspended.get(i)); 
    if (result == 3) return true; // !!
	if (result == 2)
	   {history.add(suspended.get(i));	  // ЂƂgp
	    suspended.remove_by_index(i--);} //Â̂Œ
	else if (result == 0)
	   {history.add(suspended.get(i));	  // ЂƂgp
	    suspended.remove_by_index(i);
	    i = -1;} //l̂ł͂߂蒼

//	if (result == 1) ;
  }
  return false;  // I
}	    

                                                           






class pool {													
  public:
    pool_element element[400];
	int max_element;
   
    void clear(){
	  for(int i = 0; i <= max_element; i++)
	    element[i].clear();
	  // ˂^ĂB
	  max_element =1;  
	  element[0].clear();
	  element[0].variables[0] = -1;
	  element[0].variables[1] = -1;
	  element[0].variables[2] = -1;
	  element[0].variables[3] = -1;

	}

	int new_element(){
	  if (max_element == 399) return 0;
	  element[max_element].clear();
	  return max_element++;}
	void remove_element(int num){
	  element[num].clear();//!! Ō̂ȂƃoO
	  max_element--;}
	void element_copy(int master, int copy){
	  element[copy] = element[master];
	  element[copy].child.clear();
	  }   // ???? ł܂͂  child ́H
	
	void generate_candidates();

	void print();
	void Solve();
	void AddConstraintToPool(int constraint_num);
    void AddConstraintToPool_Sub(int current_element, int constraint_num);
	int AddConstraintToElement(int element_num,
	                            int constraint_num);

    int SearchElement(int root,int element_num){
	// suspend ܂ Ԃ element 邩`FbNB
	// ؂΂\	
	// equal ..  0 not yet,  1 definitely different, 2 definitely same
	  int i;
	  switch  (element[root].equal(&element[element_num])) {
		case 2:
		 return true;
	    case 0: 
	      for (i = 0; i < element[root].child.size; i++)
	        if (SearchElement(element[root].child.get(i), element_num))	
		       return true;
		
		}
	  return false;

//	  for (int i =0; i < element_num; i++)
//	    if (element[i].equal(&element[element_num])) return true;
//	  return false;
	}
	
} pool;





void pool::Solve (){

//   Constraint Solver
//     Variable Set Ȃ Pool  p
//     ɂƂ肾 Pool ̒
//               ꂼɓKpĂB
//      ܂ ƋɒǉB
//      ׂĂ̕ϐ݂ΏI
//       LZ
//      ɓ̐񂪂ΖB
//      Pool ɂłɂ΂
//               ǉăLZB
//      (TƂroot؂ǂ)
   clear();

   negrigible.init();  // S false  ɃZbgB
                       // vŽʁA͒lɋ߂̂łĂ true.

   max_deformation = OriginalLength / 8 + 20 ;
   negrigible_region = max_deformation *2/3 + 10;

   for (int i = 0; i < constraintArray.size(); i++){
     AddConstraintToPool(i);   // constraintArray.get_next());
   if (max_element > 200) {
     i=constraintArray.size()-1;break; }
  }

  // ʂ萧݂ŁAKvȒloĂȂ
  // ͒ltB

  if (negrigible.v[0] == false){
    addConstraint_align(constraint_align_x0,OriginalLocation[0],0,0,0);
    AddConstraintToPool(constraintArray.size()-1);   
  }	
  if (negrigible.v[1] == false){
    addConstraint_align(constraint_align_y0,OriginalLocation[1],0,0,0);
    AddConstraintToPool(constraintArray.size()-1);   
  }	
  if (negrigible.v[2] == false){
    addConstraint_align(constraint_align_x1, OriginalLocation[2],0,0,0);
    AddConstraintToPool(constraintArray.size()-1);   
  }	
  if (negrigible.v[3] == false){
    addConstraint_align(constraint_align_y1, OriginalLocation[3],0,0,0);
    AddConstraintToPool(constraintArray.size()-1);   
  }	

}

void pool::AddConstraintToPool(int constraint_num){
  // pool  ЂƂ ǉ
  //   ׂĂ element ɐĂ݂ poolLB

  constraint_Data *constraint;
  int pool_size, i;

  constraint = constraintArray.get(constraint_num);

//  pool_size = max_element;  // vZJn pool size (rłǂǂ̂)
//  clear_flag();      // ʂȌvZh߂ flag 



  // pool_element ̒Ttree gČIɁB
  AddConstraintToPool_Sub(0, constraint_num);   // root T
}

  
void pool::AddConstraintToPool_Sub(int current_element, int constraint_num){
  int_List  child_list = element[current_element].child;  // rłǂǂӂ̂ ԂۑĂB
  int i;

  if (AddConstraintToElement(current_element, constraint_num)){
	    for (i=0;i<child_list.size;i++){
		  current_element = child_list.get(i);
          AddConstraintToPool_Sub(current_element, constraint_num);    // root T
		}
	}
}


int pool::AddConstraintToElement(int element_num, int constraint_num){
  // element ɐǉĎqǂB
  int x0, y0, x1, y1;

  // ܂ ČvZB ܂  2,3(break -> return false)
  //                   Ȃ     ̂܂ 0,1(return true)
  int new_element_num = new_element();
  if (new_element == 0) return false;
  element_copy(element_num, new_element_num);


   int tmp;

  // vZĂ݂B-> 0A1suspend, 2dA3
  int result = element[new_element_num]
                 .calcurate(constraint_num); 
  switch (result) {
    case 0:	 // ̂łPpoolɉB

	  // ܂ suspend ƖȂ`FbN
	  // true Ȃ疵̂ 
	  if (element[new_element_num].suspend_check()) break; // 

	  //܂Al̕ωʂ傫Ȃ`FbNB
	  if (element[new_element_num].too_much_deformation()) break;

	  //  ̂ pool ɂ邩ׂB
//	  if ((element[new_element_num].suspended.size == 0) &&
	  if ((SearchElement(0,new_element_num)) ) break;
	     // ܂肨Ȃ̂𔭌!!	  邩@@
		 // element[tmp].history.add(constraint_num); 
		 // ŏĂ̂ ȂɂȂĂ悢
	  else { // ׂẴ`FbNpX
	    element[new_element_num].history.add(constraint_num);
		element[new_element_num].negrigible_check();
        element[element_num].child.add(new_element_num);
	    return true;	// add!
	  }
    case 1:   // suspend
	  element[new_element_num].suspended.add(constraint_num);
      element[element_num].child.add(new_element_num);
	  return true;  // add!
	case 2:  // d	  explain Bȍ~̖ʂȌvZh
	  element[element_num].history.add(constraint_num);
	  break;  //remove
	case 3:	  //    ȂB
	  break;  //remove
  }

  // break łɂB -> element 
  remove_element(new_element_num);
  return false;  
}  
  
                     

void pool::print(){
  int j;
  console.add(constraintArray.size());
  console.add(max_element);
  console.add(-1);

  for (int i = 0; i < max_element ; i++){
    for(j = 0; j < 4; j++)
      console.add(element[i].variables[j] + 1);
   for(j = 0; j < element[i].history.size; j++)
      console.add(element[i].history.get(j));
   console.add(-1);
  }
}






  											   

void addConstraint_align(int constraint_type, float val,
         					int reference_type, 
         					int reference_ref,
         					int_List *reference_reference){
  constraint_Data* constraint = constraintArray.create();

  constraint->Type = constraint_type;
  constraint->Constant = val;

  constraint->Explain.Type      = reference_type;
  constraint->Explain.Ref       = reference_ref;
  constraint->Explain.Reference = reference_reference;

  console.add(1000+constraint_type);  	// 1003-1006
  console.add(val);
  console.add(-1);

}

void addConstraint_start_node(float x, float y,
         					int reference_type, 
         					int reference_ref,
         					int_List *reference_reference){
  constraint_Data* constraint = constraintArray.create();

  constraint->Type = constraint_start_node;
  constraint->Coefficient.add(x);
  constraint->Coefficient.add(y);


  constraint->Explain.Type      = reference_type;
  constraint->Explain.Ref       = reference_ref;
  constraint->Explain.Reference = reference_reference;

  console.add(1000);
  console.add(x);
  console.add(y);
  console.add(-1);
}

void addConstraint_end_node(float x, float y,
         					int reference_type, 
         					int reference_ref,
         					int_List *reference_reference){
  constraint_Data* constraint = constraintArray.create();

  constraint->Type = constraint_end_node;
  constraint->Coefficient.add(x);
  constraint->Coefficient.add(y);


  constraint->Explain.Type      = reference_type;
  constraint->Explain.Ref       = reference_ref;
  constraint->Explain.Reference = reference_reference;

  console.add(1001);
  console.add(x);
  console.add(y);
  console.add(-1);
}

void addConstraint_congruent(float x, float y,
         					int reference_type, 
         					int reference_ref,
         					int_List *reference_reference){
  // ܂ d
//  for (int i = 0; i < constraintArray.size(); i++)
//    if ((constraintArray.get(i)->Type == constraint_congruent) &&
//		(Abs(constraintArray.get(i)->Coefficient.get(0) - x) < 10) &&
//		(Abs(constraintArray.get(i)->Coefficient.get(1) - y) < 10))
//	   return;



  constraint_Data* constraint = constraintArray.create();

  constraint->Type = constraint_congruent;
  constraint->Coefficient.add(x);
  constraint->Coefficient.add(y);


  constraint->Explain.Type      = reference_type;
  constraint->Explain.Ref       = reference_ref;
  constraint->Explain.Reference = reference_reference;

  console.add(1002);
  console.add(x);
  console.add(y);
  console.add(-1);

} 
void addConstraint_slope(float a, float b,
         					int reference_type, 
         					int reference_ref,
         					int_List *reference_reference){
  constraint_Data* constraint = constraintArray.create();

  constraint->Type = constraint_slope;
  constraint->Coefficient.add(a);
  constraint->Coefficient.add(b);

  constraint->Explain.Type      = reference_type;
  constraint->Explain.Ref       = reference_ref;
  constraint->Explain.Reference = reference_reference;

  console.add(1010);
  console.add(a);
  console.add(b);
  console.add(-1);

}



void addConstraint_start_onLine(float a, float b, float c,
         					int reference_type, 
         					int reference_ref,
         					int_List *reference_reference){
  constraint_Data* constraint = constraintArray.create();

  constraint->Type = constraint_start_onLine;
  constraint->Coefficient.add(a);
  constraint->Coefficient.add(b);
  constraint->Constant=c;


  constraint->Explain.Type      = reference_type;
  constraint->Explain.Ref       = reference_ref;
  constraint->Explain.Reference = reference_reference;

  console.add(1007);
  console.add(a);
  console.add(b);
  console.add(c);
  console.add(-1);

}
void addConstraint_end_onLine(float a, float b, float c,
         					int reference_type, 
         					int reference_ref,
         					int_List *reference_reference){
  constraint_Data* constraint = constraintArray.create();

  constraint->Type = constraint_end_onLine;
  constraint->Coefficient.add(a);
  constraint->Coefficient.add(b);
  constraint->Constant=c;

  constraint->Explain.Type      = reference_type;
  constraint->Explain.Ref       = reference_ref;
  constraint->Explain.Reference = reference_reference;

  console.add(1008);
  console.add(a);
  console.add(b);
  console.add(c);
  console.add(-1);
}
void addConstraint_pallalel(float a, float b, float c,
         					int reference_type, 
         					int reference_ref,
         					int_List *reference_reference){
  for (int i = 0; i < constraintArray.size(); i++)
    if ((constraintArray.get(i)->Type == constraint_pallalel) &&
		(Abs(constraintArray.get(i)->Constant / constraintArray.get(i)->Coefficient.get(0) - c / a) < 50) &&
		(Abs(constraintArray.get(i)->Constant / constraintArray.get(i)->Coefficient.get(1) - c / b) < 50))
	   return;


  constraint_Data* constraint = constraintArray.create();

  constraint->Type = constraint_pallalel;
  constraint->Coefficient.add(a);
  constraint->Coefficient.add(b);
  constraint->Constant = c;

  constraint->Explain.Type      = reference_type;
  constraint->Explain.Ref       = reference_ref;
  constraint->Explain.Reference = reference_reference;

  console.add(1009);
  console.add(a);
  console.add(b);
  console.add(c);
  console.add(-1);

}

void addConstraint_diff_x(float x,
         					int reference_type, 
         					int reference_ref,
         					int_List *reference_reference){
  constraint_Data* constraint = constraintArray.create();
  constraint->Type = constraint_diff_x;
  constraint->Constant=x;

  constraint->Explain.Type      = reference_type;
  constraint->Explain.Ref       = reference_ref;
  constraint->Explain.Reference = reference_reference;

  console.add(1011);
  console.add(x);
  console.add(-1);

} 


void addConstraint_diff_y(float y,
         					int reference_type, 
         					int reference_ref,
         					int_List *reference_reference){
  constraint_Data* constraint = constraintArray.create();
  constraint->Type = constraint_diff_y;
  constraint->Constant=y;

  constraint->Explain.Type      = reference_type;
  constraint->Explain.Ref       = reference_ref;
  constraint->Explain.Reference = reference_reference;

  console.add(1012);
  console.add(y);
  console.add(-1);
} 


extern "C" void _export WINAPI NewSolverTest(){

  constraintArray.clear();
/*
  addConstraint_start_node(100, 200);
  addConstraint_slope(100, -100);
  addConstraint_align_x1(400);
  
  addConstraint_end_onLine(1,1,500);
  addConstraint_end_onLine(1,-1,100);



  console.clear();

  pool.Solve();  
  pool.print();
*/	   
}
