//  Copyright (C) 1998 Takeo Igarashi
//  segment 1̐`

void  WebAdjust(Segment_Data* segment, float speed);
void  SegmentAdjust(Segment_Data* segment, Front_Object_Data* object, float speed);
void onSegment(int x, int y, 
               Segment_Data* segment,
               float parallel_width, float strength,
               int reference_type, int_List *reference_segment);
void onSegment2(Segment_Data* segment,Node_Data* node);

void TouchSegment(Segment_Data* new_segment, Front_Object_Data *object, float speed);

/* 
   ̋
     Web Diff   
	     allowance = speed * 1.8;          // lׂ̕ 
         angle_allowance = speed / 40;     // 80 - 400 -> 2 - 10
		 200 + allowance - diff;  (200 ... 400)
	 slope
	     300 + angle_allowance - diff;  ( 300 ... 310)
	 Stay
	     80
     Touch
	     600 - distance;  (400 - 600)

*/



void  SegmentAdjust(Segment_Data* segment, Front_Object_Data* object, float speed){

  console.clear();

  TouchSegment(segment, object, speed);
  WebAdjust(segment, speed);
}







int get_cross_node( Segment_Data* segment0,  Segment_Data* segment1, 
                    Node_Data* result){

  //   0 ƌ_    
  //   1 _Ȃ   s v
  //   2 _Ȃ	꒼

  Node_Data *line1s, 
            *line1e, 
            *line2s,
            *line2e;
  line1s = NodeArray.get(segment0->start); 
  line1e = NodeArray.get(segment0->end); 
  line2s = NodeArray.get(segment1->start); 
  line2e = NodeArray.get(segment1->end);
 
            

  float a0, b0, c0,
        a1, b1, c1; 

  a0 = line1s->Y - line1e->Y;
  b0 = line1e->X - line1s->X;
  c0 = line1e->Y * line1s->X - line1e->X * line1s->Y;

  a1 = line2s->Y - line2e->Y;
  b1 = line2e->X - line2s->X;
  c1 = line2e->Y * line2s->X - line2e->X * line2s->Y;
  
  //   sin^2
//  if (Abs(a0 * b1 - a1 * b0) < 2500 ){
  if (Sqr(a0 * b1 - a1 * b0)/(a0*a0+b0*b0)/(a1*a1+b1*b1) < 0.001 ){
    result->X = line1s->X ;
    result->Y = line1s->Y ;
	if (Abs(a1 * c0 - a0 * c1) < 2500){
	  return 2;}	 // _Ȃ	꒼
	else {
      return 1;}	//  _Ȃ   s v
  }
  else{
    result->X = ((b0 * c1 - b1 * c0)/(a0 * b1 - a1 * b0)) ;
    result->Y = ((a0 * c1 - a1 * c0)/(a1 * b0 - a0 * b1));
	return 0;
  }

}

int same_line( Segment_Data* segment0,  Segment_Data* segment1){
  //   true	꒼

  Node_Data *line1s, 
            *line1e, 
            *line2s,
            *line2e;
  line1s = NodeArray.get(segment0->start); 
  line1e = NodeArray.get(segment0->end); 
  line2s = NodeArray.get(segment1->start); 
  line2e = NodeArray.get(segment1->end);
 
  float a0, b0, c0,
        a1, b1, c1; 

  a0 = line1s->Y - line1e->Y;
  b0 = line1e->X - line1s->X;
  c0 = line1e->Y * line1s->X - line1e->X * line1s->Y;

  a1 = line2s->Y - line2e->Y;
  b1 = line2e->X - line2s->X;
  c1 = line2e->Y * line2s->X - line2e->X * line2s->Y;

// console.add(a0 * b1 - a1 * b0);
// console.add(-1);  
// console.add(a0 * c1 - a1 * c0);
// console.add(-1);  
  //  a0 : a1 = b0 : b1
  if (//(Abs(a0 * b1 - a1 * b0) < 100000) &&  // 덷
      (Sqr(a0 * b1 - a1 * b0)/(a0*a0+b0*b0)/(a1*a1+b1*b1) < 0.001 ) &&
      (Abs(b1 * c0 - b0 * c1) < 100000) &&
	  (Abs(a1 * c0 - a0 * c1) < 100000)) {
	  return true;}	 // ꒼
	else {
      return false;}	//  v
}




void onSegment(int x, int y, 
               Segment_Data* segment,
               float parallel_width, float strength,
               int ref_type, int ref_num){
  // x,y (new_segment)  old_segment ɏ悤ɐB

  float x0 = NodeArray.get(segment->start)->X;
  float y0 = NodeArray.get(segment->start)->Y;
  float x1 = NodeArray.get(segment->end)->X;
  float y1 = NodeArray.get(segment->end)->Y;
  
  
  if (y0 == y1) 
   	if (x == 0)  // start point
	  addConstraint_align(constraint_align_y0, y0 - sign(x1-x0)*parallel_width,
	                         ref_type,ref_num,0);
	else
	  addConstraint_align(constraint_align_y1, y1 + sign(x1-x0)*parallel_width,
	                         ref_type,ref_num,0);

//	if (x1 > x0) AddConstraint_specify(y, y0 - parallel_width, strength, reference_type, reference_segment);
//	        else AddConstraint_specify(y, y0 + parallel_width, strength, reference_type, reference_segment);
  
  else if (x0 == x1) 
    if (x == 0)	 // start point
	  addConstraint_align(constraint_align_x0, x0 + sign(y1-y0)*parallel_width,
	                         ref_type,ref_num,0);
	else
	  addConstraint_align(constraint_align_x1, x1 - sign(y1-y0)*parallel_width,
	                         ref_type,ref_num,0);

//    if (y1 > y0) AddConstraint_specify(x, x0 + parallel_width, strength, reference_type, reference_segment);
//	        else AddConstraint_specify(x, x0 - parallel_width, strength, reference_type, reference_segment);
  
  else {
   	  float a =   y1-  y0;
 	  float b =   x0 - x1;
	  double c = x0 * y1 - y0 * x1;
	  c = c + parallel_width * sqrt(a * a + b * b);
	  
	  if (x == 0)
	    addConstraint_start_onLine(a,b,c,ref_type,ref_num,0);
	  else
   	    addConstraint_end_onLine(a,b,c,ref_type,ref_num,0);

//      AddConstraint_liner1(x, y, a, b, c , strength, reference_type, reference_segment);
 }

  //_֋߂̐Ă sameline ł̂Œ
//  AddConstraint_specify(x, cross_node.X, 700 - distance, 0,0);  
//  AddConstraint_specify(y, cross_node.Y, 700 - distance, 0,0);  

}

void set_pallalel(Segment_Data* segment,
               float parallel_width, 
               int ref_type, int ref_num){
  // x,y (new_segment)  old_segment ɏ悤ɐB

  float x0 = NodeArray.get(segment->start)->X;
  float y0 = NodeArray.get(segment->start)->Y;
  float x1 = NodeArray.get(segment->end)->X;
  float y1 = NodeArray.get(segment->end)->Y;
  
  
  if (y0 == y1) {
	  addConstraint_align(constraint_align_y, y0 - sign(x1-x0)*parallel_width,
	                        ref_type,ref_num,0);
//	  addConstraint_align_y0(y0 - sign(x1-x0)*parallel_width,
//	                         ref_type,ref_num,0);
//	  addConstraint_align_y1(y1 + sign(x1-x0)*parallel_width,
//	                         ref_type,ref_num,0);

  }
  else if (x0 == x1) {
	  addConstraint_align(constraint_align_x,x0 + sign(y1-y0)*parallel_width,
	                        ref_type,ref_num,0);
//	  addConstraint_align_x0(x0 + sign(y1-y0)*parallel_width,
//	                         ref_type,ref_num,0);
//	  addConstraint_align_x1(x1 - sign(y1-y0)*parallel_width,
//	                         ref_type,ref_num,0);

  }
  else {
   	  float a =   y1-  y0;
 	  float b =   x0 - x1;
	  double c = x0 * y1 - y0 * x1;
	  c = c + parallel_width * sqrt(a * a + b * b);
	  
	    addConstraint_pallalel(a,b,c,ref_type,ref_num,0);
 }

}


/*
void onSegment2(Segment_Data* segment,
                               Node_Data* node){
  // new_segment  cross_node ʂ悤ɐB

  int   x0 = 0,  y0 = 1,  x1 = 2, y1 = 3;

  float x = node->X;
  float y = node->Y;

  float x0_ = NodeArray.get(segment->start)->X;
  float y0_ = NodeArray.get(segment->start)->Y;
  float x1_ = NodeArray.get(segment->end)->X;
  float y1_ = NodeArray.get(segment->end)->Y;

  AddConstraint_online(  x0,  y0, x1,  y1, x,  y,  0);

 //_
 if ((( x - (x0_ * 0.6 + x1_ * 0.4)) *
      ( x - (x0_ * 0.4 + x1_ * 0.6))) < 0){
   AddConstraint_liner1(x0, x1, 1, 1, 2 * x, 0, 0,0);
  }
 if ((( y - (y0_ * 0.6 + y1_ * 0.4)) *
      ( y - (y0_ * 0.4 + y1_ * 0.6))) < 0){
   AddConstraint_liner1(y0, y1, 1, 1, 2 * y, 0, 0,0);
  }


}                                      
*/                                      

//  [_̐ڑ   ߂ɂB
void node_identical(Node_Data* node, Node_Data* new_node, int x, int y, float speed,
               int ref_type, int ref_num){
	//Explain ɂāA@2@ɖȂƈӖȂB
	//̃`FbNʓ|Ȃ̂łƂ肠pX


   float allowance = speed * 1.8;   // lׂ̕ 
  
   float dist = get_distance( node , new_node);

   if (dist > allowance) return;

   if (x == 0)
     addConstraint_start_node(node->X, node->Y, ref_type,ref_num,0);
   else
     addConstraint_end_node(node->X, node->Y, ref_type,ref_num,0);

}

int_List congruent_explain;

void TouchSegment(Segment_Data* new_segment, Front_Object_Data *object, float speed){
  int x0 = 0,
      y0 = 1,
	  x1 = 2,
	  y1 = 3;

  // SZOg̃T[`@@@ڐG@A@etc
  // 
  //
  int old_segment_num;
  Segment_Data* old_segment;
  Node_Data cross_node;
  int relation;
  float distance = 100;
  float parallel_width;
 
  float xdiff = NodeArray.get(new_segment->end)->X -
				NodeArray.get(new_segment->start)->X;
  float ydiff = NodeArray.get(new_segment->end)->Y -
				NodeArray.get(new_segment->start)->Y;
  float old_xdiff, old_ydiff;

  float congruent_x, congruent_y, congruent_min = 1000, tmp;
  int congruent_num;

  for (List_Index i = 0 ; i <= object->size() - 1; i++){
	old_segment_num = object->get(i);
    old_segment = SegmentArray.get(old_segment_num);  //old

	  // o
	  // ł [_ڑ ƓlA[KvB
      old_xdiff = Abs(NodeArray.get(old_segment->end)->X -
				      NodeArray.get(old_segment->start)->X);
      old_ydiff = Abs(NodeArray.get(old_segment->end)->Y -
				      NodeArray.get(old_segment->start)->Y);
	  if ((tmp =   Abs(Abs(xdiff) - old_xdiff) 
	  	         + Abs(Abs(ydiff) - old_ydiff)) 
	  	   < (congruent_min + 10) ){
		  if (tmp > congruent_min -10)
		    // Ȃ̂ XgɉB
		    congruent_explain.add(old_segment_num);
		  else{
		    congruent_explain.clear();
		    congruent_explain.add(old_segment_num);
		    congruent_num = old_segment_num;
		    congruent_x = sign(xdiff)*old_xdiff;
		    congruent_y = sign(ydiff)*old_ydiff;
		    congruent_min = tmp;}}
	  else if ((tmp =   Abs(Abs(xdiff) - old_ydiff) 
	  	              + Abs(Abs(ydiff) - old_xdiff)) 
	  	   < (congruent_min+50) ){
		  if (tmp > congruent_min -50)
		    // Ȃ̂ XgɉB
		    congruent_explain.add(old_segment_num);
		  else{
		    congruent_explain.clear();
		    congruent_explain.add(old_segment_num);
		    congruent_num = old_segment_num;
		    congruent_x = sign(xdiff)*old_ydiff;
		    congruent_y = sign(ydiff)*old_xdiff;
		    congruent_min = tmp;}}

      relation = SegmentRelation(old_segment, new_segment,
                                 speed, &parallel_width);
      switch (relation) {
        case _touch2s:
          onSegment(x0, y0, old_segment, 0, 500, explain_touch_start, old_segment_num); //cross_node, distance);
          break;
        case _touch2e:
          onSegment(x1, y1, old_segment, 0, 500, explain_touch_end, old_segment_num); //cross_node, distance);
		  break;
/*        case _touch1s: 
          onSegment2(new_segment, NodeArray.get(old_segment->start));
   	  	  break;
        case _touch1e:
          onSegment2(new_segment, NodeArray.get(old_segment->end));
		  break;
*/		case _connect1s2s:
		  node_identical(NodeArray.get(old_segment->start),
		                 NodeArray.get(new_segment->start), x0, y0, speed,
		                 explain_touch_start, old_segment_num);
		  break;
		case _connect1s2e:
		  node_identical(NodeArray.get(old_segment->start),
		                 NodeArray.get(new_segment->end), x1, y1, speed,
		                 explain_touch_end, old_segment_num);
		  break;
		case _connect1e2s:
		  node_identical(NodeArray.get(old_segment->end),
		                 NodeArray.get(new_segment->start),  x0, y0, speed,
		                 explain_touch_start, old_segment_num);
		  break;
		case _connect1e2e:
		  node_identical(NodeArray.get(old_segment->end),
		                 NodeArray.get(new_segment->end),  x1,y1, speed,
		                 explain_touch_end, old_segment_num);
		  break;
		case _sameline:
          onSegment(x0, y0, old_segment, 0, 0   ,0,0); //cross_node, distance);
          onSegment(x1, y1, old_segment, 0, 0   ,0,0); //cross_node, distance);
          break;
		case _parallel:
		  float current, nearest, nearest2;
		  int n1, n2;
          int_List *nn1, *nn2; // segment_num
          nn1 =  &explain_list;
          nn2 =  &explain_list;

          //  Diff -> parallel_width
          current =   parallel_width;
//          WebArray_Diff.get_nearest(Abs(current), &nearest, &nearest2, &nn1, &nn2);
          PairWebArray_Diff.get_nearest(Abs(current), &nearest, &nearest2);
          if (current < 0) {
     	     if (nearest != -10000)  nearest  *= -1;
	         if (nearest2 != -10000) nearest2 *= -1;
  	      }

		  if (nearest != -10000) {
            set_pallalel(old_segment, nearest,explain_pallalel,old_segment_num); //explain_copy,-1,nn1); //cross_node, distance);
		  }
//		  if (nearest2 != -10000) {
//            onSegment(x0, y0, old_segment, nearest2, 0,0,0); //explain_copy,-1,nn2); //cross_node, distance);
//            onSegment(x1, y1, old_segment, nearest2, 0,0,0); //explain_copy,-1,nn2); //cross_node, distance);
//          }
          break;
      }	// switch


  }	// for

  if (congruent_min < 600) // ͂ЂƂ
	addConstraint_congruent(congruent_x, congruent_y,explain_copy,-1,&congruent_explain);	

}



//  ̋vZ	    tmp = allowance - Abs(nearest - current)
float web_strength(float tmp, float allowance){  
   return 200 + 100 * tmp / allowance;
}



void  WebAdjust(Segment_Data* segment, float speed){
  //̃ZOg̐̒oB
  //ł sort Ă܂Ă̂ŁA߂̂oB
  
  int x0 = 0,
      y0 = 1,
	  x1 = 2,
	  y1 = 3;
  float current, nearest, nearest2, tmp;
//  int n1, n2; // segment_num
  int_List *nn1, *nn2; // segment_num

  nn1 =  &explain_list; //ςȂƂɏȂ悤ɔÔ߁B
  nn2 =  &explain_list;

  float allowance = speed * 1.8; //200;   // lׂ̕ 
  float angle_allowance = speed / 40; // 80 - 400 -> 2 - 10



//  Xcoord
  current = NodeArray.get(segment->start)->X;
  WebArray_Xcoord.get_nearest(current, &nearest, &nearest2, &nn1, &nn2);
	if (Abs(nearest - current) < ambiguous_region)  
	  addConstraint_align(constraint_align_x0, nearest,explain_specifyX, -1,nn1);
	if (Abs(nearest2 - current) < ambiguous_region)  
	  addConstraint_align(constraint_align_x0, nearest2,explain_specifyX, -1,nn2);


  
  current = NodeArray.get(segment->end)->X;
  WebArray_Xcoord.get_nearest(current, &nearest, &nearest2, &nn1, &nn2);
	if (Abs(nearest - current) < ambiguous_region)  
	  addConstraint_align(constraint_align_x1, nearest,explain_specifyX, -1,nn1);
	if (Abs(nearest2 - current) < ambiguous_region)  
	  addConstraint_align(constraint_align_x1, nearest2,explain_specifyX, -1,nn2);

//  current = (NodeArray.get(segment->start)->X +
//			 NodeArray.get(segment->end)->X) / 2;
//  WebArray_Xcoord.get_nearest(current, &nearest, &nearest2, &nn1, &nn2);
//	if (nearest != -10000) 
//      AddConstraint_liner1(x0, x1, 1, 1, 2 * nearest, 0, explain_specifyX, nn1);
//	if (nearest2 != -10000) 
//     AddConstraint_liner1(x0, x1, 1, 1, 2 * nearest2, 0, explain_specifyX, nn2);
  
//  Ycoord
  current = NodeArray.get(segment->start)->Y;
  WebArray_Ycoord.get_nearest(current, &nearest, &nearest2, &nn1, &nn2);
	if (Abs(nearest - current) < ambiguous_region)  
	  addConstraint_align(constraint_align_y0, nearest,explain_specifyY, -1,nn1);
	if (Abs(nearest2 - current) < ambiguous_region)  
	  addConstraint_align(constraint_align_y0, nearest2,explain_specifyX, -1,nn2);
  
  current = NodeArray.get(segment->end)->Y;
  WebArray_Ycoord.get_nearest(current, &nearest, &nearest2, &nn1, &nn2);
	if (Abs(nearest - current) < ambiguous_region)  
	  addConstraint_align(constraint_align_y1, nearest,explain_specifyY, -1,nn1);
	if (Abs(nearest2 - current) < ambiguous_region)  
	  addConstraint_align(constraint_align_y1, nearest2,explain_specifyX, -1,nn2);


//  current = (NodeArray.get(segment->start)->Y +
//			 NodeArray.get(segment->end)->Y) / 2;
//  WebArray_Ycoord.get_nearest(current, &nearest, &nearest2, &nn1, &nn2);
//	if (nearest != -10000) 
//     AddConstraint_liner1(y0, y1, 1, 1, 2 * nearest, 0, explain_specifyY, nn1);
//	if (nearest2 != -10000) 
//     AddConstraint_liner1(y0, y1, 1, 1, 2 * nearest2, 0, explain_specifyY, nn2);


  

//  slope -> slope
  float x_diff = ( NodeArray.get(segment->end)->X
                 - NodeArray.get(segment->start)->X);
  float y_diff = ( NodeArray.get(segment->end)->Y
                 - NodeArray.get(segment->start)->Y);
  current = get_angle(x_diff, y_diff); // 0-180
  WebArray_slope.get_nearest(current, &nearest, &nearest2, &nn1, &nn2);	         // s

  if (Abs(nearest - current) < ambiguous_angle){  
    float cosine =  cos( nearest  / 180 * pi);        //  Y / X
    float sine =  sin( nearest  / 180 * pi);        //  Y / X

    if (sine < 0.001)
      addConstraint_diff_y(0,explain_angle, -1,nn1);
    else if (Abs(cosine) < 0.001)
      addConstraint_diff_x(0,explain_angle, -1,nn1);
	else {
      if (y_diff < 0)  {sine *=-1;cosine *=-1;}    
      addConstraint_slope(sine, -cosine,explain_angle, -1,nn1);
    }
  }

  if (Abs(nearest2 - current) < ambiguous_angle){  
    float cosine =  cos( nearest2  / 180 * pi);        //  Y / X
    float sine =  sin( nearest2  / 180 * pi);        //  Y / X

   if (sine < 0.001)			  //ʈ
         addConstraint_diff_y(0,explain_angle, -1,nn2);
   else if (Abs(cosine) <0.001)
         addConstraint_diff_x(0,explain_angle, -1,nn2);
   else {
        if (y_diff < 0)  {sine *=-1;cosine *=-1;}     
	   addConstraint_slope(sine, -cosine,explain_angle, -1,nn2);
   	  }
   }
      
   

}


