// Copyright Aditya K. Ghose
// This program is designed for anytime default inference. 

 import java.util.*;
 import java.awt.*;
 import java.applet.Applet;
 import java.io.*;


public class GUITest extends Frame {

   private Button Pause, Resume;
   private Button Run, Quit;
   public TextArea ta;

   private boolean PAUSE=false;
   private boolean RUN=false;
   private boolean RESUME=false;
   private boolean Enter_Facts=false;
   private boolean Enter_Hypotheses=false;
   private boolean Enter_Constraints=false;
   public boolean MethodFlag1=true;
   public boolean MethodFlag2=false;

   public RunThread RunMethodT;
   private About a;
   public PerformanceDraw P_D;
   public NewInput n1, n2, n3;
   public NewInput Method2n;

   private MenuItem FactView, HypothesesView, ConstraintView;
   private MenuItem FactItem1;
   private MenuItem PerformanceItem1;
   private MenuItem HypothesesItem1;
   private MenuItem ConstraintItem1;
   private MenuItem HelpItem1;
   private CheckboxMenuItem MethodItem1, MethodItem2;

   public static final int ROWS = 12;
   public static final int COLUMNS = 55;
   public static final int MFONT_SIZE = 14;
   public static final int BFONT_SIZE = 24;
   public static final int NUMBER_VARIABLES=100;

   public String ResultString[];
   public int Num_Results;
   public boolean If_Run=false;
   public boolean If_Pause=false;


   public GUITest()
   {
	super("ANYTIME THEORIST");

	ta=new TextArea("Results",ROWS,COLUMNS);

	ResultString=new String[NUMBER_VARIABLES];
        Num_Results=0;
        P_D=new PerformanceDraw("Performance Chart");
	P_D.hide();
	ta.setEditable(false);
   	Run=new Button("Run");
	Pause=new Button("Pause");
	Resume=new Button("Resume");
	Quit=new Button("Quit");
        Run.setFont(new Font("TimesRoman", Font.BOLD, BFONT_SIZE));
	Pause.setFont(new Font("TimesRoman", Font.BOLD, BFONT_SIZE));
	Resume.setFont(new Font("TimesRoman", Font.BOLD, BFONT_SIZE));
	Quit.setFont(new Font("TimesRoman", Font.BOLD, BFONT_SIZE));

	Panel cPanel=new Panel();
	cPanel.add(ta);
	
	Panel sPanel=new Panel();
	sPanel.add(Run);
	sPanel.add(Pause);
	sPanel.add(Resume);
	sPanel.add(Quit);
        Menu factMenu=new Menu("Fact");
	Menu hypothesesMenu=new Menu("Hypotheses");
	Menu constraintMenu=new Menu("Constraints");
	Menu performanceMenu=new Menu("Performance");
	Menu helpMenu=new Menu("Help");
	Menu methodMenu=new Menu("Method");

	factMenu.setFont(new Font("TimesRoman", Font.BOLD, MFONT_SIZE));
	hypothesesMenu.setFont(new Font("TimesRoman", Font.BOLD, MFONT_SIZE));
	constraintMenu.setFont(new Font("TimesRoman", Font.BOLD, MFONT_SIZE));
	performanceMenu.setFont(new Font("TimesRoman", Font.BOLD, MFONT_SIZE));
	helpMenu.setFont(new Font("TimesRoman", Font.BOLD, MFONT_SIZE));
        methodMenu.setFont(new Font("TimesRoman", Font.BOLD, MFONT_SIZE));

	MenuBar mBar=new MenuBar();
	FactItem1=new MenuItem("Enter Facts");
	FactView=new MenuItem("View Facts");

	HypothesesItem1=new MenuItem("Enter Hypotheses");
	HypothesesView=new MenuItem("View Hypotheses");

	ConstraintItem1=new MenuItem("Enter Constraints");
	ConstraintView=new MenuItem("View Constraints");

        PerformanceItem1=new MenuItem("Reasoning Performance");
	
	MethodItem1=new CheckboxMenuItem("Anytime Coherence (Theory Restriction)");

        MethodItem2=new CheckboxMenuItem("Anytime Coherence (Predicate Restriction)");

	HelpItem1=new MenuItem("About...");

	factMenu.add(FactItem1);
	factMenu.addSeparator();
	factMenu.add(FactView);

	hypothesesMenu.add(HypothesesItem1);
	hypothesesMenu.addSeparator();
	hypothesesMenu.add(HypothesesView);

	constraintMenu.add(ConstraintItem1);
	constraintMenu.addSeparator();
	constraintMenu.add(ConstraintView);

	methodMenu.add(MethodItem1);
	methodMenu.addSeparator();
	methodMenu.add(MethodItem2);
        MethodItem1.setState(true);
	MethodItem2.setState(false);

	performanceMenu.add(PerformanceItem1);

	helpMenu.add(HelpItem1);

	mBar.add(factMenu);
	mBar.add(hypothesesMenu);
	mBar.add(constraintMenu);
	mBar.add(methodMenu);
	mBar.add(performanceMenu);
	mBar.add(helpMenu);
	setMenuBar(mBar);

        setLayout(new BorderLayout());

	add("South", sPanel);
	add("Center", cPanel);


        ta.appendText("\n");

	pack();
//  setLocation(200,100);

 	resize(450,350);

	show();
   }


 public boolean action (Event e, Object o)
 { 
    int k,kk;

    if((n1==null || n2==null) && (e.target==Run || e.target==Pause || e.target==Resume))
	 {
            ta.appendText("\n Please enter hypotheses, facts and/or constraints!\n");
		return true;
	 }

	if(e.id==Event.WINDOW_DESTROY){
      removeFrame();
      return true;
    }

	else if(e.target instanceof Button){
	    
	    if (e.target==Pause) {
		   
		    if(If_Run) {
			  RunMethodT.suspend();
            }
//          if(If_Run) RunMethodT.PAUSE_Flag=true;
			If_Pause=true;
		     ta.appendText("\n\nAnytime coherence computation is Paused.\n");

           if(Num_Results>0) {
	       ta.appendText("Current partial extention:\n");
		   for(k=0;k<RunMethodT.Num_Facts;k++)
		   {
		     ta.appendText(RunMethodT.FactString[k]+"\n");
		   }
           for(k=0;k<Num_Results;k++){ta.appendText(ResultString[k]+"\n");}
           ta.appendText("\nTo restart reasoning process, please press Resume button.\n\n");
	      }
	      else {
		  //  ta.appendText("No results generated so far\n");
		   ta.appendText("Current partial extention:\n");
		   for(k=0;k<RunMethodT.Num_Facts;k++){ta.appendText(RunMethodT.FactString[k]+"\n");}
		   ta.appendText("\nTo restart reasoning process, please press Resume button.\n\n");
          }
		 }

	    else if (e.target==Resume) {
		  If_Pause=false;

		  if(If_Run) {
		    RunMethodT.RESUME_Flag=true;
//			ta.appendText("\nPlease go back to the previous question,\n");
//			ta.appendText("and answer Yes or No by Click the Button: ");
		    RunMethodT.PAUSE_Flag=false; 
		    RunMethodT.resume(); 
         }
        }
		else if(e.target==Quit) {removeFrame(); return true;}
		
		else if (e.target==Run) {
		 If_Run=true;
		 if(If_Pause) {
		   ta.appendText("\n\nPlease click Resume Button to continue reasoning.\n\n");
		   return true;
		 }
//		 if(RunMethodT!=null) {RunMethodT.stop();}
                 if(MethodFlag2==true && n3!=null) RunMethodT= new RunThread(this,ta,n1,n2,n3,P_D,MethodFlag1,MethodFlag2,Method2n);
                 else if(MethodFlag2==true && n3==null) RunMethodT= new RunThread(this,ta,n1,n2,null,P_D,MethodFlag1,MethodFlag2,Method2n);
                 else if(MethodFlag2==false && n3!=null) RunMethodT= new RunThread(this,ta,n1,n2,n3,P_D,MethodFlag1,MethodFlag2,null);
                 else if(MethodFlag2==false && n3==null) RunMethodT= new RunThread(this,ta,n1,n2,null,P_D,MethodFlag1,MethodFlag2,null);
                 RunMethodT.start();
		}
    }

 
   else if(e.target instanceof CheckboxMenuItem){

	if(e.target==MethodItem1){

      MethodFlag1=!MethodFlag1;

      if(MethodFlag1) {
	     MethodItem1.setState(true);
	     MethodItem2.setState(false);
		 MethodFlag2=false;
	  }
	  else MethodItem1.setState(false);
	}

	else if(e.target==MethodItem2){

      MethodFlag2=!MethodFlag2;

	  if(MethodFlag2) {
	    MethodItem2.setState(true);
		MethodItem1.setState(false);
		MethodFlag1=false;
		if(Method2n!=null){
	      Method2n.text.setEditable(true);
		  Method2n.show();
	   }
	   else Method2n=new NewInput("Enter Predictive Restriction");
	  }
	  else {
	     MethodItem2.setState(false); 
	     Method2n.hide();
		 MethodItem1.setState(true);
		 MethodFlag1=true;
	  }
	}
 }

   else if(e.target instanceof MenuItem){

    if(e.arg.equals(HelpItem1.getLabel())){
       a=new About(this);
	   setItemState(false);
	}

 
    else if (e.arg.equals(PerformanceItem1.getLabel())){
	 if(P_D!=null){
	  P_D.show();
     }

	}

	else if (e.arg.equals(FactItem1.getLabel())){
	   if(n1!=null){
	      n1.setTitle("Enter Facts");
	      n1.text.setEditable(true);
		  n1.show();
	   }
	   else {
	    Enter_Facts=true;
	    n1=new NewInput("Enter Facts");
	   }

	}
	else if (e.arg.equals(HypothesesItem1.getLabel())){
	   if(n2!=null){
	      n2.setTitle("Enter Hypotheses");
	   	  n2.text.setEditable(true);
		  n2.show();
	   }

	    else {
		  Enter_Hypotheses=true;
		  n2=new NewInput("Enter Hypotheses");
		}
	}
	else if (e.arg.equals(ConstraintItem1.getLabel())){
	   if(n3!=null){
	      n3.setTitle("Enter Constraints");
	   	  n3.text.setEditable(true);
		  n3.show();
	   }


		else {
		 Enter_Constraints=true;
		 n3=new NewInput("Enter Constraints");
		}
	}

		else if (e.arg.equals(FactView.getLabel())){
	   if(n1!=null){
	      n1.setTitle("View Facts");
	      n1.text.setEditable(false);
		  n1.show();
	   }
	   else {
		ta.appendText("\nCAUTION: please enter facts first!\n");
	   }
	}
	else if (e.arg.equals(HypothesesView.getLabel())){
	   if(n2!=null){
	      n2.setTitle("View Hypotheses");
	      n2.text.setEditable(false);
		  n2.show();
	   }

	    else {
		ta.appendText("\nCAUTION: please enter hypotheses first!\n");
		}
	}
	else if (e.arg.equals(ConstraintView.getLabel())){
	   if(n3!=null){
	      n3.setTitle("View Constraints");
	      n3.text.setEditable(false);
		  n3.show();
	   }
		else {
		ta.appendText("\nCAUTION: please enter constraints first!\n");
	    }
	}

  }
  
   return true;
 }

 

 public boolean handleEvent(Event e)
 {
  if(e.id==Event.WINDOW_DESTROY){
   removeFrame();
   return true;
  }
  return super.handleEvent(e);
 }

 public void setItemState(boolean state)
 {
  if(state==true)
   HelpItem1.enable();
  else HelpItem1.disable();
 }

 public void removeFrame()
 {
  hide();
  dispose();
//  System.exit(0);
  }
}

class RunThread extends Thread{

  public TextArea ta;
  public NewInput n1, n2, n3, Method2n;
  public PerformanceDraw P_D;
  public boolean RESUME_Flag, PAUSE_Flag;
  public String FactContents, HypothesesContents, ConstraintContents, ResultContents, RestrictionContents;
  public String FactString[], HypothesesString[], ConstraintString[], ResultString[], RestrictionString[];
  public StringTokenizer FactTokens, HypothesesTokens, ConstraintTokens, RestrictionTokens;
  public static final int NUMBER_VARIABLES=100;
  public int Num_Facts, Num_Hypotheses, Num_Constraints, Num_Results, Num_Restrictions;
  public GUITest GF;
  public boolean Method1, Method2;

//public RunThread(Frame f, RunDialog Dd, TextArea tt, NewInput n11, NewInput n22, NewInput n33, PerformanceDraw ddraw)
public RunThread(GUITest f, TextArea tt, NewInput n11, NewInput n22, NewInput n33, PerformanceDraw ddraw, boolean Flag1, boolean Flag2, NewInput Method22)

{
 int total;

 Method1=Flag1;
 Method2=Flag2;
 GF = f;

 FactString=new String[NUMBER_VARIABLES];
 HypothesesString=new String[NUMBER_VARIABLES];
 ConstraintString=new String[NUMBER_VARIABLES];
 ResultString=new String[NUMBER_VARIABLES];
 RestrictionString=new String[NUMBER_VARIABLES];

 RESUME_Flag=false;
 PAUSE_Flag=false;


 this.ta=tt;
 this.n1=n11;
 this.n2=n22;
 this.n3=n33;
 this.Method2n=Method22;


 Num_Results=0;
 FactContents =new String(n1.text.getText());
 HypothesesContents=new String(n2.text.getText());
 if(n3!=null) ConstraintContents=new String(n3.text.getText());
 if(Method2n!=null) RestrictionContents=new String(Method2n.text.getText());
 
  
  FactTokens=new StringTokenizer(FactContents);
  HypothesesTokens=new StringTokenizer(HypothesesContents);
  if(n3!=null) ConstraintTokens=new StringTokenizer(ConstraintContents);
  if(Method2n!=null) RestrictionTokens=new StringTokenizer(RestrictionContents);
 
 
 total=0;
 while(FactTokens.hasMoreTokens()){
    FactString[total]=FactTokens.nextToken();
	total=total+1;
  }

 Num_Facts=total;

 total=0;
 while(HypothesesTokens.hasMoreTokens()){
    HypothesesString[total]=HypothesesTokens.nextToken();
	total=total+1;
  }
 
 Num_Hypotheses=total;

 if(n3!=null){
 total=0;
 while(ConstraintTokens.hasMoreTokens()){
    ConstraintString[total]=ConstraintTokens.nextToken();
	total=total+1;
  }
 Num_Constraints=total;
 }
 else Num_Constraints=0;

 if(Method2n!=null){
 total=0;
 while(RestrictionTokens.hasMoreTokens()){
    RestrictionString[total]=RestrictionTokens.nextToken();
	total=total+1;
  }
 Num_Restrictions=total;
 }
 else  Num_Restrictions=0;

 if(ddraw!=null) {
   ddraw.hide(); 
   ddraw.dispose();
 }
 
// if(ddraw==null) ddraw=new PerformanceDraw("Performance Chart");
 this.P_D=ddraw;
// P_D.show();
}

 public void run()
 {
  int i,ii,j,jj,k,kk,iii,kkk,jjj;
  String Tem_Hypotheses,Tem_Item[],TempString;
  StringTokenizer FTokens, HTokens, CTokens, RTokens;
  String TrueString[],TrueStringO[],FalseString[],FalseStringO[];
  String True_H[],False_H[],FTem_Item[],CTem_Item[];
  String CurrentHT[],CurrentHF[];
  int total_T_item, total_F_item, total_item;
  int totalTitem,totalFitem;
  int Flag1,Flag2,Flag3,Flag4,TempFlag;
  int Fg1,Fg2, F_Check_Flag,F_Conflict, C_Conflict,Ctotal_item,C_Check_Flag;
  int TNum_HItem, TH_Flag, FH_Flag,Ftotal_item,FNum_HItem;
  int F_Check_Flag1,C_Check_Flag1,FS_Check_Flag,CS_Check_Flag;
  int H_Check_Flag, H_Conflict, FS_No, CS_No,Total_TNum_FNum;
  int NewHtotal_item, trials,First_Discard_Flag;
  String NewHTem_Item[], HStringCopy[],F_Double_String0,F_Double_String1;
  int i_flag, discard_flag, num_trials,F_Double_Check, Conflict_No;
  int Sf_Sh_Check_Double, Rtotal_item, Num_BackResult, Num_DisplayedResult,Count_BackResult;
  String Sf_Sh_String[],Another_TempF0, Another_TempF1,Another_TempH0,Another_TempH1;
  String Mem_No,Mem_No1;
  int If_First_Equal,Imply_Conflict,Replace1,Replace2,Replace11,Replace22,Imply_Conflict1;
  String FTem_Item_Imply[],TempStringImply;


  String BackResult[][]={
   {"00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00"},
   {"00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00"},
   {"00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00"},
   {"00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00"},
   {"00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00"},
   {"00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00"},
   {"00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00"},
   {"00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00"},
   {"00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00"},
   {"00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00"},
   {"00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00"},
   {"00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00"},
   {"00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00"},
   {"00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00"},
   {"00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00"},
   {"00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00"},
   {"00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00"},
   {"00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00"},
   {"00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00"},
   {"00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00"}};

  String DisplayedResult[][]={
   {"00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00"},
   {"00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00"},
   {"00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00"},
   {"00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00"},
   {"00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00"},
   {"00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00"},
   {"00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00"},
   {"00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00"},
   {"00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00"},
   {"00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00"},
   {"00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00"},
   {"00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00"},
   {"00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00"},
   {"00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00"},
   {"00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00"},
   {"00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00"},
   {"00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00"},
   {"00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00"},
   {"00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00"},
   {"00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00","00"}};

  Imply_Conflict=0;
  Imply_Conflict1=0;
  If_First_Equal=0;

  Replace1=0;
  Replace2=0;
  Replace11=1000;
  Replace22=1000;

  Num_BackResult=0;
  Num_DisplayedResult=0;
  Conflict_No=0;

  Count_BackResult=0;
  C_Conflict=0;

  Flag1=0;
  Flag2=0;
  Flag3=0;
  Flag4=0;
  CS_No=0;
  FS_No=0;
  F_Double_Check=0;
  Total_TNum_FNum=0;

  Sf_Sh_String=new String[2];
  F_Double_String0=new String("00");
  F_Double_String1=new String("00");
  TrueString=new String[NUMBER_VARIABLES];
  FalseString=new String[NUMBER_VARIABLES];
  TrueStringO=new String[NUMBER_VARIABLES];
  FalseStringO=new String[NUMBER_VARIABLES];
  HStringCopy=new String[NUMBER_VARIABLES];
  TempStringImply=new String("00");
  True_H=new String[NUMBER_VARIABLES];
  False_H=new String[NUMBER_VARIABLES];

  Tem_Item=new String[NUMBER_VARIABLES];
  FTem_Item=new String[NUMBER_VARIABLES];
  FTem_Item_Imply=new String[2];
  CTem_Item=new String[NUMBER_VARIABLES];
  CurrentHT=new String[2];
  CurrentHF=new String[2];
  NewHTem_Item=new String[4];
  Mem_No=new String("00");
  Mem_No1=new String("00");

  PAUSE_Flag=false;
  RESUME_Flag=false;

 if(Num_Facts==0) {
   ta.appendText("Please enter facts first!\n");
   return;
 }

 if(Num_Hypotheses==0) {
   ta.appendText("Please enter hypotheses first!\n");
   return;
 }

 total_T_item=0;
 total_F_item=0;
 P_D.PerformanceCanvas.x[0]=30;
 P_D.PerformanceCanvas.y[0]=240;


 Num_Results=0;
 GF.Num_Results=0;

 for(i=0;i<Num_Hypotheses;i++){
  HStringCopy[i]=new String(HypothesesString[i]);
 }
 for(i=Num_Facts;i<Num_Facts+Num_Constraints;i++){
  FactString[i]=new String(ConstraintString[i-Num_Facts]);
 }

 Num_Facts=Num_Facts+Num_Constraints;

 ta.appendText("\nStart now\n\n");

 if(Method2) ta.appendText("Anytime Coherence (Predictive Restriction) computation is on progress...\n\n");
 else ta.appendText("Anytime Coherence (Theory Restriction) computation is on progress...\n\n");

 for(i=0;i<Num_Facts;i++){

   total_item=0;
   if(FactString[i].indexOf((int)'|')==-1 && FactString[i].indexOf((int)'>')==-1) {
     Tem_Item[total_item]=new String(FactString[i]);
	 total_item=total_item+1;
   }
   else if(FactString[i].indexOf((int)'|')==-1 && FactString[i].indexOf((int)'>')!=-1){
     FTokens=new StringTokenizer(FactString[i],"->");
	 TempFlag=0;
     while(FTokens.hasMoreTokens()){
       TempString=new String(FTokens.nextToken());
	   if(TempFlag==0 && TempString.indexOf((int)'~')==0) Tem_Item[total_item]=new String(TempString.substring(1));
	   else if(TempFlag==0 && TempString.indexOf((int)'~')!=0) Tem_Item[total_item]=new String('~'+TempString);
	   else if(TempFlag!=0) Tem_Item[total_item]=new String(TempString);
	   total_item=total_item+1;
	   TempFlag=TempFlag+1;
	 }
   }
   else if(FactString[i].indexOf((int)'|')!=-1 && FactString[i].indexOf((int)'>')==-1){
     FTokens=new StringTokenizer(FactString[i],"|");
     while(FTokens.hasMoreTokens()){
       Tem_Item[total_item]=new String(FTokens.nextToken());
	   total_item=total_item+1;
     }
   }
   for(j=0;j<total_item;j++){
    if(Tem_Item[j].indexOf((int)'~')==0) {
	   FalseString[total_F_item]=new String(Tem_Item[j].substring(1));
	   total_F_item=total_F_item+1;
	}
	else if(Tem_Item[j].indexOf((int)'~')!=0) {
	    TrueString[total_T_item]=new String(Tem_Item[j]);
		total_T_item=total_T_item+1;
	}
   }
  }


 for(i=0;i<total_F_item;i++){
  for(j=0;j<total_T_item;j++)
   if(!FalseString[i].equals("00") && FalseString[i].equals(TrueString[j])) {
       FalseString[i]=new String("00");
	   TrueString[j]=new String("00");
	   j=total_T_item;
   }
 }

 totalTitem=total_T_item;
 totalFitem=total_F_item;

 for(i=0;i<totalFitem;i++) FalseStringO[i]=new String(FalseString[i]);
 for(i=0;i<totalTitem;i++) TrueStringO[i]=new String(TrueString[i]);


 if(!Method2){
 Num_BackResult=0;
 Num_DisplayedResult=0;

 for(i=0;i<Num_Hypotheses;i++){
  HypothesesString[i]=new String(HStringCopy[i]);
 }
 num_trials=0;
 discard_flag=0;

 for(trials=0;trials<Num_Hypotheses;trials++){

   if(discard_flag==0 && trials!=0) break;
   total_item=0;
   Replace1=0;
   Replace2=0;
   Replace11=1000;
   Replace22=1000;
   Mem_No=new String("00");
   Mem_No1=new String("00");
   Num_Restrictions=0;
   Num_Results=0;
   GF.Num_Results=0;
   First_Discard_Flag=0;
 for(i=0;i<totalFitem;i++) FalseString[i]=new String(FalseStringO[i]);
 for(i=0;i<totalTitem;i++) TrueString[i]=new String(TrueStringO[i]);

 TNum_HItem=0;
 FNum_HItem=0;

// ta.appendText("trials="+trials+", discard_flag="+discard_flag+", Num_Hypotheses="+Num_Hypotheses+"\n");

 if(discard_flag>trials) {
   trials=discard_flag;
   for(i=0;i<Num_Hypotheses;i++) {
   if(i+discard_flag<Num_Hypotheses) HypothesesString[i]=new String(HStringCopy[i+discard_flag]);
   else HypothesesString[i]=new String(HStringCopy[i+discard_flag-Num_Hypotheses]);
   }
 }
 else if (discard_flag<trials-1) break;


 num_trials=num_trials+1;

/*
 for(i_flag=trials;i_flag<Num_Hypotheses+trials;i_flag++){
  if(i_flag>=Num_Hypotheses) i=i_flag-Num_Hypotheses;
  else i=i_flag;
*/
  for(i=0;i<Num_Hypotheses;i++){

  try{
   sleep(600);
  }

  catch(InterruptedException e) {}

  P_D.PerformanceCanvas.x[i+1]=30+i*10;

  total_item=0;

  CurrentHT[0]=new String("00");
  CurrentHT[1]=new String("00");
  CurrentHF[0]=new String("00");
  CurrentHF[1]=new String("00");

   if(HypothesesString[i].indexOf((int)'|')==-1 && HypothesesString[i].indexOf((int)'>')==-1) {
     Tem_Item[total_item]=new String(HypothesesString[i]);
	 total_item=total_item+1;
   }
   else if(HypothesesString[i].indexOf((int)'|')==-1 && HypothesesString[i].indexOf((int)'>')!=-1){
     HTokens=new StringTokenizer(HypothesesString[i],"->");
	 TempFlag=0;
     while(HTokens.hasMoreTokens()){
       TempString=new String(HTokens.nextToken());
	   if(TempFlag==0 && TempString.indexOf((int)'~')==0) Tem_Item[total_item]=new String(TempString.substring(1));
	   else if(TempFlag==0 && TempString.indexOf((int)'~')!=0) Tem_Item[total_item]=new String('~'+TempString);
	   else if(TempFlag!=0) Tem_Item[total_item]=new String(TempString);
	   total_item=total_item+1;
	   TempFlag=TempFlag+1;
	 }
   }
   else if(HypothesesString[i].indexOf((int)'|')!=-1 && HypothesesString[i].indexOf((int)'>')==-1){
     HTokens=new StringTokenizer(HypothesesString[i],"|");
     while(HTokens.hasMoreTokens()){
       Tem_Item[total_item]=new String(HTokens.nextToken());
       total_item=total_item+1;
     }
   }


   Flag1=0;
   Flag2=0;

   TH_Flag=0;
   FH_Flag=0;

   for(j=0;j<total_item;j++){

    if(Tem_Item[j].indexOf((int)'~')==0) {
	   TempString=new String(Tem_Item[j].substring(1));
           False_H[FNum_HItem]=new String(TempString);
           CurrentHF[FH_Flag]=new String(TempString);
           FNum_HItem=FNum_HItem+1;
           FH_Flag=FH_Flag+1;
	   for(k=0;k<total_T_item;k++){
	    if(!TempString.equals("00") && TempString.equals(TrueString[k])) {
		  Flag1=Flag1+1;
		  k=total_T_item;
	    }
	   }

	}
	else if(Tem_Item[j].indexOf((int)'~')!=0) {
	    TempString=new String(Tem_Item[j]);
            True_H[TNum_HItem]=new String(TempString);
            CurrentHT[TH_Flag]=new String(TempString);
            TNum_HItem=TNum_HItem+1;
            TH_Flag=TH_Flag+1;
        for(k=0;k<total_F_item;k++){
		  if(TempString.equals(FalseString[k])){
		    Flag2=Flag2+1;
			k=total_F_item;
		  }
	    }
   }
  }

  Imply_Conflict=0;
  Imply_Conflict1=0;
  If_First_Equal=0;

// ta.appendText("Post 0: "+Replace1+"\n");
  if(total_item==1) {
//  Imply_Temp1=new String(Tem_Item[0]+'-'+'>');
  TempString=new String("00");
  FTem_Item[0]=new String("00");
  FTem_Item[1]=new String("00");
  FTem_Item_Imply[0]=new String("00");
  FTem_Item_Imply[1]=new String("00");
  for(j=0;j<Num_Facts;j++){

    Ftotal_item=0;
    If_First_Equal=0;

    if(FactString[j].indexOf((int)'>')!=-1){

     FTokens=new StringTokenizer(FactString[j],"->");
     TempFlag=0;

     while(FTokens.hasMoreTokens()){
       TempString=new String(FTokens.nextToken());
 //      ta.appendText("TempString="+TempString+", Tem_Item[0]="+Tem_Item[0]+"\n");
       if(!TempString.equals(Tem_Item[0]) && Ftotal_item==0) {
        If_First_Equal=1;
        break;}
	   if(TempFlag==0 && TempString.indexOf((int)'~')==0) FTem_Item[Ftotal_item]=new String(TempString.substring(1));
	   else if(TempFlag==0 && TempString.indexOf((int)'~')!=0) FTem_Item[Ftotal_item]=new String('~'+TempString);
	   else if(TempFlag!=0) FTem_Item[Ftotal_item]=new String(TempString);
	   Ftotal_item=Ftotal_item+1;
	   TempFlag=TempFlag+1;
	 }

      if(If_First_Equal==1) continue;

      for(k=j+1;k<Num_Facts;k++){
       Ftotal_item=0;
       If_First_Equal=0;

        if(FactString[k].indexOf((int)'>')!=-1){

     FTokens=new StringTokenizer(FactString[k],"->");
     TempFlag=0;

     while(FTokens.hasMoreTokens()){
       TempString=new String(FTokens.nextToken());
       if(!TempString.equals(Tem_Item[0]) && Ftotal_item==0) {If_First_Equal=1; break;}
	   if(TempFlag==0 && TempString.indexOf((int)'~')==0) FTem_Item_Imply[Ftotal_item]=new String(TempString.substring(1));
	   else if(TempFlag==0 && TempString.indexOf((int)'~')!=0) FTem_Item_Imply[Ftotal_item]=new String('~'+TempString);
	   else if(TempFlag!=0) FTem_Item_Imply[Ftotal_item]=new String(TempString);
	   Ftotal_item=Ftotal_item+1;
	   TempFlag=TempFlag+1;
	 }
       }
     if(If_First_Equal==1) continue;

     else if(If_First_Equal!=1 && FTem_Item[1].indexOf((int)'~')==0 && FTem_Item_Imply[1].indexOf((int)'~')!=0){
     TempString=new String(FTem_Item[1].substring(1));
     if(TempString.equals(FTem_Item_Imply[1])) Imply_Conflict=1;
     }
     if(If_First_Equal!=1 && FTem_Item[1].indexOf((int)'~')!=0 && FTem_Item_Imply[1].indexOf((int)'~')==0){

     TempString=new String(FTem_Item_Imply[1].substring(1));
 //    ta.appendText("If_First_Equal="+If_First_Equal+",TemString="+TempString+",FTem_Item[1]="+FTem_Item[1]+"\n");
     if(TempString.equals(FTem_Item[1])) Imply_Conflict=1;
     }
     }  /* for k=0;k < */


  }   /* for if */


  } /* for for(j=0;j<Num_facts;j++) */
 } /* for if(total_item==1) */

//  ta.appendText("Post 1: "+Replace1+"\n");
   if(total_item==1) {
   TempString=new String("00");
  FTem_Item[0]=new String("00");
  FTem_Item[1]=new String("00");
  FTem_Item_Imply[0]=new String("00");
  FTem_Item_Imply[1]=new String("00");
//   Replace1=0;
//   Replace2=0;
//  Imply_Temp1=new String(Tem_Item[0]+'-'+'>');
  for(j=0;j<Num_Facts;j++){

    Ftotal_item=0;
    If_First_Equal=0;

    if(FactString[j].indexOf((int)'>')!=-1){

     FTokens=new StringTokenizer(FactString[j],"->");
     TempFlag=0;

     while(FTokens.hasMoreTokens()){
       TempString=new String(FTokens.nextToken());
 //      ta.appendText("TempString="+TempString+", Tem_Item[0]="+Tem_Item[0]+"\n");
       if(!TempString.equals(Tem_Item[0]) && Ftotal_item==0) {
        If_First_Equal=1;
        break;}
	   if(TempFlag==0 && TempString.indexOf((int)'~')==0) FTem_Item[Ftotal_item]=new String(TempString.substring(1));
	   else if(TempFlag==0 && TempString.indexOf((int)'~')!=0) FTem_Item[Ftotal_item]=new String('~'+TempString);
	   else if(TempFlag!=0) FTem_Item[Ftotal_item]=new String(TempString);
	   Ftotal_item=Ftotal_item+1;
	   TempFlag=TempFlag+1;
	 }

      if(If_First_Equal==1) continue;

      for(k=0;k<Num_Results;k++){
       Ftotal_item=0;
       If_First_Equal=0;

        if(ResultString[k].indexOf((int)'>')!=-1){

     FTokens=new StringTokenizer(ResultString[k],"->");
     TempFlag=0;

     while(FTokens.hasMoreTokens()){
       TempString=new String(FTokens.nextToken());
       if(!TempString.equals(Tem_Item[0]) && Ftotal_item==0) {If_First_Equal=1; break;}
	   if(TempFlag==0 && TempString.indexOf((int)'~')==0) FTem_Item_Imply[Ftotal_item]=new String(TempString.substring(1));
	   else if(TempFlag==0 && TempString.indexOf((int)'~')!=0) FTem_Item_Imply[Ftotal_item]=new String('~'+TempString);
	   else if(TempFlag!=0) FTem_Item_Imply[Ftotal_item]=new String(TempString);
	   Ftotal_item=Ftotal_item+1;
	   TempFlag=TempFlag+1;
	 }
       }
     if(If_First_Equal==1) continue;

     else if(If_First_Equal!=1 && FTem_Item[1].indexOf((int)'~')==0 && FTem_Item_Imply[1].indexOf((int)'~')!=0){
     TempString=new String(FTem_Item[1].substring(1));
     if(TempString.equals(FTem_Item_Imply[1])) {Imply_Conflict=1;Replace1=1000;Replace11=i;Mem_No=new String(ResultString[k]);}
     }
     if(If_First_Equal!=1 && FTem_Item[1].indexOf((int)'~')!=0 && FTem_Item_Imply[1].indexOf((int)'~')==0){

     TempString=new String(FTem_Item_Imply[1].substring(1));
//     ta.appendText("If_First_Equal="+If_First_Equal+",TemString="+TempString+",FTem_Item[1]="+FTem_Item[1]+"\n");
     if(TempString.equals(FTem_Item[1])) {Imply_Conflict=1;Replace1=1000;Replace11=i;Mem_No=new String(ResultString[k]);}
     }
     }  /* for k=0;k < */


  }   /* for if */


  } /* for for(j=0;j<Num_facts;j++) */
 } /* for if(total_item==1) */

// ta.appendText("Post 2: "+Replace1+"\n");
   if(total_item==1) {
   TempString=new String("00");
  FTem_Item[0]=new String("00");
  FTem_Item[1]=new String("00");
  FTem_Item_Imply[0]=new String("00");
  FTem_Item_Imply[1]=new String("00");
//   Replace1=0;
//   Replace2=0;
//  Imply_Temp1=new String(Tem_Item[0]+'-'+'>');
  for(j=0;j<Num_Results;j++){

    Ftotal_item=0;
    If_First_Equal=0;

    if(ResultString[j].indexOf((int)'>')!=-1){

     FTokens=new StringTokenizer(ResultString[j],"->");
     TempFlag=0;

     while(FTokens.hasMoreTokens()){
       TempString=new String(FTokens.nextToken());
 //      ta.appendText("TempString="+TempString+", Tem_Item[0]="+Tem_Item[0]+"\n");
       if(!TempString.equals(Tem_Item[0]) && Ftotal_item==0) {
        If_First_Equal=1;
        break;}
	   if(TempFlag==0 && TempString.indexOf((int)'~')==0) FTem_Item[Ftotal_item]=new String(TempString.substring(1));
	   else if(TempFlag==0 && TempString.indexOf((int)'~')!=0) FTem_Item[Ftotal_item]=new String('~'+TempString);
	   else if(TempFlag!=0) FTem_Item[Ftotal_item]=new String(TempString);
	   Ftotal_item=Ftotal_item+1;
	   TempFlag=TempFlag+1;
	 }

      if(If_First_Equal==1) continue;

      for(k=j+1;k<Num_Results;k++){
       Ftotal_item=0;
       If_First_Equal=0;

        if(ResultString[k].indexOf((int)'>')!=-1){

     FTokens=new StringTokenizer(ResultString[k],"->");
     TempFlag=0;

     while(FTokens.hasMoreTokens()){
       TempString=new String(FTokens.nextToken());
       if(!TempString.equals(Tem_Item[0]) && Ftotal_item==0) {If_First_Equal=1; break;}
	   if(TempFlag==0 && TempString.indexOf((int)'~')==0) FTem_Item_Imply[Ftotal_item]=new String(TempString.substring(1));
	   else if(TempFlag==0 && TempString.indexOf((int)'~')!=0) FTem_Item_Imply[Ftotal_item]=new String('~'+TempString);
	   else if(TempFlag!=0) FTem_Item_Imply[Ftotal_item]=new String(TempString);
	   Ftotal_item=Ftotal_item+1;
	   TempFlag=TempFlag+1;
	 }
       }
     if(If_First_Equal==1) continue;
  //   ta.appendText(FTem_Item[1]+" "+FTem_Item_Imply[1]);
     else if(If_First_Equal!=1 && FTem_Item[1].indexOf((int)'~')==0 && FTem_Item_Imply[1].indexOf((int)'~')!=0){
     TempString=new String(FTem_Item[1].substring(1));
//     ta.appendText("1.0: "+FTem_Item[1]+" "+FTem_Item_Imply[1]+"\n");
     if(TempString.equals(FTem_Item_Imply[1])) {Imply_Conflict=1;Replace1=1000;Replace11=i;Replace2=1000;Replace22=i;
       Mem_No=new String(ResultString[k]);
       Mem_No1=new String(ResultString[j]);
       }
     }
     if(If_First_Equal!=1 && FTem_Item[1].indexOf((int)'~')!=0 && FTem_Item_Imply[1].indexOf((int)'~')==0){

     TempString=new String(FTem_Item_Imply[1].substring(1));
//     ta.appendText("2.0: "+FTem_Item[1]+" "+FTem_Item_Imply[1]+"\n");
//     ta.appendText("If_First_Equal="+If_First_Equal+",TemString="+TempString+",FTem_Item[1]="+FTem_Item[1]+"\n");
     if(TempString.equals(FTem_Item[1])) {Imply_Conflict=1;Replace1=1000;Replace11=i;Replace2=1000;Replace22=i;
       Mem_No1=new String(ResultString[j]);
       Mem_No=new String(ResultString[k]);
       }
     }
     }  /* for k=0;k < */


  }   /* for if */


  } /* for for(j=0;j<Num_facts;j++) */
 } /* for if(total_item==1) */


 // strat from here to test two items in hypotheses for the imply situation

//  Imply_Conflict=0;
  If_First_Equal=0;

// ta.appendText("Post 3: "+Replace1+"\n");
  if(total_item==2 && HypothesesString[i].indexOf((int)'>')!=-1) {
  TempString=new String("00");
  FTem_Item[0]=new String("00");
  FTem_Item[1]=new String("00");
  FTem_Item_Imply[0]=new String("00");
  FTem_Item_Imply[1]=new String("00");
//  Imply_Temp1=new String(Tem_Item[0]+'-'+'>');
  for(j=0;j<Num_Facts;j++){

    Ftotal_item=0;
    If_First_Equal=0;

    if(FactString[j].indexOf((int)'>')!=-1){

     FTokens=new StringTokenizer(FactString[j],"->");
     TempFlag=0;

     while(FTokens.hasMoreTokens()){
       TempString=new String(FTokens.nextToken());
 //      ta.appendText("TempString="+TempString+", Tem_Item[0]="+Tem_Item[0]+"\n");

	   if(TempFlag==0 && TempString.indexOf((int)'~')==0) FTem_Item[Ftotal_item]=new String(TempString.substring(1));
	   else if(TempFlag==0 && TempString.indexOf((int)'~')!=0) FTem_Item[Ftotal_item]=new String('~'+TempString);
	   else if(TempFlag!=0) FTem_Item[Ftotal_item]=new String(TempString);

           if(!FTem_Item[0].equals(Tem_Item[0])) {
           If_First_Equal=1;
           break;}
            Ftotal_item=Ftotal_item+1;
	   TempFlag=TempFlag+1;
	 }

      if(If_First_Equal==1) continue;

      for(k=0;k<Num_Facts;k++){
       Ftotal_item=0;
       If_First_Equal=0;

        if(FactString[k].indexOf((int)'>')==-1 && FactString[k].indexOf((int)'|')==-1){

       if(FactString[k].indexOf((int)'~')==0) TempString=new String(FactString[k].substring(1));
       else   //if(FactString[k].indexOf((int)'~')!=0)
       TempString=new String('~'+FactString[k]);
       if(!TempString.equals(Tem_Item[0])) {If_First_Equal=1; continue;}

       else if(If_First_Equal!=1 && TempString.equals(Tem_Item[0]) && FTem_Item[1].indexOf((int)'~')==0){
       TempStringImply=new String(FTem_Item[1].substring(1));
       if(TempStringImply.equals(Tem_Item[1])) Imply_Conflict=1;
       }
       if(If_First_Equal!=1 && TempString.equals(Tem_Item[0]) && Tem_Item[1].indexOf((int)'~')==0){
       TempStringImply=new String(Tem_Item[1].substring(1));
 //    ta.appendText("If_First_Equal="+If_First_Equal+",TemString="+TempString+",FTem_Item[1]="+FTem_Item[1]+"\n");
       if(TempStringImply.equals(FTem_Item[1])) Imply_Conflict=1;
      }
      } /* for if */
     }  /* for k=0;k < */


  }   /* for if */


  } /* for for(j=0;j<Num_facts;j++) */
 } /* for if(total_item==2) */
//  ta.appendText("Post 4: "+Replace1+"\n");
  if(total_item==2 && HypothesesString[i].indexOf((int)'>')!=-1) {
  TempString=new String("00");
  FTem_Item[0]=new String("00");
  FTem_Item[1]=new String("00");
  FTem_Item_Imply[0]=new String("00");
  FTem_Item_Imply[1]=new String("00");
//  Replace1=0;
//  Replace2=0;
//  Imply_Temp1=new String(Tem_Item[0]+'-'+'>');
  for(j=0;j<Num_Facts;j++){

    Ftotal_item=0;
    If_First_Equal=0;

    if(FactString[j].indexOf((int)'>')!=-1){

     FTokens=new StringTokenizer(FactString[j],"->");
     TempFlag=0;

     while(FTokens.hasMoreTokens()){
       TempString=new String(FTokens.nextToken());
 //      ta.appendText("TempString="+TempString+", Tem_Item[0]="+Tem_Item[0]+"\n");

	   if(TempFlag==0 && TempString.indexOf((int)'~')==0) FTem_Item[Ftotal_item]=new String(TempString.substring(1));
	   else if(TempFlag==0 && TempString.indexOf((int)'~')!=0) FTem_Item[Ftotal_item]=new String('~'+TempString);
	   else if(TempFlag!=0) FTem_Item[Ftotal_item]=new String(TempString);

           if(!FTem_Item[0].equals(Tem_Item[0])) {
           If_First_Equal=1;
           break;}
            Ftotal_item=Ftotal_item+1;
	   TempFlag=TempFlag+1;
	 }

      if(If_First_Equal==1) continue;

      for(k=0;k<Num_Results;k++){
       Ftotal_item=0;
       If_First_Equal=0;

        if(ResultString[k].indexOf((int)'>')==-1 && ResultString[k].indexOf((int)'|')==-1){

       if(ResultString[k].indexOf((int)'~')==0) TempString=new String(ResultString[k].substring(1));
       else   //if(FactString[k].indexOf((int)'~')!=0)
       TempString=new String('~'+ResultString[k]);
       if(!TempString.equals(Tem_Item[0])) {If_First_Equal=1; continue;}

       else if(If_First_Equal!=1 && TempString.equals(Tem_Item[0]) && FTem_Item[1].indexOf((int)'~')==0){
       TempStringImply=new String(FTem_Item[1].substring(1));
       if(TempStringImply.equals(Tem_Item[1])) {Imply_Conflict=1;Replace1=1000;Replace11=i;Mem_No=new String(ResultString[k]);}
       }
       if(If_First_Equal!=1 && TempString.equals(Tem_Item[0]) && Tem_Item[1].indexOf((int)'~')==0){
       TempStringImply=new String(Tem_Item[1].substring(1));
 //    ta.appendText("If_First_Equal="+If_First_Equal+",TemString="+TempString+",FTem_Item[1]="+FTem_Item[1]+"\n");
       if(TempStringImply.equals(FTem_Item[1])) {Imply_Conflict=1; Replace1=1000;Replace11=i;Mem_No=new String(ResultString[k]);}
      }
      } /* for if */
     }  /* for k=0;k < */


  }   /* for if */


  } /* for for(j=0;j<Num_facts;j++) */
 } /* for if(total_item==2) */
//   ta.appendText("Post 5: "+Replace1+"\n");
   if(total_item==2 && HypothesesString[i].indexOf((int)'>')!=-1) {
   TempString=new String("00");
  FTem_Item[0]=new String("00");
  FTem_Item[1]=new String("00");
  FTem_Item_Imply[0]=new String("00");
  FTem_Item_Imply[1]=new String("00");
//  Replace1=0;
//  Replace2=0;
//  Imply_Temp1=new String(Tem_Item[0]+'-'+'>');
  for(j=0;j<Num_Results;j++){

    Ftotal_item=0;
    If_First_Equal=0;

    if(ResultString[j].indexOf((int)'>')!=-1){

     FTokens=new StringTokenizer(ResultString[j],"->");
     TempFlag=0;

     while(FTokens.hasMoreTokens()){
       TempString=new String(FTokens.nextToken());
 //      ta.appendText("TempString="+TempString+", Tem_Item[0]="+Tem_Item[0]+"\n");

	   if(TempFlag==0 && TempString.indexOf((int)'~')==0) FTem_Item[Ftotal_item]=new String(TempString.substring(1));
	   else if(TempFlag==0 && TempString.indexOf((int)'~')!=0) FTem_Item[Ftotal_item]=new String('~'+TempString);
	   else if(TempFlag!=0) FTem_Item[Ftotal_item]=new String(TempString);

           if(!FTem_Item[0].equals(Tem_Item[0])) {
           If_First_Equal=1;
           break;}
            Ftotal_item=Ftotal_item+1;
	   TempFlag=TempFlag+1;
	 }

      if(If_First_Equal==1) continue;

      for(k=0;k<Num_Facts;k++){
       Ftotal_item=0;
       If_First_Equal=0;

        if(FactString[k].indexOf((int)'>')==-1 && FactString[k].indexOf((int)'|')==-1){

       if(FactString[k].indexOf((int)'~')==0) TempString=new String(FactString[k].substring(1));
       else   //if(FactString[k].indexOf((int)'~')!=0)
       TempString=new String('~'+FactString[k]);
       if(!TempString.equals(Tem_Item[0])) {If_First_Equal=1; continue;}

       else if(If_First_Equal!=1 && TempString.equals(Tem_Item[0]) && FTem_Item[1].indexOf((int)'~')==0){
       TempStringImply=new String(FTem_Item[1].substring(1));
       if(TempStringImply.equals(Tem_Item[1])) {Imply_Conflict=1;Replace1=1000;Replace11=i;Mem_No=new String(ResultString[j]);}
       }
       if(If_First_Equal!=1 && TempString.equals(Tem_Item[0]) && Tem_Item[1].indexOf((int)'~')==0){
       TempStringImply=new String(Tem_Item[1].substring(1));
 //    ta.appendText("If_First_Equal="+If_First_Equal+",TemString="+TempString+",FTem_Item[1]="+FTem_Item[1]+"\n");
       if(TempStringImply.equals(FTem_Item[1])) {Imply_Conflict=1; Replace1=1000;Replace11=i;Mem_No=new String(ResultString[j]);}
      }
      } /* for if */
     }  /* for k=0;k < */


  }   /* for if */


  } /* for for(j=0;j<Num_facts;j++) */
 } /* for if(total_item==2) */
//  ta.appendText("Post 6: "+Replace1+"\n");
  if(total_item==2 && HypothesesString[i].indexOf((int)'>')!=-1) {
  TempString=new String("00");
  FTem_Item[0]=new String("00");
  FTem_Item[1]=new String("00");
  FTem_Item_Imply[0]=new String("00");
  FTem_Item_Imply[1]=new String("00");
//  Imply_Temp1=new String(Tem_Item[0]+'-'+'>');
  for(j=0;j<Num_Results;j++){

    Ftotal_item=0;
    If_First_Equal=0;

    if(ResultString[j].indexOf((int)'>')!=-1){

     FTokens=new StringTokenizer(ResultString[j],"->");
     TempFlag=0;

     while(FTokens.hasMoreTokens()){
       TempString=new String(FTokens.nextToken());
 //      ta.appendText("TempString="+TempString+", Tem_Item[0]="+Tem_Item[0]+"\n");

	   if(TempFlag==0 && TempString.indexOf((int)'~')==0) FTem_Item[Ftotal_item]=new String(TempString.substring(1));
	   else if(TempFlag==0 && TempString.indexOf((int)'~')!=0) FTem_Item[Ftotal_item]=new String('~'+TempString);
	   else if(TempFlag!=0) FTem_Item[Ftotal_item]=new String(TempString);

           if(!FTem_Item[0].equals(Tem_Item[0])) {
           If_First_Equal=1;
           break;}
            Ftotal_item=Ftotal_item+1;
	   TempFlag=TempFlag+1;
	 }

      if(If_First_Equal==1) continue;

      for(k=0;k<Num_Results;k++){
       Ftotal_item=0;
       If_First_Equal=0;

       if(ResultString[k].indexOf((int)'>')==-1 && ResultString[k].indexOf((int)'|')==-1){

       if(ResultString[k].indexOf((int)'~')==0) TempString=new String(ResultString[k].substring(1));
       else   //if(FactString[k].indexOf((int)'~')!=0)
       TempString=new String('~'+ResultString[k]);
       if(!TempString.equals(Tem_Item[0])) {If_First_Equal=1; continue;}

       else if(If_First_Equal!=1 && TempString.equals(Tem_Item[0]) && FTem_Item[1].indexOf((int)'~')==0){
       TempStringImply=new String(FTem_Item[1].substring(1));
       if(TempStringImply.equals(Tem_Item[1])) {
       Imply_Conflict=1;
       Replace1=1000; Replace2=1000;
       Replace11=i;
       Replace22=i;
//       ta.appendText("here j="+j+"\n");
//       ta.appendText("there k="+k+"\n");
       Mem_No1=new String(ResultString[j]);
       Mem_No=new String(ResultString[k]);
//       ta.appendText("here there Mem_No="+Mem_No+", Mem_No1="+Mem_No1+"\n");
       }

       }
       if(If_First_Equal!=1 && TempString.equals(Tem_Item[0]) && Tem_Item[1].indexOf((int)'~')==0){
       TempStringImply=new String(Tem_Item[1].substring(1));
 //    ta.appendText("If_First_Equal="+If_First_Equal+",TemString="+TempString+",FTem_Item[1]="+FTem_Item[1]+"\n");
       if(TempStringImply.equals(FTem_Item[1])) {
        Imply_Conflict=1;
        Replace1=1000; Replace2=1000;
        Replace11=i;
        Replace22=i;
       Mem_No1=new String(ResultString[j]);
       Mem_No=new String(ResultString[k]);
       }

      }
      } /* for if */
     }  /* for k=0;k < */


  }   /* for if */


  } /* for for(j=0;j<Num_facts;j++) */
 } /* for if(total_item==2) */


// stop here to test two items in hypotheses for the imply situation

/* self checking starts here */
   if(total_item==1) {
//  Imply_Temp1=new String(Tem_Item[0]+'-'+'>');
  TempString=new String("00");
  FTem_Item[0]=new String("00");
  FTem_Item[1]=new String("00");
  FTem_Item_Imply[0]=new String("00");
  FTem_Item_Imply[1]=new String("00");
  for(j=0;j<Num_Facts;j++)
      if(FactString[j].indexOf((int)'>')==-1 && FactString[j].indexOf((int)'|')==-1){
       TempString=new String(FactString[j]);
       if(TempString.indexOf((int)'~')==0) FTem_Item[0]=new String(TempString.substring(1));
       else FTem_Item[0]=new String('~'+TempString);

       if(Tem_Item[0].equals(FTem_Item[0])) Imply_Conflict1=1;
  }



  for(j=0;j<Num_Results;j++)
      if(ResultString[j].indexOf((int)'>')==-1 && ResultString[j].indexOf((int)'|')==-1){
       TempString=new String(ResultString[j]);
       if(TempString.indexOf((int)'~')==0) FTem_Item[0]=new String(TempString.substring(1));
       else FTem_Item[0]=new String('~'+TempString);

       if(Tem_Item[0].equals(FTem_Item[0])) Imply_Conflict1=1;
  }
} /* for if(total_item==1) */
// ta.appendText("Post 7: "+Replace1+"\n");
 if(total_item==2) {
  TempString=new String("00");
  FTem_Item[0]=new String("00");
  FTem_Item[1]=new String("00");
  FTem_Item_Imply[0]=new String("00");
  FTem_Item_Imply[1]=new String("00");
//  Imply_Temp1=new String(Tem_Item[0]+'-'+'>');
  for(j=0;j<Num_Results;j++){

    Ftotal_item=0;
    If_First_Equal=0;

    if(ResultString[j].indexOf((int)'>')!=-1){

     FTokens=new StringTokenizer(ResultString[j],"->");
     TempFlag=0;

     while(FTokens.hasMoreTokens()){
       TempString=new String(FTokens.nextToken());
       if(TempFlag==0) FTem_Item[Ftotal_item]=new String(TempString);
       else if(TempFlag!=0 && TempString.indexOf((int)'~')==0) FTem_Item[Ftotal_item]=new String(TempString.substring(1));
       else if(TempFlag!=0 && TempString.indexOf((int)'~')!=0) FTem_Item[Ftotal_item]=new String('~'+TempString);
       Ftotal_item=Ftotal_item+1;
       TempFlag=TempFlag+1;
     }

    if(Tem_Item[0].equals(FTem_Item[0]) && Tem_Item[1].equals(FTem_Item[1])) Imply_Conflict1=1;
    if(Tem_Item[0].equals(FTem_Item[1]) && Tem_Item[1].equals(FTem_Item[0])) Imply_Conflict1=1;

 }
 }

   for(j=0;j<Num_Facts;j++){

    Ftotal_item=0;
    If_First_Equal=0;

    if(FactString[j].indexOf((int)'>')!=-1){

     FTokens=new StringTokenizer(FactString[j],"->");
     TempFlag=0;

     while(FTokens.hasMoreTokens()){
       TempString=new String(FTokens.nextToken());
       if(TempFlag==0) FTem_Item[Ftotal_item]=new String(TempString);
       else if(TempFlag!=0 && TempString.indexOf((int)'~')==0) FTem_Item[Ftotal_item]=new String(TempString.substring(1));
       else if(TempFlag!=0 && TempString.indexOf((int)'~')!=0) FTem_Item[Ftotal_item]=new String('~'+TempString);
       Ftotal_item=Ftotal_item+1;
       TempFlag=TempFlag+1;
     }

    if(Tem_Item[0].equals(FTem_Item[0]) && Tem_Item[1].equals(FTem_Item[1])) Imply_Conflict1=1;
    if(Tem_Item[0].equals(FTem_Item[1]) && Tem_Item[1].equals(FTem_Item[0])) Imply_Conflict1=1;

 }
 }

  for(j=0;j<Num_Results;j++){

   Ftotal_item=0;

    if(ResultString[j].indexOf((int)'|')!=-1){

     FTokens=new StringTokenizer(ResultString[j],"|");

     while(FTokens.hasMoreTokens()){
       TempString=new String(FTokens.nextToken());
       if(TempString.indexOf((int)'~')==0) FTem_Item[Ftotal_item]=new String(TempString.substring(1));
       else if(TempString.indexOf((int)'~')!=0) FTem_Item[Ftotal_item]=new String('~'+TempString);
       Ftotal_item=Ftotal_item+1;
     }

    if(Tem_Item[0].equals(FTem_Item[0]) && Tem_Item[1].equals(FTem_Item[1])) Imply_Conflict1=1;
    if(Tem_Item[0].equals(FTem_Item[1]) && Tem_Item[1].equals(FTem_Item[0])) Imply_Conflict1=1;

 }
 }

  for(j=0;j<Num_Facts;j++){

   Ftotal_item=0;

    if(FactString[j].indexOf((int)'|')!=-1){

     FTokens=new StringTokenizer(FactString[j],"|");

     while(FTokens.hasMoreTokens()){
       TempString=new String(FTokens.nextToken());
       if(TempString.indexOf((int)'~')==0) FTem_Item[Ftotal_item]=new String(TempString.substring(1));
       else if(TempString.indexOf((int)'~')!=0) FTem_Item[Ftotal_item]=new String('~'+TempString);
       Ftotal_item=Ftotal_item+1;
     }

    if(Tem_Item[0].equals(FTem_Item[0]) && Tem_Item[1].equals(FTem_Item[1])) Imply_Conflict1=1;
    if(Tem_Item[0].equals(FTem_Item[1]) && Tem_Item[1].equals(FTem_Item[0])) Imply_Conflict1=1;

 }
 }

 } 

/* self checking stops here*/

/* Double check starts here */

  if(total_item==1) {
//  Imply_Temp1=new String(Tem_Item[0]+'-'+'>');
  TempString=new String("00");
  FTem_Item[0]=new String("00");
  FTem_Item[1]=new String("00");
  FTem_Item_Imply[0]=new String("00");
  FTem_Item_Imply[1]=new String("00");
  for(j=0;j<Num_Facts;j++){

    Ftotal_item=0;
    If_First_Equal=0;

    if(FactString[j].indexOf((int)'>')!=-1){

     FTokens=new StringTokenizer(FactString[j],"->");
     TempFlag=0;

     while(FTokens.hasMoreTokens()){
       TempString=new String(FTokens.nextToken());
 //      ta.appendText("TempString="+TempString+", Tem_Item[0]="+Tem_Item[0]+"\n");
//       if(!TempString.equals(Tem_Item[0]) && Ftotal_item==0) {
//        If_First_Equal=1;
//        break;}
	   if(TempFlag==0) FTem_Item[Ftotal_item]=new String(TempString);
	   else if(TempFlag!=0 && TempString.indexOf((int)'~')!=0) FTem_Item[Ftotal_item]=new String('~'+TempString);
	   else if(TempFlag!=0 && TempString.indexOf((int)'~')==0) FTem_Item[Ftotal_item]=new String(TempString.substring(1));
	   Ftotal_item=Ftotal_item+1;
	   TempFlag=TempFlag+1;
	 }

//      if(If_First_Equal==1) continue;

      for(k=0;k<Num_Facts;k++){
      if(k==j) continue;
       Ftotal_item=0;
       If_First_Equal=0;

        if(FactString[k].indexOf((int)'>')==-1 && FactString[k].indexOf((int)'|')==-1){
           TempString=new String(FactString[k]);
           if(Tem_Item[0].equals(FTem_Item[0]) && TempString.equals(FTem_Item[1])) Imply_Conflict1=1;
           if(Tem_Item[0].equals(FTem_Item[1]) && TempString.equals(FTem_Item[0])) Imply_Conflict1=1;

     }
     }  /* for k=0;k < */


  }   /* for if */

     if(FactString[j].indexOf((int)'|')!=-1){

     FTokens=new StringTokenizer(FactString[j],"|");
     TempFlag=0;

     while(FTokens.hasMoreTokens()){
       TempString=new String(FTokens.nextToken());
 //      ta.appendText("TempString="+TempString+", Tem_Item[0]="+Tem_Item[0]+"\n");
//       if(!TempString.equals(Tem_Item[0]) && Ftotal_item==0) {
//        If_First_Equal=1;
//        break;}

	   if(TempString.indexOf((int)'~')!=0) FTem_Item[Ftotal_item]=new String('~'+TempString);
	   else FTem_Item[Ftotal_item]=new String(TempString.substring(1));
	   Ftotal_item=Ftotal_item+1;
	 }

//      if(If_First_Equal==1) continue;

      for(k=0;k<Num_Facts;k++){
      if(k==j) continue;
       Ftotal_item=0;
       If_First_Equal=0;

        if(FactString[k].indexOf((int)'>')==-1 && FactString[k].indexOf((int)'|')==-1){
           TempString=new String(FactString[k]);
           if(Tem_Item[0].equals(FTem_Item[0]) && TempString.equals(FTem_Item[1])) Imply_Conflict1=1;
           if(Tem_Item[0].equals(FTem_Item[1]) && TempString.equals(FTem_Item[0])) Imply_Conflict1=1;

     }
     }  /* for k=0;k < */

    }   /* for if */
  } /* for for(j=0;j<Num_facts;j++) */
 } /* for if(total_item==1) */

   if(total_item==1) {
//  Imply_Temp1=new String(Tem_Item[0]+'-'+'>');
  TempString=new String("00");
  FTem_Item[0]=new String("00");
  FTem_Item[1]=new String("00");
  FTem_Item_Imply[0]=new String("00");
  FTem_Item_Imply[1]=new String("00");
  for(j=0;j<Num_Facts;j++){

    Ftotal_item=0;
    If_First_Equal=0;

    if(FactString[j].indexOf((int)'>')!=-1){

     FTokens=new StringTokenizer(FactString[j],"->");
     TempFlag=0;

     while(FTokens.hasMoreTokens()){
       TempString=new String(FTokens.nextToken());
 //      ta.appendText("TempString="+TempString+", Tem_Item[0]="+Tem_Item[0]+"\n");
//       if(!TempString.equals(Tem_Item[0]) && Ftotal_item==0) {
//        If_First_Equal=1;
//        break;}
	   if(TempFlag==0) FTem_Item[Ftotal_item]=new String(TempString);
	   else if(TempFlag!=0 && TempString.indexOf((int)'~')!=0) FTem_Item[Ftotal_item]=new String('~'+TempString);
	   else if(TempFlag!=0 && TempString.indexOf((int)'~')==0) FTem_Item[Ftotal_item]=new String(TempString.substring(1));
	   Ftotal_item=Ftotal_item+1;
	   TempFlag=TempFlag+1;
	 }

//      if(If_First_Equal==1) continue;

      for(k=0;k<Num_Results;k++){
       Ftotal_item=0;
       If_First_Equal=0;

        if(ResultString[k].indexOf((int)'>')==-1 && ResultString[k].indexOf((int)'|')==-1){
           TempString=new String(ResultString[k]);
           if(Tem_Item[0].equals(FTem_Item[0]) && TempString.equals(FTem_Item[1]))
//           {Imply_Conflict1=1;Replace1=1000;Replace11=i;Mem_No=new String(ResultString[k]);}
             Imply_Conflict1=1;
           if(Tem_Item[0].equals(FTem_Item[1]) && TempString.equals(FTem_Item[0]))
//           {Imply_Conflict1=1;Replace1=1000;Replace11=i;Mem_No=new String(ResultString[k]);}
              Imply_Conflict1=1;
     }
     }  /* for k=0;k < */


  }   /* for if */

     if(FactString[j].indexOf((int)'|')!=-1){

     FTokens=new StringTokenizer(FactString[j],"|");
     TempFlag=0;

     while(FTokens.hasMoreTokens()){
       TempString=new String(FTokens.nextToken());
 //      ta.appendText("TempString="+TempString+", Tem_Item[0]="+Tem_Item[0]+"\n");
//       if(!TempString.equals(Tem_Item[0]) && Ftotal_item==0) {
//        If_First_Equal=1;
//        break;}

	   if(TempString.indexOf((int)'~')!=0) FTem_Item[Ftotal_item]=new String('~'+TempString);
	   else FTem_Item[Ftotal_item]=new String(TempString.substring(1));
	   Ftotal_item=Ftotal_item+1;
	 }

//      if(If_First_Equal==1) continue;

      for(k=0;k<Num_Results;k++){
       Ftotal_item=0;
       If_First_Equal=0;

        if(ResultString[k].indexOf((int)'>')==-1 && ResultString[k].indexOf((int)'|')==-1){
           TempString=new String(ResultString[k]);
           if(Tem_Item[0].equals(FTem_Item[0]) && TempString.equals(FTem_Item[1]))
 //          {Imply_Conflict1=1;Replace1=1000;Replace11=i;Mem_No=new String(ResultString[k]);}
             Imply_Conflict1=1;
           if(Tem_Item[0].equals(FTem_Item[1]) && TempString.equals(FTem_Item[0]))
//           {Imply_Conflict1=1;Replace1=1000;Replace11=i;Mem_No=new String(ResultString[k]);}
              Imply_Conflict1=1;
     }
     }  /* for k=0;k < */

    }   /* for if */
  } /* for for(j=0;j<Num_facts;j++) */
 } /* for if(total_item==1) */


   if(total_item==1) {

  TempString=new String("00");
  FTem_Item[0]=new String("00");
  FTem_Item[1]=new String("00");
  FTem_Item_Imply[0]=new String("00");
  FTem_Item_Imply[1]=new String("00");
  for(j=0;j<Num_Results;j++){

    Ftotal_item=0;
    If_First_Equal=0;

    if(ResultString[j].indexOf((int)'>')!=-1){

     FTokens=new StringTokenizer(ResultString[j],"->");
     TempFlag=0;

     while(FTokens.hasMoreTokens()){
       TempString=new String(FTokens.nextToken());
 //      ta.appendText("TempString="+TempString+", Tem_Item[0]="+Tem_Item[0]+"\n");
//       if(!TempString.equals(Tem_Item[0]) && Ftotal_item==0) {
//        If_First_Equal=1;
//        break;}
	   if(TempFlag==0) FTem_Item[Ftotal_item]=new String(TempString);
	   else if(TempFlag!=0 && TempString.indexOf((int)'~')!=0) FTem_Item[Ftotal_item]=new String('~'+TempString);
	   else if(TempFlag!=0 && TempString.indexOf((int)'~')==0) FTem_Item[Ftotal_item]=new String(TempString.substring(1));
	   Ftotal_item=Ftotal_item+1;
	   TempFlag=TempFlag+1;
	 }

//      if(If_First_Equal==1) continue;

      for(k=0;k<Num_Facts;k++){
       Ftotal_item=0;
       If_First_Equal=0;

        if(FactString[k].indexOf((int)'>')==-1 && FactString[k].indexOf((int)'|')==-1){
           TempString=new String(FactString[k]);
           if(Tem_Item[0].equals(FTem_Item[0]) && TempString.equals(FTem_Item[1]))
//           {Imply_Conflict1=1;Replace1=1000;Replace11=i;Mem_No=new String(ResultString[j]);}
             Imply_Conflict1=1;
           if(Tem_Item[0].equals(FTem_Item[1]) && TempString.equals(FTem_Item[0]))
 //          {Imply_Conflict1=1;Replace1=1000;Replace11=i;Mem_No=new String(ResultString[j]);}
             Imply_Conflict1=1;
     }
     }  /* for k=0;k < */


  }   /* for if */

     if(ResultString[j].indexOf((int)'|')!=-1){

     FTokens=new StringTokenizer(ResultString[j],"|");
     TempFlag=0;

     while(FTokens.hasMoreTokens()){
       TempString=new String(FTokens.nextToken());
 //      ta.appendText("TempString="+TempString+", Tem_Item[0]="+Tem_Item[0]+"\n");
//       if(!TempString.equals(Tem_Item[0]) && Ftotal_item==0) {
//        If_First_Equal=1;
//        break;}

	   if(TempString.indexOf((int)'~')!=0) FTem_Item[Ftotal_item]=new String('~'+TempString);
	   else FTem_Item[Ftotal_item]=new String(TempString.substring(1));
	   Ftotal_item=Ftotal_item+1;
	 }

//      if(If_First_Equal==1) continue;

      for(k=0;k<Num_Facts;k++){
       Ftotal_item=0;
       If_First_Equal=0;

        if(FactString[k].indexOf((int)'>')==-1 && FactString[k].indexOf((int)'|')==-1){
           TempString=new String(FactString[k]);
           if(Tem_Item[0].equals(FTem_Item[0]) && TempString.equals(FTem_Item[1]))
//           {Imply_Conflict1=1;Replace1=1000;Replace11=i;Mem_No=new String(ResultString[j]);}
           Imply_Conflict1=1;
           if(Tem_Item[0].equals(FTem_Item[1]) && TempString.equals(FTem_Item[0]))
//           {Imply_Conflict1=1;Replace1=1000;Replace11=i;Mem_No=new String(ResultString[j]);}
           Imply_Conflict1=1;
     }
     }  /* for k=0;k < */

    }   /* for if */
  } /* for for(j=0;j<Num_facts;j++) */
 } /* for if(total_item==1) */

   if(total_item==1) {
//  Imply_Temp1=new String(Tem_Item[0]+'-'+'>');
  TempString=new String("00");
  FTem_Item[0]=new String("00");
  FTem_Item[1]=new String("00");
  FTem_Item_Imply[0]=new String("00");
  FTem_Item_Imply[1]=new String("00");
  for(j=0;j<Num_Results;j++){

    Ftotal_item=0;
    If_First_Equal=0;

    if(ResultString[j].indexOf((int)'>')!=-1){

     FTokens=new StringTokenizer(ResultString[j],"->");
     TempFlag=0;

     while(FTokens.hasMoreTokens()){
       TempString=new String(FTokens.nextToken());
 //      ta.appendText("TempString="+TempString+", Tem_Item[0]="+Tem_Item[0]+"\n");
//       if(!TempString.equals(Tem_Item[0]) && Ftotal_item==0) {
//        If_First_Equal=1;
//        break;}
	   if(TempFlag==0) FTem_Item[Ftotal_item]=new String(TempString);
	   else if(TempFlag!=0 && TempString.indexOf((int)'~')!=0) FTem_Item[Ftotal_item]=new String('~'+TempString);
	   else if(TempFlag!=0 && TempString.indexOf((int)'~')==0) FTem_Item[Ftotal_item]=new String(TempString.substring(1));
	   Ftotal_item=Ftotal_item+1;
	   TempFlag=TempFlag+1;
	 }

//      if(If_First_Equal==1) continue;

      for(k=0;k<Num_Results;k++){
      if(k==j) continue;
       Ftotal_item=0;
       If_First_Equal=0;

        if(ResultString[k].indexOf((int)'>')==-1 && ResultString[k].indexOf((int)'|')==-1){
           TempString=new String(ResultString[k]);
           if(Tem_Item[0].equals(FTem_Item[0]) && TempString.equals(FTem_Item[1]))
/*            {Imply_Conflict1=1;Replace1=1000;Replace11=i;Replace2=1000;Replace22=i;
             Mem_No=new String(ResultString[k]);
             Mem_No1=new String(ResultString[j]);
            }
*/
            Imply_Conflict1=1;
           if(Tem_Item[0].equals(FTem_Item[1]) && TempString.equals(FTem_Item[0]))
/*            {Imply_Conflict1=1;Replace1=1000;Replace11=i;Replace2=1000;Replace22=i;
             Mem_No=new String(ResultString[k]);
             Mem_No1=new String(ResultString[j]);
            }    */
            Imply_Conflict1=1;

     }
     }  /* for k=0;k < */


  }   /* for if */

     if(ResultString[j].indexOf((int)'|')!=-1){

     FTokens=new StringTokenizer(ResultString[j],"|");
     TempFlag=0;

     while(FTokens.hasMoreTokens()){
       TempString=new String(FTokens.nextToken());
 //      ta.appendText("TempString="+TempString+", Tem_Item[0]="+Tem_Item[0]+"\n");
//       if(!TempString.equals(Tem_Item[0]) && Ftotal_item==0) {
//        If_First_Equal=1;
//        break;}

	   if(TempString.indexOf((int)'~')!=0) FTem_Item[Ftotal_item]=new String('~'+TempString);
	   else FTem_Item[Ftotal_item]=new String(TempString.substring(1));
	   Ftotal_item=Ftotal_item+1;
	 }

//      if(If_First_Equal==1) continue;

      for(k=0;k<Num_Results;k++){
      if(k==j) continue;
       Ftotal_item=0;
       If_First_Equal=0;

        if(ResultString[k].indexOf((int)'>')==-1 && ResultString[k].indexOf((int)'|')==-1){
           TempString=new String(ResultString[k]);
           if(Tem_Item[0].equals(FTem_Item[0]) && TempString.equals(FTem_Item[1]))
 /*           {Imply_Conflict=1;Replace1=1000;Replace11=i;Replace2=1000;Replace22=i;
             Mem_No=new String(ResultString[k]);
             Mem_No1=new String(ResultString[j]);
            }    */
            Imply_Conflict1=1;
           if(Tem_Item[0].equals(FTem_Item[1]) && TempString.equals(FTem_Item[0]))
/*            {Imply_Conflict=1;Replace1=1000;Replace11=i;Replace2=1000;Replace22=i;
             Mem_No=new String(ResultString[k]);
             Mem_No1=new String(ResultString[j]);
            }    */
            Imply_Conflict1=1;

     }
     }  /* for k=0;k < */

    }   /* for if */
  } /* for for(j=0;j<Num_facts;j++) */
 } /* for if(total_item==1) */
// ta.appendText("Post 8: "+Replace1+"\n");
   if(total_item==2) {

  TempString=new String("00");
  FTem_Item[0]=new String("00");
  FTem_Item[1]=new String("00");
  FTem_Item_Imply[0]=new String("00");
  FTem_Item_Imply[1]=new String("00");

  for(j=0;j<Num_Results;j++){
  if(ResultString[j].indexOf((int)'>')==-1 && ResultString[j].indexOf((int)'|')==-1){
  TempString=new String(ResultString[j]);
  if(TempString.indexOf((int)'~')==0) FTem_Item[0]=new String(TempString.substring(1));
  if(TempString.indexOf((int)'~')!=0) FTem_Item[0]=new String('~'+TempString);

//      if(If_First_Equal==1) continue;

      for(k=0;k<Num_Facts;k++){
         if(FactString[k].indexOf((int)'>')==-1 && FactString[k].indexOf((int)'|')==-1){
           TempStringImply=new String(FactString[k]);
           if(TempStringImply.indexOf((int)'~')==0) TempString=new String(TempStringImply.substring(1));
           if(TempStringImply.indexOf((int)'~')!=0) TempString=new String('~'+TempStringImply);
         }
      }

           if(Tem_Item[0].equals(FTem_Item[0]) && TempString.equals(Tem_Item[1]))
//           {Imply_Conflict1=1;Replace1=1000;Replace11=i;Mem_No=new String(ResultString[j]);}
             Imply_Conflict1=1;
           if(Tem_Item[1].equals(FTem_Item[0]) && TempString.equals(Tem_Item[0]))
//           {Imply_Conflict1=1;Replace1=1000;Replace11=i;Mem_No=new String(ResultString[j]);}
             Imply_Conflict1=1;
    for(k=0;k<Num_Results;k++){
    if(k==j) continue;
         if(ResultString[k].indexOf((int)'>')==-1 && ResultString[k].indexOf((int)'|')==-1){
           TempStringImply=new String(ResultString[k]);
           if(TempStringImply.indexOf((int)'~')==0) TempString=new String(TempStringImply.substring(1));
           if(TempStringImply.indexOf((int)'~')!=0) TempString=new String('~'+TempStringImply);
         }
      }

           if(Tem_Item[0].equals(FTem_Item[0]) && TempString.equals(Tem_Item[1]))
/*           {Imply_Conflict=1;Replace1=1000;Replace2=1000;Replace22=i;
             Replace11=i;Mem_No=new String(ResultString[j]);Mem_No1=new String(ResultString[k]);}
*/
             Imply_Conflict1=1;
           if(Tem_Item[1].equals(FTem_Item[0]) && TempString.equals(Tem_Item[0]))
/*           {Imply_Conflict=1;Replace1=1000;Replace2=1000;Replace11=i;
             Replace22=i;Mem_No=new String(ResultString[j]);Mem_No1=new String(ResultString[k]);}
 */
             Imply_Conflict1=1;
  }   /* for if */
 } /* for for(j=0;j<Num_facts;j++) */

 TempString=new String("00");
  FTem_Item[0]=new String("00");
  FTem_Item[1]=new String("00");
  FTem_Item_Imply[0]=new String("00");
  FTem_Item_Imply[1]=new String("00");

  for(j=0;j<Num_Facts;j++){
  if(FactString[j].indexOf((int)'>')==-1 && FactString[j].indexOf((int)'|')==-1){
  TempString=new String(FactString[j]);
  if(TempString.indexOf((int)'~')==0) FTem_Item[0]=new String(TempString.substring(1));
  if(TempString.indexOf((int)'~')!=0) FTem_Item[0]=new String('~'+TempString);

//      if(If_First_Equal==1) continue;

      for(k=0;k<Num_Facts;k++){
      if(k==j) continue;
         if(FactString[k].indexOf((int)'>')==-1 && FactString[k].indexOf((int)'|')==-1){
           TempStringImply=new String(FactString[k]);
           if(TempStringImply.indexOf((int)'~')==0) TempString=new String(TempStringImply.substring(1));
           if(TempStringImply.indexOf((int)'~')!=0) TempString=new String('~'+TempStringImply);
         }
      }

           if(Tem_Item[0].equals(FTem_Item[0]) && TempString.equals(Tem_Item[1])) Imply_Conflict1=1;
//           {Imply_Conflict=1;Replace1=1000;Replace11=i;Mem_No=new String(ResultString[j]);}
           if(Tem_Item[1].equals(FTem_Item[0]) && TempString.equals(Tem_Item[0])) Imply_Conflict1=1;
//           {Imply_Conflict=1;Replace1=1000;Replace11=i;Mem_No=new String(ResultString[j]);}

  }   /* for if */
 } /* for for(j=0;j<Num_facts;j++) */


 } /* for if(total_item==2) */

// ta.appendText("Post 9: "+Replace1+"\n");
/*double check stops here*/

   H_Check_Flag=0;
   H_Conflict=0;

   for(j=0;j<i;j++){
   NewHtotal_item=0;
   if(HypothesesString[j].indexOf((int)'|')==-1 && HypothesesString[j].indexOf((int)'>')==-1) {
     NewHTem_Item[NewHtotal_item]=new String(HypothesesString[j]);
	 NewHtotal_item=NewHtotal_item+1;
   }
   else if(HypothesesString[j].indexOf((int)'|')==-1 && HypothesesString[j].indexOf((int)'>')!=-1){
     HTokens=new StringTokenizer(HypothesesString[j],"->");
	 TempFlag=0;
     while(HTokens.hasMoreTokens()){
       TempString=new String(HTokens.nextToken());
	   if(TempFlag==0 && TempString.indexOf((int)'~')==0) NewHTem_Item[NewHtotal_item]=new String(TempString.substring(1));
	   else if(TempFlag==0 && TempString.indexOf((int)'~')!=0) NewHTem_Item[NewHtotal_item]=new String('~'+TempString);
	   else if(TempFlag!=0) NewHTem_Item[NewHtotal_item]=new String(TempString);
	   NewHtotal_item=NewHtotal_item+1;
	   TempFlag=TempFlag+1;
	 }
   }
   else if(HypothesesString[j].indexOf((int)'|')!=-1 && HypothesesString[j].indexOf((int)'>')==-1){
     HTokens=new StringTokenizer(HypothesesString[j],"|");
     while(HTokens.hasMoreTokens()){
       NewHTem_Item[NewHtotal_item]=new String(HTokens.nextToken());
	   NewHtotal_item=NewHtotal_item+1;
     }
   }


   for(k=0;k<NewHtotal_item;k++){

    if(NewHTem_Item[k].indexOf((int)'~')==0) {
        TempString=new String(NewHTem_Item[k].substring(1));
        for(kk=0;kk<TH_Flag;kk++) if(CurrentHT[kk].equals(TempString)) H_Check_Flag=H_Check_Flag+1;
	}
	if(NewHTem_Item[k].indexOf((int)'~')!=0) {
        TempString=new String(NewHTem_Item[k]);
	for(kk=0;kk<FH_Flag;kk++) if(CurrentHF[kk].equals(TempString)) H_Check_Flag=H_Check_Flag+1;
	}
   }
 /*  if(H_Check_Flag==NewHtotal_item && NewHtotal_item!=1) {
    H_Conflict=1;
    if(First_Discard_Flag==0) Mem_No=new String(HypothesesString[j]);
    ta.appendText("j="+j+"\n");
    j=i;
    } */
  }

//  ta.appendText("1: H_Conflict="+H_Conflict+"\n");
   F_Conflict=0;
   FS_No=0;
   for(j=0;j<Num_Facts;j++){
   Ftotal_item=0;
   if(FactString[j].indexOf((int)'|')==-1 && FactString[j].indexOf((int)'>')==-1) {
     FTem_Item[Ftotal_item]=new String(FactString[j]);
	 Ftotal_item=Ftotal_item+1;
   }
   else if(FactString[j].indexOf((int)'|')==-1 && FactString[j].indexOf((int)'>')!=-1){
     FTokens=new StringTokenizer(FactString[j],"->");
	 TempFlag=0;
     while(FTokens.hasMoreTokens()){
       TempString=new String(FTokens.nextToken());
	   if(TempFlag==0 && TempString.indexOf((int)'~')==0) FTem_Item[Ftotal_item]=new String(TempString.substring(1));
	   else if(TempFlag==0 && TempString.indexOf((int)'~')!=0) FTem_Item[Ftotal_item]=new String('~'+TempString);
	   else if(TempFlag!=0) FTem_Item[Ftotal_item]=new String(TempString);
	   Ftotal_item=Ftotal_item+1;
	   TempFlag=TempFlag+1;
	 }
   }
   else if(FactString[j].indexOf((int)'|')!=-1 && FactString[j].indexOf((int)'>')==-1){
     FTokens=new StringTokenizer(FactString[j],"|");
     while(FTokens.hasMoreTokens()){
       FTem_Item[Ftotal_item]=new String(FTokens.nextToken());
	   Ftotal_item=Ftotal_item+1;
     }
   }

   F_Check_Flag=0;
   FS_Check_Flag=0;
   for(k=0;k<Ftotal_item;k++){

    if(FTem_Item[k].indexOf((int)'~')==0) {
        TempString=new String(FTem_Item[k].substring(1));
	for(kk=0;kk<TNum_HItem;kk++) if(True_H[kk].equals(TempString)) F_Check_Flag=F_Check_Flag+1;
        for(kk=0;kk<TH_Flag;kk++) if(CurrentHT[kk].equals(TempString)) FS_Check_Flag=FS_Check_Flag+1;
       	}
	if(FTem_Item[k].indexOf((int)'~')!=0) {
        TempString=new String(FTem_Item[k]);
	for(kk=0;kk<FNum_HItem;kk++) if(False_H[kk].equals(TempString)) F_Check_Flag=F_Check_Flag+1;
	for(kk=0;kk<FH_Flag;kk++) if(CurrentHF[kk].equals(TempString)) FS_Check_Flag=FS_Check_Flag+1;
	}
   }

   Total_TNum_FNum=TH_Flag+FH_Flag;

//   ta.appendText(F_Check_Flag+" "+Ftotal_item+" "+TNum_HItem+" "+FNum_HItem+" "+Total_TNum_FNum+"\n");

   if(F_Check_Flag==Ftotal_item && F_Check_Flag==(TNum_HItem+FNum_HItem)) {F_Conflict=1; j=Num_Facts;}
   if(FS_Check_Flag==Ftotal_item  && FS_Check_Flag==Total_TNum_FNum) {FS_No=1;F_Conflict=1; j=Num_Facts;}

//   ta.appendText("2: H_Conflict="+H_Conflict+"\n");

   Another_TempF0=new String("00");
   Another_TempF1=new String("00");

   Rtotal_item=0;
   Sf_Sh_String=new String[2];
   Sf_Sh_Check_Double=0;
   if(FH_Flag+TH_Flag<2 && Ftotal_item==1) {

   if(FTem_Item[0].indexOf((int)'~')==0) Another_TempF0=new String(FTem_Item[0].substring(1));
   if(FTem_Item[0].indexOf((int)'~')!=0) Another_TempF1=new String(FTem_Item[0]);

    for(kkk=0;kkk<Num_Results;kkk++){
     Sf_Sh_Check_Double=0;
     Rtotal_item=0;

   if(ResultString[kkk].indexOf((int)'>')!=-1){
     RTokens=new StringTokenizer(ResultString[kkk],"->");
	 TempFlag=0;
     while(RTokens.hasMoreTokens()){
       TempString=new String(RTokens.nextToken());
	   if(TempFlag==0 && TempString.indexOf((int)'~')==0) Sf_Sh_String[Rtotal_item]=new String(TempString.substring(1));
	   else if(TempFlag==0 && TempString.indexOf((int)'~')!=0) Sf_Sh_String[Rtotal_item]=new String('~'+TempString);
	   else if(TempFlag!=0) Sf_Sh_String[Rtotal_item]=new String(TempString);
	   Rtotal_item=Rtotal_item+1;
	   TempFlag=TempFlag+1;
	 }
   }
   else if(ResultString[kkk].indexOf((int)'|')!=-1){
     RTokens=new StringTokenizer(ResultString[kkk],"|");
     while(RTokens.hasMoreTokens()){
       Sf_Sh_String[Rtotal_item]=new String(RTokens.nextToken());
	   Rtotal_item=Rtotal_item+1;
     }
   }

       for(k=0;k<Rtotal_item;k++){
        if(Sf_Sh_String[k].indexOf((int)'~')==0) {
        TempString=new String(Sf_Sh_String[k].substring(1));
        if(TempString.equals(Another_TempF1)) Sf_Sh_Check_Double=Sf_Sh_Check_Double+1;
        if(TempString.equals(CurrentHT[0])) Sf_Sh_Check_Double=Sf_Sh_Check_Double+1;
       	}
	if(Sf_Sh_String[k].indexOf((int)'~')!=0) {
        TempString=new String(Sf_Sh_String[k]);
        if(TempString.equals(Another_TempF0)) Sf_Sh_Check_Double=Sf_Sh_Check_Double+1;
        if(TempString.equals(CurrentHF[0])) Sf_Sh_Check_Double=Sf_Sh_Check_Double+1;
	}
       }
      if(Sf_Sh_Check_Double==2) {
 //      ta.appendText("Ok\n");
       if(First_Discard_Flag==0) Mem_No=new String(ResultString[kkk]);
       H_Conflict=1;
       kkk=Num_Results;
      }
    }
   }

//   ta.appendText("3: H_Conflict="+H_Conflict+"\n");

   Another_TempF0=new String("00");
   Another_TempF1=new String("00");
   Another_TempH0=new String("00");
   Another_TempH1=new String("00");

   Sf_Sh_Check_Double=0;

   if(FH_Flag+TH_Flag==2 && Ftotal_item==1) {
 //  ta.appendText("1.ok\n");
   if(FTem_Item[0].indexOf((int)'~')==0) Another_TempF0=new String(FTem_Item[0].substring(1));
   if(FTem_Item[0].indexOf((int)'~')!=0) Another_TempF1=new String(FTem_Item[0]);

    for(kkk=0;kkk<Num_Results;kkk++){
     Sf_Sh_Check_Double=0;
 //   ta.appendText("2.ok\n");
   if(ResultString[kkk].indexOf((int)'>')==-1 && ResultString[kkk].indexOf((int)'|')==-1){
        if(ResultString[kkk].indexOf((int)'~')==0) {
        TempString=new String(ResultString[kkk].substring(1));
  //      if(TempString.equals(Another_TempF1)) Sf_Sh_Check_Double=Sf_Sh_Check_Double+1;
        for(kk=0;kk<TH_Flag;kk++){
          if(CurrentHT[kk].equals(TempString)) Sf_Sh_Check_Double=Sf_Sh_Check_Double+1;
          if(CurrentHT[kk].equals(Another_TempF0)) Sf_Sh_Check_Double=Sf_Sh_Check_Double+1;
        }
        for(kk=0;kk<FH_Flag;kk++)
        if(CurrentHF[kk].equals(Another_TempF1)) Sf_Sh_Check_Double=Sf_Sh_Check_Double+1;
 //       ta.appendText("3.ok\n");
       }
	if(ResultString[kkk].indexOf((int)'~')!=0) {
        TempString=new String(ResultString[kkk]);
//        if(TempString.equals(Another_TempF0)) Sf_Sh_Check_Double=Sf_Sh_Check_Double+1;
        for(kk=0;kk<FH_Flag;kk++){
         if(CurrentHF[kk].equals(TempString)) Sf_Sh_Check_Double=Sf_Sh_Check_Double+1;
         if(CurrentHF[kk].equals(Another_TempF1)) Sf_Sh_Check_Double=Sf_Sh_Check_Double+1;
        }
        for(kk=0;kk<TH_Flag;kk++)
        if(CurrentHT[kk].equals(Another_TempF0)) Sf_Sh_Check_Double=Sf_Sh_Check_Double+1;
 //       ta.appendText("4.ok\n");
	}
    }
      if(Sf_Sh_Check_Double==2) {
 //       ta.appendText("5.ok\n");
        if(First_Discard_Flag==0) Mem_No=new String(ResultString[kkk]);
        H_Conflict=1;
        kkk=Num_Results;
        }
    }
   }

//   ta.appendText("4: H_Conflict="+H_Conflict+"\n");

   F_Double_Check=0;

   if(FH_Flag+TH_Flag<2 && FS_Check_Flag==1 && Ftotal_item==2){
      for(kkk=0;kkk<Num_Results;kkk++){
       F_Double_Check=0;
       if(!ResultString[kkk].equals(HypothesesString[i]) && ResultString[kkk].indexOf((int)'|')==-1 && ResultString[kkk].indexOf((int)'>')==-1) {
       if(ResultString[kkk].indexOf((int)'~')==0) {
         F_Double_String0=new String(ResultString[kkk].substring(1));
         F_Double_String1=new String("00");
       }
       else if(ResultString[kkk].indexOf((int)'~')!=0) {
        F_Double_String1=new String(ResultString[kkk]);
        F_Double_String0=new String("00");
       }

       for(k=0;k<Ftotal_item;k++){
        if(FTem_Item[k].indexOf((int)'~')==0) {
        TempString=new String(FTem_Item[k].substring(1));
        if(TempString.equals(F_Double_String1)) F_Double_Check=F_Double_Check+1;
       	}
	if(FTem_Item[k].indexOf((int)'~')!=0) {
        TempString=new String(FTem_Item[k]);
        if(TempString.equals(F_Double_String0)) F_Double_Check=F_Double_Check+1;
	}
       }

       }
       if(F_Double_Check==1) {
       if(First_Discard_Flag==0) Mem_No=new String(ResultString[kkk]);
       F_Conflict=1; kkk=Num_Results;}
      }
   }
  }




   Flag3=0;

   for(j=0;j<total_T_item;j++) if(TrueString[j].equals("00")) Flag3=Flag3+1;
   for(j=0;j<total_F_item;j++) if(FalseString[j].equals("00")) Flag3=Flag3+1;

   Flag4=Flag1+Flag2+Flag3;

//   ta.appendText("Flag4="+Flag4+", Flag3="+Flag3+", F_Conflict="+F_Conflict+", H_Conflict="+H_Conflict+", Imply_Conflict="+Imply_Conflict+"\n");
//   if((Flag4<(total_T_item+total_F_item) || (Flag1+Flag2)!=Total_TNum_FNum) && F_Conflict!=1 && C_Conflict!=1 && H_Conflict!=1 && Imply_Conflict!=1) {
//  ta.appendText("Imply_Conflict="+Imply_Conflict+"\n");
  if((Flag4<(total_T_item+total_F_item) || (Flag1+Flag2)!=Total_TNum_FNum) && Imply_Conflict!=1 && Imply_Conflict1!=1){
    ResultString[Num_Results]=HypothesesString[i];
    ta.appendText("Hypotheses "+Integer.toString(Num_Results+1)+" of current extension: "+"\""+ResultString[Num_Results]+"\""+".\n");
	ta.appendText("The reasons may be as follows:\n");
	ta.appendText("\""+ResultString[Num_Results]+"\""+" is consistent with F, C and current partial extension.\n\n");
    GF.ResultString[Num_Results]=HypothesesString[i];
    Num_Results=Num_Results+1;
    GF.Num_Results=Num_Results;

    for(j=0;j<total_item;j++){
     Fg1=0;
     Fg2=0;
     if(Tem_Item[j].indexOf((int)'~')==0) {
	   TempString=new String(Tem_Item[j].substring(1));
	   for(k=0;k<total_T_item;k++) {
	    if(!TempString.equals("00") && TempString.equals(TrueString[k])) {
		  TrueString[k]=new String("00");
		  Fg1=1;
		  break;
	    }
       }

	 if(Fg1==0) {
	  FalseString[total_F_item]=new String(TempString);
	  total_F_item=total_F_item+1;
	 }

	}
	else if(Tem_Item[j].indexOf((int)'~')!=0) {
	    TempString=new String(Tem_Item[j]);
        for(k=0;k<total_F_item;k++){
		  if(TempString.equals(FalseString[k])){
		    FalseString[k]=new String("00");
		    Fg2=1;
                    break;
	      }
		}
    if(Fg2==0) {
	  TrueString[total_T_item]=new String(TempString);
	  total_T_item=total_T_item+1;
	 }
   }
  }

  }

//  if((Flag4==(total_T_item+total_F_item) && (Flag1+Flag2)==Total_TNum_FNum) || H_Conflict==1 || F_Conflict==1 || C_Conflict==1 || Imply_Conflict==1)
  if(Imply_Conflict==1 || Imply_Conflict1==1)
  {
    TNum_HItem=TNum_HItem-TH_Flag;
    FNum_HItem=FNum_HItem-FH_Flag;
    ta.appendText("\""+HypothesesString[i]+"\""+" is discarded, the reasons may be as follows:\n");
    ta.appendText("\""+HypothesesString[i]+"\""+" is not consistent with F and/or C and/or current partial extension.\n\n");
    if(First_Discard_Flag==0 && FS_No!=1 && CS_No!=1 && i!=0) {
       discard_flag=i;First_Discard_Flag=1;
 //      ta.appendText("Discard No.: i="+i+"\n");
       }
//   if(i!=0 && FS_No!=1 && CS_No!=1) {discard_flag=i;First_Discard_Flag=1;}
  }

  if(Imply_Conflict==1) discard_flag=0;

  PAUSE_Flag=false;
  RESUME_Flag=false;


  P_D.PerformanceCanvas.y[i+1]=240-Num_Results*10;


 P_D.PerformanceCanvas.Draw_Num=Num_Results;
 P_D.PerformanceCanvas.repaint();
// P_D.show();
// P_D.hide();
 }

 ta.appendText("\nThe "+num_trials+"th extension is as follows:\n");

 for(j=0;j<Num_Facts-Num_Constraints;j++){
  ta.appendText(FactString[j]+"\n");
 }

 for(i=0;i<Num_Results;i++){
  ta.appendText(ResultString[i]+"\n");
  DisplayedResult[Num_DisplayedResult][i]=new String(ResultString[i]);
//  ta.appendText(Num_DisplayedResult+": "+i+": "+DisplayedResult[Num_DisplayedResult][i]+"\n");
 }
 Num_DisplayedResult=Num_DisplayedResult+1;
// ta.appendText("\n\nAnytime Hypothetical Reasoning is finished!\n\n");
 ta.appendText("\n\nAnytime coherence computation for the "+num_trials+"th extension is finished!\n\n");


 for(jjj=0;jjj<Num_BackResult;jjj++){

  Count_BackResult=0;
  for(i=0;i<Num_Results;i++){
  for(j=0;j<Num_Results;j++){
  if(ResultString[i].equals(BackResult[jjj][j])) Count_BackResult=Count_BackResult+1;
  }
  }
  if(Count_BackResult==Num_Results){
  for(j=0;j<Num_Results;j++) BackResult[jjj][j]=new String("00");
  }
 }

 if(discard_flag!=0){

 for(jjj=0;jjj<Num_Results;jjj++){
  if(Mem_No.equals(ResultString[jjj])){
  for(j=0;j<Num_Results;j++){
  if(Mem_No.equals(ResultString[j])) {
    BackResult[Num_BackResult][j]=new String(HypothesesString[discard_flag]);
//  ta.appendText(Num_BackResult+": "+BackResult[Num_BackResult][j]+"\n");
  }
  else {BackResult[Num_BackResult][j]=new String(ResultString[j]);
//  ta.appendText(Num_BackResult+": "+BackResult[Num_BackResult][j]+"\n");
  }
  }
  }
  }
 }


// ta.appendText("Replace1="+Replace1+", Replace2="+Replace2+", Mem_No="+Mem_No+", Mem_No1="+Mem_No1+"\n");
// ta.appendText("Num_Results="+Num_Results+", Num_BackResult="+Num_BackResult+"\n");
 if(Replace1==1000){

 for(jjj=0;jjj<Num_Results;jjj++){
  if(Mem_No.equals(ResultString[jjj])){
//  ta.appendText("ok\n");
  for(j=0;j<Num_Results;j++){
  if(Mem_No.equals(ResultString[j])) {
    BackResult[Num_BackResult][j]=new String(HypothesesString[Replace11]);
//  ta.appendText(Num_BackResult+": "+BackResult[Num_BackResult][j]+"\n");
  }
  else {BackResult[Num_BackResult][j]=new String(ResultString[j]);
//  ta.appendText(Num_BackResult+": "+BackResult[Num_BackResult][j]+"\n");
  }
  }

  }
  }
 }


 if(Replace1==1000 && Replace2==1000){
 Num_BackResult=Num_BackResult+1;
 for(jjj=0;jjj<Num_Results;jjj++){
  if(Mem_No1.equals(ResultString[jjj])){
  for(j=0;j<Num_Results;j++){
  if(Mem_No1.equals(ResultString[j])) {
    BackResult[Num_BackResult][j]=new String(HypothesesString[Replace22]);
//  ta.appendText(Num_BackResult+": "+BackResult[Num_BackResult][j]+"\n");
  }
  else {BackResult[Num_BackResult][j]=new String(ResultString[j]);
//  ta.appendText(Num_BackResult+": "+BackResult[Num_BackResult][j]+"\n");
  }
  }
  }
  }
 }

 Num_BackResult=Num_BackResult+1;

  for(jjj=0;jjj<Num_BackResult;jjj++){
  for(kkk=jjj+1;kkk<Num_BackResult;kkk++){
  Count_BackResult=0;
  for(i=0;i<Num_Results;i++){
   for(j=0;j<Num_Results;j++){
   if(BackResult[jjj][i].equals(BackResult[kkk][j])){
   Count_BackResult=Count_BackResult+1;
   j=Num_Results;
  }
  }
  }
  if(Count_BackResult==Num_Results){
  for(j=0;j<Num_Results;j++) BackResult[kkk][j]=new String("00");}
  }
 }

  for(jjj=0;jjj<Num_DisplayedResult;jjj++){
  for(kkk=0;kkk<Num_BackResult;kkk++){
   Count_BackResult=0;
  for(i=0;i<Num_Results;i++) {
  for(j=0;j<Num_Results;j++){
  if(DisplayedResult[jjj][i].equals(BackResult[kkk][j])){
   Count_BackResult=Count_BackResult+1;
   j=Num_Results;
  }
  }
  }
  if(Count_BackResult==Num_Results){
  for(j=0;j<Num_Results;j++) BackResult[kkk][j]=new String("00");
  }
  }
 }

 P_D.PerformanceCanvas.Draw_Num=Num_Hypotheses;

 P_D.PerformanceCanvas.repaint();
// P_D.show();
// P_D.hide();
 }
 for(jjj=0;jjj<Num_BackResult;jjj++){
 if(BackResult[jjj][0].equals("00")) continue;
 else {
 num_trials=num_trials+1;
 ta.appendText("\nThe "+num_trials+"th extension is as follows:\n");
 for(j=0;j<Num_Facts-Num_Constraints;j++){
  ta.appendText(FactString[j]+"\n");
 }
 for(j=0;j<20;j++) if(!BackResult[jjj][j].equals("00")) ta.appendText(BackResult[jjj][j]+"\n");
 ta.appendText("\n\nAnytime coherence computation for the "+num_trials+"th extension is finished!\n\n");
 }
 }
 }

 else if(Method2){

  ta.appendText("Restrictions are considered based on their priorities...\n\n");

  for(iii=0;iii<Num_Restrictions;iii++){
  Num_Results=0;

  if(iii!=(Num_Restrictions-1)) ta.appendText("When only the following restriction(s) is(are) considered:\n");
  else ta.appendText("When all of the following restriction(s) is(are) considered:\n");

  for(ii=0;ii<iii+1;ii++) ta.appendText(RestrictionString[ii]+"\n");
  ta.appendText("\n");

  for(ii=0;ii<totalFitem;ii++)  FalseString[ii]=new String(FalseStringO[ii]);
  for(ii=0;ii<totalTitem;ii++) TrueString[ii]=new String(TrueStringO[ii]);
  for(ii=0;ii<Num_Hypotheses;ii++) HypothesesString[ii]=new String(HStringCopy[ii]);

    for(ii=iii+1;ii<Num_Restrictions;ii++) {

	 if(RestrictionString[ii].indexOf((int)'~')!=0){
	   for(jj=0;jj<total_T_item;jj++){
	     if(TrueString[jj].equals(RestrictionString[ii])) TrueString[jj]=new String("00");
	   }

     }

     else if(RestrictionString[ii].indexOf((int)'~')==0){
	  TempString=new String(RestrictionString[ii].substring(1));
	  for(jj=0;jj<total_F_item;jj++){
    	 if(FalseString[jj].equals(TempString)) FalseString[jj]=new String("00");
	  }
     }

    }


 TNum_HItem=0;
 FNum_HItem=0;

 num_trials=0;
 discard_flag=0;

  Num_BackResult=0;
 Num_DisplayedResult=0;

 for(i=0;i<Num_Hypotheses;i++){
  HypothesesString[i]=new String(HStringCopy[i]);
 }

 for(trials=0;trials<Num_Hypotheses;trials++){

   if(discard_flag==0 && trials!=0) break;
   total_item=0;
   Replace1=0;
   Replace2=0;
   Replace11=1000;
   Replace22=1000;
   Mem_No=new String("00");
   Mem_No1=new String("00");
   Num_Restrictions=0;
   Num_Results=0;
   GF.Num_Results=0;
   First_Discard_Flag=0;
 for(i=0;i<totalFitem;i++) FalseString[i]=new String(FalseStringO[i]);
 for(i=0;i<totalTitem;i++) TrueString[i]=new String(TrueStringO[i]);

 TNum_HItem=0;
 FNum_HItem=0;

// ta.appendText("trials="+trials+", discard_flag="+discard_flag+", Num_Hypotheses="+Num_Hypotheses+"\n");

 if(discard_flag>trials) {
   trials=discard_flag;
   for(i=0;i<Num_Hypotheses;i++) {
   if(i+discard_flag<Num_Hypotheses) HypothesesString[i]=new String(HStringCopy[i+discard_flag]);
   else HypothesesString[i]=new String(HStringCopy[i+discard_flag-Num_Hypotheses]);
   }
 }
 else if (discard_flag<trials-1) break;


 num_trials=num_trials+1;

 /*
 for(i_flag=trials;i_flag<Num_Hypotheses+trials;i_flag++){
  if(i_flag>=Num_Hypotheses) i=i_flag-Num_Hypotheses;
  else i=i_flag;
*/

  for(i=0;i<Num_Hypotheses;i++){
  try{
   sleep(600);
  }

  catch(InterruptedException e) {}

  P_D.PerformanceCanvas.x[i+1]=30+i*10;

  total_item=0;

  CurrentHT[0]=new String("00");
  CurrentHT[1]=new String("00");
  CurrentHF[0]=new String("00");
  CurrentHF[1]=new String("00");

   if(HypothesesString[i].indexOf((int)'|')==-1 && HypothesesString[i].indexOf((int)'>')==-1) {
     Tem_Item[total_item]=new String(HypothesesString[i]);
     for(ii=iii+1;ii<Num_Restrictions;ii++)
   if(Tem_Item[total_item].equals(RestrictionString[ii])){
    Tem_Item[total_item]=new String("00");
    total_item=total_item-1;
    }
	 total_item=total_item+1;
   }
   else if(HypothesesString[i].indexOf((int)'|')==-1 && HypothesesString[i].indexOf((int)'>')!=-1){
     HTokens=new StringTokenizer(HypothesesString[i],"->");
	 TempFlag=0;
     while(HTokens.hasMoreTokens()){
       TempString=new String(HTokens.nextToken());
	   if(TempFlag==0 && TempString.indexOf((int)'~')==0) Tem_Item[total_item]=new String(TempString.substring(1));
	   else if(TempFlag==0 && TempString.indexOf((int)'~')!=0) Tem_Item[total_item]=new String('~'+TempString);
	   else if(TempFlag!=0) Tem_Item[total_item]=new String(TempString);
           for(ii=iii+1;ii<Num_Restrictions;ii++)
   if(Tem_Item[total_item].equals(RestrictionString[ii])) {
   Tem_Item[total_item]=new String("00");
    total_item=total_item-1;}
	   total_item=total_item+1;
	   TempFlag=TempFlag+1;
	 }
   }
   else if(HypothesesString[i].indexOf((int)'|')!=-1 && HypothesesString[i].indexOf((int)'>')==-1){
     HTokens=new StringTokenizer(HypothesesString[i],"|");
     while(HTokens.hasMoreTokens()){
       Tem_Item[total_item]=new String(HTokens.nextToken());
       for(ii=iii+1;ii<Num_Restrictions;ii++)
   if(Tem_Item[total_item].equals(RestrictionString[ii])) {
    Tem_Item[total_item]=new String("00");
    total_item=total_item-1;
    }
       total_item=total_item+1;
     }
   }


    Flag1=0;
   Flag2=0;

   TH_Flag=0;
   FH_Flag=0;

   for(j=0;j<total_item;j++){

    if(Tem_Item[j].indexOf((int)'~')==0) {
	   TempString=new String(Tem_Item[j].substring(1));
           False_H[FNum_HItem]=new String(TempString);
           CurrentHF[FH_Flag]=new String(TempString);
           FNum_HItem=FNum_HItem+1;
           FH_Flag=FH_Flag+1;
	   for(k=0;k<total_T_item;k++){
	    if(!TempString.equals("00") && TempString.equals(TrueString[k])) {
		  Flag1=Flag1+1;
		  k=total_T_item;
	    }
	   }

	}
	else if(Tem_Item[j].indexOf((int)'~')!=0) {
	    TempString=new String(Tem_Item[j]);
            True_H[TNum_HItem]=new String(TempString);
            CurrentHT[TH_Flag]=new String(TempString);
            TNum_HItem=TNum_HItem+1;
            TH_Flag=TH_Flag+1;
        for(k=0;k<total_F_item;k++){
		  if(TempString.equals(FalseString[k])){
		    Flag2=Flag2+1;
			k=total_F_item;
		  }
	    }
   }
  }

  Imply_Conflict=0;
  Imply_Conflict1=0;
  If_First_Equal=0;

// ta.appendText("Post 0: "+Replace1+"\n");
  if(total_item==1) {
//  Imply_Temp1=new String(Tem_Item[0]+'-'+'>');
  TempString=new String("00");
  FTem_Item[0]=new String("00");
  FTem_Item[1]=new String("00");
  FTem_Item_Imply[0]=new String("00");
  FTem_Item_Imply[1]=new String("00");
  for(j=0;j<Num_Facts;j++){

    Ftotal_item=0;
    If_First_Equal=0;

    if(FactString[j].indexOf((int)'>')!=-1){

     FTokens=new StringTokenizer(FactString[j],"->");
     TempFlag=0;

     while(FTokens.hasMoreTokens()){
       TempString=new String(FTokens.nextToken());
 //      ta.appendText("TempString="+TempString+", Tem_Item[0]="+Tem_Item[0]+"\n");
       if(!TempString.equals(Tem_Item[0]) && Ftotal_item==0) {
        If_First_Equal=1;
        break;}
	   if(TempFlag==0 && TempString.indexOf((int)'~')==0) FTem_Item[Ftotal_item]=new String(TempString.substring(1));
	   else if(TempFlag==0 && TempString.indexOf((int)'~')!=0) FTem_Item[Ftotal_item]=new String('~'+TempString);
	   else if(TempFlag!=0) FTem_Item[Ftotal_item]=new String(TempString);
	   Ftotal_item=Ftotal_item+1;
	   TempFlag=TempFlag+1;
	 }

      if(If_First_Equal==1) continue;

      for(k=j+1;k<Num_Facts;k++){
       Ftotal_item=0;
       If_First_Equal=0;

        if(FactString[k].indexOf((int)'>')!=-1){

     FTokens=new StringTokenizer(FactString[k],"->");
     TempFlag=0;

     while(FTokens.hasMoreTokens()){
       TempString=new String(FTokens.nextToken());
       if(!TempString.equals(Tem_Item[0]) && Ftotal_item==0) {If_First_Equal=1; break;}
	   if(TempFlag==0 && TempString.indexOf((int)'~')==0) FTem_Item_Imply[Ftotal_item]=new String(TempString.substring(1));
	   else if(TempFlag==0 && TempString.indexOf((int)'~')!=0) FTem_Item_Imply[Ftotal_item]=new String('~'+TempString);
	   else if(TempFlag!=0) FTem_Item_Imply[Ftotal_item]=new String(TempString);
	   Ftotal_item=Ftotal_item+1;
	   TempFlag=TempFlag+1;
	 }
       }
     if(If_First_Equal==1) continue;

     else if(If_First_Equal!=1 && FTem_Item[1].indexOf((int)'~')==0 && FTem_Item_Imply[1].indexOf((int)'~')!=0){
     TempString=new String(FTem_Item[1].substring(1));
     if(TempString.equals(FTem_Item_Imply[1])) Imply_Conflict=1;
     }
     if(If_First_Equal!=1 && FTem_Item[1].indexOf((int)'~')!=0 && FTem_Item_Imply[1].indexOf((int)'~')==0){

     TempString=new String(FTem_Item_Imply[1].substring(1));
 //    ta.appendText("If_First_Equal="+If_First_Equal+",TemString="+TempString+",FTem_Item[1]="+FTem_Item[1]+"\n");
     if(TempString.equals(FTem_Item[1])) Imply_Conflict=1;
     }
     }  /* for k=0;k < */


  }   /* for if */


  } /* for for(j=0;j<Num_facts;j++) */
 } /* for if(total_item==1) */

//  ta.appendText("Post 1: "+Replace1+"\n");
   if(total_item==1) {
   TempString=new String("00");
  FTem_Item[0]=new String("00");
  FTem_Item[1]=new String("00");
  FTem_Item_Imply[0]=new String("00");
  FTem_Item_Imply[1]=new String("00");
//   Replace1=0;
//   Replace2=0;
//  Imply_Temp1=new String(Tem_Item[0]+'-'+'>');
  for(j=0;j<Num_Facts;j++){

    Ftotal_item=0;
    If_First_Equal=0;

    if(FactString[j].indexOf((int)'>')!=-1){

     FTokens=new StringTokenizer(FactString[j],"->");
     TempFlag=0;

     while(FTokens.hasMoreTokens()){
       TempString=new String(FTokens.nextToken());
 //      ta.appendText("TempString="+TempString+", Tem_Item[0]="+Tem_Item[0]+"\n");
       if(!TempString.equals(Tem_Item[0]) && Ftotal_item==0) {
        If_First_Equal=1;

        break;}
	   if(TempFlag==0 && TempString.indexOf((int)'~')==0) FTem_Item[Ftotal_item]=new String(TempString.substring(1));
	   else if(TempFlag==0 && TempString.indexOf((int)'~')!=0) FTem_Item[Ftotal_item]=new String('~'+TempString);
	   else if(TempFlag!=0) FTem_Item[Ftotal_item]=new String(TempString);
	   Ftotal_item=Ftotal_item+1;
	   TempFlag=TempFlag+1;
	 }

      if(If_First_Equal==1) continue;

      for(k=0;k<Num_Results;k++){
       Ftotal_item=0;
       If_First_Equal=0;

        if(ResultString[k].indexOf((int)'>')!=-1){

     FTokens=new StringTokenizer(ResultString[k],"->");
     TempFlag=0;

     while(FTokens.hasMoreTokens()){
       TempString=new String(FTokens.nextToken());
       if(!TempString.equals(Tem_Item[0]) && Ftotal_item==0) {If_First_Equal=1; break;}
	   if(TempFlag==0 && TempString.indexOf((int)'~')==0) FTem_Item_Imply[Ftotal_item]=new String(TempString.substring(1));
	   else if(TempFlag==0 && TempString.indexOf((int)'~')!=0) FTem_Item_Imply[Ftotal_item]=new String('~'+TempString);
	   else if(TempFlag!=0) FTem_Item_Imply[Ftotal_item]=new String(TempString);
	   Ftotal_item=Ftotal_item+1;
	   TempFlag=TempFlag+1;
	 }
       }
     if(If_First_Equal==1) continue;

     else if(If_First_Equal!=1 && FTem_Item[1].indexOf((int)'~')==0 && FTem_Item_Imply[1].indexOf((int)'~')!=0){
     TempString=new String(FTem_Item[1].substring(1));
     if(TempString.equals(FTem_Item_Imply[1])) {Imply_Conflict=1;Replace1=1000;Replace11=i;Mem_No=new String(ResultString[k]);}
     }
     if(If_First_Equal!=1 && FTem_Item[1].indexOf((int)'~')!=0 && FTem_Item_Imply[1].indexOf((int)'~')==0){

     TempString=new String(FTem_Item_Imply[1].substring(1));
//     ta.appendText("If_First_Equal="+If_First_Equal+",TemString="+TempString+",FTem_Item[1]="+FTem_Item[1]+"\n");
     if(TempString.equals(FTem_Item[1])) {Imply_Conflict=1;Replace1=1000;Replace11=i;Mem_No=new String(ResultString[k]);}
     }
     }  /* for k=0;k < */


  }   /* for if */


  } /* for for(j=0;j<Num_facts;j++) */
 } /* for if(total_item==1) */

// ta.appendText("Post 2: "+Replace1+"\n");
   if(total_item==1) {
   TempString=new String("00");
  FTem_Item[0]=new String("00");
  FTem_Item[1]=new String("00");
  FTem_Item_Imply[0]=new String("00");
  FTem_Item_Imply[1]=new String("00");
//   Replace1=0;
//   Replace2=0;
//  Imply_Temp1=new String(Tem_Item[0]+'-'+'>');
  for(j=0;j<Num_Results;j++){

    Ftotal_item=0;
    If_First_Equal=0;

    if(ResultString[j].indexOf((int)'>')!=-1){

     FTokens=new StringTokenizer(ResultString[j],"->");
     TempFlag=0;

     while(FTokens.hasMoreTokens()){
       TempString=new String(FTokens.nextToken());
 //      ta.appendText("TempString="+TempString+", Tem_Item[0]="+Tem_Item[0]+"\n");
       if(!TempString.equals(Tem_Item[0]) && Ftotal_item==0) {
        If_First_Equal=1;
        break;}
	   if(TempFlag==0 && TempString.indexOf((int)'~')==0) FTem_Item[Ftotal_item]=new String(TempString.substring(1));
	   else if(TempFlag==0 && TempString.indexOf((int)'~')!=0) FTem_Item[Ftotal_item]=new String('~'+TempString);
	   else if(TempFlag!=0) FTem_Item[Ftotal_item]=new String(TempString);
	   Ftotal_item=Ftotal_item+1;
	   TempFlag=TempFlag+1;
	 }

      if(If_First_Equal==1) continue;

      for(k=j+1;k<Num_Results;k++){
       Ftotal_item=0;
       If_First_Equal=0;

        if(ResultString[k].indexOf((int)'>')!=-1){

     FTokens=new StringTokenizer(ResultString[k],"->");
     TempFlag=0;

     while(FTokens.hasMoreTokens()){
       TempString=new String(FTokens.nextToken());
       if(!TempString.equals(Tem_Item[0]) && Ftotal_item==0) {If_First_Equal=1; break;}
	   if(TempFlag==0 && TempString.indexOf((int)'~')==0) FTem_Item_Imply[Ftotal_item]=new String(TempString.substring(1));
	   else if(TempFlag==0 && TempString.indexOf((int)'~')!=0) FTem_Item_Imply[Ftotal_item]=new String('~'+TempString);
	   else if(TempFlag!=0) FTem_Item_Imply[Ftotal_item]=new String(TempString);
	   Ftotal_item=Ftotal_item+1;
	   TempFlag=TempFlag+1;
	 }
       }
     if(If_First_Equal==1) continue;
  //   ta.appendText(FTem_Item[1]+" "+FTem_Item_Imply[1]);
     else if(If_First_Equal!=1 && FTem_Item[1].indexOf((int)'~')==0 && FTem_Item_Imply[1].indexOf((int)'~')!=0){
     TempString=new String(FTem_Item[1].substring(1));
//     ta.appendText("1.0: "+FTem_Item[1]+" "+FTem_Item_Imply[1]+"\n");
     if(TempString.equals(FTem_Item_Imply[1])) {Imply_Conflict=1;Replace1=1000;Replace11=i;Replace2=1000;Replace22=i;
       Mem_No=new String(ResultString[k]);
       Mem_No1=new String(ResultString[j]);
       }
     }
     if(If_First_Equal!=1 && FTem_Item[1].indexOf((int)'~')!=0 && FTem_Item_Imply[1].indexOf((int)'~')==0){

     TempString=new String(FTem_Item_Imply[1].substring(1));
//     ta.appendText("2.0: "+FTem_Item[1]+" "+FTem_Item_Imply[1]+"\n");
//     ta.appendText("If_First_Equal="+If_First_Equal+",TemString="+TempString+",FTem_Item[1]="+FTem_Item[1]+"\n");
     if(TempString.equals(FTem_Item[1])) {Imply_Conflict=1;Replace1=1000;Replace11=i;Replace2=1000;Replace22=i;
       Mem_No1=new String(ResultString[j]);
       Mem_No=new String(ResultString[k]);
       }
     }
     }  /* for k=0;k < */


  }   /* for if */


  } /* for for(j=0;j<Num_facts;j++) */
 } /* for if(total_item==1) */


 // strat from here to test two items in hypotheses for the imply situation

//  Imply_Conflict=0;
  If_First_Equal=0;

// ta.appendText("Post 3: "+Replace1+"\n");
  if(total_item==2 && HypothesesString[i].indexOf((int)'>')!=-1) {
  TempString=new String("00");
  FTem_Item[0]=new String("00");
  FTem_Item[1]=new String("00");
  FTem_Item_Imply[0]=new String("00");
  FTem_Item_Imply[1]=new String("00");
//  Imply_Temp1=new String(Tem_Item[0]+'-'+'>');
  for(j=0;j<Num_Facts;j++){

    Ftotal_item=0;
    If_First_Equal=0;

    if(FactString[j].indexOf((int)'>')!=-1){

     FTokens=new StringTokenizer(FactString[j],"->");
     TempFlag=0;

     while(FTokens.hasMoreTokens()){
       TempString=new String(FTokens.nextToken());
 //      ta.appendText("TempString="+TempString+", Tem_Item[0]="+Tem_Item[0]+"\n");

	   if(TempFlag==0 && TempString.indexOf((int)'~')==0) FTem_Item[Ftotal_item]=new String(TempString.substring(1));
	   else if(TempFlag==0 && TempString.indexOf((int)'~')!=0) FTem_Item[Ftotal_item]=new String('~'+TempString);
	   else if(TempFlag!=0) FTem_Item[Ftotal_item]=new String(TempString);

           if(!FTem_Item[0].equals(Tem_Item[0])) {
           If_First_Equal=1;
           break;}
            Ftotal_item=Ftotal_item+1;
	   TempFlag=TempFlag+1;
	 }

      if(If_First_Equal==1) continue;

      for(k=0;k<Num_Facts;k++){
       Ftotal_item=0;
       If_First_Equal=0;

        if(FactString[k].indexOf((int)'>')==-1 && FactString[k].indexOf((int)'|')==-1){

       if(FactString[k].indexOf((int)'~')==0) TempString=new String(FactString[k].substring(1));
       else   //if(FactString[k].indexOf((int)'~')!=0)
       TempString=new String('~'+FactString[k]);
       if(!TempString.equals(Tem_Item[0])) {If_First_Equal=1; continue;}

       else if(If_First_Equal!=1 && TempString.equals(Tem_Item[0]) && FTem_Item[1].indexOf((int)'~')==0){
       TempStringImply=new String(FTem_Item[1].substring(1));
       if(TempStringImply.equals(Tem_Item[1])) Imply_Conflict=1;
       }
       if(If_First_Equal!=1 && TempString.equals(Tem_Item[0]) && Tem_Item[1].indexOf((int)'~')==0){
       TempStringImply=new String(Tem_Item[1].substring(1));
 //    ta.appendText("If_First_Equal="+If_First_Equal+",TemString="+TempString+",FTem_Item[1]="+FTem_Item[1]+"\n");
       if(TempStringImply.equals(FTem_Item[1])) Imply_Conflict=1;
      }
      } /* for if */
     }  /* for k=0;k < */


  }   /* for if */


  } /* for for(j=0;j<Num_facts;j++) */
 } /* for if(total_item==2) */
//  ta.appendText("Post 4: "+Replace1+"\n");
  if(total_item==2 && HypothesesString[i].indexOf((int)'>')!=-1) {
  TempString=new String("00");
  FTem_Item[0]=new String("00");
  FTem_Item[1]=new String("00");
  FTem_Item_Imply[0]=new String("00");
  FTem_Item_Imply[1]=new String("00");
//  Replace1=0;
//  Replace2=0;
//  Imply_Temp1=new String(Tem_Item[0]+'-'+'>');
  for(j=0;j<Num_Facts;j++){

    Ftotal_item=0;
    If_First_Equal=0;

    if(FactString[j].indexOf((int)'>')!=-1){

     FTokens=new StringTokenizer(FactString[j],"->");
     TempFlag=0;

     while(FTokens.hasMoreTokens()){
       TempString=new String(FTokens.nextToken());
 //      ta.appendText("TempString="+TempString+", Tem_Item[0]="+Tem_Item[0]+"\n");

	   if(TempFlag==0 && TempString.indexOf((int)'~')==0) FTem_Item[Ftotal_item]=new String(TempString.substring(1));
	   else if(TempFlag==0 && TempString.indexOf((int)'~')!=0) FTem_Item[Ftotal_item]=new String('~'+TempString);
	   else if(TempFlag!=0) FTem_Item[Ftotal_item]=new String(TempString);

           if(!FTem_Item[0].equals(Tem_Item[0])) {
           If_First_Equal=1;
           break;}
            Ftotal_item=Ftotal_item+1;
	   TempFlag=TempFlag+1;
	 }

      if(If_First_Equal==1) continue;

      for(k=0;k<Num_Results;k++){
       Ftotal_item=0;
       If_First_Equal=0;

        if(ResultString[k].indexOf((int)'>')==-1 && ResultString[k].indexOf((int)'|')==-1){

       if(ResultString[k].indexOf((int)'~')==0) TempString=new String(ResultString[k].substring(1));
       else   //if(FactString[k].indexOf((int)'~')!=0)
       TempString=new String('~'+ResultString[k]);
       if(!TempString.equals(Tem_Item[0])) {If_First_Equal=1; continue;}

       else if(If_First_Equal!=1 && TempString.equals(Tem_Item[0]) && FTem_Item[1].indexOf((int)'~')==0){
       TempStringImply=new String(FTem_Item[1].substring(1));
       if(TempStringImply.equals(Tem_Item[1])) {Imply_Conflict=1;Replace1=1000;Replace11=i;Mem_No=new String(ResultString[k]);}
       }
       if(If_First_Equal!=1 && TempString.equals(Tem_Item[0]) && Tem_Item[1].indexOf((int)'~')==0){
       TempStringImply=new String(Tem_Item[1].substring(1));
 //    ta.appendText("If_First_Equal="+If_First_Equal+",TemString="+TempString+",FTem_Item[1]="+FTem_Item[1]+"\n");
       if(TempStringImply.equals(FTem_Item[1])) {Imply_Conflict=1; Replace1=1000;Replace11=i;Mem_No=new String(ResultString[k]);}
      }
      } /* for if */
     }  /* for k=0;k < */


  }   /* for if */


  } /* for for(j=0;j<Num_facts;j++) */
 } /* for if(total_item==2) */
//   ta.appendText("Post 5: "+Replace1+"\n");
   if(total_item==2 && HypothesesString[i].indexOf((int)'>')!=-1) {
   TempString=new String("00");
  FTem_Item[0]=new String("00");
  FTem_Item[1]=new String("00");
  FTem_Item_Imply[0]=new String("00");
  FTem_Item_Imply[1]=new String("00");
//  Replace1=0;
//  Replace2=0;
//  Imply_Temp1=new String(Tem_Item[0]+'-'+'>');
  for(j=0;j<Num_Results;j++){

    Ftotal_item=0;
    If_First_Equal=0;

    if(ResultString[j].indexOf((int)'>')!=-1){

     FTokens=new StringTokenizer(ResultString[j],"->");
     TempFlag=0;

     while(FTokens.hasMoreTokens()){
       TempString=new String(FTokens.nextToken());
 //      ta.appendText("TempString="+TempString+", Tem_Item[0]="+Tem_Item[0]+"\n");

	   if(TempFlag==0 && TempString.indexOf((int)'~')==0) FTem_Item[Ftotal_item]=new String(TempString.substring(1));
	   else if(TempFlag==0 && TempString.indexOf((int)'~')!=0) FTem_Item[Ftotal_item]=new String('~'+TempString);
	   else if(TempFlag!=0) FTem_Item[Ftotal_item]=new String(TempString);

           if(!FTem_Item[0].equals(Tem_Item[0])) {
           If_First_Equal=1;
           break;}
            Ftotal_item=Ftotal_item+1;
	   TempFlag=TempFlag+1;
	 }

      if(If_First_Equal==1) continue;

      for(k=0;k<Num_Facts;k++){
       Ftotal_item=0;
       If_First_Equal=0;

        if(FactString[k].indexOf((int)'>')==-1 && FactString[k].indexOf((int)'|')==-1){

       if(FactString[k].indexOf((int)'~')==0) TempString=new String(FactString[k].substring(1));
       else   //if(FactString[k].indexOf((int)'~')!=0)
       TempString=new String('~'+FactString[k]);
       if(!TempString.equals(Tem_Item[0])) {If_First_Equal=1; continue;}

       else if(If_First_Equal!=1 && TempString.equals(Tem_Item[0]) && FTem_Item[1].indexOf((int)'~')==0){
       TempStringImply=new String(FTem_Item[1].substring(1));
       if(TempStringImply.equals(Tem_Item[1])) {Imply_Conflict=1;Replace1=1000;Replace11=i;Mem_No=new String(ResultString[j]);}
       }
       if(If_First_Equal!=1 && TempString.equals(Tem_Item[0]) && Tem_Item[1].indexOf((int)'~')==0){
       TempStringImply=new String(Tem_Item[1].substring(1));
 //    ta.appendText("If_First_Equal="+If_First_Equal+",TemString="+TempString+",FTem_Item[1]="+FTem_Item[1]+"\n");
       if(TempStringImply.equals(FTem_Item[1])) {Imply_Conflict=1; Replace1=1000;Replace11=i;Mem_No=new String(ResultString[j]);}
      }
      } /* for if */
     }  /* for k=0;k < */


  }   /* for if */


  } /* for for(j=0;j<Num_facts;j++) */
 } /* for if(total_item==2) */
//  ta.appendText("Post 6: "+Replace1+"\n");
  if(total_item==2 && HypothesesString[i].indexOf((int)'>')!=-1) {
  TempString=new String("00");
  FTem_Item[0]=new String("00");
  FTem_Item[1]=new String("00");
  FTem_Item_Imply[0]=new String("00");
  FTem_Item_Imply[1]=new String("00");
//  Imply_Temp1=new String(Tem_Item[0]+'-'+'>');
  for(j=0;j<Num_Results;j++){

    Ftotal_item=0;
    If_First_Equal=0;

    if(ResultString[j].indexOf((int)'>')!=-1){

     FTokens=new StringTokenizer(ResultString[j],"->");
     TempFlag=0;

     while(FTokens.hasMoreTokens()){
       TempString=new String(FTokens.nextToken());
 //      ta.appendText("TempString="+TempString+", Tem_Item[0]="+Tem_Item[0]+"\n");

	   if(TempFlag==0 && TempString.indexOf((int)'~')==0) FTem_Item[Ftotal_item]=new String(TempString.substring(1));
	   else if(TempFlag==0 && TempString.indexOf((int)'~')!=0) FTem_Item[Ftotal_item]=new String('~'+TempString);
	   else if(TempFlag!=0) FTem_Item[Ftotal_item]=new String(TempString);

           if(!FTem_Item[0].equals(Tem_Item[0])) {
           If_First_Equal=1;
           break;}
            Ftotal_item=Ftotal_item+1;
	   TempFlag=TempFlag+1;
	 }

      if(If_First_Equal==1) continue;

      for(k=0;k<Num_Results;k++){
       Ftotal_item=0;
       If_First_Equal=0;

       if(ResultString[k].indexOf((int)'>')==-1 && ResultString[k].indexOf((int)'|')==-1){

       if(ResultString[k].indexOf((int)'~')==0) TempString=new String(ResultString[k].substring(1));
       else   //if(FactString[k].indexOf((int)'~')!=0)
       TempString=new String('~'+ResultString[k]);
       if(!TempString.equals(Tem_Item[0])) {If_First_Equal=1; continue;}

       else if(If_First_Equal!=1 && TempString.equals(Tem_Item[0]) && FTem_Item[1].indexOf((int)'~')==0){
       TempStringImply=new String(FTem_Item[1].substring(1));
       if(TempStringImply.equals(Tem_Item[1])) {
       Imply_Conflict=1;
       Replace1=1000; Replace2=1000;
       Replace11=i;
       Replace22=i;
//       ta.appendText("here j="+j+"\n");
//       ta.appendText("there k="+k+"\n");
       Mem_No1=new String(ResultString[j]);
       Mem_No=new String(ResultString[k]);
//       ta.appendText("here there Mem_No="+Mem_No+", Mem_No1="+Mem_No1+"\n");
       }

       }
       if(If_First_Equal!=1 && TempString.equals(Tem_Item[0]) && Tem_Item[1].indexOf((int)'~')==0){
       TempStringImply=new String(Tem_Item[1].substring(1));
 //    ta.appendText("If_First_Equal="+If_First_Equal+",TemString="+TempString+",FTem_Item[1]="+FTem_Item[1]+"\n");
       if(TempStringImply.equals(FTem_Item[1])) {
        Imply_Conflict=1;
        Replace1=1000; Replace2=1000;
        Replace11=i;
        Replace22=i;
       Mem_No1=new String(ResultString[j]);
       Mem_No=new String(ResultString[k]);
       }

      }
      } /* for if */
     }  /* for k=0;k < */


  }   /* for if */


  } /* for for(j=0;j<Num_facts;j++) */
 } /* for if(total_item==2) */


// stop here to test two items in hypotheses for the imply situation

/* self checking starts here */
   if(total_item==1) {
//  Imply_Temp1=new String(Tem_Item[0]+'-'+'>');
  TempString=new String("00");
  FTem_Item[0]=new String("00");
  FTem_Item[1]=new String("00");
  FTem_Item_Imply[0]=new String("00");
  FTem_Item_Imply[1]=new String("00");
  for(j=0;j<Num_Facts;j++)
      if(FactString[j].indexOf((int)'>')==-1 && FactString[j].indexOf((int)'|')==-1){
       TempString=new String(FactString[j]);
       if(TempString.indexOf((int)'~')==0) FTem_Item[0]=new String(TempString.substring(1));
       else FTem_Item[0]=new String('~'+TempString);

       if(Tem_Item[0].equals(FTem_Item[0])) Imply_Conflict1=1;
  }



  for(j=0;j<Num_Results;j++)
      if(ResultString[j].indexOf((int)'>')==-1 && ResultString[j].indexOf((int)'|')==-1){
       TempString=new String(ResultString[j]);
       if(TempString.indexOf((int)'~')==0) FTem_Item[0]=new String(TempString.substring(1));
       else FTem_Item[0]=new String('~'+TempString);

       if(Tem_Item[0].equals(FTem_Item[0])) Imply_Conflict1=1;
  }
} /* for if(total_item==1) */
// ta.appendText("Post 7: "+Replace1+"\n");
 if(total_item==2) {
  TempString=new String("00");
  FTem_Item[0]=new String("00");
  FTem_Item[1]=new String("00");
  FTem_Item_Imply[0]=new String("00");
  FTem_Item_Imply[1]=new String("00");
//  Imply_Temp1=new String(Tem_Item[0]+'-'+'>');
  for(j=0;j<Num_Results;j++){

    Ftotal_item=0;
    If_First_Equal=0;

    if(ResultString[j].indexOf((int)'>')!=-1){

     FTokens=new StringTokenizer(ResultString[j],"->");
     TempFlag=0;

     while(FTokens.hasMoreTokens()){
       TempString=new String(FTokens.nextToken());
       if(TempFlag==0) FTem_Item[Ftotal_item]=new String(TempString);
       else if(TempFlag!=0 && TempString.indexOf((int)'~')==0) FTem_Item[Ftotal_item]=new String(TempString.substring(1));
       else if(TempFlag!=0 && TempString.indexOf((int)'~')!=0) FTem_Item[Ftotal_item]=new String('~'+TempString);
       Ftotal_item=Ftotal_item+1;
       TempFlag=TempFlag+1;
     }

    if(Tem_Item[0].equals(FTem_Item[0]) && Tem_Item[1].equals(FTem_Item[1])) Imply_Conflict1=1;
    if(Tem_Item[0].equals(FTem_Item[1]) && Tem_Item[1].equals(FTem_Item[0])) Imply_Conflict1=1;

 }
 }

   for(j=0;j<Num_Facts;j++){

    Ftotal_item=0;
    If_First_Equal=0;

    if(FactString[j].indexOf((int)'>')!=-1){

     FTokens=new StringTokenizer(FactString[j],"->");
     TempFlag=0;

     while(FTokens.hasMoreTokens()){
       TempString=new String(FTokens.nextToken());
       if(TempFlag==0) FTem_Item[Ftotal_item]=new String(TempString);
       else if(TempFlag!=0 && TempString.indexOf((int)'~')==0) FTem_Item[Ftotal_item]=new String(TempString.substring(1));
       else if(TempFlag!=0 && TempString.indexOf((int)'~')!=0) FTem_Item[Ftotal_item]=new String('~'+TempString);
       Ftotal_item=Ftotal_item+1;
       TempFlag=TempFlag+1;
     }

    if(Tem_Item[0].equals(FTem_Item[0]) && Tem_Item[1].equals(FTem_Item[1])) Imply_Conflict1=1;
    if(Tem_Item[0].equals(FTem_Item[1]) && Tem_Item[1].equals(FTem_Item[0])) Imply_Conflict1=1;

 }
 }

  for(j=0;j<Num_Results;j++){

   Ftotal_item=0;

    if(ResultString[j].indexOf((int)'|')!=-1){

     FTokens=new StringTokenizer(ResultString[j],"|");

     while(FTokens.hasMoreTokens()){
       TempString=new String(FTokens.nextToken());
       if(TempString.indexOf((int)'~')==0) FTem_Item[Ftotal_item]=new String(TempString.substring(1));
       else if(TempString.indexOf((int)'~')!=0) FTem_Item[Ftotal_item]=new String('~'+TempString);
       Ftotal_item=Ftotal_item+1;
     }

    if(Tem_Item[0].equals(FTem_Item[0]) && Tem_Item[1].equals(FTem_Item[1])) Imply_Conflict1=1;
    if(Tem_Item[0].equals(FTem_Item[1]) && Tem_Item[1].equals(FTem_Item[0])) Imply_Conflict1=1;

 }
 }

  for(j=0;j<Num_Facts;j++){

   Ftotal_item=0;

    if(FactString[j].indexOf((int)'|')!=-1){

     FTokens=new StringTokenizer(FactString[j],"|");

     while(FTokens.hasMoreTokens()){
       TempString=new String(FTokens.nextToken());
       if(TempString.indexOf((int)'~')==0) FTem_Item[Ftotal_item]=new String(TempString.substring(1));
       else if(TempString.indexOf((int)'~')!=0) FTem_Item[Ftotal_item]=new String('~'+TempString);
       Ftotal_item=Ftotal_item+1;
     }

    if(Tem_Item[0].equals(FTem_Item[0]) && Tem_Item[1].equals(FTem_Item[1])) Imply_Conflict1=1;
    if(Tem_Item[0].equals(FTem_Item[1]) && Tem_Item[1].equals(FTem_Item[0])) Imply_Conflict1=1;

 }
 }

 } 

/* self checking stops here*/

/* Double check starts here */

  if(total_item==1) {
//  Imply_Temp1=new String(Tem_Item[0]+'-'+'>');
  TempString=new String("00");
  FTem_Item[0]=new String("00");
  FTem_Item[1]=new String("00");
  FTem_Item_Imply[0]=new String("00");
  FTem_Item_Imply[1]=new String("00");
  for(j=0;j<Num_Facts;j++){

    Ftotal_item=0;
    If_First_Equal=0;

    if(FactString[j].indexOf((int)'>')!=-1){

     FTokens=new StringTokenizer(FactString[j],"->");
     TempFlag=0;

     while(FTokens.hasMoreTokens()){
       TempString=new String(FTokens.nextToken());
 //      ta.appendText("TempString="+TempString+", Tem_Item[0]="+Tem_Item[0]+"\n");
//       if(!TempString.equals(Tem_Item[0]) && Ftotal_item==0) {
//        If_First_Equal=1;
//        break;}
	   if(TempFlag==0) FTem_Item[Ftotal_item]=new String(TempString);
	   else if(TempFlag!=0 && TempString.indexOf((int)'~')!=0) FTem_Item[Ftotal_item]=new String('~'+TempString);
	   else if(TempFlag!=0 && TempString.indexOf((int)'~')==0) FTem_Item[Ftotal_item]=new String(TempString.substring(1));
	   Ftotal_item=Ftotal_item+1;
	   TempFlag=TempFlag+1;
	 }

//      if(If_First_Equal==1) continue;

      for(k=0;k<Num_Facts;k++){
      if(k==j) continue;
       Ftotal_item=0;
       If_First_Equal=0;

        if(FactString[k].indexOf((int)'>')==-1 && FactString[k].indexOf((int)'|')==-1){
           TempString=new String(FactString[k]);
           if(Tem_Item[0].equals(FTem_Item[0]) && TempString.equals(FTem_Item[1])) Imply_Conflict1=1;
           if(Tem_Item[0].equals(FTem_Item[1]) && TempString.equals(FTem_Item[0])) Imply_Conflict1=1;

     }
     }  /* for k=0;k < */


  }   /* for if */

     if(FactString[j].indexOf((int)'|')!=-1){

     FTokens=new StringTokenizer(FactString[j],"|");
     TempFlag=0;

     while(FTokens.hasMoreTokens()){
       TempString=new String(FTokens.nextToken());
 //      ta.appendText("TempString="+TempString+", Tem_Item[0]="+Tem_Item[0]+"\n");
//       if(!TempString.equals(Tem_Item[0]) && Ftotal_item==0) {
//        If_First_Equal=1;
//        break;}

	   if(TempString.indexOf((int)'~')!=0) FTem_Item[Ftotal_item]=new String('~'+TempString);
	   else FTem_Item[Ftotal_item]=new String(TempString.substring(1));
	   Ftotal_item=Ftotal_item+1;
	 }

//      if(If_First_Equal==1) continue;

      for(k=0;k<Num_Facts;k++){
      if(k==j) continue;
       Ftotal_item=0;
       If_First_Equal=0;

        if(FactString[k].indexOf((int)'>')==-1 && FactString[k].indexOf((int)'|')==-1){
           TempString=new String(FactString[k]);
           if(Tem_Item[0].equals(FTem_Item[0]) && TempString.equals(FTem_Item[1])) Imply_Conflict1=1;
           if(Tem_Item[0].equals(FTem_Item[1]) && TempString.equals(FTem_Item[0])) Imply_Conflict1=1;

     }
     }  /* for k=0;k < */

    }   /* for if */
  } /* for for(j=0;j<Num_facts;j++) */
 } /* for if(total_item==1) */

   if(total_item==1) {
//  Imply_Temp1=new String(Tem_Item[0]+'-'+'>');
  TempString=new String("00");
  FTem_Item[0]=new String("00");
  FTem_Item[1]=new String("00");
  FTem_Item_Imply[0]=new String("00");
  FTem_Item_Imply[1]=new String("00");
  for(j=0;j<Num_Facts;j++){

    Ftotal_item=0;
    If_First_Equal=0;

    if(FactString[j].indexOf((int)'>')!=-1){

     FTokens=new StringTokenizer(FactString[j],"->");
     TempFlag=0;

     while(FTokens.hasMoreTokens()){
       TempString=new String(FTokens.nextToken());
 //      ta.appendText("TempString="+TempString+", Tem_Item[0]="+Tem_Item[0]+"\n");
//       if(!TempString.equals(Tem_Item[0]) && Ftotal_item==0) {
//        If_First_Equal=1;
//        break;}
	   if(TempFlag==0) FTem_Item[Ftotal_item]=new String(TempString);
	   else if(TempFlag!=0 && TempString.indexOf((int)'~')!=0) FTem_Item[Ftotal_item]=new String('~'+TempString);
	   else if(TempFlag!=0 && TempString.indexOf((int)'~')==0) FTem_Item[Ftotal_item]=new String(TempString.substring(1));
	   Ftotal_item=Ftotal_item+1;
	   TempFlag=TempFlag+1;
	 }

//      if(If_First_Equal==1) continue;

      for(k=0;k<Num_Results;k++){
       Ftotal_item=0;
       If_First_Equal=0;

        if(ResultString[k].indexOf((int)'>')==-1 && ResultString[k].indexOf((int)'|')==-1){
           TempString=new String(ResultString[k]);
           if(Tem_Item[0].equals(FTem_Item[0]) && TempString.equals(FTem_Item[1]))
//           {Imply_Conflict1=1;Replace1=1000;Replace11=i;Mem_No=new String(ResultString[k]);}
             Imply_Conflict1=1;
           if(Tem_Item[0].equals(FTem_Item[1]) && TempString.equals(FTem_Item[0]))
//           {Imply_Conflict1=1;Replace1=1000;Replace11=i;Mem_No=new String(ResultString[k]);}
              Imply_Conflict1=1;
     }
     }  /* for k=0;k < */


  }   /* for if */

     if(FactString[j].indexOf((int)'|')!=-1){

     FTokens=new StringTokenizer(FactString[j],"|");
     TempFlag=0;

     while(FTokens.hasMoreTokens()){
       TempString=new String(FTokens.nextToken());
 //      ta.appendText("TempString="+TempString+", Tem_Item[0]="+Tem_Item[0]+"\n");
//       if(!TempString.equals(Tem_Item[0]) && Ftotal_item==0) {
//        If_First_Equal=1;
//        break;}

	   if(TempString.indexOf((int)'~')!=0) FTem_Item[Ftotal_item]=new String('~'+TempString);
	   else FTem_Item[Ftotal_item]=new String(TempString.substring(1));
	   Ftotal_item=Ftotal_item+1;
	 }

//      if(If_First_Equal==1) continue;

      for(k=0;k<Num_Results;k++){
       Ftotal_item=0;
       If_First_Equal=0;

        if(ResultString[k].indexOf((int)'>')==-1 && ResultString[k].indexOf((int)'|')==-1){
           TempString=new String(ResultString[k]);
           if(Tem_Item[0].equals(FTem_Item[0]) && TempString.equals(FTem_Item[1]))
 //          {Imply_Conflict1=1;Replace1=1000;Replace11=i;Mem_No=new String(ResultString[k]);}
             Imply_Conflict1=1;
           if(Tem_Item[0].equals(FTem_Item[1]) && TempString.equals(FTem_Item[0]))
//           {Imply_Conflict1=1;Replace1=1000;Replace11=i;Mem_No=new String(ResultString[k]);}
              Imply_Conflict1=1;
     }
     }  /* for k=0;k < */

    }   /* for if */
  } /* for for(j=0;j<Num_facts;j++) */
 } /* for if(total_item==1) */


   if(total_item==1) {

  TempString=new String("00");
  FTem_Item[0]=new String("00");
  FTem_Item[1]=new String("00");
  FTem_Item_Imply[0]=new String("00");
  FTem_Item_Imply[1]=new String("00");
  for(j=0;j<Num_Results;j++){

    Ftotal_item=0;
    If_First_Equal=0;

    if(ResultString[j].indexOf((int)'>')!=-1){

     FTokens=new StringTokenizer(ResultString[j],"->");
     TempFlag=0;

     while(FTokens.hasMoreTokens()){
       TempString=new String(FTokens.nextToken());
 //      ta.appendText("TempString="+TempString+", Tem_Item[0]="+Tem_Item[0]+"\n");
//       if(!TempString.equals(Tem_Item[0]) && Ftotal_item==0) {
//        If_First_Equal=1;
//        break;}
	   if(TempFlag==0) FTem_Item[Ftotal_item]=new String(TempString);
	   else if(TempFlag!=0 && TempString.indexOf((int)'~')!=0) FTem_Item[Ftotal_item]=new String('~'+TempString);
	   else if(TempFlag!=0 && TempString.indexOf((int)'~')==0) FTem_Item[Ftotal_item]=new String(TempString.substring(1));
	   Ftotal_item=Ftotal_item+1;
	   TempFlag=TempFlag+1;
	 }

//      if(If_First_Equal==1) continue;

      for(k=0;k<Num_Facts;k++){
       Ftotal_item=0;
       If_First_Equal=0;

        if(FactString[k].indexOf((int)'>')==-1 && FactString[k].indexOf((int)'|')==-1){
           TempString=new String(FactString[k]);
           if(Tem_Item[0].equals(FTem_Item[0]) && TempString.equals(FTem_Item[1]))
//           {Imply_Conflict1=1;Replace1=1000;Replace11=i;Mem_No=new String(ResultString[j]);}
             Imply_Conflict1=1;
           if(Tem_Item[0].equals(FTem_Item[1]) && TempString.equals(FTem_Item[0]))
 //          {Imply_Conflict1=1;Replace1=1000;Replace11=i;Mem_No=new String(ResultString[j]);}
             Imply_Conflict1=1;
     }
     }  /* for k=0;k < */


  }   /* for if */

     if(ResultString[j].indexOf((int)'|')!=-1){

     FTokens=new StringTokenizer(ResultString[j],"|");
     TempFlag=0;

     while(FTokens.hasMoreTokens()){
       TempString=new String(FTokens.nextToken());
 //      ta.appendText("TempString="+TempString+", Tem_Item[0]="+Tem_Item[0]+"\n");
//       if(!TempString.equals(Tem_Item[0]) && Ftotal_item==0) {
//        If_First_Equal=1;
//        break;}

	   if(TempString.indexOf((int)'~')!=0) FTem_Item[Ftotal_item]=new String('~'+TempString);
	   else FTem_Item[Ftotal_item]=new String(TempString.substring(1));
	   Ftotal_item=Ftotal_item+1;
	 }

//      if(If_First_Equal==1) continue;

      for(k=0;k<Num_Facts;k++){
       Ftotal_item=0;
       If_First_Equal=0;

        if(FactString[k].indexOf((int)'>')==-1 && FactString[k].indexOf((int)'|')==-1){
           TempString=new String(FactString[k]);
           if(Tem_Item[0].equals(FTem_Item[0]) && TempString.equals(FTem_Item[1]))
//           {Imply_Conflict1=1;Replace1=1000;Replace11=i;Mem_No=new String(ResultString[j]);}
           Imply_Conflict1=1;
           if(Tem_Item[0].equals(FTem_Item[1]) && TempString.equals(FTem_Item[0]))
//           {Imply_Conflict1=1;Replace1=1000;Replace11=i;Mem_No=new String(ResultString[j]);}
           Imply_Conflict1=1;
     }
     }  /* for k=0;k < */

    }   /* for if */
  } /* for for(j=0;j<Num_facts;j++) */
 } /* for if(total_item==1) */

   if(total_item==1) {
//  Imply_Temp1=new String(Tem_Item[0]+'-'+'>');
  TempString=new String("00");
  FTem_Item[0]=new String("00");
  FTem_Item[1]=new String("00");
  FTem_Item_Imply[0]=new String("00");
  FTem_Item_Imply[1]=new String("00");
  for(j=0;j<Num_Results;j++){

    Ftotal_item=0;
    If_First_Equal=0;

    if(ResultString[j].indexOf((int)'>')!=-1){

     FTokens=new StringTokenizer(ResultString[j],"->");
     TempFlag=0;

     while(FTokens.hasMoreTokens()){
       TempString=new String(FTokens.nextToken());
 //      ta.appendText("TempString="+TempString+", Tem_Item[0]="+Tem_Item[0]+"\n");
//       if(!TempString.equals(Tem_Item[0]) && Ftotal_item==0) {
//        If_First_Equal=1;
//        break;}
	   if(TempFlag==0) FTem_Item[Ftotal_item]=new String(TempString);
	   else if(TempFlag!=0 && TempString.indexOf((int)'~')!=0) FTem_Item[Ftotal_item]=new String('~'+TempString);
	   else if(TempFlag!=0 && TempString.indexOf((int)'~')==0) FTem_Item[Ftotal_item]=new String(TempString.substring(1));
	   Ftotal_item=Ftotal_item+1;
	   TempFlag=TempFlag+1;
	 }

//      if(If_First_Equal==1) continue;

      for(k=0;k<Num_Results;k++){
      if(k==j) continue;
       Ftotal_item=0;
       If_First_Equal=0;

        if(ResultString[k].indexOf((int)'>')==-1 && ResultString[k].indexOf((int)'|')==-1){
           TempString=new String(ResultString[k]);
           if(Tem_Item[0].equals(FTem_Item[0]) && TempString.equals(FTem_Item[1]))
/*            {Imply_Conflict1=1;Replace1=1000;Replace11=i;Replace2=1000;Replace22=i;
             Mem_No=new String(ResultString[k]);
             Mem_No1=new String(ResultString[j]);
            }
*/
            Imply_Conflict1=1;
           if(Tem_Item[0].equals(FTem_Item[1]) && TempString.equals(FTem_Item[0]))
/*            {Imply_Conflict1=1;Replace1=1000;Replace11=i;Replace2=1000;Replace22=i;
             Mem_No=new String(ResultString[k]);
             Mem_No1=new String(ResultString[j]);
            }    */
            Imply_Conflict1=1;

     }
     }  /* for k=0;k < */


  }   /* for if */

     if(ResultString[j].indexOf((int)'|')!=-1){

     FTokens=new StringTokenizer(ResultString[j],"|");
     TempFlag=0;

     while(FTokens.hasMoreTokens()){
       TempString=new String(FTokens.nextToken());
 //      ta.appendText("TempString="+TempString+", Tem_Item[0]="+Tem_Item[0]+"\n");
//       if(!TempString.equals(Tem_Item[0]) && Ftotal_item==0) {
//        If_First_Equal=1;
//        break;}

	   if(TempString.indexOf((int)'~')!=0) FTem_Item[Ftotal_item]=new String('~'+TempString);
	   else FTem_Item[Ftotal_item]=new String(TempString.substring(1));
	   Ftotal_item=Ftotal_item+1;
	 }

//      if(If_First_Equal==1) continue;

      for(k=0;k<Num_Results;k++){
      if(k==j) continue;
       Ftotal_item=0;
       If_First_Equal=0;

        if(ResultString[k].indexOf((int)'>')==-1 && ResultString[k].indexOf((int)'|')==-1){
           TempString=new String(ResultString[k]);
           if(Tem_Item[0].equals(FTem_Item[0]) && TempString.equals(FTem_Item[1]))
 /*           {Imply_Conflict=1;Replace1=1000;Replace11=i;Replace2=1000;Replace22=i;
             Mem_No=new String(ResultString[k]);
             Mem_No1=new String(ResultString[j]);
            }    */
            Imply_Conflict1=1;
           if(Tem_Item[0].equals(FTem_Item[1]) && TempString.equals(FTem_Item[0]))
/*            {Imply_Conflict=1;Replace1=1000;Replace11=i;Replace2=1000;Replace22=i;
             Mem_No=new String(ResultString[k]);
             Mem_No1=new String(ResultString[j]);
            }    */
            Imply_Conflict1=1;

     }
     }  /* for k=0;k < */

    }   /* for if */
  } /* for for(j=0;j<Num_facts;j++) */
 } /* for if(total_item==1) */
// ta.appendText("Post 8: "+Replace1+"\n");
   if(total_item==2) {

  TempString=new String("00");
  FTem_Item[0]=new String("00");
  FTem_Item[1]=new String("00");
  FTem_Item_Imply[0]=new String("00");
  FTem_Item_Imply[1]=new String("00");

  for(j=0;j<Num_Results;j++){
  if(ResultString[j].indexOf((int)'>')==-1 && ResultString[j].indexOf((int)'|')==-1){
  TempString=new String(ResultString[j]);
  if(TempString.indexOf((int)'~')==0) FTem_Item[0]=new String(TempString.substring(1));
  if(TempString.indexOf((int)'~')!=0) FTem_Item[0]=new String('~'+TempString);

//      if(If_First_Equal==1) continue;

      for(k=0;k<Num_Facts;k++){
         if(FactString[k].indexOf((int)'>')==-1 && FactString[k].indexOf((int)'|')==-1){
           TempStringImply=new String(FactString[k]);
           if(TempStringImply.indexOf((int)'~')==0) TempString=new String(TempStringImply.substring(1));
           if(TempStringImply.indexOf((int)'~')!=0) TempString=new String('~'+TempStringImply);
         }
      }

           if(Tem_Item[0].equals(FTem_Item[0]) && TempString.equals(Tem_Item[1]))
//           {Imply_Conflict1=1;Replace1=1000;Replace11=i;Mem_No=new String(ResultString[j]);}
             Imply_Conflict1=1;
           if(Tem_Item[1].equals(FTem_Item[0]) && TempString.equals(Tem_Item[0]))
//           {Imply_Conflict1=1;Replace1=1000;Replace11=i;Mem_No=new String(ResultString[j]);}
             Imply_Conflict1=1;
    for(k=0;k<Num_Results;k++){
    if(k==j) continue;
         if(ResultString[k].indexOf((int)'>')==-1 && ResultString[k].indexOf((int)'|')==-1){
           TempStringImply=new String(ResultString[k]);
           if(TempStringImply.indexOf((int)'~')==0) TempString=new String(TempStringImply.substring(1));
           if(TempStringImply.indexOf((int)'~')!=0) TempString=new String('~'+TempStringImply);
         }
      }

           if(Tem_Item[0].equals(FTem_Item[0]) && TempString.equals(Tem_Item[1]))
/*           {Imply_Conflict=1;Replace1=1000;Replace2=1000;Replace22=i;
             Replace11=i;Mem_No=new String(ResultString[j]);Mem_No1=new String(ResultString[k]);}
*/
             Imply_Conflict1=1;
           if(Tem_Item[1].equals(FTem_Item[0]) && TempString.equals(Tem_Item[0]))
/*           {Imply_Conflict=1;Replace1=1000;Replace2=1000;Replace11=i;
             Replace22=i;Mem_No=new String(ResultString[j]);Mem_No1=new String(ResultString[k]);}
 */
             Imply_Conflict1=1;
  }   /* for if */
 } /* for for(j=0;j<Num_facts;j++) */

 TempString=new String("00");
  FTem_Item[0]=new String("00");
  FTem_Item[1]=new String("00");
  FTem_Item_Imply[0]=new String("00");
  FTem_Item_Imply[1]=new String("00");

  for(j=0;j<Num_Facts;j++){
  if(FactString[j].indexOf((int)'>')==-1 && FactString[j].indexOf((int)'|')==-1){
  TempString=new String(FactString[j]);
  if(TempString.indexOf((int)'~')==0) FTem_Item[0]=new String(TempString.substring(1));
  if(TempString.indexOf((int)'~')!=0) FTem_Item[0]=new String('~'+TempString);

//      if(If_First_Equal==1) continue;

      for(k=0;k<Num_Facts;k++){
      if(k==j) continue;
         if(FactString[k].indexOf((int)'>')==-1 && FactString[k].indexOf((int)'|')==-1){
           TempStringImply=new String(FactString[k]);
           if(TempStringImply.indexOf((int)'~')==0) TempString=new String(TempStringImply.substring(1));
           if(TempStringImply.indexOf((int)'~')!=0) TempString=new String('~'+TempStringImply);
         }
      }

           if(Tem_Item[0].equals(FTem_Item[0]) && TempString.equals(Tem_Item[1])) Imply_Conflict1=1;
//           {Imply_Conflict=1;Replace1=1000;Replace11=i;Mem_No=new String(ResultString[j]);}
           if(Tem_Item[1].equals(FTem_Item[0]) && TempString.equals(Tem_Item[0])) Imply_Conflict1=1;
//           {Imply_Conflict=1;Replace1=1000;Replace11=i;Mem_No=new String(ResultString[j]);}

  }   /* for if */
 } /* for for(j=0;j<Num_facts;j++) */


 } /* for if(total_item==2) */

// ta.appendText("Post 9: "+Replace1+"\n");
/*double check stops here*/

   H_Check_Flag=0;
   H_Conflict=0;

   for(j=0;j<i;j++){
   NewHtotal_item=0;
   if(HypothesesString[j].indexOf((int)'|')==-1 && HypothesesString[j].indexOf((int)'>')==-1) {
     NewHTem_Item[NewHtotal_item]=new String(HypothesesString[j]);
	 NewHtotal_item=NewHtotal_item+1;
   }
   else if(HypothesesString[j].indexOf((int)'|')==-1 && HypothesesString[j].indexOf((int)'>')!=-1){
     HTokens=new StringTokenizer(HypothesesString[j],"->");
	 TempFlag=0;
     while(HTokens.hasMoreTokens()){
       TempString=new String(HTokens.nextToken());
	   if(TempFlag==0 && TempString.indexOf((int)'~')==0) NewHTem_Item[NewHtotal_item]=new String(TempString.substring(1));
	   else if(TempFlag==0 && TempString.indexOf((int)'~')!=0) NewHTem_Item[NewHtotal_item]=new String('~'+TempString);
	   else if(TempFlag!=0) NewHTem_Item[NewHtotal_item]=new String(TempString);
	   NewHtotal_item=NewHtotal_item+1;
	   TempFlag=TempFlag+1;
	 }
   }
   else if(HypothesesString[j].indexOf((int)'|')!=-1 && HypothesesString[j].indexOf((int)'>')==-1){
     HTokens=new StringTokenizer(HypothesesString[j],"|");
     while(HTokens.hasMoreTokens()){
       NewHTem_Item[NewHtotal_item]=new String(HTokens.nextToken());
	   NewHtotal_item=NewHtotal_item+1;
     }
   }


   for(k=0;k<NewHtotal_item;k++){

    if(NewHTem_Item[k].indexOf((int)'~')==0) {
        TempString=new String(NewHTem_Item[k].substring(1));
        for(kk=0;kk<TH_Flag;kk++) if(CurrentHT[kk].equals(TempString)) H_Check_Flag=H_Check_Flag+1;
	}
	if(NewHTem_Item[k].indexOf((int)'~')!=0) {
        TempString=new String(NewHTem_Item[k]);
	for(kk=0;kk<FH_Flag;kk++) if(CurrentHF[kk].equals(TempString)) H_Check_Flag=H_Check_Flag+1;
	}
   }
 /*  if(H_Check_Flag==NewHtotal_item && NewHtotal_item!=1) {
    H_Conflict=1;
    if(First_Discard_Flag==0) Mem_No=new String(HypothesesString[j]);
    ta.appendText("j="+j+"\n");
    j=i;
    } */
  }

//  ta.appendText("1: H_Conflict="+H_Conflict+"\n");
   F_Conflict=0;
   FS_No=0;
   for(j=0;j<Num_Facts;j++){
   Ftotal_item=0;
   if(FactString[j].indexOf((int)'|')==-1 && FactString[j].indexOf((int)'>')==-1) {
     FTem_Item[Ftotal_item]=new String(FactString[j]);
	 Ftotal_item=Ftotal_item+1;
   }
   else if(FactString[j].indexOf((int)'|')==-1 && FactString[j].indexOf((int)'>')!=-1){
     FTokens=new StringTokenizer(FactString[j],"->");
	 TempFlag=0;
     while(FTokens.hasMoreTokens()){
       TempString=new String(FTokens.nextToken());
	   if(TempFlag==0 && TempString.indexOf((int)'~')==0) FTem_Item[Ftotal_item]=new String(TempString.substring(1));
	   else if(TempFlag==0 && TempString.indexOf((int)'~')!=0) FTem_Item[Ftotal_item]=new String('~'+TempString);
	   else if(TempFlag!=0) FTem_Item[Ftotal_item]=new String(TempString);
	   Ftotal_item=Ftotal_item+1;
	   TempFlag=TempFlag+1;
	 }
   }
   else if(FactString[j].indexOf((int)'|')!=-1 && FactString[j].indexOf((int)'>')==-1){
     FTokens=new StringTokenizer(FactString[j],"|");
     while(FTokens.hasMoreTokens()){
       FTem_Item[Ftotal_item]=new String(FTokens.nextToken());
	   Ftotal_item=Ftotal_item+1;
     }
   }

   F_Check_Flag=0;
   FS_Check_Flag=0;
   for(k=0;k<Ftotal_item;k++){

    if(FTem_Item[k].indexOf((int)'~')==0) {
        TempString=new String(FTem_Item[k].substring(1));
	for(kk=0;kk<TNum_HItem;kk++) if(True_H[kk].equals(TempString)) F_Check_Flag=F_Check_Flag+1;
        for(kk=0;kk<TH_Flag;kk++) if(CurrentHT[kk].equals(TempString)) FS_Check_Flag=FS_Check_Flag+1;
       	}
	if(FTem_Item[k].indexOf((int)'~')!=0) {
        TempString=new String(FTem_Item[k]);
	for(kk=0;kk<FNum_HItem;kk++) if(False_H[kk].equals(TempString)) F_Check_Flag=F_Check_Flag+1;
	for(kk=0;kk<FH_Flag;kk++) if(CurrentHF[kk].equals(TempString)) FS_Check_Flag=FS_Check_Flag+1;
	}
   }

   Total_TNum_FNum=TH_Flag+FH_Flag;

//   ta.appendText(F_Check_Flag+" "+Ftotal_item+" "+TNum_HItem+" "+FNum_HItem+" "+Total_TNum_FNum+"\n");

   if(F_Check_Flag==Ftotal_item && F_Check_Flag==(TNum_HItem+FNum_HItem)) {F_Conflict=1; j=Num_Facts;}
   if(FS_Check_Flag==Ftotal_item  && FS_Check_Flag==Total_TNum_FNum) {FS_No=1;F_Conflict=1; j=Num_Facts;}

//   ta.appendText("2: H_Conflict="+H_Conflict+"\n");

   Another_TempF0=new String("00");
   Another_TempF1=new String("00");

   Rtotal_item=0;
   Sf_Sh_String=new String[2];
   Sf_Sh_Check_Double=0;
   if(FH_Flag+TH_Flag<2 && Ftotal_item==1) {

   if(FTem_Item[0].indexOf((int)'~')==0) Another_TempF0=new String(FTem_Item[0].substring(1));
   if(FTem_Item[0].indexOf((int)'~')!=0) Another_TempF1=new String(FTem_Item[0]);

    for(kkk=0;kkk<Num_Results;kkk++){
     Sf_Sh_Check_Double=0;
     Rtotal_item=0;

   if(ResultString[kkk].indexOf((int)'>')!=-1){
     RTokens=new StringTokenizer(ResultString[kkk],"->");
	 TempFlag=0;
     while(RTokens.hasMoreTokens()){
       TempString=new String(RTokens.nextToken());
	   if(TempFlag==0 && TempString.indexOf((int)'~')==0) Sf_Sh_String[Rtotal_item]=new String(TempString.substring(1));
	   else if(TempFlag==0 && TempString.indexOf((int)'~')!=0) Sf_Sh_String[Rtotal_item]=new String('~'+TempString);
	   else if(TempFlag!=0) Sf_Sh_String[Rtotal_item]=new String(TempString);
	   Rtotal_item=Rtotal_item+1;
	   TempFlag=TempFlag+1;
	 }
   }
   else if(ResultString[kkk].indexOf((int)'|')!=-1){
     RTokens=new StringTokenizer(ResultString[kkk],"|");
     while(RTokens.hasMoreTokens()){
       Sf_Sh_String[Rtotal_item]=new String(RTokens.nextToken());
	   Rtotal_item=Rtotal_item+1;
     }
   }

       for(k=0;k<Rtotal_item;k++){
        if(Sf_Sh_String[k].indexOf((int)'~')==0) {
        TempString=new String(Sf_Sh_String[k].substring(1));
        if(TempString.equals(Another_TempF1)) Sf_Sh_Check_Double=Sf_Sh_Check_Double+1;
        if(TempString.equals(CurrentHT[0])) Sf_Sh_Check_Double=Sf_Sh_Check_Double+1;
       	}
	if(Sf_Sh_String[k].indexOf((int)'~')!=0) {
        TempString=new String(Sf_Sh_String[k]);
        if(TempString.equals(Another_TempF0)) Sf_Sh_Check_Double=Sf_Sh_Check_Double+1;
        if(TempString.equals(CurrentHF[0])) Sf_Sh_Check_Double=Sf_Sh_Check_Double+1;
	}
       }
      if(Sf_Sh_Check_Double==2) {
 //      ta.appendText("Ok\n");
       if(First_Discard_Flag==0) Mem_No=new String(ResultString[kkk]);
       H_Conflict=1;
       kkk=Num_Results;
      }
    }
   }

//   ta.appendText("3: H_Conflict="+H_Conflict+"\n");

   Another_TempF0=new String("00");
   Another_TempF1=new String("00");
   Another_TempH0=new String("00");
   Another_TempH1=new String("00");

   Sf_Sh_Check_Double=0;

   if(FH_Flag+TH_Flag==2 && Ftotal_item==1) {
 //  ta.appendText("1.ok\n");
   if(FTem_Item[0].indexOf((int)'~')==0) Another_TempF0=new String(FTem_Item[0].substring(1));
   if(FTem_Item[0].indexOf((int)'~')!=0) Another_TempF1=new String(FTem_Item[0]);

    for(kkk=0;kkk<Num_Results;kkk++){
     Sf_Sh_Check_Double=0;
 //   ta.appendText("2.ok\n");
   if(ResultString[kkk].indexOf((int)'>')==-1 && ResultString[kkk].indexOf((int)'|')==-1){
        if(ResultString[kkk].indexOf((int)'~')==0) {
        TempString=new String(ResultString[kkk].substring(1));
  //      if(TempString.equals(Another_TempF1)) Sf_Sh_Check_Double=Sf_Sh_Check_Double+1;
        for(kk=0;kk<TH_Flag;kk++){
          if(CurrentHT[kk].equals(TempString)) Sf_Sh_Check_Double=Sf_Sh_Check_Double+1;
          if(CurrentHT[kk].equals(Another_TempF0)) Sf_Sh_Check_Double=Sf_Sh_Check_Double+1;
        }
        for(kk=0;kk<FH_Flag;kk++)
        if(CurrentHF[kk].equals(Another_TempF1)) Sf_Sh_Check_Double=Sf_Sh_Check_Double+1;
 //       ta.appendText("3.ok\n");
       }
	if(ResultString[kkk].indexOf((int)'~')!=0) {
        TempString=new String(ResultString[kkk]);
//        if(TempString.equals(Another_TempF0)) Sf_Sh_Check_Double=Sf_Sh_Check_Double+1;
        for(kk=0;kk<FH_Flag;kk++){
         if(CurrentHF[kk].equals(TempString)) Sf_Sh_Check_Double=Sf_Sh_Check_Double+1;
         if(CurrentHF[kk].equals(Another_TempF1)) Sf_Sh_Check_Double=Sf_Sh_Check_Double+1;
        }
        for(kk=0;kk<TH_Flag;kk++)
        if(CurrentHT[kk].equals(Another_TempF0)) Sf_Sh_Check_Double=Sf_Sh_Check_Double+1;
 //       ta.appendText("4.ok\n");
	}
    }
      if(Sf_Sh_Check_Double==2) {
 //       ta.appendText("5.ok\n");
        if(First_Discard_Flag==0) Mem_No=new String(ResultString[kkk]);
        H_Conflict=1;
        kkk=Num_Results;
        }
    }
   }

//   ta.appendText("4: H_Conflict="+H_Conflict+"\n");

   F_Double_Check=0;

   if(FH_Flag+TH_Flag<2 && FS_Check_Flag==1 && Ftotal_item==2){
      for(kkk=0;kkk<Num_Results;kkk++){
       F_Double_Check=0;
       if(!ResultString[kkk].equals(HypothesesString[i]) && ResultString[kkk].indexOf((int)'|')==-1 && ResultString[kkk].indexOf((int)'>')==-1) {
       if(ResultString[kkk].indexOf((int)'~')==0) {
         F_Double_String0=new String(ResultString[kkk].substring(1));
         F_Double_String1=new String("00");
       }
       else if(ResultString[kkk].indexOf((int)'~')!=0) {
        F_Double_String1=new String(ResultString[kkk]);
        F_Double_String0=new String("00");
       }

       for(k=0;k<Ftotal_item;k++){
        if(FTem_Item[k].indexOf((int)'~')==0) {
        TempString=new String(FTem_Item[k].substring(1));
        if(TempString.equals(F_Double_String1)) F_Double_Check=F_Double_Check+1;
       	}
	if(FTem_Item[k].indexOf((int)'~')!=0) {
        TempString=new String(FTem_Item[k]);
        if(TempString.equals(F_Double_String0)) F_Double_Check=F_Double_Check+1;
	}
       }

       }
       if(F_Double_Check==1) {
       if(First_Discard_Flag==0) Mem_No=new String(ResultString[kkk]);
       F_Conflict=1; kkk=Num_Results;}
      }
   }
  }




   Flag3=0;

   for(j=0;j<total_T_item;j++) if(TrueString[j].equals("00")) Flag3=Flag3+1;
   for(j=0;j<total_F_item;j++) if(FalseString[j].equals("00")) Flag3=Flag3+1;

   Flag4=Flag1+Flag2+Flag3;

//   ta.appendText("Flag4="+Flag4+", Flag3="+Flag3+", F_Conflict="+F_Conflict+", H_Conflict="+H_Conflict+", Imply_Conflict="+Imply_Conflict+"\n");
//   if((Flag4<(total_T_item+total_F_item) || (Flag1+Flag2)!=Total_TNum_FNum) && F_Conflict!=1 && C_Conflict!=1 && H_Conflict!=1 && Imply_Conflict!=1) {
//  ta.appendText("Imply_Conflict="+Imply_Conflict+"\n");
  if((Flag4<(total_T_item+total_F_item) || (Flag1+Flag2)!=Total_TNum_FNum) && Imply_Conflict!=1 && Imply_Conflict1!=1){
    ResultString[Num_Results]=HypothesesString[i];
    ta.appendText("Hypotheses "+Integer.toString(Num_Results+1)+" of current extension: "+"\""+ResultString[Num_Results]+"\""+".\n");
	ta.appendText("The reasons may be as follows:\n");
	ta.appendText("\""+ResultString[Num_Results]+"\""+" is consistent with F, C and current partial extension.\n\n");
    GF.ResultString[Num_Results]=HypothesesString[i];
    Num_Results=Num_Results+1;
    GF.Num_Results=Num_Results;

    for(j=0;j<total_item;j++){
     Fg1=0;
     Fg2=0;
     if(Tem_Item[j].indexOf((int)'~')==0) {
	   TempString=new String(Tem_Item[j].substring(1));
	   for(k=0;k<total_T_item;k++) {
	    if(!TempString.equals("00") && TempString.equals(TrueString[k])) {
		  TrueString[k]=new String("00");
		  Fg1=1;
		  break;
	    }
       }

	 if(Fg1==0) {
	  FalseString[total_F_item]=new String(TempString);
	  total_F_item=total_F_item+1;
	 }

	}
	else if(Tem_Item[j].indexOf((int)'~')!=0) {
	    TempString=new String(Tem_Item[j]);
        for(k=0;k<total_F_item;k++){
		  if(TempString.equals(FalseString[k])){
		    FalseString[k]=new String("00");
		    Fg2=1;
                    break;
	      }
		}
    if(Fg2==0) {
	  TrueString[total_T_item]=new String(TempString);
	  total_T_item=total_T_item+1;
	 }
   }
  }

  }

//  if((Flag4==(total_T_item+total_F_item) && (Flag1+Flag2)==Total_TNum_FNum) || H_Conflict==1 || F_Conflict==1 || C_Conflict==1 || Imply_Conflict==1)
  if(Imply_Conflict==1 || Imply_Conflict1==1)
  {
    TNum_HItem=TNum_HItem-TH_Flag;
    FNum_HItem=FNum_HItem-FH_Flag;
    ta.appendText("\""+HypothesesString[i]+"\""+" is discarded, the reasons may be as follows:\n");
    ta.appendText("\""+HypothesesString[i]+"\""+" is not consistent with F and/or C and/or current partial extension.\n\n");
    if(First_Discard_Flag==0 && FS_No!=1 && CS_No!=1 && i!=0) {
       discard_flag=i;First_Discard_Flag=1;
//       ta.appendText("Discard No.: i="+i+"\n");
       }
//   if(i!=0 && FS_No!=1 && CS_No!=1) {discard_flag=i;First_Discard_Flag=1;}
  }

  if(Imply_Conflict==1) discard_flag=0;

  PAUSE_Flag=false;
  RESUME_Flag=false;


  P_D.PerformanceCanvas.y[i+1]=240-Num_Results*10;


 P_D.PerformanceCanvas.Draw_Num=Num_Results;
 P_D.PerformanceCanvas.repaint();
// P_D.show();
// P_D.hide();
 }

 ta.appendText("\nThe "+num_trials+"th extension is as follows:\n");

 for(j=0;j<Num_Facts-Num_Constraints;j++){
  ta.appendText(FactString[j]+"\n");
 }

 for(i=0;i<Num_Results;i++){
  ta.appendText(ResultString[i]+"\n");
  DisplayedResult[Num_DisplayedResult][i]=new String(ResultString[i]);
//  ta.appendText(Num_DisplayedResult+": "+i+": "+DisplayedResult[Num_DisplayedResult][i]+"\n");
 }
 Num_DisplayedResult=Num_DisplayedResult+1;
// ta.appendText("\n\nAnytime Hypothetical Reasoning is finished!\n\n");
 ta.appendText("\n\nAnytime coherence computation for the "+num_trials+"th extension is finished!\n\n");


 for(jjj=0;jjj<Num_BackResult;jjj++){

  Count_BackResult=0;
  for(i=0;i<Num_Results;i++){
  for(j=0;j<Num_Results;j++){
  if(ResultString[i].equals(BackResult[jjj][j])) Count_BackResult=Count_BackResult+1;
  }
  }
  if(Count_BackResult==Num_Results){
  for(j=0;j<Num_Results;j++) BackResult[jjj][j]=new String("00");
  }
 }

 if(discard_flag!=0){

 for(jjj=0;jjj<Num_Results;jjj++){
  if(Mem_No.equals(ResultString[jjj])){
  for(j=0;j<Num_Results;j++){
  if(Mem_No.equals(ResultString[j])) {
    BackResult[Num_BackResult][j]=new String(HypothesesString[discard_flag]);
//  ta.appendText(Num_BackResult+": "+BackResult[Num_BackResult][j]+"\n");
  }
  else {BackResult[Num_BackResult][j]=new String(ResultString[j]);
//  ta.appendText(Num_BackResult+": "+BackResult[Num_BackResult][j]+"\n");
  }
  }
  }
  }
 }


// ta.appendText("Replace1="+Replace1+", Replace2="+Replace2+", Mem_No="+Mem_No+", Mem_No1="+Mem_No1+"\n");
// ta.appendText("Num_Results="+Num_Results+", Num_BackResult="+Num_BackResult+"\n");
 if(Replace1==1000){

 for(jjj=0;jjj<Num_Results;jjj++){
  if(Mem_No.equals(ResultString[jjj])){
//  ta.appendText("ok\n");
  for(j=0;j<Num_Results;j++){
  if(Mem_No.equals(ResultString[j])) {
    BackResult[Num_BackResult][j]=new String(HypothesesString[Replace11]);
//  ta.appendText(Num_BackResult+": "+BackResult[Num_BackResult][j]+"\n");
  }
  else {BackResult[Num_BackResult][j]=new String(ResultString[j]);
//  ta.appendText(Num_BackResult+": "+BackResult[Num_BackResult][j]+"\n");
  }
  }

  }
  }
 }


 if(Replace1==1000 && Replace2==1000){
 Num_BackResult=Num_BackResult+1;
 for(jjj=0;jjj<Num_Results;jjj++){
  if(Mem_No1.equals(ResultString[jjj])){
  for(j=0;j<Num_Results;j++){
  if(Mem_No1.equals(ResultString[j])) {
    BackResult[Num_BackResult][j]=new String(HypothesesString[Replace22]);
//  ta.appendText(Num_BackResult+": "+BackResult[Num_BackResult][j]+"\n");
  }
  else {BackResult[Num_BackResult][j]=new String(ResultString[j]);
//  ta.appendText(Num_BackResult+": "+BackResult[Num_BackResult][j]+"\n");
  }
  }
  }
  }
 }

 Num_BackResult=Num_BackResult+1;

  for(jjj=0;jjj<Num_BackResult;jjj++){
  for(kkk=jjj+1;kkk<Num_BackResult;kkk++){
  Count_BackResult=0;
  for(i=0;i<Num_Results;i++){
   for(j=0;j<Num_Results;j++){
   if(BackResult[jjj][i].equals(BackResult[kkk][j])){
   Count_BackResult=Count_BackResult+1;
   j=Num_Results;
  }
  }
  }
  if(Count_BackResult==Num_Results){
  for(j=0;j<Num_Results;j++) BackResult[kkk][j]=new String("00");}
  }
 }

  for(jjj=0;jjj<Num_DisplayedResult;jjj++){
  for(kkk=0;kkk<Num_BackResult;kkk++){
   Count_BackResult=0;
  for(i=0;i<Num_Results;i++) {
  for(j=0;j<Num_Results;j++){
  if(DisplayedResult[jjj][i].equals(BackResult[kkk][j])){
   Count_BackResult=Count_BackResult+1;
   j=Num_Results;
  }
  }
  }
  if(Count_BackResult==Num_Results){
  for(j=0;j<Num_Results;j++) BackResult[kkk][j]=new String("00");
  }
  }
 }

 P_D.PerformanceCanvas.Draw_Num=Num_Hypotheses;

 P_D.PerformanceCanvas.repaint();
// P_D.show();
// P_D.hide();
 }
 for(jjj=0;jjj<Num_BackResult;jjj++){
 if(BackResult[jjj][0].equals("00")) continue;
 else {
 num_trials=num_trials+1;
 ta.appendText("\nThe "+num_trials+"th extension is as follows:\n");
 for(j=0;j<Num_Facts-Num_Constraints;j++){
  ta.appendText(FactString[j]+"\n");
 }
 for(j=0;j<20;j++) if(!BackResult[jjj][j].equals("00")) ta.appendText(BackResult[jjj][j]+"\n");
 ta.appendText("\n\nAnytime coherence computation for the "+num_trials+"th extension is finished!\n\n");



 }
 }
 }
 }
 }
}


