/*		---   demand driven goal generator ---		    *\

   Copyright (C) 1998  Takashi Chikayama and Haruhiko Usa


   [ Goal(..,X0,X1,..)@demand([X0,X1,..]), Goal(..Y,..)@demand(Y),... ]

   1. make_ddgoal(DDV,Goal,H);
   2. next_ddgoal(DDV,Goal);
    ( new_generic(ddgoal_g_new,1,xd,H); )


   << structure of demand driven goal, and it's generator variable >>

     % make_ddgoal(X0,G,H); next_ddgoal(X1,G); ...; next_ddgoal(Xn,G);
         [X0] -> [generator object|G] -+->|   makeint(0)   |
         [X1] -> [generator object|G] -+  | &predicate_... |
                                       |  |     arg[0]     |
         [Xn] -> [generator object|G] -+  |     arg[1]     |
                                          |      ...       |

     % X1 is referenced.
         [X0] -> [generator object|G] -+->| ref. next goal |
         [X1] -> [variable]            |  | &predicate_... |
                                       |  |     arg[0]     |
         [Xn] -> [generator object|G] -+  |     arg[1]     |
\*								    */

/*
#define DD_TRACE(MSG)   fprintf(stderr,MSG)
#define DD_GCTRACE(MSG) fprintf(stderr,MSG)
*/


#ifdef DD_COUNT
#define DDCOUNT(MSG) MSG
long int ddgoal_make = 0;
long int ddgoal_call = 0;
#else
#define DDCOUNT(MSG)
#endif

#ifndef DD_TRACE
#define DD_TRACE(MSG)
#endif
#ifndef DD_GCTRACE
#define DD_GCTRACE(MSG)
#endif

#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/alloc.h>
#include <klic/g_methtab.h>
#include <klic/g_basic.h>
#include <klic/gg_macro.h>
#include <klic/susp.h>
#include <stdio.h>

#define GG_CLASS_NAME()		ddgoal
#define GG_OBJ_TYPE		struct ddgoal_generator

struct goalrec *copy_ddgoal();
static q generate();
static long print();
static q *gc();

GG_OBJ_TYPE {
  struct generator_object_method_table *method_table;
  struct goalrec *ddg;
};

GGDEF_GENERATE()
{
  G_STD_DECL;
  struct goalrec *ddg;

  ddg = GG_SELF->ddg;
  if(ddg && isint(derefone(ddg))) enqueue_ddgoal(current_prio,ddg,glbl);
  DDCOUNT(ddgoal_call++);
  heapp = g_allocp;
  return derefone(GG_SELF) = (q)(GG_SELF);
}

GGDEF_PRINT()
{
  G_STD_DECL;
  fprintf(g_fp, "DDGOAL@%X", (q*)GG_SELF-new_space_top);
  return 0;
}

GGDEF_GC()
{
  G_STD_DECL;
  GG_OBJ_TYPE *newself;
  struct goalrec *ddg, *g=0;
  GGSET_NEWOBJ_IN_NEWGEN(newself);
  ddg = GG_SELF->ddg;
  if(ddg) g = ddg->next;
  switch(ptagof(g)) {
  case ATOMIC:			/* copy ddg */
    ddg = copy_ddgoal(ddg, g_allocp, g_sp);
    newself->ddg = ddg;
    GG_SELF->ddg = (struct goalrec*)makecons(ddg);
    return (q*)newself;
  case CONS:			/* ddg is already copied */
    DD_GCTRACE("GC 2 (already copied)\n");
    newself->ddg = (struct goalrec *)consp(g);
    GG_RETURN_FROM_GC(newself);
  case VARREF:			/* ddg is already enqueued */
    DD_GCTRACE("GC 3 (already enqueued)\n");
    newself->ddg = 0;
    GG_RETURN_FROM_GC(newself);
  }
}

GGDEF_UNIFY()
{
  return 0;
}

#define GGUSE_MY_GENERATE
#define GGUSE_MY_GC
#define GGUSE_MY_UNIFY
#define GGUSE_MY_PRINT

#include <klic/gg_methtab.h>

GGDEF_NEW()
{
  GG_STD_DECL_FOR_NEW;
  GG_OBJ_TYPE *obj;

#if 0
  if (GG_ARGC != 1) {
    fatalf("Wrong number of arguments (%d) for dd-goal generator", GG_ARGC);
  }
#endif

  G_HEAPALLOC(obj,GG_OBJ_SIZE,(GG_OBJ_TYPE *));
  obj->method_table = &GG_method_table;
  obj->ddg = (struct goalrec*) GG_ARGV[0];
  DDCOUNT(ddgoal_make++);
  GG_RETURN_FROM_NEW(GG_MAKE_HOOK_VAR(obj));
}

