/***************************************************************************
* Functions
*
* FunCstr.h (Management of constraints and narrowing operators)
*
* Date:    1 feb 98
* Author:  L. Granvilliers - LIFO Orleans
****************************************************************************/
/*************************************************************************/
/*                                                                       */
/*       Copyright (C) 1998 Universite de Nantes                         */
/*                                                                       */
/*************************************************************************/

#ifndef FUNCSTR_H
#define FUNCSTR_H

#include "FunTree.h"



/***************************************************************************
*                          NARROWING OPERATORS
****************************************************************************/

typedef int (* FunPruneProj)(void *,     long,    long,      FiaBounds *);
                         /*  function   locvar  globvar    domain of  var */


typedef struct
{
     FunFunction *fun;   /* the function */
     long locvar;        /* the variable (local index in c) defining the projection */
     long globvar;       /* the same variable (global index) */
     FunPruneProj prune; /* the pruning function for the projection of fun on var */
}
FunOpNar;

#       define FunFunOpNar(n)     n->c
#       define FunLocVarOpNar(n)  n->locvar
#       define FunGlobVarOpNar(n) n->globvar
#       define FunPruneOpNar(n)   n->prune


#       define FunNarNewtonFail     0
#       define FunNarNewtonFlounder 1
#       define FunNarNewtonSuccess  2


#       define FunStackAllocUnit 100


int FunNarNewtonEq  (FunFunction *fun, long locvar, long globvar, FiaBounds *out);
int FunNarNewtonSup (FunFunction *fun, long locvar, long globvar, FiaBounds *out);
int FunNarNewtonInf (FunFunction *fun, long locvar, long globvar, FiaBounds *out);
int FunNarTaylorEq  (FunFunction *fun, long locvar, long globvar, FiaBounds *out);


/* Creation of ONE narrowing operator associated to the projection of f
   with respect to globvar */
FunOpNar *FunOpNarCreateOne(FunFunction *f, long globvar);


/* Application of the narrowing operator op */
int FunOpNarApply(FunOpNar *op);

#endif
