/***************************************************************************
* Groebner
*
* Groebner.h (Management of groebner bases)
*
* Date:    1 feb 98
* Author:  L. Granvilliers - LIFO Orleans
****************************************************************************/
/*************************************************************************/
/*                                                                       */
/*       Copyright (C) 1998 Universite de Nantes                         */
/*                                                                       */
/*************************************************************************/

#ifndef GROEBNER_H
#define GROEBNER_H

#include <gmp.h>


/***************************************************************************
    A term is a product of couples (variable, exponent) */

struct GbTermDef
{    long idvar;
     int exponent;
     struct GbTermDef *next;
     struct GbTermDef *prev;
};
typedef struct GbTermDef GbTerm;

#        define Tvar(t)  (t)->idvar
#        define Texp(t)  (t)->exponent
#        define Tprev(t) (t)->prev
#        define Tnext(t) (t)->next


typedef struct
{ 
       GbTerm *first;
       GbTerm *end;
}
GbListTerm;

#       define LTfirst(l) (l)->first
#       define LTend(l)   (l)->end



/***************************************************************************
    A monomial is a couple (coefficient, list of terms) */

typedef struct
{ 
       mpq_t coeff;
       GbListTerm *lterm;
}
GbMonomial;

#       define Mcoeff(m) (m)->coeff
#       define Mlterm(m) (m)->lterm



/***************************************************************************
    A polynomial is a sum of monomials, i.e. an ordered list of monomials */

struct GbPolyDef
{
       GbMonomial *monomial;
       struct GbPolyDef *next;
};
typedef struct GbPolyDef GbPoly;

#       define Pmono(p) (p)->monomial
#       define Pnext(p) (p)->next




/***************************************************************************
    Comparison primitives of variables */

#   define GbVarSup 0
#   define GbVarInf 1
#   define GbVarEq  2
#   define GbCmpVar(x,y) ((x==y)?GbVarEq:((x<y)?GbVarInf:GbVarSup))


#   define GbADD    0
#   define GbSUB    1
#   define GbMUL    2
#   define GbInt    3
#   define GbFloat  4
#   define GbRat    5
#   define GbPOW    6
#   define GbSQR    7
#   define GbVAR    8
#   define GbNEG    9


#   define GbMaxRR(x,y) (((x)<(y))? y : x)


/***************************************************************************
   INTERFACE with BSSolve
****************************************************************************/

#  define GROEBNER_REP "groebner"


/* To make the wrapped string from a polynomial */
char *GbPoly2wstring(GbPoly *p);

/* To make a polynomial from a wrapped string */
GbPoly *GbParsePoly(char * s);

/* To make the S-polynomial of p1 and p2 */
GbPoly *GbSpoly(GbPoly *p1, GbPoly *p2);
GbPoly *BsGbSpoly(long idp1, long idp2);

/* To reduce *p1 with respect to p2 */
void GbReduce(GbPoly **p1, GbPoly *p2);
void BsGbReduce(long idp1, long idp2);

/* To deallocate a polynomial */
void GbFreeP(GbPoly *p);

/* To test is p is the zero polynomial */
int GbPolyZero(GbPoly *p);

/* Returns the munimum of two polynomials */
int GbPolyMin(GbPoly *p1, GbPoly *p2);

void BsGbPolyMin(int uselesstag, char **res, int *size,
                 char *sp1, int size1, char *sp2, int size2);

int BsGbPolyEqual(GbPoly *p1, GbPoly *p2);

#endif
