/*************************************************************************/
/*                                                                       */
/*       Copyright (C) 1998 Universite de Nantes                         */
/*                                                                       */
/*************************************************************************/
 
/************* 
 Edit history: 
       27/2/98 - Nicolas Romero : Creation
*************/

#include <search.h>
#include <string.h>
#include "vars.h"

#define VarVal( v)        ((v)->value)

BssValue *VarValue( BssVar *v)
{
  VarNormalizeRep( v);
  return ((v)->value);
}


BssVar *VarAllocInit( /* char **/ int name, int loc, BssValue value)
{
  BssVar *v;

  v = (BssVar*)malloc( sizeof( BssVar));
  VarName( v) = name /*(char*)strdup(name)*/;
  VarLoc( v) = loc;
  VarVal( v) = BssAllocCopy( value);
  VarExt( v) = LRepAlloc();
  VarMostRecent( v)[0] ='\0' ;

  return v;
}

void *VarUpdateRep( BssVar *v, char *rep, void *value)
{
  void *old, **res;
  /* try to insert the new external value */
  res = LRepInsert( VarExt( v), rep, value);

  /* don't forget the most_recent marker! */
  memcpy( VarMostRecent( v), rep, 9);

  /* test if the value has been inserted, or if there already was
     a value (which is the most common case) */
  if (res == &value)
    /* the value has been inserted */
    return (void*)0;
  else {
    /* the value has not been inserted, we must replace the old value
       by the new one, and return the old value (to be freed) */
    old = *res;/* (void*)*res; */
    *res = value;
    return old;
  }
}

BssValue *VarUpdate( BssVar *v, BssValue *value)
{
  BssValue *old;
  old = VarVal( v);
  VarVal( v) = value;

  /* don't forget the most_recent marker! */
  free(VarMostRecent( v));
  VarMostRecent( v)[0] = '\0';

  return old;
}

void VarFree( BssVar *v, void (*rfree)( void *))
{
  BssFree( VarVal (v));
  LRepFree( VarExt( v), rfree);
  free( v);
}

void VarNormalizeRep( BssVar *v)
{
  if (*VarMostRecent( v))
    {
      BssCopy( VarVal( v), RepConvert( VarMostRecent(v), v));
      VarMostRecent( v)[0] = '\0';
    }
}

char *Var2bstring( BssVar *v, int *length)
{
  char *s, *vals;
  int vall;
  
  VarNormalizeRep( v);
  vals= Bss2bstring( VarValue( v), &vall);
  length[0] = 2*sizeof(int) + vall;

  s = (char *)malloc( length[0]);

  memcpy( s, &VarName( v), sizeof( int));
  memcpy(  &s[sizeof( int)], &VarLoc( v), sizeof( int));
  memcpy(  &s[2*sizeof(int)], vals, vall);

  return s;
}

BssVar *bstring2Var( char *s)
{
  BssVar *v;
  int l;
  v = (BssVar*)malloc( sizeof( BssVar));
  
  memcpy(  &VarName( v), s, sizeof( int));
  s += sizeof( int);
  memcpy(  &VarLoc( v), s, sizeof( int));
  s += sizeof( int);
  VarVal( v) = bstring2Bss( s);

  VarExt( v) = LRepAlloc();
  VarMostRecent( v)[0] ='\0' ;
  
  return v;
}

