/*************************************************************************/
/*                                                                       */
/*       Copyright (C) 1998 Universite de Nantes                         */
/*                                                                       */
/*************************************************************************/
 
/************* 
 Edit history: 
       27/2/98 - Nicolas Romero : Creation
*************/

#ifndef REPS_H
#define REPS_H

#include <stdio.h>

typedef struct {
  char *firstrep; /* pointer to the beginning of the list of
		     rep. names (actually an array of chars) */
  char *nextrep;  /* to retrieve the list of rep. names */
  char *endrep;   /* pointer to the end of the list of
b		     rep. names */
  void *list;     /* actually a binary search tree */
} LRep;

#define LRepFirstRep( l) ((l)->firstrep)
#define LRepNextRep( l) ((l)->nextrep)
#define LRepEndRep( l) ((l)->endrep)
#define LRepList( l) ((l)->list)

LRep *LRepAlloc();
/* The two following functions return a pointer to the address of the
   stored value */
void **LRepInsert( LRep *l, char *name, void *value);
void **LRepFind( LRep *l, char *name);
char *LRepWhich( LRep *l);

void LRepFree( LRep *l, void (*vfree)(void *));

void LRepWrite( FILE *f, LRep *l, void (*vwrite)(FILE *, void *));


typedef void *(*RepConvertFnc)( void*);

/* name must be at most 9 bytes long, including \0 */
void RepInit();
void RepDeclare(  char *name, RepConvertFnc convert);
void *RepConvert( char *name, void *v);


#endif
