/*************************************************************************/
/*                                                                       */
/*       Copyright (C) 1998 Universite de Nantes                         */
/*                                                                       */
/*************************************************************************/
 
/************* 
 Edit history: 
       27/2/98 - Nicolas Romero : Creation
*************/

#include "reps.h"
#include "htable.h"
#include "../variables/vars.h"
#include <string.h>
#include <search.h>

struct extval {
  char *name;
  void *value;
};


struct ListRep {
  struct extval *v;
  struct ListRep *svt;
};


#define MY_SEARCH tsearch
#define MY_DELETE tdelete
#define MY_FIND tfind

int EVCmp( const void *r1, const void *r2)
{
  return strcmp( ((struct extval *)r1)->name, ((struct extval *)r2)->name);
}

void *my_search(const void *key, void **rootp,
		int (*compar)(const void *, const void *))
{
  if (!(*(struct ListRep**)rootp)) {
    if (*rootp = malloc( sizeof(struct ListRep))) {
      (*(struct ListRep**)rootp)->v = (struct extval*)key;
      (*(struct ListRep**)rootp)->svt = (struct ListRep*)0;
      return &(*(struct ListRep**)rootp)->v;
    }
    else
      return (void*)0;
  }
  else if ((*compar)( key, (*(struct ListRep**)rootp)->v) == 0)
    return &(*(struct ListRep**)rootp)->v;
  else
    return (my_search( key, &(*(struct ListRep**)rootp)->svt, compar));
}

void *my_find(const void *key, void * const *rootp,
	      int (*compar)(const void *, const void *))
{
  if (!(*(struct ListRep**)rootp))
    return (void*)0;
  else if ((*compar)( key, (*(struct ListRep**)rootp)->v) == 0)
    return &(*(struct ListRep**)rootp)->v;
  else
    return (my_find( key, &(*(struct ListRep**)rootp)->svt, compar));
}

void *my_delete(const void *key, void **rootp,
		int (*compar)(const void *, const void *))
{
  struct ListRep *tmp;
  void **oldval;
  if (!(*(struct ListRep**)rootp)) {
    return (void*)0;
  }
  else if ((*compar)( key, (*(struct ListRep**)rootp)->v) == 0) {
    tmp = (*(struct ListRep**)rootp);
    (*(struct ListRep**)rootp) = (*(struct ListRep**)rootp)->svt;
    oldval = &(tmp->v);
    free( tmp);
    return oldval;
  }
  else
    return (my_delete( key, &(*(struct ListRep**)rootp)->svt, compar));
}


LRep *LRepAlloc()
{
  LRep *l;

  l = (LRep*)malloc( sizeof( LRep));

  LRepFirstRep( l) = (char*)0;
  LRepNextRep( l) = LRepEndRep( l) = LRepFirstRep( l);

  LRepList( l) = (void*)0;
  
  return l;
}

void **LRepInsert( LRep *l, char *name, void *value)
{
  int len, i, diff;
  struct extval *v, **w;

  v = (struct extval*)malloc( sizeof(struct extval));
  v->name = (char*)strdup( name);
  v->value = value;
  
  len = strlen( name);
  if (LRepFirstRep( l)) {
    /* there exist some rep. */
    /* the list of rep. names must be enlarged */

    diff = LRepEndRep(l) - LRepFirstRep(l);
    LRepFirstRep (l) = (char*)realloc( LRepFirstRep (l),
				       diff + 2 + len);
  LRepEndRep( l) = LRepFirstRep( l) + diff - 1;
  }
  else {
    /* no rep. for the moment*/
    /* the list of rep. names must be created */
    LRepFirstRep(l) = (char*)malloc( 1 + len);
    LRepEndRep( l) = LRepFirstRep(l) - 1;
  }
    /* then, the new name is copied */
    for (i=0; i<=len; i++)
      *(++LRepEndRep( l)) = name[i];
    /* a 0 is added to the end, to detect it */
    *(++LRepEndRep( l)) = '\0';
    
    /* nextrep is reinitialized */
    LRepNextRep( l) = LRepFirstRep( l);

    /* now, we can add the new rep to the list */
    w = (struct extval**)MY_SEARCH( v, &LRepList( l), EVCmp);
    if (w)
      return &(*w)->value;
    else
      return (void*)0;
}

void **LRepFind( LRep *l, char *name)
{
  struct extval v, **w;

  v.name = name;
  w = (struct extval**)MY_FIND( &v, (const void **)&LRepList( l), EVCmp);
  if (w)
    return &(*w)->value;
  else
    return (void*)0;
}

char *LRepWhich( LRep *l)
{
  char *res;

  res = LRepNextRep( l);

  if (res)
    if (*res) {
      for (;*LRepNextRep( l) !='\0';LRepNextRep( l)++);
      LRepNextRep( l)++;
    }

    else {
      LRepNextRep( l) = LRepFirstRep( l);
      return (char*)0;
    }
  
  return res;
}

void LRepFree( LRep *l, void (*vfree)(void *))
{
  char *rep;
  struct extval v, **w;
  
  /* free all the values */
  while( rep = LRepWhich( l)) {
    v.name = rep;
    w = (struct extval **)MY_FIND( &v, (const void **)&LRepList( l), EVCmp);
    if (w) {
      vfree((*w)->value);
      free( *w);
    }
    MY_DELETE( &v, &LRepList( l), EVCmp);
  }

  /* then free the rest of l */
  free( LRepList( l));
  free( LRepFirstRep( l));
  free( l);
}

void LRepWrite( FILE *f, LRep *l, void (*vwrite)(FILE *, void *))
{
  char *rep;
  struct extval v, **w;

  /* print all the values */
  while( rep = LRepWhich( l)) {
    v.name = rep;
    w = (struct extval**)MY_FIND( &v, (const void **)&LRepList( l),
				EVCmp);
    if (w) {
      fprintf( f, "%s : ", v.name);
      vwrite( f, (*w)->value);
    }
  }
}

htable *hrepcvt;

void RepInit()
{
  hrepcvt = hinit(313);
}

void RepDeclare(  char *name, RepConvertFnc convert)
{
  hinsert( hrepcvt, name, convert);
}

void *RepConvert( char *name, void *v)
{
  RepConvertFnc f = hfind( hrepcvt, name);
  if (f)
    return (*(RepConvertFnc)f)( *VarGetRep( (BssVar*)v, name));
  else
    return (void*)0;
}
